/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.wizards;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AJLog;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.internal.buildconfig.BuildConfiguration;
import org.eclipse.ajdt.internal.buildconfig.BuildConfigurator;
import org.eclipse.ajdt.internal.buildconfig.ProjectBuildConfigurator;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;

public class BuildConfigurationCreationPage
extends WizardNewFileCreationPage {
    private IWorkbench workbench;
    private Button openFileCheckbox;
    private Button makeActiveCheckbox;
    private IStructuredSelection selection;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_1;

    public BuildConfigurationCreationPage(IWorkbench workbench, IStructuredSelection selection) {
        super("CreateBuildConfigurationFilePage1", selection);
        this.setTitle(AspectJUIPlugin.getResourceString("BuildConfig.createLstFile"));
        this.setDescription(AspectJUIPlugin.getResourceString("BuildConfig.createLstDesc"));
        this.workbench = workbench;
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite composite = (Composite)this.getControl();
        this.setFileName(String.valueOf(this.getFreeFileName()) + "." + "ajproperties");
        this.openFileCheckbox = new Button(composite, 32);
        this.openFileCheckbox.setText(AspectJUIPlugin.getResourceString("BuildConfig.openForEdit"));
        this.openFileCheckbox.setSelection(true);
        this.makeActiveCheckbox = new Button(composite, 32);
        this.makeActiveCheckbox.setText(AspectJUIPlugin.getResourceString("BuildConfig.activate"));
        this.makeActiveCheckbox.setSelection(true);
        this.setPageComplete(this.validatePage());
    }

    private String getFreeFileName() {
        IProject project = null;
        if (this.selection.size() > 0) {
            Object element = this.selection.getFirstElement();
            if (element instanceof IResource) {
                project = ((IResource)element).getProject();
            } else if (element instanceof IJavaElement) {
                project = ((IJavaElement)element).getJavaProject().getProject();
            }
        }
        return BuildConfigurator.getFreeFileName(project);
    }

    protected void createAdvancedControls(Composite parent) {
    }

    protected IStatus validateLinkedResource() {
        return new Status(0, "org.eclipse.ajdt.ui", 0, "", null);
    }

    protected void createLinkTarget() {
    }

    public boolean finish() {
        IFile newFile = this.createNewFile();
        if (newFile == null) {
            return false;
        }
        IProject project = newFile.getProject();
        ProjectBuildConfigurator pbc = BuildConfigurator.getBuildConfigurator().getProjectBuildConfigurator(project);
        new BuildConfiguration(newFile, pbc, this.makeActiveCheckbox.getSelection());
        try {
            IWorkbenchWindow dwindow;
            IWorkbenchPage page;
            if (this.openFileCheckbox.getSelection() && (page = (dwindow = this.workbench.getActiveWorkbenchWindow()).getActivePage()) != null) {
                IDE.openEditor((IWorkbenchPage)page, (IFile)newFile, (boolean)true);
            }
        }
        catch (PartInitException partInitException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(partInitException, (Object)this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
            return false;
        }
        AJLog.log((String)("New config file created: " + newFile.getName()));
        return true;
    }

    protected boolean validatePage() {
        if (super.validatePage()) {
            if (!this.isProjectSelected()) {
                this.setErrorMessage(AspectJUIPlugin.getResourceString("BuildConfig.needToSelectProject"));
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isProjectSelected() {
        IPath containerPath = this.getContainerFullPath();
        IProject[] projects = AspectJPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            IPath path = project.getFullPath();
            if (path.equals((Object)containerPath)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected String getNewFileLabel() {
        return AspectJUIPlugin.getResourceString("BuildConfig.newLstFile");
    }

    static {
        Factory factory = new Factory("BuildConfigurationCreationPage.java", Class.forName("org.eclipse.ajdt.internal.ui.wizards.BuildConfigurationCreationPage"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.BuildConfigurationCreationPage", "org.eclipse.ui.PartInitException:", "<missing>:"), 160);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "finish", "org.eclipse.ajdt.internal.ui.wizards.BuildConfigurationCreationPage", "", "", "", "boolean"), 140);
    }
}

