/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.wizards.exports;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.internal.ui.wizards.exports.AJJarPackageWizard;
import org.eclipse.ajdt.internal.ui.wizards.exports.AJJarPackagerUtil;
import org.eclipse.ajdt.internal.ui.wizards.exports.IJarPackageWizardPage;
import org.eclipse.ajdt.internal.ui.wizards.exports.SealPackagesFilter;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.filters.EmptyInnerPackageFilter;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerMessages;
import org.eclipse.jdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.MainMethodSearchEngine;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.viewsupport.LibraryFilter;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jdt.ui.jarpackager.JarPackageData;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;

class AJJarManifestWizardPage
extends WizardPage
implements IJarPackageWizardPage {
    private UntypedListener fUntypedListener = new UntypedListener();
    private JarPackageData fJarPackage;
    private IType[] fMainTypes;
    private Composite fManifestGroup;
    private Button fGenerateManifestRadioButton;
    private Button fSaveManifestCheckbox;
    private Button fReuseManifestCheckbox;
    private Text fNewManifestFileText;
    private Label fNewManifestFileLabel;
    private Button fNewManifestFileBrowseButton;
    private Button fUseManifestRadioButton;
    private Text fManifestFileText;
    private Label fManifestFileLabel;
    private Button fManifestFileBrowseButton;
    private Label fSealingHeaderLabel;
    private Button fSealJarRadioButton;
    private Label fSealJarLabel;
    private Button fSealedPackagesDetailsButton;
    private Button fSealPackagesRadioButton;
    private Label fSealPackagesLabel;
    private Button fUnSealedPackagesDetailsButton;
    private Label fMainClassHeaderLabel;
    private Label fMainClassLabel;
    private Text fMainClassText;
    private Button fMainClassBrowseButton;
    private static final String PAGE_NAME = "JarManifestWizardPage";
    private static final String STORE_GENERATE_MANIFEST = "JarManifestWizardPage.GENERATE_MANIFEST";
    private static final String STORE_SAVE_MANIFEST = "JarManifestWizardPage.SAVE_MANIFEST";
    private static final String STORE_REUSE_MANIFEST = "JarManifestWizardPage.REUSE_MANIFEST";
    private static final String STORE_MANIFEST_LOCATION = "JarManifestWizardPage.MANIFEST_LOCATION";
    private static final String STORE_SEAL_JAR = "JarManifestWizardPage.SEAL_JAR";
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_6;

    public AJJarManifestWizardPage(JarPackageData jarPackage) {
        super(PAGE_NAME);
        this.setTitle(JarPackagerMessages.getString((String)"JarManifestWizardPage.title"));
        this.setDescription(JarPackagerMessages.getString((String)"JarManifestWizardPage.description"));
        this.fJarPackage = jarPackage;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        this.createLabel(composite, JarPackagerMessages.getString((String)"JarManifestWizardPage.manifestSource.label"), false);
        this.createManifestGroup(composite);
        this.createSpacer(composite);
        this.fSealingHeaderLabel = this.createLabel(composite, JarPackagerMessages.getString((String)"JarManifestWizardPage.sealingHeader.label"), false);
        this.createSealingGroup(composite);
        this.createSpacer(composite);
        this.fMainClassHeaderLabel = this.createLabel(composite, JarPackagerMessages.getString((String)"JarManifestWizardPage.mainClassHeader.label"), false);
        this.createMainClassGroup(composite);
        this.setEqualButtonSizes();
        this.restoreWidgetValues();
        this.setControl((Control)composite);
        this.update();
        Dialog.applyDialogFont((Control)composite);
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.jdt.ui.jar_manifest_wizard_page_context");
    }

    protected void createManifestGroup(Composite parent) {
        this.fManifestGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        this.fManifestGroup.setLayout((Layout)layout);
        this.fManifestGroup.setLayoutData((Object)new GridData(784));
        this.fGenerateManifestRadioButton = new Button(this.fManifestGroup, 16400);
        this.fGenerateManifestRadioButton.setText(JarPackagerMessages.getString((String)"JarManifestWizardPage.genetateManifest.text"));
        this.fGenerateManifestRadioButton.addListener(13, (Listener)this.fUntypedListener);
        Composite saveOptions = new Composite(this.fManifestGroup, 0);
        GridLayout saveOptionsLayout = new GridLayout();
        saveOptionsLayout.marginWidth = 0;
        saveOptions.setLayout((Layout)saveOptionsLayout);
        GridData data = new GridData(784);
        data.horizontalIndent = 20;
        saveOptions.setLayoutData((Object)data);
        this.fSaveManifestCheckbox = new Button(saveOptions, 16416);
        this.fSaveManifestCheckbox.setText(JarPackagerMessages.getString((String)"JarManifestWizardPage.saveManifest.text"));
        this.fSaveManifestCheckbox.addListener(4, (Listener)this.fUntypedListener);
        this.fReuseManifestCheckbox = new Button(saveOptions, 16416);
        this.fReuseManifestCheckbox.setText(JarPackagerMessages.getString((String)"JarManifestWizardPage.reuseManifest.text"));
        this.fReuseManifestCheckbox.addListener(4, (Listener)this.fUntypedListener);
        this.createNewManifestFileGroup(saveOptions);
        this.fUseManifestRadioButton = new Button(this.fManifestGroup, 16400);
        this.fUseManifestRadioButton.setText(JarPackagerMessages.getString((String)"JarManifestWizardPage.useManifest.text"));
        this.fUseManifestRadioButton.setLayoutData((Object)new GridData(768));
        Composite existingManifestGroup = new Composite(this.fManifestGroup, 0);
        GridLayout existingManifestLayout = new GridLayout();
        existingManifestLayout.marginWidth = 0;
        existingManifestGroup.setLayout((Layout)existingManifestLayout);
        data = new GridData(784);
        data.horizontalIndent = 20;
        existingManifestGroup.setLayoutData((Object)data);
        this.createManifestFileGroup(existingManifestGroup);
    }

    protected void createNewManifestFileGroup(Composite parent) {
        Composite manifestFileGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.numColumns = 3;
        manifestFileGroup.setLayout((Layout)layout);
        manifestFileGroup.setLayoutData((Object)new GridData(784));
        this.fNewManifestFileLabel = new Label(manifestFileGroup, 0);
        this.fNewManifestFileLabel.setText(JarPackagerMessages.getString((String)"JarManifestWizardPage.newManifestFile.text"));
        this.fNewManifestFileText = new Text(manifestFileGroup, 2052);
        this.fNewManifestFileText.addListener(24, (Listener)this.fUntypedListener);
        GridData data = new GridData(768);
        data.widthHint = this.convertWidthInCharsToPixels(40);
        this.fNewManifestFileText.setLayoutData((Object)data);
        this.fNewManifestFileBrowseButton = new Button(manifestFileGroup, 8);
        this.fNewManifestFileBrowseButton.setText(JarPackagerMessages.getString((String)"JarManifestWizardPage.newManifestFileBrowseButton.text"));
        this.fNewManifestFileBrowseButton.setLayoutData((Object)new GridData(256));
        this.fNewManifestFileBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AJJarManifestWizardPage.this.handleNewManifestFileBrowseButtonPressed();
            }
        });
    }

    protected void createManifestFileGroup(Composite parent) {
        Composite manifestFileGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        manifestFileGroup.setLayout((Layout)layout);
        manifestFileGroup.setLayoutData((Object)new GridData(784));
        this.fManifestFileLabel = new Label(manifestFileGroup, 0);
        this.fManifestFileLabel.setText(JarPackagerMessages.getString((String)"JarManifestWizardPage.manifestFile.text"));
        this.fManifestFileText = new Text(manifestFileGroup, 2052);
        this.fManifestFileText.addListener(24, (Listener)this.fUntypedListener);
        GridData data = new GridData(768);
        data.widthHint = this.convertWidthInCharsToPixels(40);
        this.fManifestFileText.setLayoutData((Object)data);
        this.fManifestFileBrowseButton = new Button(manifestFileGroup, 8);
        this.fManifestFileBrowseButton.setText(JarPackagerMessages.getString((String)"JarManifestWizardPage.manifestFileBrowse.text"));
        this.fManifestFileBrowseButton.setLayoutData((Object)new GridData(256));
        this.fManifestFileBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AJJarManifestWizardPage.this.handleManifestFileBrowseButtonPressed();
            }
        });
    }

    protected void createSealingGroup(Composite parent) {
        Composite sealingGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.horizontalSpacing += 3;
        sealingGroup.setLayout((Layout)layout);
        sealingGroup.setLayoutData((Object)new GridData(272));
        this.createSealJarGroup(sealingGroup);
        this.createSealPackagesGroup(sealingGroup);
    }

    protected void createSealJarGroup(Composite sealGroup) {
        this.fSealJarRadioButton = new Button(sealGroup, 16);
        this.fSealJarRadioButton.setText(JarPackagerMessages.getString((String)"JarManifestWizardPage.sealJar.text"));
        this.fSealJarRadioButton.addListener(13, (Listener)this.fUntypedListener);
        this.fSealJarLabel = new Label(sealGroup, 131072);
        this.fSealJarLabel.setLayoutData((Object)new GridData(768));
        this.fSealJarLabel.setText("");
        this.fUnSealedPackagesDetailsButton = new Button(sealGroup, 8);
        this.fUnSealedPackagesDetailsButton.setLayoutData((Object)new GridData(256));
        this.fUnSealedPackagesDetailsButton.setText(JarPackagerMessages.getString((String)"JarManifestWizardPage.unsealPackagesButton.text"));
        this.fUnSealedPackagesDetailsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AJJarManifestWizardPage.this.handleUnSealPackagesDetailsButtonPressed();
            }
        });
    }

    protected void createSealPackagesGroup(Composite sealGroup) {
        this.fSealPackagesRadioButton = new Button(sealGroup, 16);
        this.fSealPackagesRadioButton.setText(JarPackagerMessages.getString((String)"JarManifestWizardPage.sealPackagesButton.text"));
        this.fSealPackagesLabel = new Label(sealGroup, 131072);
        this.fSealPackagesLabel.setLayoutData((Object)new GridData(768));
        this.fSealPackagesLabel.setText("");
        this.fSealedPackagesDetailsButton = new Button(sealGroup, 8);
        this.fSealedPackagesDetailsButton.setLayoutData((Object)new GridData(256));
        this.fSealedPackagesDetailsButton.setText(JarPackagerMessages.getString((String)"JarManifestWizardPage.sealedPackagesDetailsButton.text"));
        this.fSealedPackagesDetailsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AJJarManifestWizardPage.this.handleSealPackagesDetailsButtonPressed();
            }
        });
    }

    protected void createMainClassGroup(Composite parent) {
        Composite mainClassGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        mainClassGroup.setLayout((Layout)layout);
        mainClassGroup.setLayoutData((Object)new GridData(272));
        this.fMainClassLabel = new Label(mainClassGroup, 0);
        this.fMainClassLabel.setText(JarPackagerMessages.getString((String)"JarManifestWizardPage.mainClass.label"));
        this.fMainClassText = new Text(mainClassGroup, 2052);
        this.fMainClassText.addListener(24, (Listener)this.fUntypedListener);
        GridData data = new GridData(768);
        data.widthHint = this.convertWidthInCharsToPixels(40);
        this.fMainClassText.setLayoutData((Object)data);
        this.fMainClassText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                AJJarManifestWizardPage.this.fJarPackage.setManifestMainClass(AJJarManifestWizardPage.this.findMainMethodByName(AJJarManifestWizardPage.this.fMainClassText.getText()));
                AJJarManifestWizardPage.this.update();
            }
        });
        this.fMainClassBrowseButton = new Button(mainClassGroup, 8);
        this.fMainClassBrowseButton.setText(JarPackagerMessages.getString((String)"JarManifestWizardPage.mainClassBrowseButton.text"));
        this.fMainClassBrowseButton.setLayoutData((Object)new GridData(256));
        this.fMainClassBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AJJarManifestWizardPage.this.handleMainClassBrowseButtonPressed();
            }
        });
    }

    private void update() {
        this.updateModel();
        this.updateEnableState();
        this.updatePageCompletion();
    }

    protected void handleNewManifestFileBrowseButtonPressed() {
        SaveAsDialog dialog = new SaveAsDialog(this.getContainer().getShell());
        dialog.create();
        dialog.getShell().setText(JarPackagerMessages.getString((String)"JarManifestWizardPage.saveAsDialog.title"));
        dialog.setMessage(JarPackagerMessages.getString((String)"JarManifestWizardPage.saveAsDialog.message"));
        dialog.setOriginalFile(this.createFileHandle(this.fJarPackage.getManifestLocation()));
        if (dialog.open() == 0) {
            this.fJarPackage.setManifestLocation(dialog.getResult());
            this.fNewManifestFileText.setText(dialog.getResult().toString());
        }
    }

    protected void handleManifestFileBrowseButtonPressed() {
        ElementTreeSelectionDialog dialog = this.createWorkspaceFileSelectionDialog(JarPackagerMessages.getString((String)"JarManifestWizardPage.manifestSelectionDialog.title"), JarPackagerMessages.getString((String)"JarManifestWizardPage.manifestSelectionDialog.message"));
        if (this.fJarPackage.isManifestAccessible()) {
            dialog.setInitialSelections((Object[])new IResource[]{this.fJarPackage.getManifestFile()});
        }
        if (dialog.open() == 0) {
            Object[] resources = dialog.getResult();
            if (resources.length != 1) {
                this.setErrorMessage(JarPackagerMessages.getString((String)"JarManifestWizardPage.error.onlyOneManifestMustBeSelected"));
            } else {
                this.setErrorMessage("");
                this.fJarPackage.setManifestLocation(((IResource)resources[0]).getFullPath());
                this.fManifestFileText.setText(this.fJarPackage.getManifestLocation().toString());
            }
        }
    }

    private IType findMainMethodByName(String name) {
        if (this.fMainTypes == null) {
            List resources = AJJarPackagerUtil.asResources(this.fJarPackage.getElements());
            if (resources == null) {
                this.setErrorMessage(JarPackagerMessages.getString((String)"JarManifestWizardPage.error.noResourceSelected"));
            }
            IJavaSearchScope searchScope = JavaSearchScopeFactory.getInstance().createJavaSearchScope(resources.toArray(new IResource[resources.size()]), true);
            MainMethodSearchEngine engine = new MainMethodSearchEngine();
            try {
                this.fMainTypes = engine.searchMainMethods((IRunnableContext)this.getContainer(), searchScope, 0);
            }
            catch (InvocationTargetException invocationTargetException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(invocationTargetException, this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
            }
            catch (InterruptedException interruptedException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(interruptedException, this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_1);
            }
        }
        int i = 0;
        while (i < this.fMainTypes.length) {
            if (this.fMainTypes[i].getFullyQualifiedName().equals(name)) {
                return this.fMainTypes[i];
            }
            ++i;
        }
        return null;
    }

    protected void handleMainClassBrowseButtonPressed() {
        List resources = AJJarPackagerUtil.asResources(this.fJarPackage.getElements());
        if (resources == null) {
            this.setErrorMessage(JarPackagerMessages.getString((String)"JarManifestWizardPage.error.noResourceSelected"));
            return;
        }
        IJavaSearchScope searchScope = JavaSearchScopeFactory.getInstance().createJavaSearchScope(resources.toArray(new IResource[resources.size()]), true);
        SelectionDialog dialog = JavaUI.createMainTypeDialog((Shell)this.getContainer().getShell(), (IRunnableContext)this.getContainer(), (IJavaSearchScope)searchScope, (int)0, (boolean)false, (String)"");
        dialog.setTitle(JarPackagerMessages.getString((String)"JarManifestWizardPage.mainTypeSelectionDialog.title"));
        dialog.setMessage(JarPackagerMessages.getString((String)"JarManifestWizardPage.mainTypeSelectionDialog.message"));
        if (this.fJarPackage.getManifestMainClass() != null) {
            dialog.setInitialSelections(new Object[]{this.fJarPackage.getManifestMainClass()});
        }
        if (dialog.open() == 0) {
            this.fJarPackage.setManifestMainClass((IType)dialog.getResult()[0]);
            this.fMainClassText.setText(AJJarPackagerUtil.getMainClassName(this.fJarPackage));
        } else if (!this.fJarPackage.isMainClassValid((IRunnableContext)this.getContainer())) {
            this.fJarPackage.setManifestMainClass(null);
            this.fMainClassText.setText(AJJarPackagerUtil.getMainClassName(this.fJarPackage));
        }
    }

    protected void handleSealPackagesDetailsButtonPressed() {
        SelectionDialog dialog = this.createPackageDialog(this.getPackagesForSelectedResources(this.fJarPackage));
        dialog.setTitle(JarPackagerMessages.getString((String)"JarManifestWizardPage.sealedPackagesSelectionDialog.title"));
        dialog.setMessage(JarPackagerMessages.getString((String)"JarManifestWizardPage.sealedPackagesSelectionDialog.message"));
        dialog.setInitialSelections((Object[])this.fJarPackage.getPackagesToSeal());
        if (dialog.open() == 0) {
            this.fJarPackage.setPackagesToSeal(this.getPackagesFromDialog(dialog));
        }
        this.updateSealingInfo();
    }

    protected void handleUnSealPackagesDetailsButtonPressed() {
        SelectionDialog dialog = this.createPackageDialog(this.getPackagesForSelectedResources(this.fJarPackage));
        dialog.setTitle(JarPackagerMessages.getString((String)"JarManifestWizardPage.unsealedPackagesSelectionDialog.title"));
        dialog.setMessage(JarPackagerMessages.getString((String)"JarManifestWizardPage.unsealedPackagesSelectionDialog.message"));
        dialog.setInitialSelections((Object[])this.fJarPackage.getPackagesToUnseal());
        if (dialog.open() == 0) {
            this.fJarPackage.setPackagesToUnseal(this.getPackagesFromDialog(dialog));
        }
        this.updateSealingInfo();
    }

    protected void updateEnableState() {
        boolean generate = this.fGenerateManifestRadioButton.getSelection();
        boolean save = generate && this.fSaveManifestCheckbox.getSelection();
        this.fSaveManifestCheckbox.setEnabled(generate);
        this.fReuseManifestCheckbox.setEnabled(this.fJarPackage.isDescriptionSaved() && save);
        this.fNewManifestFileText.setEnabled(save);
        this.fNewManifestFileLabel.setEnabled(save);
        this.fNewManifestFileBrowseButton.setEnabled(save);
        this.fManifestFileText.setEnabled(!generate);
        this.fManifestFileLabel.setEnabled(!generate);
        this.fManifestFileBrowseButton.setEnabled(!generate);
        this.fSealingHeaderLabel.setEnabled(generate);
        boolean sealState = this.fSealJarRadioButton.getSelection();
        this.fSealJarRadioButton.setEnabled(generate);
        this.fSealJarLabel.setEnabled(generate);
        this.fUnSealedPackagesDetailsButton.setEnabled(sealState && generate);
        this.fSealPackagesRadioButton.setEnabled(generate);
        this.fSealPackagesLabel.setEnabled(generate);
        this.fSealedPackagesDetailsButton.setEnabled(!sealState && generate);
        this.fMainClassHeaderLabel.setEnabled(generate);
        this.fMainClassLabel.setEnabled(generate);
        this.fMainClassText.setEnabled(generate);
        this.fMainClassBrowseButton.setEnabled(generate);
        this.updateSealingInfo();
    }

    protected void updateSealingInfo() {
        if (this.fJarPackage.isJarSealed()) {
            this.fSealPackagesLabel.setText("");
            int i = this.fJarPackage.getPackagesToUnseal().length;
            if (i == 0) {
                this.fSealJarLabel.setText(JarPackagerMessages.getString((String)"JarManifestWizardPage.jarSealed"));
            } else if (i == 1) {
                this.fSealJarLabel.setText(JarPackagerMessages.getString((String)"JarManifestWizardPage.jarSealedExceptOne"));
            } else {
                this.fSealJarLabel.setText(JarPackagerMessages.getFormattedString((String)"JarManifestWizardPage.jarSealedExceptSome", (Object)new Integer(i)));
            }
        } else {
            this.fSealJarLabel.setText("");
            int i = this.fJarPackage.getPackagesToSeal().length;
            if (i == 0) {
                this.fSealPackagesLabel.setText(JarPackagerMessages.getString((String)"JarManifestWizardPage.nothingSealed"));
            } else if (i == 1) {
                this.fSealPackagesLabel.setText(JarPackagerMessages.getString((String)"JarManifestWizardPage.onePackageSealed"));
            } else {
                this.fSealPackagesLabel.setText(JarPackagerMessages.getFormattedString((String)"JarManifestWizardPage.somePackagesSealed", (Object)new Integer(i)));
            }
        }
    }

    public boolean isPageComplete() {
        boolean isPageComplete = true;
        this.setMessage(null);
        if (!this.fJarPackage.areGeneratedFilesExported()) {
            return true;
        }
        if (this.fJarPackage.isManifestGenerated() && this.fJarPackage.isManifestSaved()) {
            if (this.fJarPackage.getManifestLocation().toString().length() == 0) {
                isPageComplete = false;
            } else {
                IPath location = this.fJarPackage.getManifestLocation();
                if (!location.toString().startsWith("/")) {
                    this.setErrorMessage(JarPackagerMessages.getString((String)"JarManifestWizardPage.error.manifestPathMustBeAbsolute"));
                    return false;
                }
                IResource resource = this.findResource(location);
                if (resource != null && resource.getType() != 1) {
                    this.setErrorMessage(JarPackagerMessages.getString((String)"JarManifestWizardPage.error.manifestMustNotBeExistingContainer"));
                    return false;
                }
                resource = this.findResource(location.removeLastSegments(1));
                if (resource == null || resource.getType() == 1) {
                    this.setErrorMessage(JarPackagerMessages.getString((String)"JarManifestWizardPage.error.manifestContainerDoesNotExist"));
                    return false;
                }
            }
        }
        if (!this.fJarPackage.isManifestGenerated()) {
            if (this.fJarPackage.isManifestAccessible()) {
                Manifest manifest = null;
                try {
                    manifest = this.fJarPackage.getManifestProvider().create(this.fJarPackage);
                }
                catch (CoreException coreException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_3, (JoinPoint.StaticPart)ajc$tjp_4);
                }
                if (manifest != null && manifest.getMainAttributes().getValue(Attributes.Name.MANIFEST_VERSION) == null) {
                    this.setMessage(JarPackagerMessages.getString((String)"JarManifestWizardPage.warning.noManifestVersion"), 2);
                }
            } else {
                if (this.fJarPackage.getManifestLocation().toString().length() == 0) {
                    this.setErrorMessage(JarPackagerMessages.getString((String)"JarManifestWizardPage.error.noManifestFile"));
                } else {
                    this.setErrorMessage(JarPackagerMessages.getString((String)"JarManifestWizardPage.error.invalidManifestFile"));
                }
                return false;
            }
        }
        Set selectedPackages = this.getPackagesForSelectedResources(this.fJarPackage);
        if (this.fJarPackage.isJarSealed() && !selectedPackages.containsAll(Arrays.asList(this.fJarPackage.getPackagesToUnseal()))) {
            this.setErrorMessage(JarPackagerMessages.getString((String)"JarManifestWizardPage.error.unsealedPackagesNotInSelection"));
            return false;
        }
        if (!this.fJarPackage.isJarSealed() && !selectedPackages.containsAll(Arrays.asList(this.fJarPackage.getPackagesToSeal()))) {
            this.setErrorMessage(JarPackagerMessages.getString((String)"JarManifestWizardPage.error.sealedPackagesNotInSelection"));
            return false;
        }
        if (!this.fJarPackage.isMainClassValid((IRunnableContext)this.getContainer()) || this.fJarPackage.getManifestMainClass() == null && this.fMainClassText.getText().length() > 0) {
            this.setErrorMessage(JarPackagerMessages.getString((String)"JarManifestWizardPage.error.invalidMainClass"));
            return false;
        }
        this.setErrorMessage(null);
        return isPageComplete;
    }

    public void setPreviousPage(IWizardPage page) {
        super.setPreviousPage(page);
        this.fMainTypes = null;
        this.updateEnableState();
        if (this.getContainer() != null) {
            this.updatePageCompletion();
        }
    }

    public void finish() {
        this.saveWidgetValues();
    }

    public final void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            settings.put(STORE_GENERATE_MANIFEST, this.fJarPackage.isManifestGenerated());
            settings.put(STORE_SAVE_MANIFEST, this.fJarPackage.isManifestSaved());
            settings.put(STORE_REUSE_MANIFEST, this.fJarPackage.isManifestReused());
            settings.put(STORE_MANIFEST_LOCATION, this.fJarPackage.getManifestLocation().toString());
            settings.put(STORE_SEAL_JAR, this.fJarPackage.isJarSealed());
        }
        this.internalSaveWidgetValues();
    }

    protected void internalSaveWidgetValues() {
    }

    protected void restoreWidgetValues() {
        if (!((AJJarPackageWizard)this.getWizard()).isInitializingFromJarPackage()) {
            this.initializeJarPackage();
        }
        if (this.fJarPackage.isManifestGenerated()) {
            this.fGenerateManifestRadioButton.setSelection(true);
        } else {
            this.fUseManifestRadioButton.setSelection(true);
        }
        this.fSaveManifestCheckbox.setSelection(this.fJarPackage.isManifestSaved());
        this.fReuseManifestCheckbox.setSelection(this.fJarPackage.isManifestReused());
        this.fManifestFileText.setText(this.fJarPackage.getManifestLocation().toString());
        this.fNewManifestFileText.setText(this.fJarPackage.getManifestLocation().toString());
        if (this.fJarPackage.isJarSealed()) {
            this.fSealJarRadioButton.setSelection(true);
        } else {
            this.fSealPackagesRadioButton.setSelection(true);
        }
        this.fMainClassText.setText(AJJarPackagerUtil.getMainClassName(this.fJarPackage));
    }

    protected void initializeJarPackage() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            this.fJarPackage.setGenerateManifest(settings.getBoolean(STORE_GENERATE_MANIFEST));
            this.fJarPackage.setSaveManifest(settings.getBoolean(STORE_SAVE_MANIFEST));
            this.fJarPackage.setReuseManifest(settings.getBoolean(STORE_REUSE_MANIFEST));
            String pathStr = settings.get(STORE_MANIFEST_LOCATION);
            if (pathStr == null) {
                pathStr = "";
            }
            this.fJarPackage.setManifestLocation((IPath)new Path(pathStr));
            this.fJarPackage.setSealJar(settings.getBoolean(STORE_SEAL_JAR));
        }
    }

    protected void updateModel() {
        if (this.getControl() == null) {
            return;
        }
        this.fJarPackage.setGenerateManifest(this.fGenerateManifestRadioButton.getSelection());
        this.fJarPackage.setSaveManifest(this.fSaveManifestCheckbox.getSelection());
        this.fJarPackage.setReuseManifest(this.fReuseManifestCheckbox.getSelection());
        String path = this.fJarPackage.isManifestGenerated() ? this.fNewManifestFileText.getText() : this.fManifestFileText.getText();
        if (path == null) {
            path = "";
        }
        this.fJarPackage.setManifestLocation((IPath)new Path(path));
        this.fJarPackage.setSealJar(this.fSealJarRadioButton.getSelection());
    }

    protected void updatePageCompletion() {
        boolean pageComplete = this.isPageComplete();
        this.setPageComplete(pageComplete);
        if (pageComplete) {
            this.setErrorMessage(null);
        }
    }

    protected IFile createFileHandle(IPath filePath) {
        if (filePath.isValidPath(filePath.toString()) && filePath.segmentCount() >= 2) {
            return JavaPlugin.getWorkspace().getRoot().getFile(filePath);
        }
        return null;
    }

    protected Label createLabel(Composite parent, String text, boolean bold) {
        Label label = new Label(parent, 0);
        if (bold) {
            label.setFont(JFaceResources.getBannerFont());
        }
        label.setText(text);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    protected void setSize(Control control, int width, int height) {
        GridData gd = new GridData(3);
        gd.widthHint = width;
        gd.heightHint = height;
        control.setLayoutData((Object)gd);
    }

    protected void setEqualButtonSizes() {
        int width = SWTUtil.getButtonWidthHint((Button)this.fManifestFileBrowseButton);
        int width2 = SWTUtil.getButtonWidthHint((Button)this.fNewManifestFileBrowseButton);
        width = Math.max(width, width2);
        width2 = SWTUtil.getButtonWidthHint((Button)this.fSealedPackagesDetailsButton);
        width = Math.max(width, width2);
        width2 = SWTUtil.getButtonWidthHint((Button)this.fUnSealedPackagesDetailsButton);
        width = Math.max(width, width2);
        width2 = SWTUtil.getButtonWidthHint((Button)this.fMainClassBrowseButton);
        width = Math.max(width, width2);
        this.setSize((Control)this.fManifestFileBrowseButton, width, -1);
        this.setSize((Control)this.fNewManifestFileBrowseButton, width, -1);
        this.setSize((Control)this.fSealedPackagesDetailsButton, width, -1);
        this.setSize((Control)this.fUnSealedPackagesDetailsButton, width, -1);
        this.setSize((Control)this.fMainClassBrowseButton, width, -1);
    }

    protected void createSpacer(Composite parent) {
        Label spacer = new Label(parent, 0);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        spacer.setLayoutData((Object)data);
    }

    protected IResource findResource(IPath path) {
        IWorkspace workspace = JavaPlugin.getWorkspace();
        IStatus result = workspace.validatePath(path.toString(), 15);
        if (result.isOK() && workspace.getRoot().exists(path)) {
            return workspace.getRoot().findMember(path);
        }
        return null;
    }

    protected IPath getPathFromString(String text) {
        return new Path(text).makeAbsolute();
    }

    protected SelectionDialog createPackageDialog(Set packageFragments) {
        ArrayList<IPackageFragment> packages = new ArrayList<IPackageFragment>(packageFragments.size());
        Iterator iter = packageFragments.iterator();
        while (iter.hasNext()) {
            int kind;
            IPackageFragment fragment = (IPackageFragment)iter.next();
            boolean containsJavaElements = false;
            try {
                kind = fragment.getKind();
                containsJavaElements = fragment.getChildren().length > 0;
            }
            catch (JavaModelException javaModelException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_5, (JoinPoint.StaticPart)ajc$tjp_6);
                JavaModelException ex = javaModelException;
                ExceptionHandler.handle((CoreException)((Object)ex), (Shell)this.getContainer().getShell(), (String)JarPackagerMessages.getString((String)"JarManifestWizardPage.error.jarPackageWizardError.title"), (String)JarPackagerMessages.getFormattedString((String)"JarManifestWizardPage.error.jarPackageWizardError.message", (Object)fragment.getElementName()));
                continue;
            }
            if (kind == 2 || !containsJavaElements) continue;
            packages.add(fragment);
        }
        StandardJavaElementContentProvider cp = new StandardJavaElementContentProvider(){

            public boolean hasChildren(Object element) {
                return !(element instanceof IPackageFragment) && super.hasChildren(element);
            }
        };
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getContainer().getShell(), (ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT), (ITreeContentProvider)cp);
        dialog.setDoubleClickSelects(false);
        dialog.setInput((Object)JavaCore.create((IWorkspaceRoot)JavaPlugin.getWorkspace().getRoot()));
        dialog.addFilter((ViewerFilter)new EmptyInnerPackageFilter());
        dialog.addFilter((ViewerFilter)new LibraryFilter());
        dialog.addFilter((ViewerFilter)new SealPackagesFilter(packages));
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                StatusInfo res = new StatusInfo();
                int i = 0;
                while (i < selection.length) {
                    if (!(selection[i] instanceof IPackageFragment)) {
                        res.setError(JarPackagerMessages.getString((String)"JarManifestWizardPage.error.mustContainPackages"));
                        return res;
                    }
                    ++i;
                }
                res.setOK();
                return res;
            }
        });
        return dialog;
    }

    protected IPackageFragment[] getPackagesFromDialog(SelectionDialog dialog) {
        if (dialog.getReturnCode() == 0 && dialog.getResult().length > 0) {
            return Arrays.asList(dialog.getResult()).toArray(new IPackageFragment[dialog.getResult().length]);
        }
        return new IPackageFragment[0];
    }

    protected ElementTreeSelectionDialog createWorkspaceFileSelectionDialog(String title, String message) {
        int labelFlags = 272;
        StandardJavaElementContentProvider contentProvider = new StandardJavaElementContentProvider();
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(labelFlags);
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider);
        dialog.setAllowMultiple(false);
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                StatusInfo res = new StatusInfo();
                if (selection.length == 1 && selection[0] instanceof IFile) {
                    res.setOK();
                } else {
                    res.setError("");
                }
                return res;
            }
        });
        dialog.addFilter((ViewerFilter)new EmptyInnerPackageFilter());
        dialog.addFilter((ViewerFilter)new LibraryFilter());
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.setStatusLineAboveButtons(true);
        dialog.setInput((Object)JavaCore.create((IWorkspaceRoot)JavaPlugin.getWorkspace().getRoot()));
        return dialog;
    }

    private Set getPackagesForSelectedResources(JarPackageData jarPackage) {
        HashSet<IJavaElement> packages = new HashSet<IJavaElement>();
        int n = this.fJarPackage.getElements().length;
        int i = 0;
        while (i < n) {
            Object element = this.fJarPackage.getElements()[i];
            if (element instanceof ICompilationUnit) {
                packages.add(((ICompilationUnit)element).getParent());
            }
            ++i;
        }
        return packages;
    }

    static {
        Factory factory = new Factory("AJJarManifestWizardPage.java", Class.forName("org.eclipse.ajdt.internal.ui.wizards.exports.AJJarManifestWizardPage"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.exports.AJJarManifestWizardPage", "java.lang.reflect.InvocationTargetException:", "<missing>:"), 456);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "findMainMethodByName", "org.eclipse.ajdt.internal.ui.wizards.exports.AJJarManifestWizardPage", "java.lang.String:", "name:", "", "org.eclipse.jdt.core.IType"), 445);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.exports.AJJarManifestWizardPage", "java.lang.InterruptedException:", "<missing>:"), 458);
        ajc$tjp_3 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.exports.AJJarManifestWizardPage", "org.eclipse.core.runtime.CoreException:", "<missing>:"), 610);
        ajc$tjp_4 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "isPageComplete", "org.eclipse.ajdt.internal.ui.wizards.exports.AJJarManifestWizardPage", "", "", "", "boolean"), 577);
        ajc$tjp_5 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.exports.AJJarManifestWizardPage", "org.eclipse.jdt.core.JavaModelException:", "ex:"), 895);
        ajc$tjp_6 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("4", "createPackageDialog", "org.eclipse.ajdt.internal.ui.wizards.exports.AJJarManifestWizardPage", "java.util.Set:", "packageFragments:", "", "org.eclipse.ui.dialogs.SelectionDialog"), 886);
    }

    private class UntypedListener
    implements Listener {
        UntypedListener() {
        }

        public void handleEvent(Event e) {
            if (AJJarManifestWizardPage.this.getControl() == null) {
                return;
            }
            AJJarManifestWizardPage.this.update();
        }
    }
}

