/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.wizards.migration;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.codeconversion.CodeChecker;
import org.eclipse.ajdt.internal.buildconfig.BuildConfiguration;
import org.eclipse.ajdt.internal.buildconfig.BuildConfigurator;
import org.eclipse.ajdt.internal.buildconfig.ProjectBuildConfigurator;
import org.eclipse.ajdt.internal.ui.refactoring.RenamingUtils;
import org.eclipse.ajdt.internal.ui.wizards.migration.AJProjectListLabelProvider;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class RenameFileExtensionsPage
extends WizardPage {
    private CheckedListDialogField checkedListDialogField;
    private List ajProjects;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;

    private RenameFileExtensionsPage() {
        super(AspectJUIPlugin.getResourceString("RenameFileExtensionsPage.name"));
        this.setTitle(AspectJUIPlugin.getResourceString("RenameFileExtensionsPage.title"));
        this.setDescription(AspectJUIPlugin.getResourceString("RenameFileExtensionsPage.description"));
    }

    protected RenameFileExtensionsPage(List projects) {
        this();
        this.ajProjects = projects;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.setControl((Control)composite);
        String[] buttonLabels = new String[]{NewWizardMessages.getString((String)"ProjectsWorkbookPage.projects.checkall.button"), NewWizardMessages.getString((String)"ProjectsWorkbookPage.projects.uncheckall.button")};
        this.checkedListDialogField = new CheckedListDialogField(null, buttonLabels, (ILabelProvider)new AJProjectListLabelProvider());
        this.checkedListDialogField.setLabelText(AspectJUIPlugin.getResourceString("RenameFileExtensionsMigrationPage.message"));
        this.checkedListDialogField.setCheckAllButtonIndex(0);
        this.checkedListDialogField.setUncheckAllButtonIndex(1);
        this.checkedListDialogField.setElements((Collection)this.ajProjects);
        this.checkedListDialogField.setCheckedElements((Collection)this.ajProjects);
        this.checkedListDialogField.setViewerSorter(new ViewerSorter());
        LayoutUtil.doDefaultLayout((Composite)composite, (DialogField[])new DialogField[]{this.checkedListDialogField}, (boolean)true, (int)-1, (int)-1);
        LayoutUtil.setHorizontalGrabbing((Control)this.checkedListDialogField.getListControl(null));
        PixelConverter converter = new PixelConverter((Control)parent);
        int buttonBarWidth = converter.convertWidthInCharsToPixels(24);
        this.checkedListDialogField.setButtonsMinWidth(buttonBarWidth);
    }

    public void finishPressed(IProgressMonitor monitor) {
        AspectJUIPlugin.getDefault().disableBuildConfiguratorResourceChangeListener();
        List checkedProjects = this.checkedListDialogField.getCheckedElements();
        monitor.worked((this.ajProjects.size() - checkedProjects.size()) * 20);
        Iterator iter = checkedProjects.iterator();
        while (iter.hasNext()) {
            IProject project = (IProject)iter.next();
            RenameFileExtensionsPage.convertAspectsToAJAndOthersToJava(true, true, project, monitor);
        }
        AspectJUIPlugin.getDefault().enableBuildConfiguratorResourceChangeListener();
    }

    public static void convertAspectsToAJAndOthersToJava(boolean includeNonBuiltFiles, boolean updateBuildConfigs, IProject project, IProgressMonitor monitor) {
        try {
            project.build(6, "org.eclipse.ajdt.core.ajbuilder", null, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(coreException, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
        }
        monitor.worked(6);
        IJavaProject jp = JavaCore.create((IProject)project);
        ProjectBuildConfigurator pbc = BuildConfigurator.getBuildConfigurator().getProjectBuildConfigurator(jp);
        BuildConfiguration activeBuildConfig = pbc.getActiveBuildConfiguration();
        pbc.getBuildConfigurations().size();
        try {
            IPackageFragment[] packages = jp.getPackageFragments();
            HashMap oldToNewNames = new HashMap();
            int i = 0;
            while (i < packages.length) {
                if (!packages[i].isReadOnly()) {
                    try {
                        ICompilationUnit[] files = packages[i].getCompilationUnits();
                        int j = 0;
                        while (j < files.length) {
                            IResource resource = files[j].getResource();
                            if (includeNonBuiltFiles || activeBuildConfig.isIncluded(resource)) {
                                boolean isAspect = CodeChecker.containsAspectJConstructs((IFile)((IFile)resource));
                                if (!isAspect && resource.getFileExtension().equals("aj")) {
                                    RenamingUtils.renameFile(false, resource, (IProgressMonitor)new NullProgressMonitor(), oldToNewNames);
                                } else if (isAspect && resource.getFileExtension().equals("java")) {
                                    RenamingUtils.renameFile(true, resource, (IProgressMonitor)new NullProgressMonitor(), oldToNewNames);
                                }
                            }
                            ++j;
                        }
                    }
                    catch (JavaModelException javaModelException) {
                        UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(javaModelException, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_1);
                    }
                }
                ++i;
            }
            monitor.worked(10);
            if (updateBuildConfigs) {
                RenamingUtils.updateBuildConfigurations(oldToNewNames, project, (IProgressMonitor)new NullProgressMonitor());
            }
            monitor.worked(4);
        }
        catch (JavaModelException javaModelException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(javaModelException, ajc$tjp_3, (JoinPoint.StaticPart)ajc$tjp_1);
        }
    }

    static {
        Factory factory = new Factory("RenameFileExtensionsPage.java", Class.forName("org.eclipse.ajdt.internal.ui.wizards.migration.RenameFileExtensionsPage"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.migration.RenameFileExtensionsPage", "org.eclipse.core.runtime.CoreException:", "<missing>:"), 122);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("9", "convertAspectsToAJAndOthersToJava", "org.eclipse.ajdt.internal.ui.wizards.migration.RenameFileExtensionsPage", "boolean:boolean:org.eclipse.core.resources.IProject:org.eclipse.core.runtime.IProgressMonitor:", "includeNonBuiltFiles:updateBuildConfigs:project:monitor:", "", "void"), 112);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.migration.RenameFileExtensionsPage", "org.eclipse.jdt.core.JavaModelException:", "<missing>:"), 169);
        ajc$tjp_3 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.migration.RenameFileExtensionsPage", "org.eclipse.jdt.core.JavaModelException:", "<missing>:"), 179);
    }
}

