/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.xref.internal.ui.utils;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.contribution.xref.internal.ui.providers.TreeObject;
import org.eclipse.contribution.xref.internal.ui.providers.TreeParent;
import org.eclipse.contribution.xref.internal.ui.providers.XReferenceContentProvider;
import org.eclipse.contribution.xref.internal.ui.ras.XRefUIFFDC;
import org.eclipse.contribution.xref.ui.IDeferredXReference;
import org.eclipse.contribution.xref.ui.XReferenceUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.ide.IDE;

public class XRefUIUtils {
    private static boolean selectedOutsideJavaElement;
    static /* synthetic */ Class class$0;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_8;
    private static final JoinPoint.StaticPart ajc$tjp_9;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_10;
    private static final JoinPoint.StaticPart ajc$tjp_11;
    private static final JoinPoint.StaticPart ajc$tjp_12;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_13;
    private static final JoinPoint.StaticPart ajc$tjp_14;
    private static final JoinPoint.StaticPart ajc$tjp_15;

    static {
        Factory factory = new Factory("XRefUIUtils.java", Class.forName("org.eclipse.contribution.xref.internal.ui.utils.XRefUIUtils"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.contribution.xref.internal.ui.utils.XRefUIUtils", "org.eclipse.jdt.core.JavaModelException:", "<missing>:"), 107);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("9", "computeHighlightRangeSourceReference", "org.eclipse.contribution.xref.internal.ui.utils.XRefUIUtils", "org.eclipse.jdt.internal.ui.javaeditor.JavaEditor:", "editor:", "", "org.eclipse.jdt.core.ISourceReference"), 77);
        ajc$tjp_10 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("9", "evaluateXReferences", "org.eclipse.contribution.xref.internal.ui.utils.XRefUIUtils", "org.eclipse.contribution.xref.ui.IDeferredXReference:org.eclipse.jface.viewers.TreeViewer:org.eclipse.swt.widgets.Shell:", "xr:viewer:shell:", "", "void"), 214);
        ajc$tjp_11 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.contribution.xref.internal.ui.utils.XRefUIUtils", "java.lang.reflect.InvocationTargetException:", "invEx:"), 225);
        ajc$tjp_12 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.contribution.xref.internal.ui.utils.XRefUIUtils", "java.lang.ClassNotFoundException:", "<missing>:"), 302);
        ajc$tjp_13 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("9", "getXRefAdapterListForJavaElement", "org.eclipse.contribution.xref.internal.ui.utils.XRefUIUtils", "org.eclipse.jdt.core.IJavaElement:boolean:", "javaElement:showParentCrosscutting:", "", "java.util.List"), 283);
        ajc$tjp_14 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.contribution.xref.internal.ui.utils.XRefUIUtils", "org.eclipse.jdt.core.JavaModelException:", "<missing>:"), 306);
        ajc$tjp_15 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.contribution.xref.internal.ui.utils.XRefUIUtils", "java.lang.ClassNotFoundException:", "<missing>:"), 312);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.contribution.xref.internal.ui.utils.XRefUIUtils", "org.eclipse.jdt.core.JavaModelException:", "x:"), 184);
        ajc$tjp_3 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("a", "getElementAt", "org.eclipse.contribution.xref.internal.ui.utils.XRefUIUtils", "org.eclipse.jdt.internal.ui.javaeditor.JavaEditor:int:boolean:", "editor:offset:reconcile:", "", "org.eclipse.jdt.core.IJavaElement"), 123);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.contribution.xref.internal.ui.utils.XRefUIUtils", "org.eclipse.core.runtime.CoreException:", "<missing>:"), 188);
        ajc$tjp_5 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.contribution.xref.internal.ui.utils.XRefUIUtils", "java.lang.Exception:", "<missing>:"), 199);
        ajc$tjp_6 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("9", "revealInEditor", "org.eclipse.contribution.xref.internal.ui.utils.XRefUIUtils", "org.eclipse.jdt.core.IJavaElement:", "j:", "", "void"), 195);
        ajc$tjp_7 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.contribution.xref.internal.ui.utils.XRefUIUtils", "org.eclipse.core.runtime.CoreException:", "<missing>:"), 209);
        ajc$tjp_8 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("9", "revealInEditor", "org.eclipse.contribution.xref.internal.ui.utils.XRefUIUtils", "org.eclipse.core.resources.IResource:", "r:", "", "void"), 204);
        ajc$tjp_9 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.contribution.xref.internal.ui.utils.XRefUIUtils", "java.lang.InterruptedException:", "<missing>:"), 223);
        selectedOutsideJavaElement = false;
    }

    public static ISourceReference computeHighlightRangeSourceReference(JavaEditor editor) {
        ISourceViewer sourceViewer = editor.getViewer();
        if (sourceViewer == null) {
            return null;
        }
        StyledText styledText = sourceViewer.getTextWidget();
        if (styledText == null) {
            return null;
        }
        int caret = 0;
        if (sourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)sourceViewer;
            caret = extension.widgetOffset2ModelOffset(styledText.getCaretOffset());
        } else {
            int offset = sourceViewer.getVisibleRegion().getOffset();
            caret = offset + styledText.getCaretOffset();
        }
        IJavaElement element = XRefUIUtils.getElementAt(editor, caret, false);
        if (!(element instanceof ISourceReference)) {
            return null;
        }
        if (element.getElementType() == 13) {
            IImportDeclaration declaration = (IImportDeclaration)element;
            IImportContainer container = (IImportContainer)declaration.getParent();
            ISourceRange srcRange = null;
            try {
                srcRange = container.getSourceRange();
            }
            catch (JavaModelException javaModelException) {
                XRefUIFFDC.aspectOf().ajc$before$org_eclipse_contribution_xref_ras_FFDC$1$31280822(javaModelException, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
            }
            if (srcRange != null && srcRange.getOffset() == caret) {
                return container;
            }
        }
        return (ISourceReference)element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IJavaElement getElementAt(JavaEditor editor, int offset, boolean reconcile) {
        block18: {
            IWorkingCopyManager manager = JavaPlugin.getDefault().getWorkingCopyManager();
            ICompilationUnit unit = manager.getWorkingCopy(editor.getEditorInput());
            if (unit != null) {
                try {
                    if (reconcile) {
                        ICompilationUnit iCompilationUnit = unit;
                        synchronized (iCompilationUnit) {
                            unit.reconcile(0, false, null, null);
                        }
                        IJavaElement elementAt = unit.getElementAt(offset);
                        if (elementAt != null) {
                            return elementAt;
                        }
                        IJavaElement[] children = unit.getChildren();
                        int i = 0;
                        while (i < children.length) {
                            if (children[i] instanceof SourceType) {
                                return children[i];
                            }
                            ++i;
                        }
                        break block18;
                    }
                    if (unit.isConsistent()) {
                        IJavaElement elementAt = unit.getElementAt(offset);
                        if (elementAt != null) {
                            return elementAt;
                        }
                        IResource res = unit.getCorrespondingResource();
                        if (res instanceof IFile) {
                            IFile file = (IFile)res;
                            IProject containingProject = file.getProject();
                            IMarker[] javaModelMarkers = containingProject.findMarkers("org.eclipse.jdt.core.problem", false, 2);
                            int i = 0;
                            while (i < javaModelMarkers.length) {
                                IMarker marker = javaModelMarkers[i];
                                if (marker.getResource().equals((Object)file)) {
                                    return null;
                                }
                                ++i;
                            }
                        }
                        if (elementAt == null && unit.getChildren().length != 0) {
                            selectedOutsideJavaElement = true;
                            return unit.getChildren()[0];
                        }
                    }
                }
                catch (JavaModelException javaModelException) {
                    XRefUIFFDC.aspectOf().ajc$before$org_eclipse_contribution_xref_ras_FFDC$1$31280822(javaModelException, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_3);
                    JavaModelException x = javaModelException;
                    if (!x.isDoesNotExist()) {
                        JavaPlugin.log((IStatus)x.getStatus());
                    }
                }
                catch (CoreException coreException) {
                    XRefUIFFDC.aspectOf().ajc$before$org_eclipse_contribution_xref_ras_FFDC$1$31280822(coreException, ajc$tjp_4, (JoinPoint.StaticPart)ajc$tjp_3);
                }
            }
        }
        return null;
    }

    public static void revealInEditor(IJavaElement j) {
        try {
            IEditorPart p = JavaUI.openInEditor((IJavaElement)j);
            JavaUI.revealInEditor((IEditorPart)p, (IJavaElement)j);
        }
        catch (Exception exception) {
            XRefUIFFDC.aspectOf().ajc$before$org_eclipse_contribution_xref_ras_FFDC$1$31280822(exception, ajc$tjp_5, (JoinPoint.StaticPart)ajc$tjp_6);
        }
    }

    public static void revealInEditor(IResource r) {
        try {
            IMarker m = r.createMarker("org.eclipse.core.resources.marker");
            IDE.openEditor((IWorkbenchPage)XRefUIUtils.getActiveWorkbenchWindow().getActivePage(), (IMarker)m, (boolean)true);
        }
        catch (CoreException coreException) {
            XRefUIFFDC.aspectOf().ajc$before$org_eclipse_contribution_xref_ras_FFDC$1$31280822(coreException, ajc$tjp_7, (JoinPoint.StaticPart)ajc$tjp_8);
        }
    }

    public static void evaluateXReferences(IDeferredXReference xr, TreeViewer viewer, Shell shell) {
        try {
            new ProgressMonitorDialog(shell).run(true, true, (IRunnableWithProgress)xr);
            if (!(viewer.getContentProvider() instanceof XReferenceContentProvider)) {
                return;
            }
            ((XReferenceContentProvider)viewer.getContentProvider()).refresh();
            viewer.refresh();
            viewer.expandToLevel(3);
        }
        catch (InterruptedException interruptedException) {
            XRefUIFFDC.aspectOf().ajc$before$org_eclipse_contribution_xref_ras_FFDC$1$31280822(interruptedException, ajc$tjp_9, (JoinPoint.StaticPart)ajc$tjp_10);
        }
        catch (InvocationTargetException invocationTargetException) {
            XRefUIFFDC.aspectOf().ajc$before$org_eclipse_contribution_xref_ras_FFDC$1$31280822(invocationTargetException, ajc$tjp_11, (JoinPoint.StaticPart)ajc$tjp_10);
            InvocationTargetException invEx = invocationTargetException;
            System.err.println("Something nasty here, " + xr + " could not be evaluated: " + invEx);
        }
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return XReferenceUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static List getXRefAdapterForSelection(IWorkbenchPart part, ISelection selection, boolean showParentCrosscutting) {
        ArrayList xrefAdapterList = new ArrayList();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object first = structuredSelection.getFirstElement();
            if (first instanceof IJavaElement) {
                return XRefUIUtils.getXRefAdapterListForJavaElement((IJavaElement)first, showParentCrosscutting);
            }
        } else if (part instanceof IEditorPart && selection instanceof ITextSelection && part instanceof JavaEditor) {
            JavaEditor je = (JavaEditor)part;
            ISourceReference sourceRef = XRefUIUtils.computeHighlightRangeSourceReference(je);
            IJavaElement javaElement = (IJavaElement)sourceRef;
            return XRefUIUtils.getXRefAdapterListForJavaElement(javaElement, showParentCrosscutting);
        }
        return xrefAdapterList;
    }

    public static IJavaElement getSelectedJavaElement(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object first = structuredSelection.getFirstElement();
            if (first instanceof IJavaElement && !(first instanceof IJavaProject)) {
                return (IJavaElement)first;
            }
        } else if (part instanceof IEditorPart && selection instanceof ITextSelection && part instanceof JavaEditor) {
            JavaEditor je = (JavaEditor)part;
            ISourceReference sourceRef = XRefUIUtils.computeHighlightRangeSourceReference(je);
            IJavaElement javaElement = (IJavaElement)sourceRef;
            return javaElement;
        }
        return null;
    }

    public static List getXRefAdapterListForJavaElement(IJavaElement javaElement, boolean showParentCrosscutting) {
        ArrayList<Object> xrefAdapterList = new ArrayList<Object>();
        if (javaElement != null && !javaElement.exists()) {
            return xrefAdapterList;
        }
        if (javaElement != null && (showParentCrosscutting || selectedOutsideJavaElement)) {
            ICompilationUnit parent = (ICompilationUnit)javaElement.getAncestor(5);
            if (parent != null) {
                try {
                    IType[] types = parent.getAllTypes();
                    int i = 0;
                    while (i < types.length) {
                        SourceType a;
                        if (types[i] instanceof SourceType && types[i].getParent() instanceof ICompilationUnit && (a = (SourceType)types[i]) != null) {
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("org.eclipse.contribution.xref.core.IXReferenceAdapter");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    XRefUIFFDC.aspectOf().ajc$before$org_eclipse_contribution_xref_ras_FFDC$1$31280822(classNotFoundException, ajc$tjp_12, (JoinPoint.StaticPart)ajc$tjp_13);
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            xrefAdapterList.add(a.getAdapter((Class)clazz));
                        }
                        ++i;
                    }
                }
                catch (JavaModelException javaModelException) {
                    XRefUIFFDC.aspectOf().ajc$before$org_eclipse_contribution_xref_ras_FFDC$1$31280822(javaModelException, ajc$tjp_14, (JoinPoint.StaticPart)ajc$tjp_13);
                }
            }
        } else {
            IJavaElement a = javaElement;
            if (a != null) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.contribution.xref.core.IXReferenceAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        XRefUIFFDC.aspectOf().ajc$before$org_eclipse_contribution_xref_ras_FFDC$1$31280822(classNotFoundException, ajc$tjp_15, (JoinPoint.StaticPart)ajc$tjp_13);
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                xrefAdapterList.add(a.getAdapter((Class)clazz));
            }
        }
        selectedOutsideJavaElement = false;
        return xrefAdapterList;
    }

    public static ISelection getCurrentSelection() {
        IWorkbenchWindow window = JavaPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getSelectionService().getSelection();
        }
        return null;
    }

    public static TreeObject getTreeObjectForSelection(TreeViewer viewer, ISelection selection, IWorkbenchPart part) {
        if (selection instanceof IStructuredSelection) {
            Object data;
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object first = structuredSelection.getFirstElement();
            if (first instanceof IJavaElement) {
                return XRefUIUtils.getTreeObjectForJavaElement(viewer.getTree().getItems(), (IJavaElement)first);
            }
            if (first instanceof TreeObject && (data = ((TreeObject)first).getData()) instanceof IJavaElement) {
                return XRefUIUtils.getTreeObjectForJavaElement(viewer.getTree().getItems(), (IJavaElement)data);
            }
        } else if (part instanceof IEditorPart && selection instanceof ITextSelection && part instanceof JavaEditor) {
            JavaEditor je = (JavaEditor)part;
            ISourceReference sourceRef = XRefUIUtils.computeHighlightRangeSourceReference(je);
            IJavaElement javaElement = (IJavaElement)sourceRef;
            return XRefUIUtils.getTreeObjectForJavaElement(viewer.getTree().getItems(), javaElement);
        }
        return null;
    }

    public static TreeObject getTreeObjectForJavaElement(TreeItem[] items, IJavaElement javaElement) {
        int i = 0;
        while (i < items.length) {
            Object o = items[i].getData();
            TreeParent treeParent = null;
            TreeObject treeObject = null;
            if (o instanceof TreeParent) {
                treeParent = (TreeParent)o;
            } else if (o instanceof TreeObject) {
                treeObject = (TreeObject)o;
            }
            TreeObject element = null;
            element = treeParent == null ? treeObject : treeParent;
            if (element != null && element.getData() != null && element.getData().equals(javaElement)) {
                return element;
            }
            element = XRefUIUtils.getTreeObjectForJavaElement(items[i].getItems(), javaElement);
            if (element != null) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public static void setSelection(IWorkbenchPart part, ISelection selection, TreeViewer viewer) {
        TreeObject o = XRefUIUtils.getTreeObjectForSelection(viewer, selection, part);
        if (o != null) {
            viewer.setSelection((ISelection)new StructuredSelection((Object)o), true);
            viewer.reveal((Object)o);
        } else if (selection != null) {
            viewer.setSelection(selection, true);
            viewer.reveal((Object)selection);
        }
    }
}

