/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.xref.ui.views;

import java.util.Iterator;
import java.util.List;
import org.eclipse.contribution.xref.core.IXReferenceAdapter;
import org.eclipse.contribution.xref.core.XReferenceProviderManager;
import org.eclipse.contribution.xref.internal.ui.actions.CollapseAllAction;
import org.eclipse.contribution.xref.internal.ui.actions.DoubleClickAction;
import org.eclipse.contribution.xref.internal.ui.actions.ToggleLinkingAction;
import org.eclipse.contribution.xref.internal.ui.actions.ToggleShowXRefsForFileAction;
import org.eclipse.contribution.xref.internal.ui.actions.XReferenceCustomFilterAction;
import org.eclipse.contribution.xref.internal.ui.providers.XReferenceContentProvider;
import org.eclipse.contribution.xref.internal.ui.providers.XReferenceLabelProvider;
import org.eclipse.contribution.xref.internal.ui.utils.XRefUIUtils;
import org.eclipse.contribution.xref.ui.XReferenceUIPlugin;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.views.contentoutline.ContentOutline;

public class XReferenceView
extends ViewPart
implements ISelectionListener,
IPartListener {
    public static final String ID = "org.eclipse.contribution.xref.ui.views.XReferenceView";
    public static final String LINK_ID = "org.eclipse.contribution.xref.ui.views.XReferenceView.link";
    public static final String XREFS_FOR_FILE_ID = "org.eclipse.contribution.xref.ui.views.XReferenceView.xrefsForFile";
    private Action doubleClickAction;
    private Action collapseAllAction;
    private Action toggleLinkingAction;
    private Action toggleShowXRefsForFileAction;
    private Action xRefCustomFilterAction;
    private boolean linkingEnabled = true;
    private boolean showXRefsForFileEnabled = false;
    private boolean changeDrivenByBuild = false;
    private List lastXRefAdapterList;
    private List lastLinkedXRefAdapterList;
    private ISelection lastSelection;
    private ISelection lastLinkedSelection;
    private IWorkbenchPart lastWorkbenchPart;
    private IWorkbenchPart lastLinkedWorkbenchPart;
    private IJavaElement lastJavaElement;
    private IJavaElement lastLinkedJavaElement;
    private TreeViewer viewer;
    private XReferenceContentProvider contentProvider;

    public XReferenceView() {
        XReferenceUIPlugin.xrefView = this;
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 770);
        this.contentProvider = new XReferenceContentProvider();
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new XReferenceLabelProvider());
        this.viewer.setAutoExpandLevel(-1);
        this.restorePersistedSettings();
        this.makeActions();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        IWorkbenchWindow window = XRefUIUtils.getActiveWorkbenchWindow();
        if (window != null) {
            window.getSelectionService().addPostSelectionListener((ISelectionListener)this);
        }
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        XReferenceProviderManager.getManager().setIsInplace(false);
        this.addListenersToOpenEditors();
        if (!(part instanceof AbstractTextEditor) && !(part instanceof ContentOutline)) {
            return;
        }
        List xraList = null;
        this.lastJavaElement = XRefUIUtils.getSelectedJavaElement(part, selection);
        if (this.linkingEnabled) {
            xraList = this.showXRefsForFileEnabled ? XRefUIUtils.getXRefAdapterListForJavaElement(this.lastJavaElement, true) : XRefUIUtils.getXRefAdapterListForJavaElement(this.lastJavaElement, false);
            if (xraList == null || xraList.isEmpty() || !this.lastJavaElement.exists()) {
                this.clearView();
            } else if (this.lastXRefAdapterList == null || this.lastXRefAdapterList.isEmpty()) {
                this.viewer.setInput((Object)xraList);
                XRefUIUtils.setSelection(part, selection, this.viewer);
            } else if (!this.sameXRefAdapter(this.lastXRefAdapterList, xraList)) {
                this.viewer.setInput((Object)xraList);
                XRefUIUtils.setSelection(part, selection, this.viewer);
            } else if (this.changeDrivenByBuild) {
                this.viewer.setInput((Object)xraList);
                XRefUIUtils.setSelection(part, selection, this.viewer);
            } else {
                XRefUIUtils.setSelection(part, selection, this.viewer);
            }
            this.lastWorkbenchPart = part;
            this.lastSelection = selection;
            this.lastXRefAdapterList = xraList;
            this.lastLinkedSelection = selection;
            this.lastLinkedWorkbenchPart = part;
            this.lastLinkedXRefAdapterList = xraList;
            this.lastLinkedJavaElement = this.lastJavaElement;
        } else {
            xraList = this.showXRefsForFileEnabled ? XRefUIUtils.getXRefAdapterListForJavaElement(this.lastLinkedJavaElement, true) : XRefUIUtils.getXRefAdapterListForJavaElement(this.lastLinkedJavaElement, false);
            if (xraList == null || xraList.isEmpty() || !this.lastLinkedJavaElement.exists()) {
                this.clearView();
            } else if (this.lastXRefAdapterList == null || this.lastXRefAdapterList.isEmpty()) {
                this.viewer.setInput((Object)xraList);
                XRefUIUtils.setSelection(this.lastLinkedWorkbenchPart, this.lastLinkedSelection, this.viewer);
            } else if (this.sameXRefAdapter(this.lastLinkedXRefAdapterList, xraList) && this.changeDrivenByBuild) {
                this.viewer.setInput((Object)xraList);
                XRefUIUtils.setSelection(this.lastLinkedWorkbenchPart, this.lastLinkedSelection, this.viewer);
            }
            this.lastWorkbenchPart = part;
            this.lastSelection = selection;
            this.lastXRefAdapterList = xraList;
        }
    }

    private boolean sameXRefAdapter(List previousXRefAdapterList, List currentXRefAdapterList) {
        boolean sameXRefAdapter = true;
        Iterator iter = currentXRefAdapterList.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            boolean foundMatch = false;
            if (o instanceof IXReferenceAdapter) {
                IXReferenceAdapter currentXra = (IXReferenceAdapter)o;
                Iterator i2 = previousXRefAdapterList.iterator();
                while (i2.hasNext()) {
                    Object o2 = i2.next();
                    if (!(o2 instanceof IXReferenceAdapter)) continue;
                    IXReferenceAdapter lastXra = (IXReferenceAdapter)o2;
                    if (!currentXra.getReferenceSource().equals(lastXra.getReferenceSource())) continue;
                    foundMatch = true;
                }
            }
            if (foundMatch) continue;
            sameXRefAdapter = false;
        }
        return sameXRefAdapter;
    }

    public void dispose() {
        IEditorReference[] openEditors;
        IWorkbenchPage activePage;
        IWorkbenchWindow activeWindow;
        super.dispose();
        IWorkbenchWindow window = XRefUIUtils.getActiveWorkbenchWindow();
        if (window != null) {
            window.getSelectionService().removePostSelectionListener((ISelectionListener)this);
        }
        if ((activeWindow = JavaPlugin.getActiveWorkbenchWindow()) != null && (activePage = activeWindow.getActivePage()) != null && (openEditors = activePage.getEditorReferences()).length != 0) {
            int i = 0;
            while (i < openEditors.length) {
                openEditors[i].getPage().removePartListener((IPartListener)this);
                ++i;
            }
        }
        this.persistSettings();
        XReferenceUIPlugin.xrefView = null;
    }

    public boolean isLinkingEnabled() {
        return this.linkingEnabled;
    }

    public void setLinkingEnabled(boolean isOn) {
        this.linkingEnabled = isOn;
        if (this.linkingEnabled) {
            List xraList = null;
            xraList = this.showXRefsForFileEnabled ? XRefUIUtils.getXRefAdapterListForJavaElement(this.lastJavaElement, true) : XRefUIUtils.getXRefAdapterListForJavaElement(this.lastJavaElement, false);
            this.viewer.setInput((Object)xraList);
        }
    }

    public boolean isShowXRefsForFileEnabled() {
        return this.showXRefsForFileEnabled;
    }

    public void setShowXRefsForFileEnabled(boolean isOn) {
        this.showXRefsForFileEnabled = isOn;
        List xraList = null;
        IWorkbenchPart part = null;
        if (!this.linkingEnabled) {
            if (this.lastLinkedSelection != null && this.lastLinkedWorkbenchPart != null) {
                part = this.lastLinkedWorkbenchPart;
                xraList = this.showXRefsForFileEnabled ? XRefUIUtils.getXRefAdapterListForJavaElement(this.lastLinkedJavaElement, true) : XRefUIUtils.getXRefAdapterListForJavaElement(this.lastLinkedJavaElement, false);
            }
        } else if (this.lastSelection != null && this.lastWorkbenchPart != null) {
            part = this.lastWorkbenchPart;
            xraList = this.showXRefsForFileEnabled ? XRefUIUtils.getXRefAdapterListForJavaElement(this.lastJavaElement, true) : XRefUIUtils.getXRefAdapterListForJavaElement(this.lastJavaElement, false);
        }
        if (xraList != null) {
            ISelection sel = this.viewer.getSelection();
            this.viewer.setInput(xraList);
            XRefUIUtils.setSelection(part, sel, this.viewer);
        }
    }

    public void collapseAll() {
        this.viewer.collapseAll();
    }

    public ISelection getLastSelection() {
        return this.lastSelection;
    }

    public IWorkbenchPart getLastSelectedWorkbenchPart() {
        return this.lastWorkbenchPart;
    }

    private void persistSettings() {
        IPreferenceStore pstore = XReferenceUIPlugin.getDefault().getPreferenceStore();
        if (!pstore.contains(LINK_ID)) {
            pstore.setDefault(LINK_ID, true);
        }
        pstore.setValue(LINK_ID, this.linkingEnabled);
        if (!pstore.contains(XREFS_FOR_FILE_ID)) {
            pstore.setDefault(XREFS_FOR_FILE_ID, false);
        }
        pstore.setValue(XREFS_FOR_FILE_ID, this.showXRefsForFileEnabled);
        XReferenceUIPlugin.getDefault().savePluginPreferences();
    }

    private void restorePersistedSettings() {
        IPreferenceStore pstore = XReferenceUIPlugin.getDefault().getPreferenceStore();
        if (pstore.contains(LINK_ID)) {
            this.linkingEnabled = pstore.getBoolean(LINK_ID);
        }
        if (pstore.contains(XREFS_FOR_FILE_ID)) {
            this.showXRefsForFileEnabled = pstore.getBoolean(XREFS_FOR_FILE_ID);
        }
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.toggleLinkingAction);
        manager.add((IAction)this.toggleShowXRefsForFileAction);
        manager.add((IContributionItem)new Separator("filters"));
        manager.add((IAction)this.xRefCustomFilterAction);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.collapseAllAction);
        manager.add((IAction)this.toggleLinkingAction);
        manager.add((IAction)this.toggleShowXRefsForFileAction);
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                XReferenceView.this.doubleClickAction.run();
            }
        });
    }

    private void makeActions() {
        this.toggleLinkingAction = new ToggleLinkingAction(this);
        this.collapseAllAction = new CollapseAllAction(this);
        this.doubleClickAction = new DoubleClickAction(this.getViewSite().getShell(), this.viewer);
        this.toggleShowXRefsForFileAction = new ToggleShowXRefsForFileAction(this);
        this.xRefCustomFilterAction = new XReferenceCustomFilterAction(this.getSite().getShell());
    }

    private void addListenersToOpenEditors() {
        IEditorReference[] openEditors;
        IWorkbenchPage activePage;
        IWorkbenchWindow activeWindow = JavaPlugin.getActiveWorkbenchWindow();
        if (activeWindow != null && (activePage = activeWindow.getActivePage()) != null && (openEditors = activePage.getEditorReferences()).length != 0) {
            int i = 0;
            while (i < openEditors.length) {
                openEditors[i].getPage().addPartListener((IPartListener)this);
                ++i;
            }
        }
    }

    public void setChangeDrivenByBuild(boolean changeDrivenByBuild) {
        this.changeDrivenByBuild = changeDrivenByBuild;
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        IEditorReference[] openEditors;
        IWorkbenchPage activePage;
        IWorkbenchWindow activeWindow;
        if (part instanceof IEditorPart && (activeWindow = JavaPlugin.getActiveWorkbenchWindow()) != null && (activePage = activeWindow.getActivePage()) != null && (openEditors = activePage.getEditorReferences()).length == 0) {
            this.clearView();
            if (this.linkingEnabled) {
                this.lastXRefAdapterList = null;
                this.lastSelection = null;
                this.lastWorkbenchPart = null;
                this.lastJavaElement = null;
            }
        }
    }

    private void clearView() {
        if (this.viewer != null && this.viewer.getContentProvider() != null) {
            this.viewer.setInput(null);
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public TreeViewer getTreeViewer() {
        return this.viewer;
    }

    public Action getCustomFilterAction() {
        return this.xRefCustomFilterAction;
    }

    public Action getToggleShowXRefsForEntireFileAction() {
        return this.toggleShowXRefsForFileAction;
    }

    public Action getToggleLinkWithEditorAction() {
        return this.toggleLinkingAction;
    }
}

