/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.codeconversion;

import java.util.ArrayList;
import org.eclipse.ajdt.codeconversion.AspectsConvertingParser;
import org.eclipse.ajdt.codeconversion.ConversionOptions;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.BufferChangedEvent;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IBufferChangedListener;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.JavaModelException;

public class JavaCompatibleBuffer
implements IBuffer,
IBufferChangedListener {
    private IBuffer realBuffer;
    private IBuffer fakeBuffer;
    private ArrayList insertionTable;
    private boolean upToDate = false;
    private ConversionOptions conversionOptions = ConversionOptions.STANDARD;

    public JavaCompatibleBuffer(IBuffer real, IBuffer fake) {
        this.realBuffer = real;
        this.fakeBuffer = fake;
        real.addBufferChangedListener((IBufferChangedListener)this);
    }

    public void reinitialize(IBuffer buf) {
        if (buf != this.realBuffer) {
            this.realBuffer = buf;
            this.realBuffer.addBufferChangedListener((IBufferChangedListener)this);
            this.upToDate = false;
        }
    }

    public void close() {
    }

    public char getChar(int position) {
        this.ensureUpToDate();
        return this.fakeBuffer.getChar(position);
    }

    public char[] getCharacters() {
        this.ensureUpToDate();
        return this.fakeBuffer.getCharacters();
    }

    public String getContents() {
        this.ensureUpToDate();
        return this.fakeBuffer.getContents();
    }

    public int getLength() {
        this.ensureUpToDate();
        return this.fakeBuffer.getLength();
    }

    public String getText(int offset, int length) {
        this.ensureUpToDate();
        return this.fakeBuffer.getText(offset, length);
    }

    public String toString() {
        this.ensureUpToDate();
        return this.fakeBuffer.toString();
    }

    public void addBufferChangedListener(IBufferChangedListener listener) {
        this.realBuffer.addBufferChangedListener(listener);
    }

    public void append(char[] text) {
        this.realBuffer.append(text);
    }

    public void append(String text) {
        this.realBuffer.append(text);
    }

    public boolean equals(Object obj) {
        return this.realBuffer.equals(obj);
    }

    public IOpenable getOwner() {
        return this.realBuffer.getOwner();
    }

    public IResource getUnderlyingResource() {
        return this.realBuffer.getUnderlyingResource();
    }

    public int hashCode() {
        return this.realBuffer.hashCode();
    }

    public boolean hasUnsavedChanges() {
        return this.realBuffer.hasUnsavedChanges();
    }

    public boolean isClosed() {
        return this.realBuffer.isClosed();
    }

    public boolean isReadOnly() {
        return this.realBuffer.isReadOnly();
    }

    public void removeBufferChangedListener(IBufferChangedListener listener) {
        this.realBuffer.removeBufferChangedListener(listener);
    }

    public void replace(int position, int length, char[] text) {
        if ((position = this.translatePositionToReal(position)) != -1) {
            this.realBuffer.replace(position, length, text);
        }
    }

    public void replace(int position, int length, String text) {
        if ((position = this.translatePositionToReal(position)) != -1) {
            this.realBuffer.replace(position, length, text);
        }
    }

    public void save(IProgressMonitor progress, boolean force) throws JavaModelException {
        this.realBuffer.save(progress, force);
    }

    public void setContents(char[] contents) {
        this.realBuffer.setContents(contents);
    }

    public void setContents(String contents) {
        this.realBuffer.setContents(contents);
    }

    private void ensureUpToDate() {
        if (!this.upToDate) {
            this.fakeBuffer.setContents((char[])this.realBuffer.getCharacters().clone());
            AspectsConvertingParser conv = new AspectsConvertingParser((char[])this.realBuffer.getCharacters().clone());
            this.insertionTable = conv.convert(this.conversionOptions);
            this.fakeBuffer.setContents(conv.content);
            this.upToDate = true;
        }
    }

    public int translatePositionToReal(int pos) {
        this.ensureUpToDate();
        return AspectsConvertingParser.translatePositionToBeforeChanges(pos, this.insertionTable);
    }

    public int translatePositionToFake(int pos) {
        this.ensureUpToDate();
        return AspectsConvertingParser.translatePositionToAfterChanges(pos, this.insertionTable);
    }

    public void bufferChanged(BufferChangedEvent event) {
        if (this.realBuffer.isClosed()) {
            this.fakeBuffer.close();
        }
        this.upToDate = false;
    }

    public ConversionOptions getConversionOptions() {
        return this.conversionOptions;
    }

    public void setConversionOptions(ConversionOptions conversionOptions) {
        this.conversionOptions = conversionOptions;
        this.upToDate = false;
    }
}

