/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.core.builder;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.OutputLocationManager;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AJLog;
import org.eclipse.ajdt.core.AspectJCorePreferences;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.core.CoreUtils;
import org.eclipse.ajdt.core.builder.IProjectProperties;
import org.eclipse.ajdt.internal.core.builder.BuildClasspathResolver;
import org.eclipse.ajdt.internal.core.ras.CoreFFDC;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class CoreProjectProperties
implements IProjectProperties {
    private String cachedClasspath = null;
    private Map filesKnownMap = new HashMap();
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_5;

    public String getProjectName() {
        return AspectJPlugin.getDefault().getCurrentProject().getName();
    }

    public String getClassToExecute() {
        AJLog.log("*** AJ Plugin: ProjectProperties.getClassToExecute NOT IMPLEMENTED ***");
        return null;
    }

    public String getRootProjectDir() {
        IProject project = AspectJPlugin.getDefault().getCurrentProject();
        return project.getLocation().toOSString();
    }

    public List getBuildConfigFiles() {
        return null;
    }

    public String getDefaultBuildConfigFile() {
        String defaultLstFile = AspectJPlugin.getBuildConfigurationFile(AspectJPlugin.getDefault().getCurrentProject());
        return defaultLstFile;
    }

    public String getLastActiveBuildConfigFile() {
        String currentLstFile = AspectJPlugin.getBuildConfigurationFile(AspectJPlugin.getDefault().getCurrentProject());
        return currentLstFile;
    }

    public List getProjectSourceFiles() {
        IProject project = AspectJPlugin.getDefault().getCurrentProject();
        ArrayList sourceFiles = new ArrayList();
        try {
            IJavaProject jp = JavaCore.create((IProject)project);
            IClasspathEntry[] cpes = jp.getRawClasspath();
            int i = 0;
            while (i < cpes.length) {
                IPath path;
                IResource res;
                if (cpes[i].getEntryKind() == 3 && (res = project.findMember((path = cpes[i].getPath()).removeFirstSegments(1))) != null && res instanceof IContainer) {
                    List l = this.allFiles((IContainer)res);
                    sourceFiles.addAll(l);
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
        }
        return sourceFiles;
    }

    public void setProjectSourceFileListKnown(IProject project, boolean known) {
        this.filesKnownMap.put(project, new Boolean(known));
    }

    public boolean isProjectSourceFileListKnown(IProject project) {
        Boolean known = (Boolean)this.filesKnownMap.get(project);
        if (known == null) {
            return false;
        }
        return known;
    }

    private List allFiles(IContainer folder) {
        final ArrayList contents = new ArrayList();
        try {
            folder.accept(new IResourceVisitor(){

                public boolean visit(IResource res) {
                    if (res.getType() == 1 && CoreUtils.ASPECTJ_SOURCE_FILTER.accept(res.getName())) {
                        contents.add(res.getLocation().toFile());
                    }
                    return true;
                }
            });
        }
        catch (CoreException coreException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_3);
        }
        return contents;
    }

    public String getProjectSourcePath() {
        IProject p = AspectJPlugin.getDefault().getCurrentProject();
        return p.getLocation().toOSString();
    }

    public String getClasspath() {
        if (this.cachedClasspath != null) {
            return this.cachedClasspath;
        }
        IProject proj = AspectJPlugin.getDefault().getCurrentProject();
        IJavaProject jp = JavaCore.create((IProject)proj);
        this.cachedClasspath = new BuildClasspathResolver().getClasspath(AspectJPlugin.getWorkspace().getRoot(), jp);
        return this.cachedClasspath;
    }

    public void flushClasspathCache() {
        this.cachedClasspath = null;
    }

    public String getOutputPath() {
        IPath workspaceRelativeOutputPath;
        IProject currProject = AspectJPlugin.getDefault().getCurrentProject();
        IJavaProject jProject = JavaCore.create((IProject)currProject);
        try {
            workspaceRelativeOutputPath = jProject.getOutputLocation();
        }
        catch (JavaModelException javaModelException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_4, (JoinPoint.StaticPart)ajc$tjp_5);
            return currProject.getLocation().toOSString();
        }
        if (workspaceRelativeOutputPath.segmentCount() == 1) {
            return jProject.getResource().getLocation().toOSString();
        }
        IFolder out = ResourcesPlugin.getWorkspace().getRoot().getFolder(workspaceRelativeOutputPath);
        return out.getLocation().toOSString();
    }

    public String getBootClasspath() {
        return null;
    }

    public String getExecutionArgs() {
        return "";
    }

    public String getVmArgs() {
        return null;
    }

    public Set getInJars() {
        return null;
    }

    public Map getSourcePathResources() {
        return null;
    }

    public String getOutJar() {
        IProject thisProject = AspectJPlugin.getDefault().getCurrentProject();
        String outputJar = AspectJCorePreferences.getProjectOutJar(thisProject);
        if (outputJar.trim().length() > 0 && !outputJar.startsWith("\\") && !outputJar.startsWith("/")) {
            String trimmedName = outputJar.trim();
            boolean prependProject = true;
            if (trimmedName.length() > 1 && trimmedName.charAt(1) == ':') {
                prependProject = false;
            }
            if (prependProject) {
                String projectBaseDirectory = thisProject.getLocation().toOSString();
                outputJar = new String(String.valueOf(projectBaseDirectory) + File.separator + outputJar.trim());
            }
        }
        return outputJar;
    }

    public Set getSourceRoots() {
        return null;
    }

    public Set getAspectPath() {
        IProject thisProject = AspectJPlugin.getDefault().getCurrentProject();
        String[] v = AspectJCorePreferences.getProjectAspectPath(thisProject);
        String aspectpath = this.expandVariables(v[0], v[2]);
        if ((aspectpath = this.fullyQualifyPathEntries(aspectpath)).length() == 0) {
            return null;
        }
        return this.mapStringToSet(aspectpath, false);
    }

    public Set getInpath() {
        IProject thisProject = AspectJPlugin.getDefault().getCurrentProject();
        String[] v = AspectJCorePreferences.getProjectInPath(thisProject);
        String inpath = this.expandVariables(v[0], v[2]);
        if ((inpath = this.fullyQualifyPathEntries(inpath)).length() == 0) {
            return null;
        }
        return this.mapStringToSet(inpath, false);
    }

    public String expandVariables(String path, String eKinds) {
        StringBuffer resultBuffer = new StringBuffer();
        StringTokenizer strTok = new StringTokenizer(path, File.pathSeparator);
        StringTokenizer strTok2 = new StringTokenizer(eKinds, File.pathSeparator);
        while (strTok.hasMoreTokens()) {
            String current = strTok.nextToken();
            int entryKind = Integer.parseInt(strTok2.nextToken());
            if (entryKind == 4) {
                String exp;
                int slashPos = current.indexOf("/", 0);
                if (slashPos != -1) {
                    exp = JavaCore.getClasspathVariable((String)current.substring(0, slashPos)).toOSString();
                    resultBuffer.append(exp);
                    resultBuffer.append(current.substring(slashPos));
                } else {
                    exp = JavaCore.getClasspathVariable((String)current).toOSString();
                    resultBuffer.append(exp);
                }
            } else {
                resultBuffer.append(current);
            }
            resultBuffer.append(File.pathSeparator);
        }
        return resultBuffer.toString();
    }

    public String fullyQualifyPathEntries(String inputPath) {
        StringBuffer resultBuffer = new StringBuffer();
        StringTokenizer strTok = new StringTokenizer(inputPath, File.pathSeparator);
        while (strTok.hasMoreTokens()) {
            String current = strTok.nextToken();
            File f = new File(current);
            if (f.exists() && f.isAbsolute()) {
                resultBuffer.append(current);
            } else {
                String projectName = null;
                int slashPos = current.indexOf("/", 1);
                projectName = slashPos != -1 ? current.substring(1, slashPos) : current.substring(1);
                IProject project = AspectJPlugin.getWorkspace().getRoot().getProject(projectName);
                if (project != null && project.getLocation() != null) {
                    String projectPath = project.getLocation().toString();
                    if (slashPos != -1) {
                        resultBuffer.append(String.valueOf(projectPath) + "/" + current.substring(slashPos + 1));
                    } else {
                        resultBuffer.append(projectPath);
                    }
                } else {
                    AJLog.log("AspectJ path entry " + current + " does not exist. Ignoring.");
                }
            }
            resultBuffer.append(File.pathSeparator);
        }
        String result = resultBuffer.toString();
        if (result.endsWith(File.pathSeparator)) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private Set mapStringToSet(String input, boolean validateFiles) {
        if (input.length() == 0) {
            return null;
        }
        String inputCopy = input;
        StringBuffer invalidEntries = new StringBuffer();
        String projectBaseDirectory = AspectJPlugin.getDefault().getCurrentProject().getLocation().toOSString();
        HashSet<File> fileSet = new HashSet<File>();
        while (inputCopy.indexOf(File.pathSeparator) != -1) {
            int idx = inputCopy.indexOf(File.pathSeparator);
            String path = inputCopy.substring(0, idx);
            File f = new File(path);
            if (!f.isAbsolute()) {
                f = new File(String.valueOf(projectBaseDirectory) + File.separator + path);
            }
            if (validateFiles && !f.exists()) {
                invalidEntries.append(f + "\n");
            } else {
                fileSet.add(f);
            }
            inputCopy = inputCopy.substring(idx + 1);
        }
        if (inputCopy.length() != 0) {
            File f = new File(inputCopy);
            if (!f.isAbsolute()) {
                f = new File(String.valueOf(projectBaseDirectory) + File.separator + inputCopy);
            }
            if (validateFiles && !f.exists()) {
                invalidEntries.append(f + "\n");
            } else {
                fileSet.add(f);
            }
        }
        if (validateFiles && invalidEntries.length() != 0) {
            Ajde.getDefault().getErrorHandler().handleWarning(AspectJPlugin.getFormattedResourceString("missingJarsWarning", invalidEntries.toString()));
        }
        return fileSet;
    }

    public OutputLocationManager getOutputLocationManager() {
        return null;
    }

    static {
        Factory factory = new Factory("CoreProjectProperties.java", Class.forName("org.eclipse.ajdt.core.builder.CoreProjectProperties"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.builder.CoreProjectProperties", "org.eclipse.jdt.core.JavaModelException:", "<missing>:"), 117);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "getProjectSourceFiles", "org.eclipse.ajdt.core.builder.CoreProjectProperties", "", "", "", "java.util.List"), 98);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.builder.CoreProjectProperties", "org.eclipse.core.runtime.CoreException:", "<missing>:"), 150);
        ajc$tjp_3 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "allFiles", "org.eclipse.ajdt.core.builder.CoreProjectProperties", "org.eclipse.core.resources.IContainer:", "folder:", "", "java.util.List"), 137);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.builder.CoreProjectProperties", "org.eclipse.jdt.core.JavaModelException:", "<missing>:"), 196);
        ajc$tjp_5 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "getOutputPath", "org.eclipse.ajdt.core.builder.CoreProjectProperties", "", "", "", "java.lang.String"), 190);
    }
}

