/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.core.javaelements;

import org.aspectj.asm.IProgramElement;
import org.eclipse.ajdt.core.javaelements.DeclareElement;
import org.eclipse.ajdt.core.javaelements.DeclareElementInfo;
import org.eclipse.ajdt.core.javaelements.IMockElement;
import org.eclipse.jdt.internal.core.JavaElement;

public class MockDeclareElement
extends DeclareElement
implements IMockElement {
    private IProgramElement.ExtraInformation extraInfo;
    private DeclareElementInfo elementInfo;

    public MockDeclareElement(JavaElement parent, String name, String[] parameterTypes, IProgramElement.ExtraInformation extraInfo, DeclareElementInfo elementInfo) {
        super(parent, name, parameterTypes);
        this.elementInfo = elementInfo;
        this.extraInfo = extraInfo;
    }

    public MockDeclareElement(JavaElement parent, int offset, String name) {
        super(parent, name, null);
        this.elementInfo = new DeclareElementInfo();
        this.elementInfo.setSourceRangeStart(offset);
        this.elementInfo.setName(name.toCharArray());
        this.elementInfo.setAJKind(this.getKindForString(name));
    }

    public IProgramElement.ExtraInformation getAJExtraInformation() {
        return this.extraInfo;
    }

    public Object getElementInfo() {
        return this.elementInfo;
    }

    public String getHandleIdentifier() {
        return String.valueOf(super.getHandleIdentifier()) + '>' + this.elementInfo.getSourceRange().getOffset();
    }

    public boolean equals(Object o) {
        if (o instanceof MockDeclareElement) {
            return super.equals(o) && ((MockDeclareElement)o).elementInfo == this.elementInfo;
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode() + this.elementInfo.hashCode();
    }

    public IProgramElement.Kind getKindForString(String kindString) {
        int i = 0;
        while (i < IProgramElement.Kind.ALL.length) {
            if (kindString.startsWith(IProgramElement.Kind.ALL[i].toString())) {
                return IProgramElement.Kind.ALL[i];
            }
            ++i;
        }
        return IProgramElement.Kind.ERROR;
    }
}

