/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.core.javaelements;

import java.util.List;
import org.aspectj.asm.IProgramElement;
import org.eclipse.ajdt.core.javaelements.AspectJMemberElementInfo;
import org.eclipse.ajdt.core.javaelements.IMockElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.Member;

public class MockSourceMethod
extends Member
implements IMethod,
IMockElement {
    protected String[] parameterTypes;
    private MethodElementInfo elementInfo;

    public MockSourceMethod(JavaElement parent, String name, String[] parameterTypes, MethodElementInfo elementInfo) {
        super(parent, name);
        this.parameterTypes = parameterTypes;
        this.elementInfo = elementInfo;
    }

    public MockSourceMethod(JavaElement parent, String name, String[] parameterTypes, int offset, String accessibility) {
        super(parent, name);
        this.parameterTypes = parameterTypes;
        this.elementInfo = new MethodElementInfo();
        if (accessibility.equals(IProgramElement.Accessibility.PRIVATE.toString())) {
            this.elementInfo.setAJAccessibility(IProgramElement.Accessibility.PRIVATE);
        } else if (accessibility.equals(IProgramElement.Accessibility.PROTECTED.toString())) {
            this.elementInfo.setAJAccessibility(IProgramElement.Accessibility.PROTECTED);
        } else if (accessibility.equals(IProgramElement.Accessibility.PUBLIC.toString())) {
            this.elementInfo.setAJAccessibility(IProgramElement.Accessibility.PUBLIC);
        } else if (accessibility.equals(IProgramElement.Accessibility.PACKAGE.toString())) {
            this.elementInfo.setAJAccessibility(IProgramElement.Accessibility.PACKAGE);
        } else if (accessibility.equals(IProgramElement.Accessibility.PRIVILEGED.toString())) {
            this.elementInfo.setAJAccessibility(IProgramElement.Accessibility.PRIVILEGED);
        }
        this.elementInfo.setSourceRangeStart(offset);
        this.elementInfo.setName(name.toCharArray());
        this.elementInfo.setAJKind(IProgramElement.Kind.METHOD);
    }

    public Object getElementInfo() {
        return this.elementInfo;
    }

    protected char getHandleMementoDelimiter() {
        return '~';
    }

    public String getHandleIdentifier() {
        return String.valueOf(super.getHandleIdentifier()) + '>' + this.elementInfo.getSourceRange().getOffset() + '>' + this.elementInfo.accessibility.toString();
    }

    public IProgramElement.Kind getAJKind() {
        return IProgramElement.Kind.METHOD;
    }

    public IProgramElement.Accessibility getAJAccessibility() {
        return this.elementInfo.accessibility;
    }

    public List getAJModifiers() {
        return this.elementInfo.modifiers;
    }

    public IProgramElement.ExtraInformation getAJExtraInformation() {
        return this.elementInfo.extra;
    }

    public String[] getExceptionTypes() {
        return null;
    }

    public String[] getTypeParameterSignatures() {
        return new String[0];
    }

    public int getNumberOfParameters() {
        return this.parameterTypes.length;
    }

    public String[] getParameterNames() {
        return null;
    }

    public String[] getParameterTypes() {
        return this.parameterTypes;
    }

    public String getReturnType() {
        return null;
    }

    public String getSignature() {
        return null;
    }

    public boolean isConstructor() {
        return false;
    }

    public boolean isMainMethod() {
        return false;
    }

    public boolean isSimilar(IMethod method) {
        return false;
    }

    public int getElementType() {
        return 9;
    }

    public static class MethodElementInfo
    extends AspectJMemberElementInfo {
    }
}

