/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.core.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ajdt.core.model.AJProjectModel;
import org.eclipse.ajdt.core.model.AJRelationship;
import org.eclipse.ajdt.core.model.AJRelationshipManager;
import org.eclipse.jdt.core.IJavaElement;

public class ModelComparison {
    public static List[] compare(AJProjectModel fromModel, AJProjectModel toModel) {
        AJRelationship rel;
        List fromRels = fromModel.getAllRelationships(AJRelationshipManager.getAllRelatinshipTypes());
        List toRels = toModel.getAllRelationships(AJRelationshipManager.getAllRelatinshipTypes());
        ArrayList<AJRelationship> addedList = new ArrayList<AJRelationship>();
        ArrayList<AJRelationship> removedList = new ArrayList<AJRelationship>();
        Iterator iter = fromRels.iterator();
        while (iter.hasNext()) {
            rel = (AJRelationship)iter.next();
            if (ModelComparison.removeMatchingRel(toRels, rel)) continue;
            removedList.add(rel);
        }
        iter = toRels.iterator();
        while (iter.hasNext()) {
            rel = (AJRelationship)iter.next();
            addedList.add(rel);
        }
        return new List[]{addedList, removedList};
    }

    private static boolean matchJavaElements(IJavaElement je1, IJavaElement je2) {
        return je1.getHandleIdentifier().equals(je2.getHandleIdentifier());
    }

    private static boolean removeMatchingRel(List list, AJRelationship match) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            AJRelationship rel = (AJRelationship)iter.next();
            if (!rel.getRelationship().equals(match.getRelationship()) || !ModelComparison.matchJavaElements(rel.getSource(), match.getSource()) || !ModelComparison.matchJavaElements(rel.getTarget(), match.getTarget())) continue;
            list.remove(rel);
            return true;
        }
        return false;
    }
}

