/*******************************************************************************
 * Copyright (c) 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     Helen Hawkins   - iniital version
 *******************************************************************************/
package org.eclipse.contribution.xref.core;

import org.eclipse.core.runtime.IAdapterFactory;

/**
 * Adapter factory to support Cross References 
 *
 */
public class XReferenceAdapterFactory implements IAdapterFactory {
 
	private static final Class[] adapterList = new Class[]{IXReferenceAdapter.class};
	
	/* (non-Javadoc)
	 * @see org.eclipse.core.runtime.IAdapterFactory#getAdapter(java.lang.Object, java.lang.Class)
	 */
	public Object getAdapter(Object adaptableObject, Class adapterType) {
		if (!adapterType.equals(IXReferenceAdapter.class) ) {
			return null;
		}
		
		return new XReferenceAdapter(adaptableObject);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.core.runtime.IAdapterFactory#getAdapterList()
	 */
	public Class[] getAdapterList() {
		return adapterList;
	}

}
