/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.xref.internal.ui.inplace;

import java.util.ArrayList;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.contribution.xref.core.IXReferenceNode;
import org.eclipse.contribution.xref.internal.ui.XReferenceUIPlugin;
import org.eclipse.contribution.xref.internal.ui.actions.DoubleClickAction;
import org.eclipse.contribution.xref.internal.ui.providers.TreeObject;
import org.eclipse.contribution.xref.internal.ui.providers.TreeParent;
import org.eclipse.contribution.xref.internal.ui.providers.XReferenceContentProvider;
import org.eclipse.contribution.xref.internal.ui.providers.XReferenceLabelProvider;
import org.eclipse.contribution.xref.internal.ui.ras.XRefUIFFDC;
import org.eclipse.contribution.xref.ui.utils.XRefUIUtils;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.util.StringMatcher;
import org.eclipse.jdt.internal.ui.viewsupport.MemberFilter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.Geometry;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tracker;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommand;
import org.eclipse.ui.commands.ICommandManager;
import org.eclipse.ui.commands.IKeySequenceBinding;
import org.eclipse.ui.keys.KeySequence;
import org.eclipse.ui.keys.KeyStroke;
import org.eclipse.ui.keys.SWTKeySupport;

public class XReferenceInplaceDialog {
    private static final String STORE_DISABLE_RESTORE_SIZE = "DISABLE_RESTORE_SIZE";
    private static final String STORE_DISABLE_RESTORE_LOCATION = "DISABLE_RESTORE_LOCATION";
    private static final String STORE_LOCATION_X = "location.x";
    private static final String STORE_LOCATION_Y = "location.y";
    private static final String STORE_SIZE_WIDTH = "size.width";
    private static final String STORE_SIZE_HEIGHT = "size.height";
    private final String sectionName = "org.eclipse.contribution.internal.xref.QuickXRef";
    private Text filterText;
    private StringMatcher stringMatcher;
    private Font statusTextFont;
    private List filteredElements = new ArrayList();
    private Rectangle bounds;
    private Rectangle trim;
    private Button viewMenuButton;
    private ToolBar toolBar;
    private MenuManager viewMenuManager;
    private ISelection lastSelection;
    private IWorkbenchPart workbenchPart;
    private final String invokingCommandId = "org.eclipse.contribution.xref.show.xref";
    private boolean isShowingParentCrosscutting = false;
    private ICommand invokingCommand;
    private KeyAdapter keyAdapter;
    private KeySequence[] invokingCommandKeySequences;
    private Label statusField;
    private List previousXRefAdapterList;
    private Action doubleClickAction;
    private boolean isDeactivateListenerActive = false;
    private Composite composite;
    private Composite viewMenuButtonComposite;
    private int shellStyle;
    private Listener deactivateListener;
    private Shell parentShell;
    private Shell dialogShell;
    private TreeViewer viewer;
    private XReferenceContentProvider contentProvider;
    private XReferenceLabelProvider labelProvider;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;

    public XReferenceInplaceDialog(Shell parent) {
        this.parentShell = parent;
        this.shellStyle = 16;
    }

    public void open() {
        if (this.dialogShell != null) {
            this.close();
        }
        if ("org.eclipse.contribution.xref.show.xref" != null) {
            ICommandManager commandManager = PlatformUI.getWorkbench().getCommandSupport().getCommandManager();
            this.invokingCommand = commandManager.getCommand("org.eclipse.contribution.xref.show.xref");
            if (this.invokingCommand != null && !this.invokingCommand.isDefined()) {
                this.invokingCommand = null;
            } else {
                this.getInvokingCommandKeySequences();
            }
        }
        this.createShell();
        this.createComposites();
        this.filterText = this.createFilterText(this.viewMenuButtonComposite);
        this.createViewMenu(this.viewMenuButtonComposite);
        this.createHorizontalSeparator(this.composite);
        this.viewer = this.createTreeViewer(this.composite, 768);
        this.createStatusField(this.composite);
        this.addListenersToTree(this.viewer);
        this.viewMenuButtonComposite.setTabList(new Control[]{this.filterText});
        this.composite.setTabList(new Control[]{this.viewMenuButtonComposite, this.viewer.getTree()});
        this.setInfoSystemColor();
        this.installFilter();
        this.addListenersToShell();
        this.createContents();
        this.initializeBounds();
        this.dialogShell.open();
    }

    private void createShell() {
        this.dialogShell = new Shell(this.parentShell, this.shellStyle);
        this.dialogShell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent event) {
                event.doit = false;
                XReferenceInplaceDialog.this.dispose();
            }
        });
        Display display = this.dialogShell.getDisplay();
        this.dialogShell.setBackground(display.getSystemColor(2));
        int border = (this.shellStyle & 8) == 0 ? 0 : 1;
        this.dialogShell.setLayout((Layout)new BorderFillLayout(border));
    }

    private void createComposites() {
        this.composite = new Composite((Composite)this.dialogShell, 16);
        GridLayout layout = new GridLayout(1, false);
        this.composite.setLayout((Layout)layout);
        this.composite.setLayoutData((Object)new GridData(768));
        this.viewMenuButtonComposite = new Composite(this.composite, 0);
        layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.viewMenuButtonComposite.setLayout((Layout)layout);
        this.viewMenuButtonComposite.setLayoutData((Object)new GridData(768));
    }

    private TreeViewer createTreeViewer(Composite parent, int style) {
        this.viewer = new TreeViewer(parent, 4 | style & 0xFFFFFFFD);
        this.viewer.getTree().setLayoutData((Object)new GridData(1808));
        this.contentProvider = new XReferenceContentProvider();
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.labelProvider = new XReferenceLabelProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setAutoExpandLevel(-1);
        this.viewer.addFilter((ViewerFilter)new NamePatternFilter());
        this.viewer.addFilter((ViewerFilter)new MemberFilter());
        return this.viewer;
    }

    private void createHorizontalSeparator(Composite parent) {
        Label separator = new Label(parent, 259);
        separator.setLayoutData((Object)new GridData(768));
    }

    private void setInfoSystemColor() {
        Display display = this.dialogShell.getDisplay();
        this.viewer.getTree().setForeground(display.getSystemColor(28));
        this.filterText.setForeground(display.getSystemColor(28));
        this.composite.setForeground(display.getSystemColor(28));
        this.viewMenuButtonComposite.setForeground(display.getSystemColor(28));
        this.toolBar.setForeground(display.getSystemColor(28));
        this.statusField.setForeground(display.getSystemColor(17));
        this.viewer.getTree().setBackground(display.getSystemColor(29));
        this.filterText.setBackground(display.getSystemColor(29));
        this.composite.setBackground(display.getSystemColor(29));
        this.viewMenuButtonComposite.setBackground(display.getSystemColor(29));
        this.toolBar.setBackground(display.getSystemColor(29));
        this.statusField.setBackground(display.getSystemColor(29));
    }

    private void addListenersToTree(TreeViewer treeViewer) {
        final Tree tree = treeViewer.getTree();
        tree.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b') {
                    XReferenceInplaceDialog.this.dispose();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        tree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                XReferenceInplaceDialog.this.gotoSelectedElement();
            }
        });
        tree.addMouseMoveListener(new MouseMoveListener(){
            TreeItem fLastItem = null;

            public void mouseMove(MouseEvent e) {
                TreeItem o;
                if (tree.equals(e.getSource()) && (o = tree.getItem(new Point(e.x, e.y))) instanceof TreeItem) {
                    if (!o.equals(this.fLastItem)) {
                        this.fLastItem = o;
                        tree.setSelection(new TreeItem[]{this.fLastItem});
                    } else if (e.y < tree.getItemHeight() / 4) {
                        Point p = tree.toDisplay(e.x, e.y);
                        Item item = XReferenceInplaceDialog.this.viewer.scrollUp(p.x, p.y);
                        if (item instanceof TreeItem) {
                            this.fLastItem = (TreeItem)item;
                            tree.setSelection(new TreeItem[]{this.fLastItem});
                        }
                    } else if (e.y > tree.getBounds().height - tree.getItemHeight() / 4) {
                        Point p = tree.toDisplay(e.x, e.y);
                        Item item = XReferenceInplaceDialog.this.viewer.scrollDown(p.x, p.y);
                        if (item instanceof TreeItem) {
                            this.fLastItem = (TreeItem)item;
                            tree.setSelection(new TreeItem[]{this.fLastItem});
                        }
                    }
                }
            }
        });
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (tree.getSelectionCount() < 1) {
                    return;
                }
                if (e.button != 1) {
                    return;
                }
                if (tree.equals(e.getSource())) {
                    TreeItem o = tree.getItem(new Point(e.x, e.y));
                    TreeItem selection = tree.getSelection()[0];
                    if (selection.equals(o)) {
                        XReferenceInplaceDialog.this.gotoSelectedElement();
                    }
                }
            }
        });
        this.doubleClickAction = new DoubleClickAction(this.dialogShell, treeViewer);
        treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                XReferenceInplaceDialog.this.doubleClickAction.run();
                if (XReferenceInplaceDialog.this.dialogShell != null && XReferenceInplaceDialog.this.dialogShell.isDisposed()) {
                    XReferenceInplaceDialog.this.dispose();
                }
            }
        });
        treeViewer.getTree().addKeyListener((KeyListener)this.getKeyAdapter());
    }

    private void addListenersToShell() {
        this.dialogShell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                XReferenceInplaceDialog.this.close();
                if (XReferenceInplaceDialog.this.statusTextFont != null && !XReferenceInplaceDialog.this.statusTextFont.isDisposed()) {
                    XReferenceInplaceDialog.this.statusTextFont.dispose();
                }
                XReferenceInplaceDialog.this.dialogShell = null;
                XReferenceInplaceDialog.this.viewer = null;
                XReferenceInplaceDialog.this.composite = null;
                XReferenceInplaceDialog.this.filterText = null;
                XReferenceInplaceDialog.this.statusTextFont = null;
            }
        });
        this.deactivateListener = new Listener(){

            public void handleEvent(Event event) {
                if (XReferenceInplaceDialog.this.isDeactivateListenerActive) {
                    XReferenceInplaceDialog.this.dispose();
                }
            }
        };
        this.dialogShell.addListener(27, this.deactivateListener);
        this.isDeactivateListenerActive = true;
        this.dialogShell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellActivated(ShellEvent e) {
                if (e.widget == XReferenceInplaceDialog.this.dialogShell && XReferenceInplaceDialog.this.dialogShell.getShells().length == 0) {
                    XReferenceInplaceDialog.this.isDeactivateListenerActive = true;
                }
            }
        });
        this.dialogShell.addControlListener((ControlListener)new ControlAdapter(){

            public void controlMoved(ControlEvent e) {
                XReferenceInplaceDialog.this.bounds = XReferenceInplaceDialog.this.dialogShell.getBounds();
                if (XReferenceInplaceDialog.this.trim != null) {
                    Point location = XReferenceInplaceDialog.this.composite.getLocation();
                    ((XReferenceInplaceDialog)XReferenceInplaceDialog.this).bounds.x = ((XReferenceInplaceDialog)XReferenceInplaceDialog.this).bounds.x - ((XReferenceInplaceDialog)XReferenceInplaceDialog.this).trim.x + location.x;
                    ((XReferenceInplaceDialog)XReferenceInplaceDialog.this).bounds.y = ((XReferenceInplaceDialog)XReferenceInplaceDialog.this).bounds.y - ((XReferenceInplaceDialog)XReferenceInplaceDialog.this).trim.y + location.y;
                }
            }

            public void controlResized(ControlEvent e) {
                XReferenceInplaceDialog.this.bounds = XReferenceInplaceDialog.this.dialogShell.getBounds();
                if (XReferenceInplaceDialog.this.trim != null) {
                    Point location = XReferenceInplaceDialog.this.composite.getLocation();
                    ((XReferenceInplaceDialog)XReferenceInplaceDialog.this).bounds.x = ((XReferenceInplaceDialog)XReferenceInplaceDialog.this).bounds.x - ((XReferenceInplaceDialog)XReferenceInplaceDialog.this).trim.x + location.x;
                    ((XReferenceInplaceDialog)XReferenceInplaceDialog.this).bounds.y = ((XReferenceInplaceDialog)XReferenceInplaceDialog.this).bounds.y - ((XReferenceInplaceDialog)XReferenceInplaceDialog.this).trim.y + location.y;
                }
            }
        });
    }

    private void createViewMenu(Composite parent) {
        this.toolBar = new ToolBar(parent, 0x800000);
        ToolItem viewMenuButton = new ToolItem(this.toolBar, 8, 0);
        GridData data = new GridData();
        data.horizontalAlignment = 3;
        data.verticalAlignment = 1;
        this.toolBar.setLayoutData((Object)data);
        viewMenuButton.setImage(JavaPluginImages.get((String)"org.eclipse.jdt.ui.elcl16view_menu.gif"));
        viewMenuButton.setDisabledImage(JavaPluginImages.get((String)"org.eclipse.jdt.ui.dlcl16view_menu.gif"));
        viewMenuButton.setToolTipText(XReferenceUIPlugin.getResourceString("XReferenceInplaceDialog.viewMenu.toolTipText"));
        viewMenuButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XReferenceInplaceDialog.this.showViewMenu();
            }
        });
    }

    private void showViewMenu() {
        this.isDeactivateListenerActive = false;
        Menu aMenu = this.getViewMenuManager().createContextMenu((Control)this.dialogShell);
        Rectangle bounds = this.toolBar.getBounds();
        Point topLeft = new Point(bounds.x, bounds.y + bounds.height);
        topLeft = this.dialogShell.toDisplay(topLeft);
        aMenu.setLocation(topLeft.x, topLeft.y);
        aMenu.setVisible(true);
    }

    private MenuManager getViewMenuManager() {
        if (this.viewMenuManager == null) {
            this.viewMenuManager = new MenuManager();
            this.fillViewMenu((IMenuManager)this.viewMenuManager);
        }
        return this.viewMenuManager;
    }

    private void fillViewMenu(IMenuManager viewMenu) {
        viewMenu.add((IContributionItem)new GroupMarker("SystemMenuStart"));
        viewMenu.add((IAction)new MoveAction());
        viewMenu.add((IAction)new ResizeAction());
        viewMenu.add((IAction)new RememberBoundsAction());
        viewMenu.add((IContributionItem)new Separator("SystemMenuEnd"));
    }

    private void createStatusField(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(768));
        this.createHorizontalSeparator(comp);
        this.statusField = new Label(parent, 131072);
        this.statusField.setLayoutData((Object)new GridData(768));
        this.statusField.setText(this.getStatusFieldText());
        Font font = this.statusField.getFont();
        Display display = parent.getDisplay();
        FontData[] fontDatas = font.getFontData();
        int i = 0;
        while (i < fontDatas.length) {
            fontDatas[i].setHeight(fontDatas[i].getHeight() * 9 / 10);
            ++i;
        }
        Font statusTextFont = new Font((Device)display, fontDatas);
        this.statusField.setFont(statusTextFont);
    }

    private String getStatusFieldText() {
        KeySequence[] sequences = this.getInvokingCommandKeySequences();
        if (sequences == null || sequences.length == 0) {
            return "";
        }
        String keySequence = sequences[0].format();
        if (this.isShowingParentCrosscutting) {
            return XReferenceUIPlugin.getFormattedString("XReferenceInplaceDialog.statusFieldText.hideParentCrosscutting", keySequence);
        }
        return XReferenceUIPlugin.getFormattedString("XReferenceInplaceDialog.statusFieldText.showParentCrosscutting", keySequence);
    }

    private KeySequence[] getInvokingCommandKeySequences() {
        List list;
        if (this.invokingCommandKeySequences == null && this.invokingCommand != null && !(list = this.invokingCommand.getKeySequenceBindings()).isEmpty()) {
            this.invokingCommandKeySequences = new KeySequence[list.size()];
            int i = 0;
            while (i < this.invokingCommandKeySequences.length) {
                this.invokingCommandKeySequences[i] = ((IKeySequenceBinding)list.get(i)).getKeySequence();
                ++i;
            }
            return this.invokingCommandKeySequences;
        }
        return this.invokingCommandKeySequences;
    }

    private KeyAdapter getKeyAdapter() {
        if (this.keyAdapter == null) {
            this.keyAdapter = new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    int accelerator = SWTKeySupport.convertEventToUnmodifiedAccelerator((KeyEvent)e);
                    KeySequence keySequence = KeySequence.getInstance((KeyStroke)SWTKeySupport.convertAcceleratorToKeyStroke((int)accelerator));
                    KeySequence[] sequences = XReferenceInplaceDialog.this.getInvokingCommandKeySequences();
                    if (sequences == null) {
                        return;
                    }
                    int i = 0;
                    while (i < sequences.length) {
                        if (sequences[i].equals((Object)keySequence)) {
                            e.doit = false;
                            XReferenceInplaceDialog.this.toggleShowParentCrosscutting();
                            return;
                        }
                        ++i;
                    }
                }
            };
        }
        return this.keyAdapter;
    }

    protected void toggleShowParentCrosscutting() {
        if (this.lastSelection != null && this.workbenchPart != null) {
            List xraList = null;
            xraList = !this.isShowingParentCrosscutting ? XRefUIUtils.getXRefAdapterForSelection(this.workbenchPart, this.lastSelection, true) : XRefUIUtils.getXRefAdapterForSelection(this.workbenchPart, this.lastSelection, false);
            if (xraList != null) {
                ISelection sel = this.viewer.getSelection();
                if (sel == null) {
                    sel = this.lastSelection;
                }
                this.viewer.setInput((Object)xraList);
                XRefUIUtils.setSelection(this.workbenchPart, sel, this.viewer);
            }
        }
        this.isShowingParentCrosscutting = !this.isShowingParentCrosscutting;
        this.updateStatusFieldText();
    }

    protected void updateStatusFieldText() {
        if (this.statusField != null) {
            this.statusField.setText(this.getStatusFieldText());
        }
    }

    private void initializeBounds() {
        Rectangle oldBounds = this.restoreBounds();
        if (oldBounds != null) {
            this.dialogShell.setBounds(oldBounds);
            return;
        }
        GC gc = new GC((Drawable)this.composite);
        gc.setFont(this.composite.getFont());
        int width = gc.getFontMetrics().getAverageCharWidth();
        int height = gc.getFontMetrics().getHeight();
        gc.dispose();
        Point size = new Point(60 * width, 10 * height);
        Point location = this.getDefaultLocation(size);
        this.dialogShell.setBounds(new Rectangle(location.x, location.y, size.x, size.y));
    }

    private Point getDefaultLocation(Point initialSize) {
        Monitor monitor = this.dialogShell.getDisplay().getPrimaryMonitor();
        if (this.parentShell != null) {
            monitor = this.parentShell.getMonitor();
        }
        Rectangle monitorBounds = monitor.getClientArea();
        Point centerPoint = this.parentShell != null ? Geometry.centerPoint((Rectangle)this.parentShell.getBounds()) : Geometry.centerPoint((Rectangle)monitorBounds);
        return new Point(centerPoint.x - initialSize.x / 2, Math.max(monitorBounds.y, Math.min(centerPoint.y - initialSize.y * 2 / 3, monitorBounds.y + monitorBounds.height - initialSize.y)));
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings settings = XReferenceUIPlugin.getDefault().getDialogSettings().getSection("org.eclipse.contribution.internal.xref.QuickXRef");
        if (settings == null) {
            settings = XReferenceUIPlugin.getDefault().getDialogSettings().addNewSection("org.eclipse.contribution.internal.xref.QuickXRef");
        }
        return settings;
    }

    private void storeBounds() {
        boolean controlRestoresLocation;
        IDialogSettings dialogSettings = this.getDialogSettings();
        boolean controlRestoresSize = !dialogSettings.getBoolean(STORE_DISABLE_RESTORE_SIZE);
        boolean bl = controlRestoresLocation = !dialogSettings.getBoolean(STORE_DISABLE_RESTORE_LOCATION);
        if (this.bounds == null) {
            return;
        }
        if (controlRestoresSize) {
            dialogSettings.put(STORE_SIZE_WIDTH, this.bounds.width);
            dialogSettings.put(STORE_SIZE_HEIGHT, this.bounds.height);
        }
        if (controlRestoresLocation) {
            dialogSettings.put(STORE_LOCATION_X, this.bounds.x);
            dialogSettings.put(STORE_LOCATION_Y, this.bounds.y);
        }
    }

    private Rectangle restoreBounds() {
        IDialogSettings dialogSettings = this.getDialogSettings();
        boolean controlRestoresSize = !dialogSettings.getBoolean(STORE_DISABLE_RESTORE_SIZE);
        boolean controlRestoresLocation = !dialogSettings.getBoolean(STORE_DISABLE_RESTORE_LOCATION);
        Rectangle bounds = new Rectangle(-1, -1, -1, -1);
        if (controlRestoresSize) {
            try {
                bounds.width = dialogSettings.getInt(STORE_SIZE_WIDTH);
                bounds.height = dialogSettings.getInt(STORE_SIZE_HEIGHT);
            }
            catch (NumberFormatException numberFormatException) {
                NumberFormatException numberFormatException2 = numberFormatException;
                XRefUIFFDC.aspectOf().ajc$before$org_eclipse_contribution_xref_ras_FFDC$2$7ced305e(numberFormatException2, this, ajc$tjp_0, ajc$tjp_1);
                bounds.width = -1;
                bounds.height = -1;
            }
        }
        if (controlRestoresLocation) {
            try {
                bounds.x = dialogSettings.getInt(STORE_LOCATION_X);
                bounds.y = dialogSettings.getInt(STORE_LOCATION_Y);
            }
            catch (NumberFormatException numberFormatException) {
                NumberFormatException numberFormatException3 = numberFormatException;
                XRefUIFFDC.aspectOf().ajc$before$org_eclipse_contribution_xref_ras_FFDC$2$7ced305e(numberFormatException3, this, ajc$tjp_2, ajc$tjp_1);
                bounds.x = -1;
                bounds.y = -1;
            }
        }
        if (bounds.x == -1 && bounds.y == -1 && bounds.width == -1 && bounds.height == -1) {
            return null;
        }
        Rectangle maxBounds = null;
        if (this.dialogShell != null && !this.dialogShell.isDisposed()) {
            maxBounds = this.dialogShell.getDisplay().getBounds();
        } else {
            Display display = Display.getCurrent();
            if (display == null) {
                display = Display.getDefault();
            }
            if (display != null && !display.isDisposed()) {
                maxBounds = display.getBounds();
            }
        }
        if (bounds.width > -1 && bounds.height > -1) {
            if (maxBounds != null) {
                bounds.width = Math.min(bounds.width, maxBounds.width);
                bounds.height = Math.min(bounds.height, maxBounds.height);
            }
            bounds.width = Math.max(bounds.width, 30);
            bounds.height = Math.max(bounds.height, 30);
        }
        if (bounds.x > -1 && bounds.y > -1 && maxBounds != null) {
            bounds.x = Math.max(bounds.x, maxBounds.x);
            bounds.y = Math.max(bounds.y, maxBounds.y);
            if (bounds.width > -1 && bounds.height > -1) {
                bounds.x = Math.min(bounds.x, maxBounds.width - bounds.width);
                bounds.y = Math.min(bounds.y, maxBounds.height - bounds.height);
            }
        }
        return bounds;
    }

    private Text createFilterText(Composite parent) {
        this.filterText = new Text(parent, 0);
        GridData data = new GridData(768);
        GC gc = new GC((Drawable)parent);
        gc.setFont(parent.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        data.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)1);
        data.horizontalAlignment = 4;
        data.verticalAlignment = 2;
        this.filterText.setLayoutData((Object)data);
        this.filterText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    XReferenceInplaceDialog.this.gotoSelectedElement();
                }
                if (e.keyCode == 0x1000002) {
                    XReferenceInplaceDialog.this.viewer.getTree().setFocus();
                }
                if (e.keyCode == 0x1000001) {
                    XReferenceInplaceDialog.this.viewer.getTree().setFocus();
                }
                if (e.character == '\u001b') {
                    XReferenceInplaceDialog.this.dispose();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.filterText.addKeyListener((KeyListener)this.getKeyAdapter());
        return this.filterText;
    }

    private void gotoSelectedElement() {
        TreeObject item;
        Object data2;
        Object selectedElement = this.getSelectedElement();
        if (selectedElement instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selectedElement;
            Object data2 = ((TreeObject)sel).getData();
            if (data2 != null) {
                if (data2 instanceof IXReferenceNode) {
                    XRefUIUtils.revealInEditor(((IXReferenceNode)data2).getJavaElement());
                } else if (data2 instanceof IJavaElement) {
                    XRefUIUtils.revealInEditor((IJavaElement)data2);
                }
                this.dispose();
            }
        } else if (selectedElement instanceof TreeObject && (data2 = (item = (TreeObject)selectedElement).getData()) != null) {
            if (data2 instanceof IXReferenceNode) {
                XRefUIUtils.revealInEditor(((IXReferenceNode)data2).getJavaElement());
            } else if (data2 instanceof IJavaElement) {
                XRefUIUtils.revealInEditor((IJavaElement)data2);
            }
            this.dispose();
        }
    }

    private Object getSelectedElement() {
        if (this.viewer == null) {
            return null;
        }
        return ((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
    }

    private void installFilter() {
        this.filterText.setText("");
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = ((Text)e.widget).getText();
                int length = text.length();
                if (length > 0 && text.charAt(length - 1) != '*') {
                    text = String.valueOf(text) + '*';
                }
                XReferenceInplaceDialog.this.setMatcherString(text);
            }
        });
    }

    private void setMatcherString(String pattern) {
        if (pattern.length() == 0) {
            this.stringMatcher = null;
        } else {
            boolean ignoreCase = pattern.toLowerCase().equals(pattern);
            this.stringMatcher = new StringMatcher(pattern, ignoreCase, false);
        }
        this.stringMatcherUpdated();
    }

    private void stringMatcherUpdated() {
        this.filteredElements.clear();
        this.viewer.getControl().setRedraw(false);
        this.viewer.refresh();
        this.viewer.expandAll();
        this.selectFirstMatch();
        this.viewer.getControl().setRedraw(true);
    }

    private void selectFirstMatch() {
        Tree tree = this.viewer.getTree();
        Object element = this.findElement(tree.getItems());
        if (element != null) {
            this.viewer.setSelection((ISelection)new StructuredSelection(element), true);
        } else {
            this.viewer.setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    private Object findElement(TreeItem[] items) {
        ILabelProvider labelProvider = (ILabelProvider)this.viewer.getLabelProvider();
        int i = 0;
        while (i < items.length) {
            String label;
            Object o = items[i].getData();
            TreeParent treeParent = null;
            TreeObject treeObject = null;
            if (o instanceof TreeParent) {
                treeParent = (TreeParent)o;
            } else if (o instanceof TreeObject) {
                treeObject = (TreeObject)o;
            }
            Object element = null;
            element = treeParent == null ? treeObject : treeParent;
            if (this.stringMatcher == null) {
                return element;
            }
            if (element != null && this.stringMatcher.match(label = labelProvider.getText(element))) {
                return element;
            }
            element = this.findElement(items[i].getItems());
            if (element != null) {
                return element;
            }
            ++i;
        }
        return null;
    }

    private StringMatcher getMatcher() {
        return this.stringMatcher;
    }

    public void close() {
        this.storeBounds();
        this.toolBar = null;
        this.viewMenuManager = null;
        this.labelProvider.dispose();
        this.contentProvider.dispose();
    }

    public void dispose() {
        this.filterText = null;
        if (this.dialogShell != null) {
            if (!this.dialogShell.isDisposed()) {
                this.dialogShell.dispose();
            }
            this.dialogShell = null;
            this.parentShell = null;
            this.viewer = null;
            this.composite = null;
        }
    }

    private void performTrackerAction(int style) {
        Tracker tracker = new Tracker(this.dialogShell.getDisplay(), style);
        tracker.setStippled(true);
        Rectangle[] r = new Rectangle[]{this.dialogShell.getBounds()};
        tracker.setRectangles(r);
        if (tracker.open()) {
            this.dialogShell.setBounds(tracker.getRectangles()[0]);
        }
    }

    private void createContents() {
        if (this.lastSelection != null && this.workbenchPart != null) {
            this.previousXRefAdapterList = XRefUIUtils.getXRefAdapterForSelection(this.workbenchPart, this.lastSelection, false);
            if (this.previousXRefAdapterList != null) {
                this.viewer.setInput((Object)this.previousXRefAdapterList);
                XRefUIUtils.setSelection(this.workbenchPart, this.lastSelection, this.viewer);
            }
        }
        this.filterText.setText("");
    }

    public void setLastSelection(ISelection lastSelection) {
        this.lastSelection = lastSelection;
    }

    public void setWorkbenchPart(IWorkbenchPart workbenchPart) {
        this.workbenchPart = workbenchPart;
    }

    public boolean isOpen() {
        return this.dialogShell != null;
    }

    static {
        Factory factory = new Factory("XReferenceInplaceDialog.java", Class.forName("org.eclipse.contribution.xref.internal.ui.inplace.XReferenceInplaceDialog"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.contribution.xref.internal.ui.inplace.XReferenceInplaceDialog-java.lang.NumberFormatException-<missing>-"), 715);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-restoreBounds-org.eclipse.contribution.xref.internal.ui.inplace.XReferenceInplaceDialog----org.eclipse.swt.graphics.Rectangle-"), 704);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.contribution.xref.internal.ui.inplace.XReferenceInplaceDialog-java.lang.NumberFormatException-<missing>-"), 725);
    }

    protected class NamePatternFilter
    extends ViewerFilter {
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            StringMatcher matcher = XReferenceInplaceDialog.this.getMatcher();
            if (matcher == null || !(viewer instanceof TreeViewer)) {
                return true;
            }
            TreeViewer treeViewer = (TreeViewer)viewer;
            String matchName = ((ILabelProvider)treeViewer.getLabelProvider()).getText(element);
            if (matchName != null && matcher.match(matchName)) {
                if (element instanceof TreeParent) {
                    XReferenceInplaceDialog.this.filteredElements.add(element);
                }
                return true;
            }
            return this.hasUnfilteredChild(treeViewer, element);
        }

        private boolean hasUnfilteredChild(TreeViewer viewer, Object element) {
            if (element instanceof TreeParent) {
                Object[] children = ((ITreeContentProvider)viewer.getContentProvider()).getChildren(element);
                int i = 0;
                while (i < children.length) {
                    if (this.select((Viewer)viewer, element, children[i])) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }

        public Object[] filter(Viewer viewer, Object parent, Object[] elements) {
            int size = elements.length;
            ArrayList<Object> out = new ArrayList<Object>(size);
            int i = 0;
            while (i < size) {
                Object element = elements[i];
                if (XReferenceInplaceDialog.this.filteredElements.contains(parent)) {
                    if (element instanceof TreeParent) {
                        XReferenceInplaceDialog.this.filteredElements.add(element);
                    }
                    out.add(element);
                } else if (XReferenceInplaceDialog.this.filteredElements.contains(element)) {
                    out.add(element);
                } else if (this.select(viewer, parent, element)) {
                    out.add(element);
                }
                ++i;
            }
            return out.toArray();
        }
    }

    private static class BorderFillLayout
    extends Layout {
        final int fBorderSize;

        public BorderFillLayout(int borderSize) {
            if (borderSize < 0) {
                throw new IllegalArgumentException();
            }
            this.fBorderSize = borderSize;
        }

        public int getBorderSize() {
            return this.fBorderSize;
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            Control[] children = composite.getChildren();
            Point minSize = new Point(0, 0);
            if (children != null) {
                int i = 0;
                while (i < children.length) {
                    Point size = children[i].computeSize(wHint, hHint, flushCache);
                    minSize.x = Math.max(minSize.x, size.x);
                    minSize.y = Math.max(minSize.y, size.y);
                    ++i;
                }
            }
            minSize.x += this.fBorderSize * 2 + 3;
            minSize.y += this.fBorderSize * 2;
            return minSize;
        }

        protected void layout(Composite composite, boolean flushCache) {
            Control[] children = composite.getChildren();
            Point minSize = new Point(composite.getClientArea().width, composite.getClientArea().height);
            if (children != null) {
                int i = 0;
                while (i < children.length) {
                    Control child = children[i];
                    child.setSize(minSize.x - this.fBorderSize * 2, minSize.y - this.fBorderSize * 2);
                    child.setLocation(this.fBorderSize, this.fBorderSize);
                    ++i;
                }
            }
        }
    }

    private class MoveAction
    extends Action {
        MoveAction() {
            super(XReferenceUIPlugin.getResourceString("XReferenceInplaceDialog.viewMenu.move.label"), 1);
        }

        public void run() {
            XReferenceInplaceDialog.this.performTrackerAction(0);
            XReferenceInplaceDialog.this.isDeactivateListenerActive = true;
        }
    }

    private class RememberBoundsAction
    extends Action {
        RememberBoundsAction() {
            super(XReferenceUIPlugin.getResourceString("XReferenceInplaceDialog.viewMenu.rememberBounds.label"), 2);
            this.setChecked(!XReferenceInplaceDialog.this.getDialogSettings().getBoolean(XReferenceInplaceDialog.STORE_DISABLE_RESTORE_LOCATION));
        }

        public void run() {
            IDialogSettings settings = XReferenceInplaceDialog.this.getDialogSettings();
            boolean newValue = !this.isChecked();
            settings.put(XReferenceInplaceDialog.STORE_DISABLE_RESTORE_LOCATION, newValue);
            settings.put(XReferenceInplaceDialog.STORE_DISABLE_RESTORE_SIZE, newValue);
            XReferenceInplaceDialog.this.isDeactivateListenerActive = true;
        }
    }

    private class ResizeAction
    extends Action {
        ResizeAction() {
            super(XReferenceUIPlugin.getResourceString("XReferenceInplaceDialog.viewMenu.resize.label"), 1);
        }

        public void run() {
            XReferenceInplaceDialog.this.performTrackerAction(16);
            XReferenceInplaceDialog.this.isDeactivateListenerActive = true;
        }
    }
}

