/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.internal.lang.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import org.aspectj.internal.lang.annotation.ajcPrivileged;
import org.aspectj.internal.lang.reflect.AdviceImpl;
import org.aspectj.internal.lang.reflect.PerClauseImpl;
import org.aspectj.internal.lang.reflect.PointcutImpl;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.Advice;
import org.aspectj.lang.reflect.AdviceType;
import org.aspectj.lang.reflect.AjType;
import org.aspectj.lang.reflect.AjTypeSystem;
import org.aspectj.lang.reflect.DeclareAnnotation;
import org.aspectj.lang.reflect.DeclareErrorOrWarning;
import org.aspectj.lang.reflect.DeclareParents;
import org.aspectj.lang.reflect.DeclarePrecedence;
import org.aspectj.lang.reflect.DeclareSoft;
import org.aspectj.lang.reflect.InterTypeConstructorDeclaration;
import org.aspectj.lang.reflect.InterTypeFieldDeclaration;
import org.aspectj.lang.reflect.InterTypeMethodDeclaration;
import org.aspectj.lang.reflect.NoSuchAdviceException;
import org.aspectj.lang.reflect.NoSuchPointcutException;
import org.aspectj.lang.reflect.PerClause;
import org.aspectj.lang.reflect.PerClauseKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjTypeImpl<T>
implements AjType {
    private static final String ajcMagic = "ajc$";
    private Class<T> clazz;
    private org.aspectj.lang.reflect.Pointcut[] declaredPointcuts = null;
    private org.aspectj.lang.reflect.Pointcut[] pointcuts = null;
    private Advice[] declaredAdvice = null;
    private Advice[] advice = null;

    public AjTypeImpl(Class<T> fromClass) {
        this.clazz = fromClass;
    }

    @Override
    public String getName() {
        return this.clazz.getName();
    }

    @Override
    public Package getPackage() {
        return this.clazz.getPackage();
    }

    @Override
    public Class[] getInterfaces() {
        return this.clazz.getInterfaces();
    }

    @Override
    public int getModifiers() {
        return this.clazz.getModifiers();
    }

    @Override
    public AjType getSupertype() {
        return new AjTypeImpl<T>(this.clazz.getSuperclass());
    }

    @Override
    public Type getGenericSupertype() {
        return this.clazz.getGenericSuperclass();
    }

    @Override
    public Method getEnclosingMethod() {
        return this.clazz.getEnclosingMethod();
    }

    @Override
    public Constructor getEnclosingConstructor() {
        return this.clazz.getEnclosingConstructor();
    }

    @Override
    public AjType getEnclosingType() {
        Class<?> enc = this.clazz.getEnclosingClass();
        return enc != null ? new AjTypeImpl(enc) : null;
    }

    @Override
    public AjType getDeclaringType() {
        Class<?> dec = this.clazz.getDeclaringClass();
        return dec != null ? new AjTypeImpl(dec) : null;
    }

    @Override
    public PerClause getPerClause() {
        if (this.isAspect()) {
            Aspect aspectAnn = this.clazz.getAnnotation(Aspect.class);
            String perClause = aspectAnn.value();
            if (perClause.equals("")) {
                return new PerClauseImpl(PerClauseKind.SINGLETON, "");
            }
            if (perClause.startsWith("perthis(")) {
                return new PerClauseImpl(PerClauseKind.PERTHIS, perClause.substring("perthis(".length(), perClause.length() - 1));
            }
            if (perClause.startsWith("pertarget(")) {
                return new PerClauseImpl(PerClauseKind.PERTARGET, perClause.substring("pertarget(".length(), perClause.length() - 1));
            }
            if (perClause.startsWith("percflow(")) {
                return new PerClauseImpl(PerClauseKind.PERCFLOW, perClause.substring("percflow(".length(), perClause.length() - 1));
            }
            if (perClause.startsWith("percflowbelow(")) {
                return new PerClauseImpl(PerClauseKind.PERCFLOWBELOW, perClause.substring("percflowbelow(".length(), perClause.length() - 1));
            }
            if (perClause.startsWith("pertypewithin")) {
                return new PerClauseImpl(PerClauseKind.PERTYPEWITHIN, perClause.substring("pertypewithin(".length(), perClause.length() - 1));
            }
            throw new IllegalStateException("Per-clause not recognized: " + perClause);
        }
        return null;
    }

    public boolean isAnnotationPresent(Class annotationType) {
        return this.clazz.isAnnotationPresent(annotationType);
    }

    public Annotation getAnnotation(Class annotationType) {
        return this.clazz.getAnnotation(annotationType);
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.clazz.getAnnotations();
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.clazz.getDeclaredAnnotations();
    }

    @Override
    public AjType[] getAjTypes() {
        Class<?>[] classes = this.clazz.getClasses();
        AjType[] ret = new AjType[classes.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new AjTypeImpl(classes[i]);
        }
        return ret;
    }

    @Override
    public AjType[] getDeclaredAjTypes() {
        Class<?>[] classes = this.clazz.getDeclaredClasses();
        AjType[] ret = new AjType[classes.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new AjTypeImpl(classes[i]);
        }
        return ret;
    }

    @Override
    public Constructor getConstructor(Class ... parameterTypes) throws NoSuchMethodException {
        return this.clazz.getConstructor(parameterTypes);
    }

    @Override
    public Constructor[] getConstructors() {
        return this.clazz.getConstructors();
    }

    @Override
    public Constructor getDeclaredConstructor(Class ... parameterTypes) throws NoSuchMethodException {
        return this.clazz.getDeclaredConstructor(parameterTypes);
    }

    @Override
    public Constructor[] getDeclaredConstructors() {
        return this.clazz.getDeclaredConstructors();
    }

    @Override
    public Field getDeclaredField(String name) throws NoSuchFieldException {
        Field f = this.clazz.getDeclaredField(name);
        if (f.getName().startsWith(ajcMagic)) {
            throw new NoSuchFieldException(name);
        }
        return f;
    }

    @Override
    public Field[] getDeclaredFields() {
        Field[] fields = this.clazz.getDeclaredFields();
        ArrayList<Field> filteredFields = new ArrayList<Field>();
        for (Field field : fields) {
            if (field.getName().startsWith(ajcMagic)) continue;
            filteredFields.add(field);
        }
        Field[] ret = new Field[filteredFields.size()];
        filteredFields.toArray(ret);
        return ret;
    }

    @Override
    public Field getField(String name) throws NoSuchFieldException {
        Field f = this.clazz.getDeclaredField(name);
        if (f.getName().startsWith(ajcMagic)) {
            throw new NoSuchFieldException(name);
        }
        return f;
    }

    @Override
    public Field[] getFields() {
        Field[] fields = this.clazz.getFields();
        ArrayList<Field> filteredFields = new ArrayList<Field>();
        for (Field field : fields) {
            if (field.getName().startsWith(ajcMagic)) continue;
            filteredFields.add(field);
        }
        Field[] ret = new Field[filteredFields.size()];
        filteredFields.toArray(ret);
        return ret;
    }

    @Override
    public Method getDeclaredMethod(String name, Class ... parameterTypes) throws NoSuchMethodException {
        Method m = this.clazz.getDeclaredMethod(name, parameterTypes);
        if (!this.isReallyAMethod(m)) {
            throw new NoSuchMethodException(name);
        }
        return m;
    }

    @Override
    public Method getMethod(String name, Class ... parameterTypes) throws NoSuchMethodException {
        Method m = this.clazz.getMethod(name, parameterTypes);
        if (!this.isReallyAMethod(m)) {
            throw new NoSuchMethodException(name);
        }
        return m;
    }

    @Override
    public Method[] getDeclaredMethods() {
        Method[] methods = this.clazz.getDeclaredMethods();
        ArrayList<Method> filteredMethods = new ArrayList<Method>();
        for (Method method : methods) {
            if (!this.isReallyAMethod(method)) continue;
            filteredMethods.add(method);
        }
        Method[] ret = new Method[filteredMethods.size()];
        filteredMethods.toArray(ret);
        return ret;
    }

    @Override
    public Method[] getMethods() {
        Method[] methods = this.clazz.getMethods();
        ArrayList<Method> filteredMethods = new ArrayList<Method>();
        for (Method method : methods) {
            if (!this.isReallyAMethod(method)) continue;
            filteredMethods.add(method);
        }
        Method[] ret = new Method[filteredMethods.size()];
        filteredMethods.toArray(ret);
        return ret;
    }

    private boolean isReallyAMethod(Method method) {
        if (method.getName().startsWith(ajcMagic)) {
            return false;
        }
        if (method.isAnnotationPresent(Pointcut.class)) {
            return false;
        }
        if (method.isAnnotationPresent(Before.class)) {
            return false;
        }
        if (method.isAnnotationPresent(After.class)) {
            return false;
        }
        if (method.isAnnotationPresent(AfterReturning.class)) {
            return false;
        }
        if (method.isAnnotationPresent(AfterThrowing.class)) {
            return false;
        }
        return !method.isAnnotationPresent(Around.class);
    }

    @Override
    public org.aspectj.lang.reflect.Pointcut getDeclaredPointcut(String name) throws NoSuchPointcutException {
        org.aspectj.lang.reflect.Pointcut[] pcs;
        for (org.aspectj.lang.reflect.Pointcut pc : pcs = this.getDeclaredPointcuts()) {
            if (!pc.getName().equals(name)) continue;
            return pc;
        }
        throw new NoSuchPointcutException(name);
    }

    @Override
    public org.aspectj.lang.reflect.Pointcut getPointcut(String name) throws NoSuchPointcutException {
        org.aspectj.lang.reflect.Pointcut[] pcs;
        for (org.aspectj.lang.reflect.Pointcut pc : pcs = this.getDeclaredPointcuts()) {
            if (!pc.getName().equals(name)) continue;
            return pc;
        }
        throw new NoSuchPointcutException(name);
    }

    @Override
    public org.aspectj.lang.reflect.Pointcut[] getDeclaredPointcuts() {
        Method[] methods;
        if (this.declaredPointcuts != null) {
            return this.declaredPointcuts;
        }
        ArrayList<org.aspectj.lang.reflect.Pointcut> pointcuts = new ArrayList<org.aspectj.lang.reflect.Pointcut>();
        for (Method method : methods = this.clazz.getDeclaredMethods()) {
            org.aspectj.lang.reflect.Pointcut pc = this.asPointcut(method);
            if (pc == null) continue;
            pointcuts.add(pc);
        }
        org.aspectj.lang.reflect.Pointcut[] ret = new org.aspectj.lang.reflect.Pointcut[pointcuts.size()];
        pointcuts.toArray(ret);
        this.declaredPointcuts = ret;
        return ret;
    }

    @Override
    public org.aspectj.lang.reflect.Pointcut[] getPointcuts() {
        Method[] methods;
        if (this.pointcuts != null) {
            return this.pointcuts;
        }
        ArrayList<org.aspectj.lang.reflect.Pointcut> pcuts = new ArrayList<org.aspectj.lang.reflect.Pointcut>();
        for (Method method : methods = this.clazz.getMethods()) {
            org.aspectj.lang.reflect.Pointcut pc = this.asPointcut(method);
            if (pc == null) continue;
            pcuts.add(pc);
        }
        org.aspectj.lang.reflect.Pointcut[] ret = new org.aspectj.lang.reflect.Pointcut[pcuts.size()];
        pcuts.toArray(ret);
        this.pointcuts = ret;
        return ret;
    }

    private org.aspectj.lang.reflect.Pointcut asPointcut(Method method) {
        Pointcut pcAnn = method.getAnnotation(Pointcut.class);
        if (pcAnn != null) {
            int nameStart;
            int nextDollar;
            String name = method.getName();
            if (name.startsWith(ajcMagic) && (nextDollar = (name = name.substring((nameStart = name.indexOf("$$")) + 2, name.length())).indexOf("$")) != -1) {
                name = name.substring(0, nextDollar);
            }
            return new PointcutImpl(name, pcAnn.value(), method, AjTypeSystem.getAjType(method.getDeclaringClass()));
        }
        return null;
    }

    @Override
    public Advice[] getDeclaredAdvice(AdviceType ... ofType) {
        EnumSet<AdviceType> types;
        if (ofType.length == 0) {
            types = EnumSet.allOf(AdviceType.class);
        } else {
            types = EnumSet.noneOf(AdviceType.class);
            types.addAll(Arrays.asList(ofType));
        }
        return this.getDeclaredAdvice(types);
    }

    @Override
    public Advice[] getAdvice(AdviceType ... ofType) {
        EnumSet<AdviceType> types;
        if (ofType.length == 0) {
            types = EnumSet.allOf(AdviceType.class);
        } else {
            types = EnumSet.noneOf(AdviceType.class);
            types.addAll(Arrays.asList(ofType));
        }
        return this.getAdvice(types);
    }

    private Advice[] getDeclaredAdvice(Set ofAdviceTypes) {
        if (this.declaredAdvice == null) {
            this.initDeclaredAdvice();
        }
        ArrayList<Advice> adviceList = new ArrayList<Advice>();
        for (Advice a : this.declaredAdvice) {
            if (!ofAdviceTypes.contains((Object)a.getKind())) continue;
            adviceList.add(a);
        }
        Advice[] ret = new Advice[adviceList.size()];
        adviceList.toArray(ret);
        return ret;
    }

    private void initDeclaredAdvice() {
        Method[] methods = this.clazz.getDeclaredMethods();
        ArrayList<Advice> adviceList = new ArrayList<Advice>();
        for (Method method : methods) {
            Advice advice = this.asAdvice(method);
            if (advice == null) continue;
            adviceList.add(advice);
        }
        this.declaredAdvice = new Advice[adviceList.size()];
        adviceList.toArray(this.declaredAdvice);
    }

    private Advice[] getAdvice(Set ofAdviceTypes) {
        if (this.advice == null) {
            this.initAdvice();
        }
        ArrayList<Advice> adviceList = new ArrayList<Advice>();
        for (Advice a : this.advice) {
            if (!ofAdviceTypes.contains((Object)a.getKind())) continue;
            adviceList.add(a);
        }
        Advice[] ret = new Advice[adviceList.size()];
        adviceList.toArray(ret);
        return ret;
    }

    private void initAdvice() {
        Method[] methods = this.clazz.getDeclaredMethods();
        ArrayList<Advice> adviceList = new ArrayList<Advice>();
        for (Method method : methods) {
            Advice advice = this.asAdvice(method);
            if (advice == null) continue;
            adviceList.add(advice);
        }
        this.advice = new Advice[adviceList.size()];
        adviceList.toArray(this.advice);
    }

    @Override
    public Advice getAdvice(String name) throws NoSuchAdviceException {
        if (name.equals("")) {
            throw new IllegalArgumentException("use getAdvice(AdviceType...) instead for un-named advice");
        }
        if (this.advice == null) {
            this.initAdvice();
        }
        for (Advice a : this.advice) {
            if (!a.getName().equals(name)) continue;
            return a;
        }
        throw new NoSuchAdviceException(name);
    }

    @Override
    public Advice getDeclaredAdvice(String name) throws NoSuchAdviceException {
        if (name.equals("")) {
            throw new IllegalArgumentException("use getAdvice(AdviceType...) instead for un-named advice");
        }
        if (this.declaredAdvice == null) {
            this.initDeclaredAdvice();
        }
        for (Advice a : this.declaredAdvice) {
            if (!a.getName().equals(name)) continue;
            return a;
        }
        throw new NoSuchAdviceException(name);
    }

    private Advice asAdvice(Method method) {
        if (method.getAnnotations().length == 0) {
            return null;
        }
        Before beforeAnn = method.getAnnotation(Before.class);
        if (beforeAnn != null) {
            return new AdviceImpl(method, beforeAnn.value(), AdviceType.BEFORE);
        }
        After afterAnn = method.getAnnotation(After.class);
        if (afterAnn != null) {
            return new AdviceImpl(method, afterAnn.value(), AdviceType.AFTER);
        }
        AfterReturning afterReturningAnn = method.getAnnotation(AfterReturning.class);
        if (afterReturningAnn != null) {
            String pcExpr = afterReturningAnn.pointcut();
            if (pcExpr.equals("")) {
                pcExpr = afterReturningAnn.value();
            }
            return new AdviceImpl(method, pcExpr, AdviceType.AFTER_RETURNING);
        }
        AfterThrowing afterThrowingAnn = method.getAnnotation(AfterThrowing.class);
        if (afterThrowingAnn != null) {
            String pcExpr = afterThrowingAnn.pointcut();
            if (pcExpr == null) {
                pcExpr = afterThrowingAnn.value();
            }
            return new AdviceImpl(method, pcExpr, AdviceType.AFTER_THROWING);
        }
        Around aroundAnn = method.getAnnotation(Around.class);
        if (aroundAnn != null) {
            return new AdviceImpl(method, aroundAnn.value(), AdviceType.AROUND);
        }
        return null;
    }

    @Override
    public InterTypeMethodDeclaration getDeclaredITDMethod(String name, Class target, Class ... parameterTypes) {
        return null;
    }

    @Override
    public InterTypeMethodDeclaration[] getDeclaredITDMethods() {
        return null;
    }

    @Override
    public InterTypeMethodDeclaration getITDMethod(String name, Class target, Class ... parameterTypes) {
        return null;
    }

    @Override
    public InterTypeMethodDeclaration[] getITDMethods() {
        return null;
    }

    @Override
    public InterTypeConstructorDeclaration getDeclaredITDConstructor(Class target, Class ... parameterTypes) {
        return null;
    }

    @Override
    public InterTypeConstructorDeclaration[] getDeclaredITDConstructors() {
        return null;
    }

    @Override
    public InterTypeConstructorDeclaration getITDConstructor(Class target, Class ... parameterTypes) {
        return null;
    }

    @Override
    public InterTypeConstructorDeclaration[] getITDConstructors() {
        return null;
    }

    @Override
    public InterTypeFieldDeclaration getDeclaredITDField(String name, Class target) {
        return null;
    }

    @Override
    public InterTypeFieldDeclaration[] getDeclaredITDFields() {
        return null;
    }

    @Override
    public InterTypeFieldDeclaration getITDField(String name, Class target) {
        return null;
    }

    @Override
    public InterTypeFieldDeclaration[] getITDFields() {
        return null;
    }

    @Override
    public DeclareErrorOrWarning getDeclareErrorOrWarnings() {
        return null;
    }

    @Override
    public DeclareParents getDeclareParents() {
        return null;
    }

    @Override
    public DeclareSoft getDeclareSofts() {
        return null;
    }

    @Override
    public DeclareAnnotation getDeclareAnnotations() {
        return null;
    }

    @Override
    public DeclarePrecedence getDeclarePrecedence() {
        return null;
    }

    public Object[] getEnumConstants() {
        return this.clazz.getEnumConstants();
    }

    public TypeVariable[] getTypeParameters() {
        return this.clazz.getTypeParameters();
    }

    @Override
    public boolean isEnum() {
        return this.clazz.isEnum();
    }

    @Override
    public boolean isInstance(Object o) {
        return this.clazz.isInstance(o);
    }

    @Override
    public boolean isInterface() {
        return this.clazz.isInterface();
    }

    @Override
    public boolean isLocalClass() {
        return this.clazz.isLocalClass() && !this.isAspect();
    }

    @Override
    public boolean isMemberClass() {
        return this.clazz.isMemberClass() && !this.isAspect();
    }

    @Override
    public boolean isArray() {
        return this.clazz.isArray();
    }

    @Override
    public boolean isPrimitive() {
        return this.clazz.isPrimitive();
    }

    @Override
    public boolean isAspect() {
        return this.clazz.getAnnotation(Aspect.class) != null;
    }

    @Override
    public boolean isMemberAspect() {
        return this.clazz.isMemberClass() && this.isAspect();
    }

    @Override
    public boolean isPrivileged() {
        return this.isAspect() && this.clazz.isAnnotationPresent(ajcPrivileged.class);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AjTypeImpl)) {
            return false;
        }
        AjTypeImpl other = (AjTypeImpl)obj;
        return other.clazz.equals(this.clazz);
    }

    public int hashCode() {
        return this.clazz.hashCode();
    }
}

