/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.core.builder;

import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.BuildManager;
import org.aspectj.ajdt.internal.core.builder.AjState;
import org.aspectj.ajdt.internal.core.builder.IStateListener;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.core.builder.IAJBuildListener;
import org.eclipse.ajdt.core.builder.IAJCompilerMonitor;
import org.eclipse.ajdt.core.model.AJModel;
import org.eclipse.ajdt.internal.core.AJLog;
import org.eclipse.ajdt.internal.core.CoreUtils;
import org.eclipse.ajdt.internal.core.ICoreOperations;
import org.eclipse.ajdt.internal.core.ras.CoreFFDC;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaProject;

public class AJBuilder
extends IncrementalProjectBuilder {
    private static List buildListeners;
    private BuildManager buildManager = null;
    private boolean buildCancelled = false;
    private IProgressMonitor progressMonitor;
    private String lastWorkbenchPreference = "abort";
    private static IProject lastBuiltProject;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;
    private static final JoinPoint.StaticPart ajc$tjp_9;
    private static final JoinPoint.StaticPart ajc$tjp_10;
    private static final JoinPoint.StaticPart ajc$tjp_11;

    static {
        IStateListener isl;
        Factory factory = new Factory("AJBuilder.java", Class.forName("org.eclipse.ajdt.core.builder.AJBuilder"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.builder.AJBuilder-org.eclipse.core.runtime.CoreException-<missing>-"), 229);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-build-org.eclipse.ajdt.core.builder.AJBuilder-int:java.util.Map:org.eclipse.core.runtime.IProgressMonitor:-kind:args:progressMonitor:-org.eclipse.core.runtime.CoreException:-[Lorg.eclipse.core.resources.IProject;-"), 117);
        ajc$tjp_10 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.builder.AJBuilder-org.eclipse.core.runtime.CoreException-<missing>-"), 716);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-updateJavaCompilerPreferences-org.eclipse.ajdt.core.builder.AJBuilder-org.eclipse.core.resources.IProject:[Lorg.eclipse.core.resources.IProject;:-project:dependingProjects:--void-"), 675);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.builder.AJBuilder-java.lang.Exception-<missing>-"), 249);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-waitForBuildCompletion-org.eclipse.ajdt.core.builder.AJBuilder-org.eclipse.ajdt.core.builder.IAJCompilerMonitor:-monitor:--void-"), 244);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.builder.AJBuilder-org.eclipse.jdt.core.JavaModelException-<missing>-"), 307);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getRequiredProjects-org.eclipse.ajdt.core.builder.AJBuilder-org.eclipse.core.resources.IProject:boolean:-project:includeBinaryPrerequisites:--[Lorg.eclipse.core.resources.IProject;-"), 272);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.builder.AJBuilder-org.eclipse.core.runtime.CoreException-<missing>-"), 323);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getRequiredProjects-org.eclipse.ajdt.core.builder.AJBuilder-org.eclipse.core.resources.IProject:-project:--[Lorg.eclipse.core.resources.IProject;-"), 322);
        ajc$tjp_8 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.builder.AJBuilder-org.eclipse.core.internal.resources.ResourceException-e-"), 416);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-copyResources-org.eclipse.ajdt.core.builder.AJBuilder-org.eclipse.jdt.core.IJavaProject:org.eclipse.core.resources.IResourceDelta:-project:delta:-org.eclipse.core.runtime.CoreException:-boolean-"), 389);
        AjState.stateListener = isl = new IStateListener(){

            public void detectedClassChangeInThisDir(File f) {
            }

            public void aboutToCompareClasspaths(List oldClasspath, List newClasspath) {
            }

            public void pathChangeDetected() {
            }

            public void buildSuccessful(boolean arg0) {
                AJLog.log("AspectJ reports build successful, build was: " + (arg0 ? "FULL" : "INCREMENTAL"));
            }
        };
        buildListeners = new ArrayList();
        lastBuiltProject = null;
    }

    public static IProject getLastBuildTarget() {
        return lastBuiltProject;
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor progressMonitor) throws CoreException {
        IResourceDelta dta;
        this.progressMonitor = progressMonitor;
        AJLog.logStart("Total time spent in AJBuilder.build()");
        IProject project = this.getProject();
        AspectJPlugin.getDefault().setCurrentProject(project);
        AJModel.getInstance().aboutToBuild(project);
        this.buildCancelled = false;
        IProject[] requiredProjects = this.getRequiredProjects(project, true);
        ICoreOperations coreOps = AspectJPlugin.getDefault().getCoreOperations();
        if (coreOps.isFullBuildRequested(project)) {
            kind = 6;
        }
        this.preCallListeners(kind, project, requiredProjects);
        IProject[] dependingProjects = this.getDependingProjects(project);
        JavaProject javaProject = (JavaProject)JavaCore.create((IProject)project);
        if (!javaProject.hasBuildState() && dependingProjects.length > 0) {
            this.updateJavaCompilerPreferences(project, dependingProjects);
        }
        if ((dta = this.getDelta(this.getProject())) != null) {
            this.copyResources((IJavaProject)javaProject, dta);
        }
        if (kind != 6 && !coreOps.sourceFilesChanged(dta, project)) {
            AJLog.log("build: Examined delta - no source file changes for project " + project.getName());
            boolean continueToBuild = false;
            int i = 0;
            while (!continueToBuild && i < requiredProjects.length) {
                IResourceDelta delta = this.getDelta(requiredProjects[i]);
                continueToBuild = coreOps.sourceFilesChanged(delta, requiredProjects[i]);
                ++i;
            }
            if (!continueToBuild) {
                this.postCallListeners(true);
                return requiredProjects;
            }
        }
        this.buildManager = Ajde.getDefault().getBuildManager();
        this.buildManager.setBuildModelMode(true);
        IAJCompilerMonitor compilerMonitor = AspectJPlugin.getDefault().getCompilerMonitor();
        if (kind == 6) {
            IJavaProject ijp = JavaCore.create((IProject)project);
            if (ijp != null) {
                this.cleanOutputFolders(ijp);
            } else {
                AJLog.log("Unable to empty output folder on build all - why cant we find the IJavaProject?");
            }
            compilerMonitor.prepare(project, null, progressMonitor);
        } else {
            compilerMonitor.prepare(project, null, null);
        }
        lastBuiltProject = project;
        String configFile = AspectJPlugin.getBuildConfigurationFile(project);
        AJLog.logStart("Total time spent in AJDE");
        if (kind == 6) {
            this.buildManager.buildFresh(configFile);
        } else {
            this.buildManager.build(configFile);
        }
        this.waitForBuildCompletion(compilerMonitor);
        AJLog.logEnd("Total time spent in AJDE");
        boolean javaDep = false;
        int i = 0;
        while (!javaDep && i < dependingProjects.length) {
            if (dependingProjects[i].hasNature("org.eclipse.jdt.core.javanature")) {
                javaDep = true;
            }
            ++i;
        }
        try {
            if (javaDep) {
                project.refreshLocal(2, null);
            } else {
                project.refreshLocal(1, null);
            }
        }
        catch (CoreException coreException) {
            CoreException coreException2 = coreException;
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, (Object)this, ajc$tjp_0, ajc$tjp_1);
        }
        AJModel.getInstance().createMap(project);
        this.postCallListeners(false);
        AJLog.logEnd("Total time spent in AJBuilder.build()");
        return requiredProjects;
    }

    private void waitForBuildCompletion(IAJCompilerMonitor monitor) {
        while (!monitor.finished()) {
            try {
                this.checkAndHandleCancelation();
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(exception2, (Object)this, ajc$tjp_2, ajc$tjp_3);
            }
        }
    }

    private void checkAndHandleCancelation() {
        if (this.progressMonitor != null && this.buildManager != null && this.progressMonitor.isCanceled()) {
            this.buildManager.abortBuild();
            this.buildCancelled = true;
            AJLog.log("build: Build cancelled as requested");
        }
    }

    private IProject[] getRequiredProjects(IProject project, boolean includeBinaryPrerequisites) {
        JavaProject javaProject = (JavaProject)JavaCore.create((IProject)project);
        IWorkspaceRoot workspaceRoot = project.getWorkspace().getRoot();
        if (javaProject == null || workspaceRoot == null) {
            return new IProject[0];
        }
        ArrayList<IProject> projects = new ArrayList<IProject>();
        try {
            IClasspathEntry[] entries = javaProject.getExpandedClasspath(true);
            int i = 0;
            int l = entries.length;
            while (i < l) {
                IClasspathEntry entry = entries[i];
                IPath path = entry.getPath();
                IProject p = null;
                switch (entry.getEntryKind()) {
                    case 2: {
                        p = workspaceRoot.getProject(path.lastSegment());
                        break;
                    }
                    case 1: {
                        IResource resource;
                        if (!includeBinaryPrerequisites || path.segmentCount() <= 1 || !((resource = workspaceRoot.findMember(path.segment(0))) instanceof IProject)) break;
                        p = (IProject)resource;
                    }
                }
                if (p != null && !projects.contains(p)) {
                    projects.add(p);
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            JavaModelException javaModelException2 = javaModelException;
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException2, (Object)this, ajc$tjp_4, ajc$tjp_5);
            return new IProject[0];
        }
        IProject[] result = new IProject[projects.size()];
        projects.toArray(result);
        return result;
    }

    private IProject[] getRequiredProjects(IProject project) {
        IProject[] referencedProjects;
        try {
            referencedProjects = project.getReferencedProjects();
        }
        catch (CoreException coreException) {
            CoreException coreException2 = coreException;
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, (Object)this, ajc$tjp_6, ajc$tjp_7);
            referencedProjects = new IProject[]{};
        }
        IProject[] classFolderRequirements = CoreUtils.getRequiredClassFolderProjects(project);
        IProject[] requiredProjects = new IProject[referencedProjects.length + classFolderRequirements.length];
        int i = 0;
        while (i < referencedProjects.length) {
            requiredProjects[i] = referencedProjects[i];
            ++i;
        }
        i = 0;
        while (i < classFolderRequirements.length) {
            requiredProjects[i + referencedProjects.length] = classFolderRequirements[i];
            ++i;
        }
        return requiredProjects;
    }

    private IProject[] getDependingProjects(IProject project) {
        IProject[] referencingProjects = project.getReferencingProjects();
        IProject[] classFolderReferences = (IProject[])CoreUtils.getDependingProjects(project).get(0);
        IProject[] dependingProjects = new IProject[referencingProjects.length + classFolderReferences.length];
        int i = 0;
        while (i < referencingProjects.length) {
            dependingProjects[i] = referencingProjects[i];
            ++i;
        }
        i = 0;
        while (i < classFolderReferences.length) {
            dependingProjects[i + referencingProjects.length] = classFolderReferences[i];
            ++i;
        }
        return dependingProjects;
    }

    private IClasspathEntry[] getSrcClasspathEntry(IJavaProject javaProject) throws JavaModelException {
        ArrayList<IClasspathEntry> srcEntries = new ArrayList<IClasspathEntry>();
        if (javaProject == null) {
            return new IClasspathEntry[0];
        }
        IClasspathEntry[] cpEntry = javaProject.getRawClasspath();
        int j = 0;
        while (j < cpEntry.length) {
            IClasspathEntry entry = cpEntry[j];
            if (entry.getEntryKind() == 3) {
                srcEntries.add(entry);
            }
            ++j;
        }
        return srcEntries.toArray(new IClasspathEntry[srcEntries.size()]);
    }

    private boolean copyResources(IJavaProject project, IResourceDelta delta) throws CoreException {
        IClasspathEntry[] srcEntries = this.getSrcClasspathEntry(project);
        int i = 0;
        int l = srcEntries.length;
        while (i < l) {
            IClasspathEntry srcEntry = srcEntries[i];
            IPath srcPath = srcEntry.getPath().removeFirstSegments(1);
            IContainer srcContainer = this.getContainerForGivenPath(srcPath, project.getProject());
            if (srcContainer.equals((Object)project.getProject())) {
                int segmentCount = delta.getFullPath().segmentCount();
                IResourceDelta[] children = delta.getAffectedChildren();
                int j = 0;
                int m = children.length;
                while (j < m) {
                    if (!this.isExcludedFromProject(project, children[j].getFullPath(), srcEntries)) {
                        this.copyResources(project, children[j], srcEntry, segmentCount);
                    }
                    ++j;
                }
            } else {
                IPath projectRelativePath = srcEntry.getPath().removeFirstSegments(1);
                projectRelativePath.makeRelative();
                IResourceDelta sourceDelta = delta.findMember(projectRelativePath);
                if (sourceDelta != null) {
                    if (sourceDelta.getKind() == 2) {
                        return false;
                    }
                    int segmentCount = sourceDelta.getFullPath().segmentCount();
                    IResourceDelta[] children = sourceDelta.getAffectedChildren();
                    try {
                        int j = 0;
                        int m = children.length;
                        while (j < m) {
                            this.copyResources(project, children[j], srcEntry, segmentCount);
                            ++j;
                        }
                    }
                    catch (ResourceException resourceException) {
                        ResourceException resourceException2 = resourceException;
                        CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(resourceException2, (Object)this, ajc$tjp_8, ajc$tjp_9);
                        ResourceException e = resourceException2;
                        if (e.getStatus().getCode() == 275) {
                            return false;
                        }
                        throw e;
                    }
                }
            }
            ++i;
        }
        return true;
    }

    private void copyResources(IJavaProject javaProject, IResourceDelta sourceDelta, IClasspathEntry srcEntry, int segmentCount) throws CoreException {
        IResource resource = sourceDelta.getResource();
        IPath outputPath = srcEntry.getOutputLocation();
        if (outputPath == null) {
            outputPath = javaProject.getOutputLocation();
        }
        outputPath = outputPath.removeFirstSegments(1).makeRelative();
        IContainer outputFolder = this.getContainerForGivenPath(outputPath, javaProject.getProject());
        IContainer srcContainer = this.getContainerForGivenPath(srcEntry.getPath().removeFirstSegments(1), javaProject.getProject());
        switch (resource.getType()) {
            case 2: {
                switch (sourceDelta.getKind()) {
                    case 1: {
                        IPath addedPackagePath = resource.getFullPath().removeFirstSegments(segmentCount);
                        this.createFolder(addedPackagePath, outputFolder);
                    }
                    case 4: {
                        IResourceDelta[] children = sourceDelta.getAffectedChildren();
                        int i = 0;
                        int l = children.length;
                        while (i < l) {
                            this.copyResources(javaProject, children[i], srcEntry, segmentCount);
                            ++i;
                        }
                        return;
                    }
                    case 2: {
                        IFolder removedPackageFolder;
                        IPath removedPackagePath = resource.getFullPath().removeFirstSegments(segmentCount);
                        IClasspathEntry[] srcEntries = this.getSrcClasspathEntry(javaProject);
                        if (srcEntries.length > 1) {
                            int i = 0;
                            int l = srcEntries.length;
                            while (i < l) {
                                IPath srcPath = srcEntries[i].getPath().removeFirstSegments(1);
                                IFolder srcFolder = javaProject.getProject().getFolder(srcPath);
                                if (srcFolder.getFolder(removedPackagePath).exists()) {
                                    this.createFolder(removedPackagePath, outputFolder);
                                    IResourceDelta[] removedChildren = sourceDelta.getAffectedChildren();
                                    int j = 0;
                                    int m = removedChildren.length;
                                    while (j < m) {
                                        this.copyResources(javaProject, removedChildren[j], srcEntry, segmentCount);
                                        ++j;
                                    }
                                    return;
                                }
                                ++i;
                            }
                        }
                        if (!(removedPackageFolder = outputFolder.getFolder(removedPackagePath)).exists()) break;
                        removedPackageFolder.delete(1, null);
                    }
                }
                return;
            }
            case 1: {
                if (!outputFolder.equals((Object)srcContainer)) {
                    IPath resourcePath = resource.getFullPath().removeFirstSegments(segmentCount);
                    if (resourcePath == null) {
                        return;
                    }
                    if (resourcePath.getFileExtension() != null && (resourcePath.getFileExtension().equals("aj") || resourcePath.getFileExtension().equals("java"))) {
                        return;
                    }
                    IFile outputFile = outputFolder.getFile(resourcePath);
                    switch (sourceDelta.getKind()) {
                        case 1: {
                            if (outputFile.exists()) {
                                AJLog.log("Deleting existing file " + resourcePath);
                                outputFile.delete(1, null);
                            }
                            AJLog.log("Copying added file " + resourcePath);
                            this.createFolder(resourcePath.removeLastSegments(1), outputFolder);
                            resource.copy(outputFile.getFullPath(), 1, null);
                            outputFile.setDerived(true);
                            outputFile.setReadOnly(false);
                            outputFile.refreshLocal(0, null);
                            return;
                        }
                        case 2: {
                            if (outputFile.exists()) {
                                AJLog.log("Deleting removed file " + resourcePath);
                                outputFile.delete(1, null);
                            }
                            return;
                        }
                        case 4: {
                            if ((sourceDelta.getFlags() & 0x100) == 0 && (sourceDelta.getFlags() & 0x100000) == 0) {
                                return;
                            }
                            if (outputFile.exists()) {
                                AJLog.log("Deleting existing file " + resourcePath);
                                outputFile.delete(1, null);
                            }
                            AJLog.log("Copying changed file " + resourcePath);
                            this.createFolder(resourcePath.removeLastSegments(1), outputFolder);
                            resource.copy(outputFile.getFullPath(), 1, null);
                            outputFile.setDerived(true);
                            outputFile.setReadOnly(false);
                            outputFile.refreshLocal(0, null);
                        }
                    }
                }
                return;
            }
        }
    }

    private IContainer getContainerForGivenPath(IPath path, IProject project) {
        if (path.toOSString().equals("")) {
            return project;
        }
        return project.getFolder(path);
    }

    private IContainer createFolder(IPath packagePath, IContainer outputFolder) throws CoreException {
        if (packagePath.isEmpty()) {
            return outputFolder;
        }
        IFolder folder = outputFolder.getFolder(packagePath);
        folder.refreshLocal(0, null);
        if (!folder.exists()) {
            this.createFolder(packagePath.removeLastSegments(1), outputFolder);
            folder.create(true, true, null);
            folder.setDerived(true);
            folder.refreshLocal(0, null);
        }
        return folder;
    }

    private boolean isExcludedFromProject(IJavaProject javaProject, IPath childPath, IClasspathEntry[] srcEntries) throws JavaModelException {
        if (childPath.segmentCount() > 2) {
            return false;
        }
        int j = 0;
        int k = srcEntries.length;
        while (j < k) {
            IPath outputPath = srcEntries[j].getOutputLocation();
            if (outputPath == null) {
                outputPath = javaProject.getOutputLocation();
            }
            if (childPath.equals((Object)this.getContainerForGivenPath(outputPath = outputPath.removeFirstSegments(1).makeRelative(), javaProject.getProject()).getFullPath())) {
                return true;
            }
            IPath srcPath = srcEntries[j].getPath().removeFirstSegments(1);
            if (childPath.equals((Object)this.getContainerForGivenPath(srcPath, javaProject.getProject()).getFullPath())) {
                return true;
            }
            ++j;
        }
        return childPath.equals((Object)javaProject.getOutputLocation());
    }

    protected void cleanOutputFolders(IJavaProject project) throws CoreException {
        boolean deleteAll = "clean".equals(project.getOption("org.eclipse.jdt.core.builder.cleanOutputFolder", true));
        if (deleteAll) {
            boolean linked = false;
            String realOutputLocation = null;
            IPath workspaceRelativeOutputPath = project.getOutputLocation();
            if (workspaceRelativeOutputPath.segmentCount() == 1) {
                realOutputLocation = project.getResource().getLocation().toOSString();
            } else {
                IFolder out = ResourcesPlugin.getWorkspace().getRoot().getFolder(workspaceRelativeOutputPath);
                linked = out.isLinked();
                realOutputLocation = out.getLocation().toOSString();
            }
            File outputDir = new File(realOutputLocation);
            int numberDeleted = this.wipeClasses(outputDir.listFiles());
            AJLog.log("Builder: Tidied output folder, deleted " + numberDeleted + " .class files from " + realOutputLocation + (linked ? " (Linked output folder from " + workspaceRelativeOutputPath.toOSString() + ")" : ""));
        }
    }

    private int wipeClasses(File[] fs) {
        int count = 0;
        if (fs != null) {
            int fcounter = 0;
            while (fcounter < fs.length) {
                File file = fs[fcounter];
                if (file.getName().endsWith(".class")) {
                    file.delete();
                    ++count;
                }
                if (file.isDirectory()) {
                    count += this.wipeClasses(file.listFiles());
                }
                ++fcounter;
            }
        }
        return count;
    }

    private void updateJavaCompilerPreferences(IProject project, IProject[] dependingProjects) {
        boolean setWorkbenchPref = false;
        int i = 0;
        while (i < dependingProjects.length) {
            IProject dependingProject = dependingProjects[i];
            try {
                if (!AspectJPlugin.isAJProject(dependingProject) && dependingProject.hasNature("org.eclipse.jdt.core.javanature")) {
                    JavaProject jp = (JavaProject)JavaCore.create((IProject)dependingProject);
                    String[] names = jp.getPreferences().propertyNames();
                    if (names.length == 0 && !setWorkbenchPref) {
                        Hashtable options = JavaCore.getOptions();
                        String workbenchSetting = (String)options.get("org.eclipse.jdt.core.builder.invalidClasspath");
                        if (this.lastWorkbenchPreference.equals("abort") && workbenchSetting.equals("ignore")) {
                            this.lastWorkbenchPreference = "ignore";
                        } else if (this.lastWorkbenchPreference.equals("abort") && workbenchSetting.equals("abort")) {
                            if (!setWorkbenchPref) {
                                options.put("org.eclipse.jdt.core.builder.invalidClasspath", "ignore");
                                JavaCore.setOptions((Hashtable)options);
                                setWorkbenchPref = true;
                                this.lastWorkbenchPreference = "ignore";
                            }
                        } else if (this.lastWorkbenchPreference.equals("ignore") && workbenchSetting.equals("abort")) {
                            this.lastWorkbenchPreference = "abort";
                        }
                    } else if (names.length > 0) {
                        jp.setOption("org.eclipse.jdt.core.builder.invalidClasspath", "ignore");
                        this.lastWorkbenchPreference = (String)JavaCore.getOptions().get("org.eclipse.jdt.core.builder.invalidClasspath");
                    }
                }
            }
            catch (CoreException coreException) {
                CoreException coreException2 = coreException;
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, (Object)this, ajc$tjp_10, ajc$tjp_11);
            }
            ++i;
        }
    }

    public static void addAJBuildListener(IAJBuildListener listener) {
        if (!buildListeners.contains(listener)) {
            buildListeners.add(listener);
        }
    }

    public static void removeAJBuildListener(IAJBuildListener listener) {
        buildListeners.remove(listener);
    }

    private void preCallListeners(int kind, IProject project, IProject[] requiredProjects) {
        Iterator iter = buildListeners.iterator();
        while (iter.hasNext()) {
            IAJBuildListener listener = (IAJBuildListener)iter.next();
            listener.preAJBuild(kind, project, requiredProjects);
        }
    }

    private void postCallListeners(boolean noSourceChanges) {
        Iterator iter = buildListeners.iterator();
        while (iter.hasNext()) {
            IAJBuildListener listener = (IAJBuildListener)iter.next();
            listener.postAJBuild(this.getProject(), this.buildCancelled, noSourceChanges);
        }
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
    }
}

