/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.ajdt.internal.core.IAJLogger;

public class AJLog {
    private static IAJLogger logger;
    private static Map timers;

    static {
        timers = new HashMap();
    }

    public static void log(String msg) {
        if (logger != null) {
            logger.log(msg);
        } else {
            System.out.println(msg);
        }
    }

    public static void logStart(String event) {
        Long now = new Long(System.currentTimeMillis());
        timers.put(event, now);
    }

    public static void logEnd(String event) {
        AJLog.logEnd(event, null);
    }

    public static void logEnd(String event, String optional_msg) {
        Long then = (Long)timers.get(event);
        if (then != null) {
            long now = System.currentTimeMillis();
            long elapsed = now - then;
            if (optional_msg != null && optional_msg.length() > 0) {
                AJLog.log("Timer event: " + elapsed + "ms: " + event + " (" + optional_msg + ")");
            } else {
                AJLog.log("Timer event: " + elapsed + "ms: " + event);
            }
            timers.remove(event);
        }
    }

    public static void setLogger(IAJLogger l) {
        logger = l;
    }
}

