/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.core.builder;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.internal.core.builder.ClasspathLocation;
import org.eclipse.ajdt.internal.core.ras.CoreFFDC;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.util.SimpleLookupTable;

class ClasspathDirectory
extends ClasspathLocation {
    IContainer binaryFolder;
    boolean isOutputFolder;
    String binaryLocation;
    SimpleLookupTable directoryCache;
    String[] missingPackageHolder = new String[1];
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;

    ClasspathDirectory(IContainer binaryFolder, boolean isOutputFolder) {
        this.binaryFolder = binaryFolder;
        this.isOutputFolder = isOutputFolder;
        IPath location = binaryFolder.getLocation();
        this.binaryLocation = location != null ? location.addTrailingSeparator().toString() : "";
        this.directoryCache = new SimpleLookupTable(5);
    }

    public void cleanup() {
        this.directoryCache = null;
    }

    String[] directoryList(String qualifiedPackageName) {
        String[] dirList = (String[])this.directoryCache.get((Object)qualifiedPackageName);
        if (dirList == this.missingPackageHolder) {
            return null;
        }
        if (dirList != null) {
            return dirList;
        }
        try {
            IResource container = this.binaryFolder.findMember(qualifiedPackageName);
            if (container instanceof IContainer && !this.isExcluded(container)) {
                IResource[] members = ((IContainer)container).members();
                dirList = new String[members.length];
                int index = 0;
                int i = 0;
                int l = members.length;
                while (i < l) {
                    IResource m = members[i];
                    if (m.getType() == 1 && Util.isClassFileName((String)m.getName())) {
                        dirList[index++] = m.getName();
                    }
                    ++i;
                }
                if (index < dirList.length) {
                    String[] stringArray = dirList;
                    dirList = new String[index];
                    System.arraycopy(stringArray, 0, dirList, 0, index);
                }
                this.directoryCache.put((Object)qualifiedPackageName, (Object)dirList);
                return dirList;
            }
        }
        catch (CoreException coreException) {
            CoreException coreException2 = coreException;
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, this, ajc$tjp_0, ajc$tjp_1);
        }
        this.directoryCache.put((Object)qualifiedPackageName, (Object)this.missingPackageHolder);
        return null;
    }

    boolean doesFileExist(String fileName, String qualifiedPackageName, String qualifiedFullName) {
        String[] dirList = this.directoryList(qualifiedPackageName);
        if (dirList == null) {
            return false;
        }
        int i = dirList.length;
        while (--i >= 0) {
            if (!fileName.equals(dirList[i])) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClasspathDirectory)) {
            return false;
        }
        return this.binaryFolder.equals((Object)((ClasspathDirectory)o).binaryFolder);
    }

    public NameEnvironmentAnswer findClass(String binaryFileName, String qualifiedPackageName, String qualifiedBinaryFileName) {
        block7: {
            if (!this.doesFileExist(binaryFileName, qualifiedPackageName, qualifiedBinaryFileName)) {
                return null;
            }
            try {
                ClassFileReader reader = ClassFileReader.read((String)(String.valueOf(this.binaryLocation) + qualifiedBinaryFileName));
                if (reader != null) {
                    return new NameEnvironmentAnswer((IBinaryType)reader);
                }
            }
            catch (Exception exception) {
                IPath location;
                IResource file;
                Exception exception2 = exception;
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(exception2, this, ajc$tjp_2, ajc$tjp_3);
                if (!(this.binaryFolder instanceof IProject) || !((file = this.binaryFolder.findMember(qualifiedBinaryFileName)) instanceof IFile) || (location = file.getLocation()) == null) break block7;
                try {
                    ClassFileReader reader = ClassFileReader.read((String)location.toString());
                    if (reader != null) {
                        return new NameEnvironmentAnswer((IBinaryType)reader);
                    }
                }
                catch (Exception exception3) {
                    Exception exception4 = exception3;
                    CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(exception4, this, ajc$tjp_4, ajc$tjp_3);
                }
            }
        }
        return null;
    }

    public IPath getProjectRelativePath() {
        return this.binaryFolder.getProjectRelativePath();
    }

    protected boolean isExcluded(IResource resource) {
        return false;
    }

    public boolean isOutputFolder() {
        return this.isOutputFolder;
    }

    public boolean isPackage(String qualifiedPackageName) {
        return this.directoryList(qualifiedPackageName) != null;
    }

    public void reset() {
        this.directoryCache = new SimpleLookupTable(5);
    }

    public String toString() {
        return "Binary classpath directory " + this.binaryFolder.getFullPath().toString();
    }

    public String toOSString() {
        return this.binaryFolder.getLocation().toOSString();
    }

    static {
        Factory factory = new Factory("ClasspathDirectory.java", Class.forName("org.eclipse.ajdt.internal.core.builder.ClasspathDirectory"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.core.builder.ClasspathDirectory-org.eclipse.core.runtime.CoreException-<missing>-"), 67);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-directoryList-org.eclipse.ajdt.internal.core.builder.ClasspathDirectory-java.lang.String:-qualifiedPackageName:--[Ljava.lang.String;-"), 46);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.core.builder.ClasspathDirectory-java.lang.Exception-<missing>-"), 97);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-findClass-org.eclipse.ajdt.internal.core.builder.ClasspathDirectory-java.lang.String:java.lang.String:java.lang.String:-binaryFileName:qualifiedPackageName:qualifiedBinaryFileName:--org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer-"), 92);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.core.builder.ClasspathDirectory-java.lang.Exception-<missing>-"), 107);
    }
}

