/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.buildconfigurator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.buildconfigurator.IBuildConfigurationChangedListener;
import org.eclipse.ajdt.buildconfigurator.ProjectBuildConfigurator;
import org.eclipse.ajdt.buildconfigurator.PropertyPageManager;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.internal.core.AJDTUtils;
import org.eclipse.ajdt.internal.core.CoreUtils;
import org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.packageview.ClassPathContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.progress.UIJob;

public class BuildConfigurator
implements ISelectionListener {
    private HashMap projectConfigurators = new HashMap();
    private Vector changeListeners = new Vector();
    private IProject currentProj;
    private int notificationType = -1;
    private static BuildConfigurator buildConfigurator;
    private HashSet fileList;
    private boolean triedToOpenXRefView;
    static /* synthetic */ Class class$0;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;

    private BuildConfigurator() {
    }

    public static synchronized BuildConfigurator getBuildConfigurator() {
        if (buildConfigurator == null) {
            buildConfigurator = new BuildConfigurator();
        }
        return buildConfigurator;
    }

    public synchronized void selectionChanged(IWorkbenchPart action, ISelection selection) {
        Object selectedProj;
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        if (AJDTUtils.FORCE_MIGRATION || !AspectJPreferences.dontRunMigrationWizard() && !store.getBoolean("neverRunMigrationWizard") && !AspectJUIPlugin.getDefault().workspaceIsEmpty(AspectJPlugin.getWorkspace().getRoot())) {
            AJDTUtils.migrateWorkbench();
            AJDTUtils.FORCE_MIGRATION = false;
        } else if (!this.triedToOpenXRefView && !AspectJPreferences.migrationWizardIsRunning()) {
            String workspaceLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
            if (!(AspectJPreferences.migrationWizardIsRunning() || store.getBoolean("doneAutoOpenXRefView" + workspaceLocation) || store.getBoolean(workspaceLocation))) {
                UIJob job = new UIJob(AspectJUIPlugin.getResourceString("AJDTPrefConfigWizardPage.workbench.openXRefView")){
                    private static final JoinPoint.StaticPart ajc$tjp_0;
                    private static final JoinPoint.StaticPart ajc$tjp_1;

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        try {
                            AspectJUIPlugin.getDefault().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.contribution.xref.ui.views.XReferenceView");
                            return Status.OK_STATUS;
                        }
                        catch (PartInitException partInitException) {
                            PartInitException partInitException2 = partInitException;
                            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(partInitException2, (Object)this, ajc$tjp_0, ajc$tjp_1);
                            PartInitException e = partInitException2;
                            AspectJUIPlugin.getDefault().getErrorHandler().handleError(AspectJUIPlugin.getResourceString("AJDTPrefConfigWizardPage.ErrorOpeningXRefView"), e);
                            return Status.OK_STATUS;
                        }
                    }

                    static {
                        Factory factory = new Factory("BuildConfigurator.java", Class.forName("org.eclipse.ajdt.buildconfigurator.BuildConfigurator$1"));
                        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.buildconfigurator.BuildConfigurator$1-org.eclipse.ui.PartInitException-e-"), 114);
                        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-runInUIThread-org.eclipse.ajdt.buildconfigurator.BuildConfigurator$1-org.eclipse.core.runtime.IProgressMonitor:-monitor:--org.eclipse.core.runtime.IStatus-"), 111);
                    }
                };
                job.schedule();
                store.setValue("doneAutoOpenXRefView" + workspaceLocation, true);
            }
            this.triedToOpenXRefView = true;
        }
        if (action instanceof IEditorPart) {
            IResource res;
            IEditorInput iEditorInput = ((IEditorPart)action).getEditorInput();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ClassNotFoundException classNotFoundException2 = classNotFoundException;
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(classNotFoundException2, this, ajc$tjp_0, ajc$tjp_1);
                    throw new NoClassDefFoundError(classNotFoundException2.getMessage());
                }
            }
            selectedProj = (res = (IResource)iEditorInput.getAdapter((Class)clazz)) != null ? res.getProject() : null;
        } else {
            selectedProj = this.getProjectFromSelection(selection);
        }
        if (selectedProj != this.currentProj && selectedProj != null) {
            this.fileList = null;
            this.currentProj = selectedProj;
            if (this.canManage(this.currentProj)) {
                PropertyPageManager.unregisterJDTPropertyPage();
            } else if (this.currentProj.isOpen()) {
                PropertyPageManager.registerJDTPropertyPage();
            }
            this.notifyChangeListeners();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void notifyChangeListeners() {
        if (this.notificationType != -1) return;
        try {
            this.notificationType = 0;
            ProjectBuildConfigurator pbc = this.getActiveProjectBuildConfigurator();
            Iterator iter = this.changeListeners.iterator();
            while (iter.hasNext()) {
                ((IBuildConfigurationChangedListener)iter.next()).buildConfigurationChanged(pbc);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.notificationType = -1;
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.notificationType = -1;
            return;
        }
    }

    private IProject getProjectFromSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            Object first = ((IStructuredSelection)selection).getFirstElement();
            if (first instanceof IJavaElement) {
                return ((IJavaElement)first).getJavaProject().getProject();
            }
            if (first instanceof IResource) {
                IResource myRes = (IResource)first;
                return myRes.getProject();
            }
            if (first instanceof ClassPathContainer) {
                return ((ClassPathContainer)first).getJavaProject().getProject();
            }
        }
        return null;
    }

    public ProjectBuildConfigurator getActiveProjectBuildConfigurator() {
        return this.getProjectBuildConfigurator(this.currentProj);
    }

    public Set getProjectBuildConfigurators() {
        return this.projectConfigurators.entrySet();
    }

    public ProjectBuildConfigurator getProjectBuildConfigurator(IJavaProject proj) {
        if (proj != null && this.canManage(proj.getProject())) {
            ProjectBuildConfigurator pbc = (ProjectBuildConfigurator)this.projectConfigurators.get(proj.getProject().getName());
            if (pbc != null) {
                return pbc;
            }
            return this.createPBC(proj);
        }
        return null;
    }

    private synchronized ProjectBuildConfigurator createPBC(IJavaProject proj) {
        ProjectBuildConfigurator pbc = (ProjectBuildConfigurator)this.projectConfigurators.get(proj.getProject().getName());
        if (pbc != null) {
            return pbc;
        }
        pbc = new ProjectBuildConfigurator(proj);
        this.projectConfigurators.put(proj.getProject().getName(), pbc);
        return pbc;
    }

    public ProjectBuildConfigurator getProjectBuildConfigurator(IProject proj) {
        return this.getProjectBuildConfigurator(JavaCore.create((IProject)proj));
    }

    public boolean canManage(IProject proj) {
        if (proj == null || !proj.isOpen()) {
            return false;
        }
        return AspectJPlugin.isAJProject((IProject)proj);
    }

    public void addProjectBuildConfigurator(ProjectBuildConfigurator pbc) {
        this.projectConfigurators.put(pbc.getJavaProject().getProject().getName(), pbc);
    }

    public void addBuildConfigurationChangedListener(IBuildConfigurationChangedListener bccl) {
        this.changeListeners.add(bccl);
    }

    public void removeBuildConfigurationChangedListener(IBuildConfigurationChangedListener bccl) {
        this.changeListeners.remove(bccl);
    }

    public void closeProject(IProject proj) {
        this.fileList = null;
        ProjectBuildConfigurator pbc = (ProjectBuildConfigurator)this.projectConfigurators.get(proj.getName());
        if (pbc != null) {
            if (proj == this.currentProj) {
                this.currentProj = null;
            }
            this.projectConfigurators.remove(proj.getName());
            this.notifyChangeListeners();
        }
    }

    public void checkNature(IProject project) {
        if (this.projectConfigurators.containsKey(project.getName())) {
            ProjectBuildConfigurator pbc;
            if (!this.canManage(project) && (pbc = (ProjectBuildConfigurator)this.projectConfigurators.get(project.getName())) != null) {
                this.closeProject(project);
            }
        } else if (this.canManage(project)) {
            this.currentProj = project;
            this.notifyChangeListeners();
        }
    }

    public void restoreJDTState(IProject project) {
        PropertyPageManager.registerJDTPropertyPage();
        this.checkNature(project);
    }

    public void setup(IProject project) {
        this.fileList = null;
        PropertyPageManager.unregisterJDTPropertyPage();
        try {
            IJavaProject jp = JavaCore.create((IProject)project);
            IClasspathEntry[] cpes = jp.getRawClasspath();
            if (this.haveExclusionPatterns(cpes)) {
                this.fileList = this.getFileSetFromCPE(cpes, jp);
                int i = 0;
                while (i < cpes.length) {
                    if (cpes[i].getEntryKind() == 3) {
                        cpes[i] = JavaCore.newSourceEntry((IPath)cpes[i].getPath());
                    }
                    ++i;
                }
                jp.setRawClasspath(cpes, null);
            }
        }
        catch (JavaModelException javaModelException) {
            JavaModelException javaModelException2 = javaModelException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException2, this, ajc$tjp_2, ajc$tjp_3);
            this.fileList = null;
        }
        if (this.currentProj == null || this.currentProj == project) {
            this.currentProj = project;
            this.notifyChangeListeners();
        }
    }

    HashSet getFileSetFromCPE(IClasspathEntry[] cpes, IJavaProject jp) {
        HashSet fileSet = new HashSet(30);
        int i = 0;
        while (i < cpes.length) {
            IResource res;
            if (cpes[i].getEntryKind() == 3 && (res = jp.getProject().getParent().findMember(cpes[i].getPath())) != null && (res.getType() == 2 || res.getType() == 4)) {
                this.addAllIncludedMembers(fileSet, (IContainer)res, jp);
            }
            ++i;
        }
        return fileSet;
    }

    boolean haveExclusionPatterns(IClasspathEntry[] cpes) {
        int i = 0;
        while (i < cpes.length) {
            if (cpes[i].getEntryKind() == 3 && (cpes[i].getExclusionPatterns().length > 0 || cpes[i].getInclusionPatterns().length > 0)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    HashSet getInitialFileList() {
        return this.fileList;
    }

    private void addAllIncludedMembers(HashSet l, IContainer con, IJavaProject jp) {
        try {
            IResource[] reses = con.members();
            int i = 0;
            while (i < reses.length) {
                if (reses[i] instanceof IContainer) {
                    this.addAllIncludedMembers(l, (IContainer)reses[i], jp);
                } else if (jp.isOnClasspath(reses[i]) && CoreUtils.ASPECTJ_SOURCE_FILTER.accept(reses[i].getName())) {
                    l.add(reses[i]);
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            CoreException coreException2 = coreException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, this, ajc$tjp_4, ajc$tjp_5);
        }
    }

    public static String getFreeFileName(IProject project) {
        String defaultFileName = AspectJUIPlugin.getResourceString("BCDialog.SaveBuildConfigurationAs.default");
        int counter = 0;
        if (project != null) {
            boolean foundFreeName = false;
            while (!foundFreeName) {
                String name = counter == 0 ? defaultFileName : String.valueOf(defaultFileName) + counter;
                IPath path = project.getFullPath().append(String.valueOf(name) + "." + "ajproperties");
                if (!AspectJPlugin.getWorkspace().getRoot().getFile(path).exists()) {
                    foundFreeName = true;
                    continue;
                }
                ++counter;
            }
        }
        return counter == 0 ? defaultFileName : String.valueOf(defaultFileName) + counter;
    }

    static {
        Factory factory = new Factory("BuildConfigurator.java", Class.forName("org.eclipse.ajdt.buildconfigurator.BuildConfigurator"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.buildconfigurator.BuildConfigurator-java.lang.ClassNotFoundException-<missing>-"), 129);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21-selectionChanged-org.eclipse.ajdt.buildconfigurator.BuildConfigurator-org.eclipse.ui.IWorkbenchPart:org.eclipse.jface.viewers.ISelection:-action:selection:--void-"), 93);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.buildconfigurator.BuildConfigurator-org.eclipse.jdt.core.JavaModelException-<missing>-"), 322);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setup-org.eclipse.ajdt.buildconfigurator.BuildConfigurator-org.eclipse.core.resources.IProject:-project:--void-"), 307);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.buildconfigurator.BuildConfigurator-org.eclipse.core.runtime.CoreException-<missing>-"), 374);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-addAllIncludedMembers-org.eclipse.ajdt.buildconfigurator.BuildConfigurator-java.util.HashSet:org.eclipse.core.resources.IContainer:org.eclipse.jdt.core.IJavaProject:-l:con:jp:--void-"), 363);
    }
}

