/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.launching;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.buildconfigurator.BuildConfigurator;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnit;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnitManager;
import org.eclipse.ajdt.internal.launching.AJMainMethodSearchEngine;
import org.eclipse.ajdt.internal.launching.AJMainTypeSelectionDialog;
import org.eclipse.ajdt.internal.launching.LaunchConfigurationClasspathUtils;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.launcher.JavaApplicationLaunchShortcut;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;

public class AspectJApplicationLaunchShortcut
extends JavaApplicationLaunchShortcut {
    public static final String ASPECTJ_LAUNCH_ID = "org.eclipse.ajdt.launching.AspectJApplication";
    public static final String AJ_FILE_EXTENSION = "aj";
    public static final String JAVA_FILE_EXTENSION = "java";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;
    private static final JoinPoint.StaticPart ajc$tjp_9;
    private static final JoinPoint.StaticPart ajc$tjp_10;
    private static final JoinPoint.StaticPart ajc$tjp_11;
    private static final JoinPoint.StaticPart ajc$tjp_12;
    private static final JoinPoint.StaticPart ajc$tjp_13;
    private static final JoinPoint.StaticPart ajc$tjp_14;

    public void searchAndLaunch(Object[] search, String mode, boolean editor) {
        Object[] types = null;
        if (search != null) {
            try {
                IJavaElement[] elements = this.getJavaElements(search);
                if (elements.length > 0) {
                    AJMainMethodSearchEngine engine = new AJMainMethodSearchEngine();
                    IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements, (boolean)false);
                    types = engine.searchMainMethodsIncludingAspects((IRunnableContext)PlatformUI.getWorkbench().getProgressService(), scope, 24, true);
                } else {
                    types = search;
                }
            }
            catch (InterruptedException interruptedException) {
                InterruptedException interruptedException2 = interruptedException;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(interruptedException2, (Object)this, ajc$tjp_0, ajc$tjp_1);
                return;
            }
            catch (InvocationTargetException invocationTargetException) {
                InvocationTargetException invocationTargetException2 = invocationTargetException;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(invocationTargetException2, (Object)this, ajc$tjp_2, ajc$tjp_1);
                InvocationTargetException e = invocationTargetException2;
                MessageDialog.openError((Shell)this.getShell(), (String)"Launch Failed", (String)e.getMessage());
                return;
            }
            Object type = null;
            if (types.length == 0) {
                String message = null;
                message = editor ? LauncherMessages.getString((String)"JavaApplicationLaunchShortcut.The_active_editor_does_not_contain_a_main_type._1") : LauncherMessages.getString((String)"JavaApplicationLaunchShortcut.The_selection_does_not_contain_a_main_type._2");
                MessageDialog.openError((Shell)this.getShell(), (String)LauncherMessages.getString((String)"JavaApplicationAction.Launch_failed_7"), (String)message);
            } else {
                type = types.length > 1 ? this.chooseType(types, mode) : types[0];
            }
            if (type != null) {
                this.launch(type, mode);
            }
        }
    }

    private IJavaElement[] getJavaElements(Object[] objects) {
        ArrayList<IJavaElement> list = new ArrayList<IJavaElement>(objects.length);
        int i = 0;
        while (i < objects.length) {
            Object object = objects[i];
            if (object instanceof IAdaptable) {
                IJavaElement element;
                IAdaptable iAdaptable = (IAdaptable)object;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.jdt.core.IJavaElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        ClassNotFoundException classNotFoundException2 = classNotFoundException;
                        UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(classNotFoundException2, (Object)this, ajc$tjp_3, ajc$tjp_4);
                        throw new NoClassDefFoundError(classNotFoundException2.getMessage());
                    }
                }
                if ((element = (IJavaElement)iAdaptable.getAdapter((Class)clazz)) != null) {
                    IType type;
                    if (element instanceof IMember && (type = ((IMember)element).getDeclaringType()) != null) {
                        element = type;
                    }
                    list.add(element);
                }
            }
            ++i;
        }
        return list.toArray(new IJavaElement[list.size()]);
    }

    protected void launch(Object type, String mode) {
        ILaunchConfiguration config = this.findLaunchConfiguration(type, mode);
        if (config != null) {
            LaunchConfigurationClasspathUtils.addAspectPathToClasspath(config);
            DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
        }
    }

    protected ILaunchConfiguration findLaunchConfiguration(Object type, String mode) {
        ILaunchConfigurationType configType = AspectJApplicationLaunchShortcut.getAJLaunchConfigType();
        ArrayList<ILaunchConfiguration> candidateConfigs = Collections.EMPTY_LIST;
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(configType);
            candidateConfigs = new ArrayList<ILaunchConfiguration>(configs.length);
            int i = 0;
            while (i < configs.length) {
                ILaunchConfiguration config = configs[i];
                String fullyQualifiedName = null;
                String projectName = null;
                if (type instanceof IType) {
                    fullyQualifiedName = ((IType)type).getFullyQualifiedName();
                    projectName = ((IType)type).getJavaProject().getElementName();
                }
                if (config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "").equals(fullyQualifiedName) && config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "").equals(projectName)) {
                    candidateConfigs.add(config);
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            CoreException coreException2 = coreException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, (Object)this, ajc$tjp_5, ajc$tjp_6);
            CoreException e = coreException2;
            JDIDebugUIPlugin.log((Throwable)e);
        }
        int candidateCount = candidateConfigs.size();
        if (candidateCount < 1) {
            return this.createConfiguration(type);
        }
        if (candidateCount == 1) {
            return (ILaunchConfiguration)candidateConfigs.get(0);
        }
        ILaunchConfiguration config = this.chooseConfiguration(candidateConfigs, mode);
        if (config != null) {
            return config;
        }
        return null;
    }

    protected ILaunchConfiguration createConfiguration(Object type) {
        ILaunchConfiguration config = null;
        if (type instanceof IType) {
            config = this.createConfigurationForIType((IType)type);
        }
        return config;
    }

    private ILaunchConfiguration createConfigurationForIType(IType type) {
        ILaunchConfiguration config = null;
        ILaunchConfigurationWorkingCopy wc = null;
        try {
            ILaunchConfigurationType configType = AspectJApplicationLaunchShortcut.getAJLaunchConfigType();
            wc = configType.newInstance(null, this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(type.getElementName()));
        }
        catch (CoreException coreException) {
            CoreException coreException2 = coreException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, (Object)this, ajc$tjp_7, ajc$tjp_8);
            CoreException exception = coreException2;
            this.reportCreatingConfiguration(exception);
            return null;
        }
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, type.getFullyQualifiedName());
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, type.getJavaProject().getElementName());
        try {
            config = wc.doSave();
        }
        catch (CoreException coreException) {
            CoreException coreException3 = coreException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException3, (Object)this, ajc$tjp_9, ajc$tjp_8);
            CoreException exception = coreException3;
            this.reportCreatingConfiguration(exception);
        }
        return config;
    }

    protected static ILaunchConfigurationType getAJLaunchConfigType() {
        return DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(ASPECTJ_LAUNCH_ID);
    }

    protected Object chooseType(Object[] types, String mode) {
        AJMainTypeSelectionDialog dialog = new AJMainTypeSelectionDialog(this.getShell(), types);
        if (mode.equals("debug")) {
            dialog.setTitle(LauncherMessages.getString((String)"JavaApplicationAction.Type_Selection_Debug"));
        } else {
            dialog.setTitle(LauncherMessages.getString((String)"JavaApplicationAction.Type_Selection_Run"));
        }
        dialog.setMultipleSelection(false);
        if (dialog.open() == 0) {
            return dialog.getFirstResult();
        }
        return null;
    }

    public void launch(IEditorPart editor, String mode) {
        IJavaElement je;
        boolean error = true;
        IEditorInput input = editor.getEditorInput();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.IJavaElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                ClassNotFoundException classNotFoundException2 = classNotFoundException;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(classNotFoundException2, (Object)this, ajc$tjp_10, ajc$tjp_11);
                throw new NoClassDefFoundError(classNotFoundException2.getMessage());
            }
        }
        if ((je = (IJavaElement)input.getAdapter((Class)clazz)) != null) {
            this.searchAndLaunch(new Object[]{je}, mode, true);
            error = false;
        } else if (input instanceof IFileEditorInput) {
            IFile file;
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IFile");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ClassNotFoundException classNotFoundException3 = classNotFoundException;
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(classNotFoundException3, (Object)this, ajc$tjp_12, ajc$tjp_11);
                    throw new NoClassDefFoundError(classNotFoundException3.getMessage());
                }
            }
            if ((file = (IFile)input.getAdapter((Class)clazz2)).getFileExtension().equals(AJ_FILE_EXTENSION)) {
                this.searchAndLaunch(new Object[]{AJCompilationUnitManager.INSTANCE.getAJCompilationUnit(file)}, mode, true);
                error = false;
            }
        }
        if (error) {
            MessageDialog.openError((Shell)this.getShell(), (String)LauncherMessages.getString((String)"JavaApplicationAction.Launch_failed_7"), (String)LauncherMessages.getString((String)"JavaApplicationLaunchShortcut.The_active_editor_does_not_contain_a_main_type._1"));
        }
    }

    private List getMainTypesForFile(IFile file) {
        ArrayList<IType> mainTypes = new ArrayList<IType>();
        AJCompilationUnit element = AJCompilationUnitManager.INSTANCE.getAJCompilationUnit(file);
        try {
            if (BuildConfigurator.getBuildConfigurator().getProjectBuildConfigurator(element.getJavaProject()).getActiveBuildConfiguration().isIncluded(element.getCorrespondingResource())) {
                IType[] types = element.getAllTypes();
                int i = 0;
                while (i < types.length) {
                    IType type = types[i];
                    IMethod[] methods = type.getMethods();
                    int j = 0;
                    while (j < methods.length) {
                        if (methods[j].isMainMethod()) {
                            mainTypes.add(type);
                            break;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        catch (JavaModelException javaModelException) {
            JavaModelException javaModelException2 = javaModelException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException2, (Object)this, ajc$tjp_13, ajc$tjp_14);
        }
        return mainTypes;
    }

    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection struct = (IStructuredSelection)selection;
            ArrayList elements = new ArrayList();
            Iterator iter = struct.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (element instanceof IJavaElement) {
                    elements.add(element);
                    continue;
                }
                if (!(element instanceof IFile)) continue;
                IFile file = (IFile)element;
                List mainTypes = this.getMainTypesForFile(file);
                elements.addAll(mainTypes);
            }
            this.searchAndLaunch(elements.toArray(), mode, false);
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)LauncherMessages.getString((String)"JavaApplicationAction.Launch_failed_7"), (String)LauncherMessages.getString((String)"JavaApplicationLaunchShortcut.The_selection_does_not_contain_a_main_type._2"));
        }
    }

    static {
        Factory factory = new Factory("AspectJApplicationLaunchShortcut.java", Class.forName("org.eclipse.ajdt.internal.launching.AspectJApplicationLaunchShortcut"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.launching.AspectJApplicationLaunchShortcut-java.lang.InterruptedException-<missing>-"), 96);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-searchAndLaunch-org.eclipse.ajdt.internal.launching.AspectJApplicationLaunchShortcut-[Ljava.lang.Object;:java.lang.String:boolean:-search:mode:editor:--void-"), 77);
        ajc$tjp_10 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.launching.AspectJApplicationLaunchShortcut-java.lang.ClassNotFoundException-<missing>-"), 307);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-launch-org.eclipse.ajdt.internal.launching.AspectJApplicationLaunchShortcut-org.eclipse.ui.IEditorPart:java.lang.String:-editor:mode:--void-"), 305);
        ajc$tjp_12 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.launching.AspectJApplicationLaunchShortcut-java.lang.ClassNotFoundException-<missing>-"), 312);
        ajc$tjp_13 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.launching.AspectJApplicationLaunchShortcut-org.eclipse.jdt.core.JavaModelException-<missing>-"), 348);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getMainTypesForFile-org.eclipse.ajdt.internal.launching.AspectJApplicationLaunchShortcut-org.eclipse.core.resources.IFile:-file:--java.util.List-"), 332);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.launching.AspectJApplicationLaunchShortcut-java.lang.reflect.InvocationTargetException-e-"), 98);
        ajc$tjp_3 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.launching.AspectJApplicationLaunchShortcut-java.lang.ClassNotFoundException-<missing>-"), 143);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getJavaElements-org.eclipse.ajdt.internal.launching.AspectJApplicationLaunchShortcut-[Ljava.lang.Object;:-objects:--[Lorg.eclipse.jdt.core.IJavaElement;-"), 138);
        ajc$tjp_5 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.launching.AspectJApplicationLaunchShortcut-org.eclipse.core.runtime.CoreException-e-"), 205);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-findLaunchConfiguration-org.eclipse.ajdt.internal.launching.AspectJApplicationLaunchShortcut-java.lang.Object:java.lang.String:-type:mode:--org.eclipse.debug.core.ILaunchConfiguration-"), 179);
        ajc$tjp_7 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.launching.AspectJApplicationLaunchShortcut-org.eclipse.core.runtime.CoreException-exception-"), 258);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-createConfigurationForIType-org.eclipse.ajdt.internal.launching.AspectJApplicationLaunchShortcut-org.eclipse.jdt.core.IType:-type:--org.eclipse.debug.core.ILaunchConfiguration-"), 253);
        ajc$tjp_9 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.launching.AspectJApplicationLaunchShortcut-org.eclipse.core.runtime.CoreException-exception-"), 266);
    }
}

