/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.actions;

import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.buildconfigurator.BuildConfiguration;
import org.eclipse.ajdt.buildconfigurator.BuildConfigurator;
import org.eclipse.ajdt.buildconfigurator.ProjectBuildConfigurator;
import org.eclipse.ajdt.internal.core.AJLog;
import org.eclipse.ajdt.internal.core.CoreUtils;
import org.eclipse.ajdt.internal.core.ICoreOperations;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class UICoreOperations
implements ICoreOperations {
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;

    public boolean isFullBuildRequested(IProject project) {
        ProjectBuildConfigurator pbc = BuildConfigurator.getBuildConfigurator().getProjectBuildConfigurator(project);
        if (pbc != null && pbc.fullBuildRequested()) {
            pbc.requestFullBuild(false);
            return true;
        }
        return false;
    }

    public boolean sourceFilesChanged(IResourceDelta delta, IProject project) {
        if (delta != null && delta.getAffectedChildren().length != 0) {
            ProjectBuildConfigurator pbc = BuildConfigurator.getBuildConfigurator().getProjectBuildConfigurator(project);
            BuildConfiguration bc = pbc.getActiveBuildConfiguration();
            List includedFileNames = bc.getIncludedJavaFileNames(CoreUtils.ASPECTJ_SOURCE_FILTER);
            IJavaProject ijp = JavaCore.create((IProject)project);
            try {
                if (this.sourceFilesChanged(delta, includedFileNames, ijp.getOutputLocation())) {
                    AJLog.log((String)("build: Examined delta - source file changes in required project " + project.getName()));
                    return true;
                }
            }
            catch (JavaModelException javaModelException) {
                JavaModelException javaModelException2 = javaModelException;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException2, this, ajc$tjp_0, ajc$tjp_1);
            }
        }
        return false;
    }

    private boolean sourceFilesChanged(IResourceDelta dta, List includedFileNames, IPath outputLocation) {
        if (dta == null) {
            return false;
        }
        String resname = dta.getFullPath().toString();
        if (outputLocation.equals((Object)dta.getFullPath())) {
            return false;
        }
        if (resname.endsWith(".java") || resname.endsWith(".aj")) {
            return includedFileNames.contains(dta.getResource().getLocation().toOSString());
        }
        if (resname.endsWith(".lst") && !resname.endsWith("/generated.lst")) {
            return true;
        }
        boolean kids_results = false;
        int i = 0;
        IResourceDelta[] kids = dta.getAffectedChildren();
        while (!kids_results && i < kids.length) {
            kids_results |= this.sourceFilesChanged(kids[i], includedFileNames, outputLocation);
            ++i;
        }
        return kids_results;
    }

    static {
        Factory factory = new Factory("UICoreOperations.java", Class.forName("org.eclipse.ajdt.internal.ui.actions.UICoreOperations"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.actions.UICoreOperations-org.eclipse.jdt.core.JavaModelException-<missing>-"), 68);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-sourceFilesChanged-org.eclipse.ajdt.internal.ui.actions.UICoreOperations-org.eclipse.core.resources.IResourceDelta:org.eclipse.core.resources.IProject:-delta:project:--boolean-"), 55);
    }
}

