/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.editor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.internal.ui.editor.quickfix.JavaCorrectionProcessor;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IProblemRequestor;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitAnnotationModelEvent;
import org.eclipse.jdt.internal.ui.javaeditor.IJavaAnnotation;
import org.eclipse.jdt.internal.ui.javaeditor.JavaMarkerAnnotation;
import org.eclipse.jdt.internal.ui.text.java.IProblemRequestorExtension;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModelEvent;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.IAnnotationModelListenerExtension;
import org.eclipse.jface.text.source.IAnnotationPresentation;
import org.eclipse.jface.text.source.ImageUtilities;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.AnnotationPreferenceLookup;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;

public class AJCompilationUnitAnnotationModel
extends ResourceMarkerAnnotationModel
implements IProblemRequestor,
IProblemRequestorExtension {
    private ThreadLocal fProblemRequestorState = new ThreadLocal();
    private int fStateCount = 0;
    private ICompilationUnit fCompilationUnit;
    private List fGeneratedAnnotations;
    private IProgressMonitor fProgressMonitor;
    private boolean fIsActive = false;
    private ReverseMap fReverseMap = new ReverseMap();
    private List fPreviouslyOverlaid = null;
    private List fCurrentlyOverlaid = new ArrayList();
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;

    public AJCompilationUnitAnnotationModel(IResource resource) {
        super(resource);
        final IPreferenceStore store = JavaPlugin.getDefault().getPreferenceStore();
        boolean analyzeAnnotations = store.getBoolean("handleTemporaryProblems");
        this.setIsActive(analyzeAnnotations);
        IPropertyChangeListener propertyListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("handleTemporaryProblems".equals(event.getProperty())) {
                    AJCompilationUnitAnnotationModel.this.setIsActive(store.getBoolean("handleTemporaryProblems"));
                }
            }
        };
        JavaPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(propertyListener);
    }

    public void setCompilationUnit(ICompilationUnit unit) {
        this.fCompilationUnit = unit;
    }

    protected MarkerAnnotation createMarkerAnnotation(IMarker marker) {
        String markerType = MarkerUtilities.getMarkerType((IMarker)marker);
        if (markerType != null && markerType.startsWith("org.eclipse.jdt")) {
            return new JavaMarkerAnnotation(marker);
        }
        return super.createMarkerAnnotation(marker);
    }

    protected AnnotationModelEvent createAnnotationModelEvent() {
        return new CompilationUnitAnnotationModelEvent((IAnnotationModel)this, this.getResource());
    }

    protected Position createPositionFromProblem(IProblem problem) {
        int start = problem.getSourceStart();
        if (start < 0) {
            return null;
        }
        int length = problem.getSourceEnd() - problem.getSourceStart() + 1;
        if (length < 0) {
            return null;
        }
        return new Position(start, length);
    }

    public void beginReporting() {
        ProblemRequestorState state = (ProblemRequestorState)this.fProblemRequestorState.get();
        if (state == null) {
            this.internalBeginReporting(false);
        }
    }

    public void beginReportingSequence() {
        ProblemRequestorState state = (ProblemRequestorState)this.fProblemRequestorState.get();
        if (state == null) {
            this.internalBeginReporting(true);
        }
    }

    private void internalBeginReporting(boolean insideReportingSequence) {
        if (this.fCompilationUnit != null && this.fCompilationUnit.getJavaProject().isOnClasspath((IJavaElement)this.fCompilationUnit)) {
            ProblemRequestorState state = new ProblemRequestorState();
            state.fInsideReportingSequence = insideReportingSequence;
            state.fReportedProblems = new ArrayList();
            Object object = this.getLockObject();
            synchronized (object) {
                this.fProblemRequestorState.set(state);
                ++this.fStateCount;
            }
        }
    }

    public void acceptProblem(IProblem problem) {
        ProblemRequestorState state;
        if (this.fIsActive && (state = (ProblemRequestorState)this.fProblemRequestorState.get()) != null) {
            state.fReportedProblems.add(problem);
        }
    }

    public void endReporting() {
        ProblemRequestorState state = (ProblemRequestorState)this.fProblemRequestorState.get();
        if (state != null && !state.fInsideReportingSequence) {
            this.internalEndReporting(state);
        }
    }

    public void endReportingSequence() {
        ProblemRequestorState state = (ProblemRequestorState)this.fProblemRequestorState.get();
        if (state != null && state.fInsideReportingSequence) {
            this.internalEndReporting(state);
        }
    }

    private void internalEndReporting(ProblemRequestorState state) {
        int stateCount = 0;
        Object object = this.getLockObject();
        synchronized (object) {
            --this.fStateCount;
            stateCount = this.fStateCount;
            this.fProblemRequestorState.set(null);
        }
        if (stateCount == 0 && this.fIsActive) {
            this.reportProblems(state.fReportedProblems);
        }
    }

    private void reportProblems(List reportedProblems) {
        if (this.fProgressMonitor != null && this.fProgressMonitor.isCanceled()) {
            return;
        }
        boolean temporaryProblemsChanged = false;
        Object object = this.getLockObject();
        synchronized (object) {
            boolean isCanceled = false;
            this.fPreviouslyOverlaid = this.fCurrentlyOverlaid;
            this.fCurrentlyOverlaid = new ArrayList();
            if (this.fGeneratedAnnotations.size() > 0) {
                temporaryProblemsChanged = true;
                this.removeAnnotations(this.fGeneratedAnnotations, false, true);
                this.fGeneratedAnnotations.clear();
            }
            if (reportedProblems != null && reportedProblems.size() > 0) {
                Iterator e = reportedProblems.iterator();
                while (e.hasNext()) {
                    if (this.fProgressMonitor != null && this.fProgressMonitor.isCanceled()) {
                        isCanceled = true;
                        break;
                    }
                    IProblem problem = (IProblem)e.next();
                    Position position = this.createPositionFromProblem(problem);
                    if (position == null) continue;
                    try {
                        ProblemAnnotation annotation = new ProblemAnnotation(problem, this.fCompilationUnit);
                        this.overlayMarkers(position, annotation);
                        this.addAnnotation(annotation, position, false);
                        this.fGeneratedAnnotations.add(annotation);
                        temporaryProblemsChanged = true;
                    }
                    catch (BadLocationException badLocationException) {
                        BadLocationException badLocationException2 = badLocationException;
                        UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(badLocationException2, (Object)this, ajc$tjp_0, ajc$tjp_1);
                    }
                }
            }
            this.removeMarkerOverlays(isCanceled);
            this.fPreviouslyOverlaid = null;
        }
        if (temporaryProblemsChanged) {
            this.fireModelChanged();
        }
    }

    private void removeMarkerOverlays(boolean isCanceled) {
        if (isCanceled) {
            this.fCurrentlyOverlaid.addAll(this.fPreviouslyOverlaid);
        } else if (this.fPreviouslyOverlaid != null) {
            Iterator e = this.fPreviouslyOverlaid.iterator();
            while (e.hasNext()) {
                JavaMarkerAnnotation annotation = (JavaMarkerAnnotation)e.next();
                annotation.setOverlay(null);
            }
        }
    }

    private void setOverlay(Object value, ProblemAnnotation problemAnnotation) {
        JavaMarkerAnnotation annotation;
        if (value instanceof JavaMarkerAnnotation && (annotation = (JavaMarkerAnnotation)value).isProblem()) {
            annotation.setOverlay((IJavaAnnotation)problemAnnotation);
            this.fPreviouslyOverlaid.remove(annotation);
            this.fCurrentlyOverlaid.add(annotation);
        }
    }

    private void overlayMarkers(Position position, ProblemAnnotation problemAnnotation) {
        Object value = this.getAnnotations(position);
        if (value instanceof List) {
            List list = (List)value;
            Iterator e = list.iterator();
            while (e.hasNext()) {
                this.setOverlay(e.next(), problemAnnotation);
            }
        } else {
            this.setOverlay(value, problemAnnotation);
        }
    }

    private void startCollectingProblems() {
        this.fGeneratedAnnotations = new ArrayList();
    }

    private void stopCollectingProblems() {
        if (this.fGeneratedAnnotations != null) {
            this.removeAnnotations(this.fGeneratedAnnotations, true, true);
        }
        this.fGeneratedAnnotations = null;
    }

    public boolean isActive() {
        return true;
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.fProgressMonitor = monitor;
    }

    public void setIsActive(boolean isActive) {
        if (this.fIsActive != isActive) {
            this.fIsActive = isActive;
            if (this.fIsActive) {
                this.startCollectingProblems();
            } else {
                this.stopCollectingProblems();
            }
        }
    }

    private Object getAnnotations(Position position) {
        Object object = this.getLockObject();
        synchronized (object) {
            return this.fReverseMap.get(position);
        }
    }

    protected void addAnnotation(Annotation annotation, Position position, boolean fireModelChanged) throws BadLocationException {
        super.addAnnotation(annotation, position, fireModelChanged);
        Object object = this.getLockObject();
        synchronized (object) {
            Object cached = this.fReverseMap.get(position);
            if (cached == null) {
                this.fReverseMap.put(position, annotation);
            } else if (cached instanceof List) {
                List list = (List)cached;
                list.add(annotation);
            } else if (cached instanceof Annotation) {
                ArrayList<Object> list = new ArrayList<Object>(2);
                list.add(cached);
                list.add(annotation);
                this.fReverseMap.put(position, list);
            }
        }
    }

    protected void removeAllAnnotations(boolean fireModelChanged) {
        super.removeAllAnnotations(fireModelChanged);
        Object object = this.getLockObject();
        synchronized (object) {
            this.fReverseMap.clear();
        }
    }

    protected void removeAnnotation(Annotation annotation, boolean fireModelChanged) {
        Position position = this.getPosition(annotation);
        Object object = this.getLockObject();
        synchronized (object) {
            Object cached = this.fReverseMap.get(position);
            if (cached instanceof List) {
                List list = (List)cached;
                list.remove(annotation);
                if (list.size() == 1) {
                    this.fReverseMap.put(position, list.get(0));
                    list.clear();
                }
            } else if (cached instanceof Annotation) {
                this.fReverseMap.remove(position);
            }
        }
        super.removeAnnotation(annotation, fireModelChanged);
    }

    static {
        Factory factory = new Factory("AJCompilationUnitAnnotationModel.java", Class.forName("org.eclipse.ajdt.internal.ui.editor.AJCompilationUnitAnnotationModel"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.editor.AJCompilationUnitAnnotationModel-org.eclipse.jface.text.BadLocationException-<missing>-"), 260);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-reportProblems-org.eclipse.ajdt.internal.ui.editor.AJCompilationUnitAnnotationModel-java.util.List:-reportedProblems:--void-"), 221);
    }

    private static class ProblemRequestorState {
        boolean fInsideReportingSequence = false;
        List fReportedProblems;

        ProblemRequestorState() {
        }
    }

    protected static class ReverseMap {
        private List fList = new ArrayList(2);
        private int fAnchor = 0;

        public Object get(Position position) {
            Entry entry;
            int length = this.fList.size();
            int i = this.fAnchor;
            while (i < length) {
                entry = (Entry)this.fList.get(i);
                if (entry.fPosition.equals((Object)position)) {
                    this.fAnchor = i;
                    return entry.fValue;
                }
                ++i;
            }
            i = 0;
            while (i < this.fAnchor) {
                entry = (Entry)this.fList.get(i);
                if (entry.fPosition.equals((Object)position)) {
                    this.fAnchor = i;
                    return entry.fValue;
                }
                ++i;
            }
            return null;
        }

        private int getIndex(Position position) {
            int length = this.fList.size();
            int i = 0;
            while (i < length) {
                Entry entry = (Entry)this.fList.get(i);
                if (entry.fPosition.equals((Object)position)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public void put(Position position, Object value) {
            int index = this.getIndex(position);
            if (index == -1) {
                Entry entry = new Entry();
                entry.fPosition = position;
                entry.fValue = value;
                this.fList.add(entry);
            } else {
                Entry entry = (Entry)this.fList.get(index);
                entry.fValue = value;
            }
        }

        public void remove(Position position) {
            int index = this.getIndex(position);
            if (index > -1) {
                this.fList.remove(index);
            }
        }

        public void clear() {
            this.fList.clear();
        }

        static class Entry {
            Position fPosition;
            Object fValue;

            Entry() {
            }
        }
    }

    protected static class ProblemAnnotation
    extends Annotation
    implements IJavaAnnotation,
    IAnnotationPresentation {
        private static final String SPELLING_ANNOTATION_TYPE = "org.eclipse.ui.workbench.texteditor.spelling";
        private static final int TASK_LAYER;
        private static final int INFO_LAYER;
        private static final int WARNING_LAYER;
        private static final int ERROR_LAYER;
        private static Image fgQuickFixImage;
        private static Image fgQuickFixErrorImage;
        private static boolean fgQuickFixImagesInitialized;
        private ICompilationUnit fCompilationUnit;
        private List fOverlaids;
        private IProblem fProblem;
        private Image fImage;
        private boolean fQuickFixImagesInitialized = false;
        private int fLayer = 0;

        static {
            AnnotationPreferenceLookup lookup = EditorsUI.getAnnotationPreferenceLookup();
            TASK_LAYER = ProblemAnnotation.computeLayer("org.eclipse.ui.workbench.texteditor.task", lookup);
            INFO_LAYER = ProblemAnnotation.computeLayer("org.eclipse.jdt.ui.info", lookup);
            WARNING_LAYER = ProblemAnnotation.computeLayer("org.eclipse.jdt.ui.warning", lookup);
            ERROR_LAYER = ProblemAnnotation.computeLayer("org.eclipse.jdt.ui.error", lookup);
            fgQuickFixImagesInitialized = false;
        }

        private static int computeLayer(String annotationType, AnnotationPreferenceLookup lookup) {
            Annotation annotation = new Annotation(annotationType, false, null);
            AnnotationPreference preference = lookup.getAnnotationPreference(annotation);
            if (preference != null) {
                return preference.getPresentationLayer() + 1;
            }
            return 1;
        }

        public ProblemAnnotation(IProblem problem, ICompilationUnit cu) {
            this.fProblem = problem;
            this.fCompilationUnit = cu;
            if (Integer.MIN_VALUE == this.fProblem.getID()) {
                this.setType(SPELLING_ANNOTATION_TYPE);
                this.fLayer = WARNING_LAYER;
            } else if (536871362 == this.fProblem.getID()) {
                this.setType("org.eclipse.ui.workbench.texteditor.task");
                this.fLayer = TASK_LAYER;
            } else if (this.fProblem.isWarning()) {
                this.setType("org.eclipse.jdt.ui.warning");
                this.fLayer = WARNING_LAYER;
            } else if (this.fProblem.isError()) {
                this.setType("org.eclipse.jdt.ui.error");
                this.fLayer = ERROR_LAYER;
            } else {
                this.setType("org.eclipse.jdt.ui.info");
                this.fLayer = INFO_LAYER;
            }
        }

        public int getLayer() {
            return this.fLayer;
        }

        private void initializeImages() {
            if (!this.fQuickFixImagesInitialized) {
                if (this.isProblem() && this.indicateQuixFixableProblems() && JavaCorrectionProcessor.hasCorrections(this)) {
                    if (!fgQuickFixImagesInitialized) {
                        fgQuickFixImage = JavaPluginImages.get((String)"org.eclipse.jdt.ui.quickfix_warning_obj.gif");
                        fgQuickFixErrorImage = JavaPluginImages.get((String)"org.eclipse.jdt.ui.quickfix_error_obj.gif");
                        fgQuickFixImagesInitialized = true;
                    }
                    this.fImage = "org.eclipse.jdt.ui.error".equals(this.getType()) ? fgQuickFixErrorImage : fgQuickFixImage;
                }
                this.fQuickFixImagesInitialized = true;
            }
        }

        private boolean indicateQuixFixableProblems() {
            return PreferenceConstants.getPreferenceStore().getBoolean("JavaEditor.ShowTemporaryProblem");
        }

        public void paint(GC gc, Canvas canvas, Rectangle r) {
            this.initializeImages();
            if (this.fImage != null) {
                ImageUtilities.drawImage((Image)this.fImage, (GC)gc, (Canvas)canvas, (Rectangle)r, (int)0x1000000, (int)128);
            }
        }

        public Image getImage(Display display) {
            this.initializeImages();
            return this.fImage;
        }

        public String getText() {
            return this.fProblem.getMessage();
        }

        public String[] getArguments() {
            return this.isProblem() ? this.fProblem.getArguments() : null;
        }

        public int getId() {
            return this.fProblem.getID();
        }

        public boolean isProblem() {
            String type = this.getType();
            return "org.eclipse.jdt.ui.warning".equals(type) || "org.eclipse.jdt.ui.error".equals(type) || SPELLING_ANNOTATION_TYPE.equals(type);
        }

        public boolean hasOverlay() {
            return false;
        }

        public IJavaAnnotation getOverlay() {
            return null;
        }

        public void addOverlaid(IJavaAnnotation annotation) {
            if (this.fOverlaids == null) {
                this.fOverlaids = new ArrayList(1);
            }
            this.fOverlaids.add(annotation);
        }

        public void removeOverlaid(IJavaAnnotation annotation) {
            if (this.fOverlaids != null) {
                this.fOverlaids.remove(annotation);
                if (this.fOverlaids.size() == 0) {
                    this.fOverlaids = null;
                }
            }
        }

        public Iterator getOverlaidIterator() {
            if (this.fOverlaids != null) {
                return this.fOverlaids.iterator();
            }
            return null;
        }

        public ICompilationUnit getCompilationUnit() {
            return this.fCompilationUnit;
        }
    }

    public static class GlobalAnnotationModelListener
    implements IAnnotationModelListener,
    IAnnotationModelListenerExtension {
        private ListenerList fListenerList = new ListenerList();

        public void modelChanged(IAnnotationModel model) {
            Object[] listeners = this.fListenerList.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((IAnnotationModelListener)listeners[i]).modelChanged(model);
                ++i;
            }
        }

        public void modelChanged(AnnotationModelEvent event) {
            Object[] listeners = this.fListenerList.getListeners();
            int i = 0;
            while (i < listeners.length) {
                Object curr = listeners[i];
                if (curr instanceof IAnnotationModelListenerExtension) {
                    ((IAnnotationModelListenerExtension)curr).modelChanged(event);
                }
                ++i;
            }
        }

        public void addListener(IAnnotationModelListener listener) {
            this.fListenerList.add((Object)listener);
        }

        public void removeListener(IAnnotationModelListener listener) {
            this.fListenerList.remove((Object)listener);
        }
    }
}

