/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.editor;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.internal.codeconversion.AspectsConvertingParser;
import org.eclipse.ajdt.internal.codeconversion.ConversionOptions;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.formatter.ContextBasedFormattingStrategy;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

public class AJFormattingStrategy
extends ContextBasedFormattingStrategy {
    private final LinkedList fDocuments = new LinkedList();
    private final LinkedList fPartitions = new LinkedList();
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;

    public void format() {
        super.format();
        IDocument document = (IDocument)this.fDocuments.removeFirst();
        TypedPosition partition = (TypedPosition)this.fPartitions.removeFirst();
        if (document != null && partition != null) {
            try {
                String content = document.get();
                AspectsConvertingParser pars = new AspectsConvertingParser(content.toCharArray());
                ArrayList changes = pars.convert(ConversionOptions.CONSTANT_SIZE);
                content = new String(pars.content);
                TextEdit edit = CodeFormatterUtil.format2((int)8, (String)content, (int)partition.getOffset(), (int)partition.getLength(), (int)0, (String)TextUtilities.getDefaultLineDelimiter((IDocument)document), (Map)this.getPreferences());
                if (edit != null) {
                    if (changes.size() > 0) {
                        TextEdit[] edits = edit.getChildren();
                        int i = 0;
                        while (i < edits.length) {
                            TextEdit edit2 = edits[i];
                            boolean conflict = AspectsConvertingParser.conflictsWithAJEdit((int)edit2.getOffset(), (int)edit2.getLength(), (ArrayList)changes);
                            if (conflict) {
                                edit.removeChild(edit2);
                            }
                            ++i;
                        }
                    }
                    edit.apply(document);
                }
            }
            catch (MalformedTreeException malformedTreeException) {
                MalformedTreeException malformedTreeException2 = malformedTreeException;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(malformedTreeException2, (Object)this, ajc$tjp_0, ajc$tjp_1);
                MalformedTreeException exception = malformedTreeException2;
                JavaPlugin.log((Throwable)exception);
            }
            catch (BadLocationException badLocationException) {
                BadLocationException badLocationException2 = badLocationException;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(badLocationException2, (Object)this, ajc$tjp_2, ajc$tjp_1);
                BadLocationException exception = badLocationException2;
                JavaPlugin.log((Throwable)exception);
            }
        }
    }

    public void formatterStarts(IFormattingContext context) {
        super.formatterStarts(context);
        this.fPartitions.addLast(context.getProperty((Object)"formatting.context.partition"));
        this.fDocuments.addLast(context.getProperty((Object)"formatting.context.medium"));
    }

    public void formatterStops() {
        super.formatterStops();
        this.fPartitions.clear();
        this.fDocuments.clear();
    }

    static {
        Factory factory = new Factory("AJFormattingStrategy.java", Class.forName("org.eclipse.ajdt.internal.ui.editor.AJFormattingStrategy"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.editor.AJFormattingStrategy-org.eclipse.text.edits.MalformedTreeException-exception-"), 119);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-format-org.eclipse.ajdt.internal.ui.editor.AJFormattingStrategy----void-"), 56);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.editor.AJFormattingStrategy-org.eclipse.jface.text.BadLocationException-exception-"), 121);
    }
}

