/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.editor.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnit;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnitManager;
import org.eclipse.ajdt.core.javaelements.AspectElement;
import org.eclipse.ajdt.internal.builder.BuilderUtils;
import org.eclipse.ajdt.internal.ui.dialogs.AJCUTypeInfo;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.SourceRange;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationMessages;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportReferencesCollector;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportsStructure;
import org.eclipse.jdt.internal.corext.codemanipulation.OrganizeImportsOperation;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.util.AllTypesCache;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jface.text.Region;

public class AJOrganizeImportsOperation
implements IWorkspaceRunnable {
    private Region fRange;
    private ImportsStructure fImportsStructure;
    private boolean fDoSave;
    private boolean fIgnoreLowerCaseNames;
    private OrganizeImportsOperation.IChooseImportQuery fChooseImportQuery;
    private int fNumberOfImportsAdded;
    private IProblem fParsingError;
    private CompilationUnit fASTRoot;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;

    private static List getAspectJTypes(IJavaSearchScope scope) {
        ArrayList<AJCUTypeInfo> ajTypes = new ArrayList<AJCUTypeInfo>();
        IProject[] projects = AspectJPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            try {
                IJavaProject jp;
                if (projects[i].hasNature("org.eclipse.ajdt.ui.ajnature") && (jp = JavaCore.create((IProject)projects[i])) != null) {
                    IPath[] paths = scope.enclosingProjectsAndJars();
                    int a = 0;
                    while (a < paths.length) {
                        if (paths[a].equals((Object)jp.getPath())) {
                            List ajCus = AJCompilationUnitManager.INSTANCE.getAJCompilationUnits(jp);
                            Iterator iter = ajCus.iterator();
                            while (iter.hasNext()) {
                                AJCompilationUnit unit = (AJCompilationUnit)iter.next();
                                IType[] types = unit.getAllTypes();
                                int j = 0;
                                while (j < types.length) {
                                    if (types[j] instanceof AspectElement) {
                                        char[][] enclosingTypes = BuilderUtils.getEnclosingTypes(types[j]);
                                        AJCUTypeInfo info = new AJCUTypeInfo(types[j].getPackageFragment().getElementName(), types[j].getElementName(), enclosingTypes, types[j].isInterface(), types[j] instanceof AspectElement, jp.getElementName(), unit.getPackageFragmentRoot().getElementName(), unit.getElementName().substring(0, unit.getElementName().lastIndexOf(46)), "aj", (IJavaElement)unit);
                                        ajTypes.add(info);
                                    }
                                    ++j;
                                }
                            }
                        }
                        ++a;
                    }
                }
            }
            catch (JavaModelException javaModelException) {
                JavaModelException javaModelException2 = javaModelException;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(javaModelException2, ajc$tjp_0, ajc$tjp_1);
            }
            catch (CoreException coreException) {
                CoreException coreException2 = coreException;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(coreException2, ajc$tjp_2, ajc$tjp_1);
            }
            ++i;
        }
        return ajTypes;
    }

    public AJOrganizeImportsOperation(ImportsStructure impStructure, Region range, boolean ignoreLowerCaseNames, boolean save, OrganizeImportsOperation.IChooseImportQuery chooseImportQuery) {
        this.fImportsStructure = impStructure;
        this.fRange = range;
        this.fDoSave = save;
        this.fIgnoreLowerCaseNames = ignoreLowerCaseNames;
        this.fChooseImportQuery = chooseImportQuery;
        this.fNumberOfImportsAdded = 0;
        this.fParsingError = null;
        ASTParser parser = ASTParser.newParser((int)2);
        parser.setSource(impStructure.getCompilationUnit());
        parser.setResolveBindings(true);
        this.fASTRoot = (CompilationUnit)parser.createAST(null);
    }

    public AJOrganizeImportsOperation(ICompilationUnit cu, String[] importOrder, int importThreshold, boolean ignoreLowerCaseNames, boolean save, boolean doResolve, OrganizeImportsOperation.IChooseImportQuery chooseImportQuery) throws CoreException {
        this(new ImportsStructure(cu, importOrder, importThreshold, false), null, ignoreLowerCaseNames, save, chooseImportQuery);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        block13: {
            block12: {
                try {
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    ICompilationUnit cu = this.fImportsStructure.getCompilationUnit();
                    this.fNumberOfImportsAdded = 0;
                    monitor.beginTask(CodeGenerationMessages.getFormattedString((String)"OrganizeImportsOperation.description", (Object)cu.getElementName()), 4);
                    ArrayList oldSingleImports = new ArrayList();
                    ArrayList<String> oldDemandImports = new ArrayList<String>();
                    Collection references = this.findTypeReferences(oldSingleImports, oldDemandImports);
                    if (references == null) {
                        Object var16_6 = null;
                        break block12;
                    }
                    int nOldImports = oldDemandImports.size() + oldSingleImports.size();
                    oldDemandImports.add("");
                    oldDemandImports.add("java.lang");
                    oldDemandImports.add(cu.getParent().getElementName());
                    monitor.worked(1);
                    TypeReferenceProcessor processor = new TypeReferenceProcessor(oldSingleImports, oldDemandImports, this.fASTRoot, this.fImportsStructure, this.fIgnoreLowerCaseNames);
                    ArrayList<TypeInfo[]> openChoices = new ArrayList<TypeInfo[]>();
                    ArrayList<SourceRange> sourceRanges = new ArrayList<SourceRange>();
                    SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 2);
                    try {
                        subMonitor.beginTask("", references.size());
                        Iterator refIterator = references.iterator();
                        while (refIterator.hasNext()) {
                            SimpleName typeRef = (SimpleName)refIterator.next();
                            TypeInfo[] openChoice = processor.process(typeRef, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, 1));
                            if (openChoice == null) continue;
                            openChoices.add(openChoice);
                            sourceRanges.add(new SourceRange(typeRef.getStartPosition(), typeRef.getLength()));
                        }
                    }
                    catch (Throwable throwable) {
                        Object var14_19 = null;
                        subMonitor.done();
                        throw throwable;
                    }
                    {
                        Object var14_20 = null;
                    }
                    subMonitor.done();
                    processor = null;
                    if (openChoices.size() > 0 && this.fChooseImportQuery != null) {
                        ISourceRange[] ranges;
                        TypeInfo[][] choices = (TypeInfo[][])openChoices.toArray((T[])new TypeInfo[openChoices.size()][]);
                        TypeInfo[] chosen = this.fChooseImportQuery.chooseImports(choices, ranges = sourceRanges.toArray(new ISourceRange[sourceRanges.size()]));
                        if (chosen == null) {
                            throw new OperationCanceledException();
                        }
                        int i = 0;
                        while (i < chosen.length) {
                            TypeInfo typeInfo = chosen[i];
                            this.fImportsStructure.addImport(typeInfo.getFullyQualifiedName());
                            ++i;
                        }
                    }
                    this.fImportsStructure.create(this.fDoSave, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    this.fNumberOfImportsAdded = this.fImportsStructure.getNumberOfImportsCreated() - nOldImports;
                    break block13;
                }
                catch (Throwable throwable) {
                    Object var16_7 = null;
                    monitor.done();
                    throw throwable;
                }
            }
            monitor.done();
            return;
        }
        Object var16_8 = null;
        monitor.done();
    }

    private boolean isAffected(IProblem problem) {
        return this.fRange == null || this.fRange.getOffset() <= problem.getSourceEnd() && this.fRange.getOffset() + this.fRange.getLength() > problem.getSourceStart();
    }

    private Collection findTypeReferences(ArrayList oldSingleImports, ArrayList oldDemandImports) {
        IProblem[] problems = this.fASTRoot.getProblems();
        int i = 0;
        while (i < problems.length) {
            IProblem curr = problems[i];
            if (curr.isError() && (curr.getID() & 0x40000000) != 0 && this.isAffected(curr)) {
                this.fParsingError = problems[i];
                return null;
            }
            ++i;
        }
        List imports = this.fASTRoot.imports();
        int i2 = 0;
        while (i2 < imports.size()) {
            ImportDeclaration curr = (ImportDeclaration)imports.get(i2);
            String id = ASTResolving.getFullName((Name)curr.getName());
            if (curr.isOnDemand()) {
                oldDemandImports.add(id);
            } else {
                oldSingleImports.add(id);
            }
            ++i2;
        }
        ArrayList result = new ArrayList();
        ImportReferencesCollector visitor = new ImportReferencesCollector(this.fRange, result);
        this.fASTRoot.accept((ASTVisitor)visitor);
        return result;
    }

    public IProblem getParseError() {
        return this.fParsingError;
    }

    public int getNumberOfImportsAdded() {
        return this.fNumberOfImportsAdded;
    }

    public ISchedulingRule getScheduleRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    static {
        Factory factory = new Factory("AJOrganizeImportsOperation.java", Class.forName("org.eclipse.ajdt.internal.ui.editor.actions.AJOrganizeImportsOperation"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.editor.actions.AJOrganizeImportsOperation-org.eclipse.jdt.core.JavaModelException-<missing>-"), 306);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-getAspectJTypes-org.eclipse.ajdt.internal.ui.editor.actions.AJOrganizeImportsOperation-org.eclipse.jdt.core.search.IJavaSearchScope:-scope:--java.util.List-"), 267);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.editor.actions.AJOrganizeImportsOperation-org.eclipse.core.runtime.CoreException-<missing>-"), 307);
    }

    private static class TypeReferenceProcessor {
        private ArrayList fOldSingleImports;
        private ArrayList fOldDemandImports;
        private HashSet fImportsAdded;
        private ImportsStructure fImpStructure;
        private ArrayList fTypeRefsFound;
        private boolean fDoIgnoreLowerCaseNames;
        private IJavaSearchScope fSearchScope;
        private IPackageFragment fCurrPackage;
        private ScopeAnalyzer fAnalyzer;

        public TypeReferenceProcessor(ArrayList oldSingleImports, ArrayList oldDemandImports, CompilationUnit root, ImportsStructure impStructure, boolean ignoreLowerCaseNames) {
            this.fOldSingleImports = oldSingleImports;
            this.fOldDemandImports = oldDemandImports;
            this.fImpStructure = impStructure;
            this.fDoIgnoreLowerCaseNames = ignoreLowerCaseNames;
            this.fAnalyzer = new ScopeAnalyzer(root);
            ICompilationUnit cu = this.fImpStructure.getCompilationUnit();
            this.fSearchScope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{cu.getJavaProject()});
            this.fCurrPackage = (IPackageFragment)cu.getParent();
            this.fTypeRefsFound = new ArrayList();
            this.fImportsAdded = new HashSet();
        }

        private boolean needsImport(ITypeBinding typeBinding, SimpleName ref) {
            if (!typeBinding.isTopLevel() && !typeBinding.isMember()) {
                return false;
            }
            int modifiers = typeBinding.getModifiers();
            if (Modifier.isPrivate((int)modifiers)) {
                return false;
            }
            ITypeBinding currTypeBinding = Bindings.getBindingOfParentType((ASTNode)ref);
            if (currTypeBinding == null) {
                return false;
            }
            if (!Modifier.isPublic((int)modifiers) && !currTypeBinding.getPackage().getName().equals(typeBinding.getPackage().getName())) {
                return false;
            }
            ASTNode parent = ref.getParent();
            if (parent instanceof Type) {
                parent = parent.getParent();
            }
            if (parent instanceof TypeDeclaration && parent.getParent() instanceof CompilationUnit) {
                return true;
            }
            if (typeBinding.isMember()) {
                IBinding[] visibleTypes = this.fAnalyzer.getDeclarationsInScope(ref, 4);
                int i = 0;
                while (i < visibleTypes.length) {
                    if (visibleTypes[i] == typeBinding) {
                        return false;
                    }
                    ++i;
                }
            }
            return true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public TypeInfo[] process(SimpleName ref, IProgressMonitor monitor) throws CoreException {
            block18: {
                TypeInfo[] typeInfoArray;
                block20: {
                    TypeInfo[] typeInfoArray2;
                    block19: {
                        TypeInfo[] typeInfoArray3;
                        block17: {
                            TypeInfo[] typeInfoArray4;
                            block16: {
                                String typeName = ref.getIdentifier();
                                if (this.fImportsAdded.contains(typeName)) {
                                    return null;
                                }
                                try {
                                    IBinding binding = ref.resolveBinding();
                                    if (binding != null) {
                                        if (binding.getKind() == 2) {
                                            ITypeBinding typeBinding = (ITypeBinding)binding;
                                            if (typeBinding.isArray()) {
                                                typeBinding = typeBinding.getElementType();
                                            }
                                            if (this.needsImport(typeBinding, ref)) {
                                                this.fImpStructure.addImport(typeBinding);
                                                this.fImportsAdded.add(typeName);
                                            }
                                        }
                                        TypeInfo[] typeInfoArray5 = null;
                                        Object var13_12 = null;
                                        this.fTypeRefsFound.clear();
                                        return typeInfoArray5;
                                    }
                                    this.fImportsAdded.add(typeName);
                                    ArrayList typeRefsFound = this.fTypeRefsFound;
                                    this.findTypeRefs(typeName, typeRefsFound, monitor);
                                    int nFound = typeRefsFound.size();
                                    if (nFound == 0) {
                                        typeInfoArray4 = null;
                                        break block16;
                                    }
                                    if (nFound == 1) {
                                        TypeInfo typeRef = (TypeInfo)typeRefsFound.get(0);
                                        this.fImpStructure.addImport(typeRef.getFullyQualifiedName());
                                        typeInfoArray3 = null;
                                        break block17;
                                    }
                                    String containerToImport = null;
                                    boolean ambiguousImports = false;
                                    int i = 0;
                                    while (true) {
                                        if (i >= nFound) {
                                            if (containerToImport == null || ambiguousImports) break;
                                            this.fImpStructure.addImport(containerToImport, typeName);
                                            break block18;
                                        }
                                        TypeInfo typeRef = (TypeInfo)typeRefsFound.get(i);
                                        String fullName = typeRef.getFullyQualifiedName();
                                        String containerName = typeRef.getTypeContainerName();
                                        if (this.fOldSingleImports.contains(fullName)) {
                                            this.fImpStructure.addImport(fullName);
                                            typeInfoArray2 = null;
                                            break block19;
                                        }
                                        if (this.fOldDemandImports.contains(containerName)) {
                                            if (containerToImport == null) {
                                                containerToImport = containerName;
                                            } else {
                                                ambiguousImports = true;
                                            }
                                        }
                                        ++i;
                                    }
                                    typeInfoArray = typeRefsFound.toArray(new TypeInfo[nFound]);
                                    break block20;
                                }
                                catch (Throwable throwable) {
                                    Object var13_17 = null;
                                    this.fTypeRefsFound.clear();
                                    throw throwable;
                                }
                            }
                            Object var13_13 = null;
                            this.fTypeRefsFound.clear();
                            return typeInfoArray4;
                        }
                        Object var13_14 = null;
                        this.fTypeRefsFound.clear();
                        return typeInfoArray3;
                    }
                    Object var13_15 = null;
                    this.fTypeRefsFound.clear();
                    return typeInfoArray2;
                }
                Object var13_16 = null;
                this.fTypeRefsFound.clear();
                return typeInfoArray;
            }
            Object var13_18 = null;
            this.fTypeRefsFound.clear();
            return null;
        }

        private void findTypeRefs(String simpleTypeName, Collection typeRefsFound, IProgressMonitor monitor) throws JavaModelException {
            char ch;
            if (this.fDoIgnoreLowerCaseNames && simpleTypeName.length() > 0 && Strings.isLowerCase((char)(ch = simpleTypeName.charAt(0))) && Character.isLetter(ch)) {
                return;
            }
            TypeInfo[] infos = AllTypesCache.getTypesForName((String)simpleTypeName, (IJavaSearchScope)this.fSearchScope, (IProgressMonitor)monitor);
            int i = 0;
            while (i < infos.length) {
                TypeInfo curr = infos[i];
                IType type = curr.resolveType(this.fSearchScope);
                if (type != null && JavaModelUtil.isVisible((IMember)type, (IPackageFragment)this.fCurrPackage)) {
                    typeRefsFound.add(curr);
                }
                ++i;
            }
            IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{this.fImpStructure.getCompilationUnit().getJavaProject()}, (int)11);
            List ajTypes = AJOrganizeImportsOperation.getAspectJTypes(scope);
            Iterator iter = ajTypes.iterator();
            while (iter.hasNext()) {
                IType type;
                AJCUTypeInfo curr = (AJCUTypeInfo)((Object)iter.next());
                if (!curr.getTypeName().equals(simpleTypeName) || (type = curr.resolveType(this.fSearchScope)) == null || !JavaModelUtil.isVisible((IMember)type, (IPackageFragment)this.fCurrPackage)) continue;
                typeRefsFound.add(curr);
            }
        }
    }
}

