/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.wizards.migration;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.internal.ui.wizards.migration.BuilderMigrationPage;
import org.eclipse.ajdt.internal.ui.wizards.migration.CrossCuttingViewMigrationPage;
import org.eclipse.ajdt.internal.ui.wizards.migration.IntroMigrationPage;
import org.eclipse.ajdt.internal.ui.wizards.migration.PluginDependencyMigrationPage;
import org.eclipse.ajdt.internal.ui.wizards.migration.RenameFileExtensionsPage;
import org.eclipse.ajdt.internal.ui.wizards.migration.WorkbenchSettingsMigrationPage;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.util.ExceptionHandler;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class AJDTMigrationWizard
extends Wizard {
    private IntroMigrationPage introPage;
    private RenameFileExtensionsPage fileExtensionsPage;
    private BuilderMigrationPage builderMigrationPage;
    private PluginDependencyMigrationPage pluginDependencyPage;
    private WorkbenchSettingsMigrationPage workbenchSettingsPage;
    private CrossCuttingViewMigrationPage crossCuttingViewPage;
    private List ajProjects = new ArrayList();
    private List ajPluginProjects = new ArrayList();
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;

    public void addPages() {
        this.setNeedsProgressMonitor(true);
        this.findAJProjectsInCurrentWorkspace();
        this.introPage = new IntroMigrationPage();
        this.fileExtensionsPage = new RenameFileExtensionsPage(this.ajProjects);
        this.builderMigrationPage = new BuilderMigrationPage(this.ajProjects);
        this.pluginDependencyPage = new PluginDependencyMigrationPage(this.ajPluginProjects);
        this.workbenchSettingsPage = new WorkbenchSettingsMigrationPage();
        this.crossCuttingViewPage = new CrossCuttingViewMigrationPage();
        this.addPage((IWizardPage)this.introPage);
        this.addPage((IWizardPage)this.fileExtensionsPage);
        this.addPage((IWizardPage)this.builderMigrationPage);
        this.addPage((IWizardPage)this.pluginDependencyPage);
        this.addPage((IWizardPage)this.workbenchSettingsPage);
        this.addPage((IWizardPage)this.crossCuttingViewPage);
    }

    public void init() {
        this.setWindowTitle(AspectJUIPlugin.getResourceString("AJDTMigrationWizard.title"));
    }

    public boolean performFinish() {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                int total = 27 * AJDTMigrationWizard.this.ajProjects.size() + 2 * AJDTMigrationWizard.this.ajPluginProjects.size();
                monitor.setTaskName(AspectJUIPlugin.getResourceString("MigratingSettings"));
                monitor.beginTask("", total);
                monitor.subTask(AspectJUIPlugin.getResourceString("MigratingBuilderDependencies"));
                AJDTMigrationWizard.this.builderMigrationPage.finishPressed(monitor);
                if (monitor.isCanceled()) {
                    return;
                }
                monitor.subTask(AspectJUIPlugin.getResourceString("MigratingPluginDependencies"));
                AJDTMigrationWizard.this.pluginDependencyPage.finishPressed(monitor);
                if (monitor.isCanceled()) {
                    return;
                }
                monitor.subTask(AspectJUIPlugin.getResourceString("MigratingWorkbenchSettings"));
                AJDTMigrationWizard.this.workbenchSettingsPage.finishPressed(AJDTMigrationWizard.this.ajProjects, monitor);
                if (monitor.isCanceled()) {
                    return;
                }
                monitor.subTask(AspectJUIPlugin.getResourceString("MigratingFileExtensions"));
                AJDTMigrationWizard.this.fileExtensionsPage.finishPressed(monitor);
                monitor.done();
                AJDTMigrationWizard.this.crossCuttingViewPage.finishPressed();
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IRunnableWithProgress)op, (ISchedulingRule)AspectJPlugin.getWorkspace().getRoot());
        }
        catch (InvocationTargetException invocationTargetException) {
            InvocationTargetException invocationTargetException2 = invocationTargetException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(invocationTargetException2, (Object)this, ajc$tjp_0, ajc$tjp_1);
        }
        catch (InterruptedException interruptedException) {
            InterruptedException interruptedException2 = interruptedException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(interruptedException2, (Object)this, ajc$tjp_2, ajc$tjp_1);
        }
        return true;
    }

    private void findAJProjectsInCurrentWorkspace() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            if (AspectJPlugin.isAJProject((IProject)project)) {
                this.ajProjects.add(project);
                try {
                    if (project.hasNature("org.eclipse.pde.PluginNature")) {
                        this.ajPluginProjects.add(project);
                    }
                }
                catch (CoreException coreException) {
                    CoreException coreException2 = coreException;
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, (Object)this, ajc$tjp_3, ajc$tjp_4);
                }
            }
            ++i;
        }
    }

    static void setAutoBuilding(boolean state) {
        IWorkspaceDescription workspaceDesc = AspectJPlugin.getWorkspace().getDescription();
        workspaceDesc.setAutoBuilding(state);
        try {
            AspectJPlugin.getWorkspace().setDescription(workspaceDesc);
        }
        catch (CoreException coreException) {
            CoreException coreException2 = coreException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(coreException2, ajc$tjp_5, ajc$tjp_6);
            CoreException ex = coreException2;
            ExceptionHandler.handle((CoreException)ex, (String)SearchMessages.getString((String)"Search.Error.setDescription.title"), (String)SearchMessages.getString((String)"Search.Error.setDescription.message"));
        }
    }

    static {
        Factory factory = new Factory("AJDTMigrationWizard.java", Class.forName("org.eclipse.ajdt.internal.ui.wizards.migration.AJDTMigrationWizard"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.wizards.migration.AJDTMigrationWizard-java.lang.reflect.InvocationTargetException-<missing>-"), 124);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-performFinish-org.eclipse.ajdt.internal.ui.wizards.migration.AJDTMigrationWizard----boolean-"), 82);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.wizards.migration.AJDTMigrationWizard-java.lang.InterruptedException-<missing>-"), 125);
        ajc$tjp_3 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.wizards.migration.AJDTMigrationWizard-org.eclipse.core.runtime.CoreException-<missing>-"), 140);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-findAJProjectsInCurrentWorkspace-org.eclipse.ajdt.internal.ui.wizards.migration.AJDTMigrationWizard----void-"), 131);
        ajc$tjp_5 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.wizards.migration.AJDTMigrationWizard-org.eclipse.core.runtime.CoreException-ex-"), 152);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("8-setAutoBuilding-org.eclipse.ajdt.internal.ui.wizards.migration.AJDTMigrationWizard-boolean:-state:--void-"), 147);
    }
}

