/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.wizards.migration;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.internal.core.AJLog;
import org.eclipse.ajdt.internal.ui.AspectJProjectNature;
import org.eclipse.ajdt.internal.ui.wizards.migration.AJProjectListLabelProvider;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class BuilderMigrationPage
extends WizardPage {
    private CheckedListDialogField checkedListDialogField;
    private List ajProjects;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;

    private BuilderMigrationPage() {
        super(AspectJUIPlugin.getResourceString("BuilderMigrationPage.name"));
        this.setTitle(AspectJUIPlugin.getResourceString("BuilderMigrationPage.title"));
        this.setDescription(AspectJUIPlugin.getResourceString("BuilderMigrationPage.description"));
    }

    protected BuilderMigrationPage(List projects) {
        this();
        this.ajProjects = projects;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.setControl((Control)composite);
        String[] buttonLabels = new String[]{NewWizardMessages.getString((String)"ProjectsWorkbookPage.projects.checkall.button"), NewWizardMessages.getString((String)"ProjectsWorkbookPage.projects.uncheckall.button")};
        this.checkedListDialogField = new CheckedListDialogField(null, buttonLabels, (ILabelProvider)new AJProjectListLabelProvider());
        this.checkedListDialogField.setLabelText(AspectJUIPlugin.getResourceString("BuilderMigrationPage.message"));
        this.checkedListDialogField.setCheckAllButtonIndex(0);
        this.checkedListDialogField.setUncheckAllButtonIndex(1);
        this.checkedListDialogField.setElements((Collection)this.ajProjects);
        this.checkedListDialogField.setCheckedElements((Collection)this.ajProjects);
        this.checkedListDialogField.setViewerSorter(new ViewerSorter());
        LayoutUtil.doDefaultLayout((Composite)composite, (DialogField[])new DialogField[]{this.checkedListDialogField}, (boolean)true, (int)-1, (int)-1);
        LayoutUtil.setHorizontalGrabbing((Control)this.checkedListDialogField.getListControl(null));
        PixelConverter converter = new PixelConverter((Control)parent);
        int buttonBarWidth = converter.convertWidthInCharsToPixels(24);
        this.checkedListDialogField.setButtonsMinWidth(buttonBarWidth);
    }

    public void finishPressed(IProgressMonitor monitor) {
        this.clearMarkers(this.ajProjects);
        this.updateBuilder(this.ajProjects, this.checkedListDialogField.getCheckedElements(), monitor);
    }

    private void clearMarkers(List ajProjects) {
        Iterator iter = ajProjects.iterator();
        while (iter.hasNext()) {
            IProject project = (IProject)iter.next();
            try {
                project.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            }
            catch (CoreException coreException) {
                CoreException coreException2 = coreException;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, (Object)this, ajc$tjp_0, ajc$tjp_1);
            }
        }
    }

    private void updateBuilder(List ajProjects, List projectsToRemoveBuilderFrom, IProgressMonitor monitor) {
        IProject project;
        Iterator iter = ajProjects.iterator();
        while (iter.hasNext()) {
            project = (IProject)iter.next();
            try {
                AspectJProjectNature.addNewBuilder(project);
                if (!AspectJProjectNature.hasNewBuilder(project)) {
                    AJLog.log((String)"AJDT migration builder: addition of new builder failed!");
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            MessageDialog.openError(null, (String)AspectJUIPlugin.getResourceString("Builder.migration.failed.title"), (String)AspectJUIPlugin.getFormattedResourceString("Builder.migration.failed.message", project.getName()));
                        }
                    });
                }
            }
            catch (CoreException coreException) {
                CoreException coreException2 = coreException;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, (Object)this, ajc$tjp_2, ajc$tjp_3);
            }
            monitor.worked(1);
        }
        iter = projectsToRemoveBuilderFrom.iterator();
        while (iter.hasNext()) {
            project = (IProject)iter.next();
            try {
                AspectJProjectNature.removeOldBuilder(project);
            }
            catch (CoreException coreException) {
                CoreException coreException3 = coreException;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException3, (Object)this, ajc$tjp_4, ajc$tjp_3);
            }
            monitor.worked(1);
        }
        monitor.worked(ajProjects.size() - projectsToRemoveBuilderFrom.size());
    }

    static {
        Factory factory = new Factory("BuilderMigrationPage.java", Class.forName("org.eclipse.ajdt.internal.ui.wizards.migration.BuilderMigrationPage"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.wizards.migration.BuilderMigrationPage-org.eclipse.core.runtime.CoreException-<missing>-"), 104);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-clearMarkers-org.eclipse.ajdt.internal.ui.wizards.migration.BuilderMigrationPage-java.util.List:-ajProjects:--void-"), 99);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.wizards.migration.BuilderMigrationPage-org.eclipse.core.runtime.CoreException-<missing>-"), 133);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-updateBuilder-org.eclipse.ajdt.internal.ui.wizards.migration.BuilderMigrationPage-java.util.List:java.util.List:org.eclipse.core.runtime.IProgressMonitor:-ajProjects:projectsToRemoveBuilderFrom:monitor:--void-"), 112);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.wizards.migration.BuilderMigrationPage-org.eclipse.core.runtime.CoreException-<missing>-"), 144);
    }
}

