/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.pde.internal.ui.editor;

import org.eclipse.ajdt.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.ajdt.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.ajdt.pde.internal.ui.editor.SourceOutlinePage;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.pde.internal.ui.editor.text.IReconcilingParticipant;
import org.eclipse.pde.internal.ui.editor.text.ReconcilingStrategy;
import org.eclipse.pde.internal.ui.model.IDocumentKey;

public abstract class KeyValueSourcePage
extends PDESourcePage {
    public KeyValueSourcePage(PDEFormEditor editor, String id, String title) {
        super(editor, id, title);
        this.setSourceViewerConfiguration(new KeyValueSourceViewerConfiguration());
    }

    protected ViewerSorter createViewerSorter() {
        return new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                IDocumentKey key1 = (IDocumentKey)e1;
                IDocumentKey key2 = (IDocumentKey)e2;
                return key1.getOffset() < key2.getOffset() ? -1 : 1;
            }
        };
    }

    protected void outlineSelectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object first = structuredSelection.getFirstElement();
            if (first instanceof IDocumentKey) {
                this.setHighlightRange((IDocumentKey)first);
            } else {
                this.resetHighlightRange();
            }
        }
    }

    public void setHighlightRange(IDocumentKey key) {
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer == null) {
            return;
        }
        IDocument document = sourceViewer.getDocument();
        if (document == null) {
            return;
        }
        int offset = key.getOffset();
        int length = key.getLength();
        this.setHighlightRange(offset, length, true);
        sourceViewer.setSelectedRange(offset, key.getName().length());
    }

    class KeyValueSourceViewerConfiguration
    extends SourceViewerConfiguration {
        KeyValueSourceViewerConfiguration() {
        }

        public IReconciler getReconciler(ISourceViewer sourceViewer) {
            ReconcilingStrategy strategy = new ReconcilingStrategy();
            strategy.addParticipant((IReconcilingParticipant)KeyValueSourcePage.this.getInputContext().getModel());
            strategy.addParticipant((IReconcilingParticipant)((SourceOutlinePage)KeyValueSourcePage.this.getContentOutline()));
            MonoReconciler reconciler = new MonoReconciler((IReconcilingStrategy)strategy, false);
            reconciler.setDelay(500);
            return reconciler;
        }
    }
}

