/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.ui.refactoring;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.buildconfigurator.BuildConfiguration;
import org.eclipse.ajdt.buildconfigurator.BuildConfigurator;
import org.eclipse.ajdt.buildconfigurator.ProjectBuildConfigurator;
import org.eclipse.ajdt.internal.codeconversion.CodeChecker;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.ajdt.ui.refactoring.RenamingUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

public class RenameFileExtensionsDialog
extends Dialog {
    private IProject project;
    private Button convertAllToJavaButton;
    private Button convertAllToAJButton;
    private Button convertAspectsToAJButton;
    private Button includeFilesNotInBuildButton;
    private Button updateBuildConfigsButton;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;

    public RenameFileExtensionsDialog(Shell parentShell, IProject project) {
        super(parentShell);
        this.project = project;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(AspectJUIPlugin.getResourceString("Refactoring.ConvertFileExtensions"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.convertAspectsToAJButton = new Button(composite, 16);
        this.convertAspectsToAJButton.setText(AspectJUIPlugin.getResourceString("Refactoring.ConvertAspectsToAJAndClassesToJava"));
        this.convertAspectsToAJButton.setSelection(true);
        this.convertAllToAJButton = new Button(composite, 16);
        this.convertAllToAJButton.setText(AspectJUIPlugin.getResourceString("Refactoring.ConvertAllToAJ"));
        this.convertAllToJavaButton = new Button(composite, 16);
        this.convertAllToJavaButton.setText(AspectJUIPlugin.getResourceString("Refactoring.ConvertAllToJava"));
        new Label(composite, 0);
        this.includeFilesNotInBuildButton = new Button(composite, 32);
        this.includeFilesNotInBuildButton.setText(AspectJUIPlugin.getResourceString("Refactoring.IncludeFilesNotInBuild"));
        this.includeFilesNotInBuildButton.setSelection(true);
        this.updateBuildConfigsButton = new Button(composite, 32);
        this.updateBuildConfigsButton.setText(AspectJUIPlugin.getResourceString("Refactoring.UpdateBuildConfigs"));
        this.updateBuildConfigsButton.setSelection(true);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void okPressed() {
        boolean updateBuildConfigs = this.updateBuildConfigsButton.getSelection();
        AspectJUIPlugin.getDefault().disableBuildConfiguratorResourceChangeListener();
        if (this.convertAllToAJButton.getSelection()) {
            this.convertAllExtensions(true, this.includeFilesNotInBuildButton.getSelection(), updateBuildConfigs);
        } else if (this.convertAllToJavaButton.getSelection()) {
            this.convertAllExtensions(false, this.includeFilesNotInBuildButton.getSelection(), updateBuildConfigs);
        } else if (this.convertAspectsToAJButton.getSelection()) {
            this.convertAspectsToAJAndOthersToJava(this.includeFilesNotInBuildButton.getSelection(), updateBuildConfigs);
        }
        super.okPressed();
        AspectJUIPlugin.getDefault().enableBuildConfiguratorResourceChangeListener();
    }

    private void convertAspectsToAJAndOthersToJava(final boolean includeNonBuiltFiles, final boolean updateBuildConfigs) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){
            private static final JoinPoint.StaticPart ajc$tjp_0;
            private static final JoinPoint.StaticPart ajc$tjp_1;
            private static final JoinPoint.StaticPart ajc$tjp_2;

            public void run(IProgressMonitor monitor) {
                IJavaProject jp = JavaCore.create((IProject)RenameFileExtensionsDialog.this.project);
                ProjectBuildConfigurator pbc = BuildConfigurator.getBuildConfigurator().getProjectBuildConfigurator(jp);
                BuildConfiguration activeBuildConfig = pbc.getActiveBuildConfiguration();
                int numBuildConfigs = pbc.getBuildConfigurations().size();
                try {
                    IPackageFragment[] packages = jp.getPackageFragments();
                    monitor.beginTask(AspectJUIPlugin.getResourceString("Refactoring.ConvertingFileExtensions"), packages.length + 10 * numBuildConfigs);
                    HashMap oldToNewNames = new HashMap();
                    int i = 0;
                    while (i < packages.length) {
                        if (!packages[i].isReadOnly()) {
                            try {
                                ICompilationUnit[] files = packages[i].getCompilationUnits();
                                int j = 0;
                                while (j < files.length) {
                                    IResource resource = files[j].getResource();
                                    if (includeNonBuiltFiles || activeBuildConfig.isIncluded(resource)) {
                                        boolean isAspect = CodeChecker.containsAspectJConstructs((IFile)((IFile)resource));
                                        if (!isAspect && resource.getFileExtension().equals("aj")) {
                                            RenamingUtils.renameFile(false, resource, monitor, oldToNewNames);
                                        } else if (isAspect && resource.getFileExtension().equals("java")) {
                                            RenamingUtils.renameFile(true, resource, monitor, oldToNewNames);
                                        }
                                    }
                                    ++j;
                                }
                            }
                            catch (JavaModelException javaModelException) {
                                JavaModelException javaModelException2 = javaModelException;
                                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException2, this, ajc$tjp_0, ajc$tjp_1);
                            }
                        }
                        monitor.worked(1);
                        ++i;
                    }
                    if (updateBuildConfigs) {
                        RenamingUtils.updateBuildConfigurations(oldToNewNames, RenameFileExtensionsDialog.this.project, monitor, true);
                    }
                }
                catch (JavaModelException javaModelException) {
                    JavaModelException javaModelException3 = javaModelException;
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException3, this, ajc$tjp_2, ajc$tjp_1);
                }
            }

            static {
                Factory factory = new Factory("RenameFileExtensionsDialog.java", Class.forName("org.eclipse.ajdt.ui.refactoring.RenameFileExtensionsDialog$1"));
                ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.ui.refactoring.RenameFileExtensionsDialog$1-org.eclipse.jdt.core.JavaModelException-<missing>-"), 199);
                ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-run-org.eclipse.ajdt.ui.refactoring.RenameFileExtensionsDialog$1-org.eclipse.core.runtime.IProgressMonitor:-monitor:--void-"), 153);
                ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.ui.refactoring.RenameFileExtensionsDialog$1-org.eclipse.jdt.core.JavaModelException-<missing>-"), 208);
            }
        };
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(runnable);
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException invocationTargetException) {
            InvocationTargetException invocationTargetException2 = invocationTargetException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(invocationTargetException2, (Object)this, ajc$tjp_0, ajc$tjp_1);
        }
        catch (InterruptedException interruptedException) {
            InterruptedException interruptedException2 = interruptedException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(interruptedException2, (Object)this, ajc$tjp_2, ajc$tjp_1);
        }
    }

    private void convertAllExtensions(final boolean convertToAJ, final boolean includeNotBuiltFiles, final boolean updateBuildConfigs) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){
            private static final JoinPoint.StaticPart ajc$tjp_0;
            private static final JoinPoint.StaticPart ajc$tjp_1;
            private static final JoinPoint.StaticPart ajc$tjp_2;

            public void run(IProgressMonitor monitor) {
                IJavaProject jp = JavaCore.create((IProject)RenameFileExtensionsDialog.this.project);
                ProjectBuildConfigurator pbc = BuildConfigurator.getBuildConfigurator().getProjectBuildConfigurator(jp);
                BuildConfiguration activeBuildConfig = pbc.getActiveBuildConfiguration();
                int numBuildConfigs = pbc.getBuildConfigurations().size();
                try {
                    IPackageFragment[] packages = jp.getPackageFragments();
                    monitor.beginTask(AspectJUIPlugin.getResourceString("Refactoring.ConvertingFileExtensions"), packages.length + 10 * numBuildConfigs);
                    HashMap oldNamesToNewNames = new HashMap();
                    int i = 0;
                    while (i < packages.length) {
                        if (!packages[i].isReadOnly()) {
                            try {
                                ICompilationUnit[] files = packages[i].getCompilationUnits();
                                int j = 0;
                                while (j < files.length) {
                                    IResource resource = files[j].getResource();
                                    if ((includeNotBuiltFiles || activeBuildConfig.isIncluded(resource)) && (!convertToAJ && resource.getFileExtension().equals("aj") || convertToAJ && resource.getFileExtension().equals("java"))) {
                                        RenamingUtils.renameFile(convertToAJ, resource, monitor, oldNamesToNewNames);
                                    }
                                    ++j;
                                }
                            }
                            catch (JavaModelException javaModelException) {
                                JavaModelException javaModelException2 = javaModelException;
                                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException2, this, ajc$tjp_0, ajc$tjp_1);
                            }
                        }
                        monitor.worked(1);
                        ++i;
                    }
                    if (updateBuildConfigs) {
                        RenamingUtils.updateBuildConfigurations(oldNamesToNewNames, RenameFileExtensionsDialog.this.project, monitor, true);
                    }
                }
                catch (JavaModelException javaModelException) {
                    JavaModelException javaModelException3 = javaModelException;
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException3, this, ajc$tjp_2, ajc$tjp_1);
                }
            }

            static {
                Factory factory = new Factory("RenameFileExtensionsDialog.java", Class.forName("org.eclipse.ajdt.ui.refactoring.RenameFileExtensionsDialog$2"));
                ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.ui.refactoring.RenameFileExtensionsDialog$2-org.eclipse.jdt.core.JavaModelException-<missing>-"), 278);
                ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-run-org.eclipse.ajdt.ui.refactoring.RenameFileExtensionsDialog$2-org.eclipse.core.runtime.IProgressMonitor:-monitor:--void-"), 238);
                ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.ui.refactoring.RenameFileExtensionsDialog$2-org.eclipse.jdt.core.JavaModelException-<missing>-"), 287);
            }
        };
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(runnable);
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException invocationTargetException) {
            InvocationTargetException invocationTargetException2 = invocationTargetException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(invocationTargetException2, (Object)this, ajc$tjp_3, ajc$tjp_4);
        }
        catch (InterruptedException interruptedException) {
            InterruptedException interruptedException2 = interruptedException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(interruptedException2, (Object)this, ajc$tjp_5, ajc$tjp_4);
        }
    }

    static {
        Factory factory = new Factory("RenameFileExtensionsDialog.java", Class.forName("org.eclipse.ajdt.ui.refactoring.RenameFileExtensionsDialog"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.ui.refactoring.RenameFileExtensionsDialog-java.lang.reflect.InvocationTargetException-<missing>-"), 217);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-convertAspectsToAJAndOthersToJava-org.eclipse.ajdt.ui.refactoring.RenameFileExtensionsDialog-boolean:boolean:-includeNonBuiltFiles:updateBuildConfigs:--void-"), 151);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.ui.refactoring.RenameFileExtensionsDialog-java.lang.InterruptedException-<missing>-"), 218);
        ajc$tjp_3 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.ui.refactoring.RenameFileExtensionsDialog-java.lang.reflect.InvocationTargetException-<missing>-"), 296);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-convertAllExtensions-org.eclipse.ajdt.ui.refactoring.RenameFileExtensionsDialog-boolean:boolean:boolean:-convertToAJ:includeNotBuiltFiles:updateBuildConfigs:--void-"), 236);
        ajc$tjp_5 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.ui.refactoring.RenameFileExtensionsDialog-java.lang.InterruptedException-<missing>-"), 297);
    }
}

