/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.AncestorHelper;
import org.eclipse.draw2d.AncestorListener;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.EventDispatcher;
import org.eclipse.draw2d.EventListenerList;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.FocusEvent;
import org.eclipse.draw2d.FocusListener;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GraphicsSource;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.KeyEvent;
import org.eclipse.draw2d.KeyListener;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.Orientable;
import org.eclipse.draw2d.UpdateManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.internal.Draw2dMessages;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;

public class Figure
implements IFigure {
    private static Rectangle PRIVATE_RECT = new Rectangle();
    private static final int FLAG_VALID = 1;
    private static final int FLAG_OPAQUE = 2;
    private static final int FLAG_VISIBLE = 4;
    private static final int FLAG_FOCUSABLE = 8;
    private static final int FLAG_ENABLED = 16;
    private static final int FLAG_FOCUS_TRAVERSABLE = 32;
    protected static int MAX_FLAG = 32;
    protected Rectangle bounds = new Rectangle(0, 0, 64, 36);
    private LayoutManager layoutManager;
    protected int flags = 20;
    private IFigure parent;
    private Cursor cursor;
    private UpdateManager updateManager;
    private PropertyChangeSupport propertyListeners;
    private EventListenerList eventListeners = new EventListenerList();
    List children = Collections.EMPTY_LIST;
    protected Dimension prefSize;
    protected Dimension minSize;
    protected Dimension maxSize;
    protected Font font;
    protected Color bgColor;
    protected Color fgColor;
    protected Border border;
    private AncestorHelper ancestorHelper;
    protected IFigure toolTip;
    protected static final UpdateManager NO_MANAGER = new UpdateManager(){

        public void addDirtyRegion(IFigure figure, int x, int y, int w, int h) {
        }

        public void addInvalidFigure(IFigure f) {
        }

        public void performUpdate() {
        }

        public void performUpdate(Rectangle region) {
        }

        public void setRoot(IFigure root) {
        }

        public void setGraphicsSource(GraphicsSource gs) {
        }
    };
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public final void add(IFigure figure, Object constraint) {
        this.add(figure, constraint, -1);
    }

    public void add(IFigure figure, Object constraint, int index) {
        if (this.children == Collections.EMPTY_LIST) {
            this.children = new ArrayList(2);
        }
        if (index < -1 || index > this.children.size()) {
            throw new IndexOutOfBoundsException(Draw2dMessages.ERR_Figure_Add_Exception_OutOfBounds);
        }
        IFigure f = this;
        while (f != null) {
            if (figure == f) {
                throw new IllegalArgumentException(Draw2dMessages.ERR_Figure_Add_Exception_IllegalArgument);
            }
            f = f.getParent();
        }
        if (figure.getParent() != null) {
            figure.getParent().remove(figure);
        }
        if (index == -1) {
            this.children.add(figure);
        } else {
            this.children.add(index, figure);
        }
        if (this.getLayoutManager() != null) {
            this.getLayoutManager().setConstraint(figure, constraint);
        }
        this.revalidate();
        this.repaint(figure.getBounds());
        figure.setParent(this);
        figure.addNotify();
        figure.repaint();
    }

    public final void add(IFigure figure) {
        this.add(figure, null, -1);
    }

    public final void add(IFigure figure, int index) {
        this.add(figure, null, index);
    }

    public void addAncestorListener(AncestorListener ancestorListener) {
        if (this.ancestorHelper == null) {
            this.ancestorHelper = new AncestorHelper(this);
        }
        this.ancestorHelper.addAncestorListener(ancestorListener);
    }

    public void addFigureListener(FigureListener listener) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.draw2d.FigureListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.eventListeners.addListener(clazz, listener);
    }

    public void addFocusListener(FocusListener listener) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.draw2d.FocusListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.eventListeners.addListener(clazz, listener);
    }

    public void addKeyListener(KeyListener listener) {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.draw2d.KeyListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.eventListeners.addListener(clazz, listener);
    }

    protected void addListener(Class clazz, Object listener) {
        if (this.eventListeners == null) {
            this.eventListeners = new EventListenerList();
        }
        this.eventListeners.addListener(clazz, listener);
    }

    public void addMouseListener(MouseListener l) {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.draw2d.MouseListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.eventListeners.addListener(clazz, l);
    }

    public void addMouseMotionListener(MouseMotionListener l) {
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.draw2d.MouseMotionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.eventListeners.addListener(clazz, l);
    }

    public void addNotify() {
        int i = 0;
        while (i < this.children.size()) {
            ((IFigure)this.children.get(i)).addNotify();
            ++i;
        }
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        if (this.propertyListeners == null) {
            this.propertyListeners = new PropertyChangeSupport(this);
        }
        this.propertyListeners.addPropertyChangeListener(property, listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.propertyListeners == null) {
            this.propertyListeners = new PropertyChangeSupport(this);
        }
        this.propertyListeners.addPropertyChangeListener(l);
    }

    public final boolean containsPoint(Point p) {
        return this.containsPoint(p.x, p.y);
    }

    public boolean containsPoint(int x, int y) {
        return this.getBounds().contains(x, y);
    }

    public void erase() {
        if (this.getParent() == null || !this.isVisible()) {
            return;
        }
        Rectangle r = this.getBounds();
        this.getParent().repaint(r.x, r.y, r.width, r.height);
    }

    protected IFigure findDescendantAtExcluding(int x, int y, Collection c) {
        if (this.useLocalCoordinates()) {
            x -= this.getBounds().x + this.getInsets().left;
            y -= this.getBounds().y + this.getInsets().top;
        }
        if (!this.getClientArea(Rectangle.SINGLETON).contains(x, y)) {
            return null;
        }
        FigureIterator iter = new FigureIterator(this);
        while (iter.hasNext()) {
            IFigure fig = iter.nextFigure();
            if (!fig.isVisible() || (fig = fig.findFigureAtExcluding(x, y, c)) == null) continue;
            return fig;
        }
        return null;
    }

    public final IFigure findFigureAt(Point pt) {
        return this.findFigureAtExcluding(pt.x, pt.y, Collections.EMPTY_LIST);
    }

    public final IFigure findFigureAt(int x, int y) {
        return this.findFigureAtExcluding(x, y, Collections.EMPTY_LIST);
    }

    public IFigure findFigureAtExcluding(int x, int y, Collection c) {
        if (!this.containsPoint(x, y)) {
            return null;
        }
        if (c.contains(this)) {
            return null;
        }
        IFigure child = this.findDescendantAtExcluding(x, y, c);
        if (child != null) {
            return child;
        }
        return this;
    }

    public IFigure findMouseEventTargetAt(int x, int y) {
        if (!this.containsPoint(x, y)) {
            return null;
        }
        IFigure f = this.findMouseEventTargetInDescendantsAt(x, y);
        if (f != null) {
            return f;
        }
        if (this.isMouseEventTarget()) {
            return this;
        }
        return null;
    }

    IFigure findMouseEventTargetInDescendantsAt(int x, int y) {
        if (this.useLocalCoordinates()) {
            x -= this.getBounds().x + this.getInsets().left;
            y -= this.getBounds().y + this.getInsets().top;
        }
        FigureIterator iter = new FigureIterator(this);
        while (iter.hasNext()) {
            IFigure fig = iter.nextFigure();
            if (!fig.isVisible() || !fig.isEnabled() || !fig.containsPoint(x, y)) continue;
            fig = fig.findMouseEventTargetAt(x, y);
            return fig;
        }
        return null;
    }

    protected void fireMoved() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.draw2d.FigureListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!this.eventListeners.containsListener(clazz)) {
            return;
        }
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.draw2d.FigureListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Iterator figureListeners = this.eventListeners.getListeners(clazz2);
        while (figureListeners.hasNext()) {
            ((FigureListener)figureListeners.next()).figureMoved(this);
        }
    }

    protected void firePropertyChange(String property, boolean old, boolean current) {
        if (this.propertyListeners == null) {
            return;
        }
        this.propertyListeners.firePropertyChange(property, old, current);
    }

    protected void firePropertyChange(String property, Object old, Object current) {
        if (this.propertyListeners == null) {
            return;
        }
        this.propertyListeners.firePropertyChange(property, old, current);
    }

    protected void firePropertyChange(String property, int old, int current) {
        if (this.propertyListeners == null) {
            return;
        }
        this.propertyListeners.firePropertyChange(property, old, current);
    }

    public Color getBackgroundColor() {
        if (this.bgColor == null && this.getParent() != null) {
            return this.getParent().getBackgroundColor();
        }
        return this.bgColor;
    }

    public Border getBorder() {
        return this.border;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.bounds);
    }

    public List getChildren() {
        return this.children;
    }

    public Rectangle getClientArea(Rectangle rect) {
        rect.setBounds(this.getBounds());
        rect.crop(this.getInsets());
        if (this.useLocalCoordinates()) {
            rect.setLocation(0, 0);
        }
        return rect;
    }

    public Rectangle getClientArea() {
        return this.getClientArea(new Rectangle());
    }

    public Cursor getCursor() {
        if (this.cursor == null && this.getParent() != null) {
            return this.getParent().getCursor();
        }
        return this.cursor;
    }

    protected boolean getFlag(int flag) {
        return (this.flags & flag) != 0;
    }

    public Font getFont() {
        if (this.font != null) {
            return this.font;
        }
        if (this.getParent() != null) {
            return this.getParent().getFont();
        }
        return null;
    }

    public Color getForegroundColor() {
        if (this.fgColor == null && this.getParent() != null) {
            return this.getParent().getForegroundColor();
        }
        return this.fgColor;
    }

    public Insets getInsets() {
        if (this.getBorder() != null) {
            return this.getBorder().getInsets(this);
        }
        return IFigure.NO_INSETS;
    }

    public LayoutManager getLayoutManager() {
        return this.layoutManager;
    }

    protected Iterator getListeners(Class clazz) {
        if (this.eventListeners == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.eventListeners.getListeners(clazz);
    }

    public final Point getLocation() {
        return this.getBounds().getLocation();
    }

    public Dimension getMaximumSize() {
        if (this.maxSize != null) {
            return this.maxSize;
        }
        return IFigure.MAX_DIMENSION;
    }

    public Dimension getMinimumSize() {
        Dimension d;
        if (this.minSize != null) {
            return this.minSize;
        }
        if (this.getLayoutManager() != null && (d = this.getLayoutManager().getMinimumSize(this)) != null) {
            return d;
        }
        return this.getPreferredSize(-1, -1);
    }

    public IFigure getParent() {
        return this.parent;
    }

    public Dimension getPreferredSize() {
        Dimension d;
        if (this.prefSize != null) {
            return this.prefSize;
        }
        if (this.getLayoutManager() != null && (d = this.getLayoutManager().getPreferredSize(this)) != null) {
            return d;
        }
        return this.getSize();
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        return this.getPreferredSize();
    }

    public final Dimension getSize() {
        return this.getBounds().getSize();
    }

    public IFigure getToolTip() {
        return this.toolTip;
    }

    public UpdateManager getUpdateManager() {
        if (this.updateManager != null) {
            return this.updateManager;
        }
        if (this.getParent() != null) {
            return this.getParent().getUpdateManager();
        }
        return NO_MANAGER;
    }

    public void handleFocusGained(FocusEvent fe) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.draw2d.FocusListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Iterator iter = this.eventListeners.getListeners(clazz);
        while (iter.hasNext()) {
            ((FocusListener)iter.next()).focusGained(fe);
        }
    }

    public void handleFocusLost(FocusEvent fe) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.draw2d.FocusListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Iterator iter = this.eventListeners.getListeners(clazz);
        while (iter.hasNext()) {
            ((FocusListener)iter.next()).focusLost(fe);
        }
    }

    public void handleKeyPressed(KeyEvent e) {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.draw2d.KeyListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Iterator iter = this.eventListeners.getListeners(clazz);
        while (!e.isConsumed() && iter.hasNext()) {
            ((KeyListener)iter.next()).keyPressed(e);
        }
    }

    public void handleKeyReleased(KeyEvent e) {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.draw2d.KeyListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Iterator iter = this.eventListeners.getListeners(clazz);
        while (!e.isConsumed() && iter.hasNext()) {
            ((KeyListener)iter.next()).keyReleased(e);
        }
    }

    public void handleMouseDoubleClicked(MouseEvent e) {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.draw2d.MouseListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Iterator iter = this.eventListeners.getListeners(clazz);
        while (!e.isConsumed() && iter.hasNext()) {
            ((MouseListener)iter.next()).mouseDoubleClicked(e);
        }
    }

    public void handleMouseDragged(MouseEvent e) {
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.draw2d.MouseMotionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Iterator iter = this.eventListeners.getListeners(clazz);
        while (!e.isConsumed() && iter.hasNext()) {
            ((MouseMotionListener)iter.next()).mouseDragged(e);
        }
    }

    public void handleMouseEntered(MouseEvent e) {
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.draw2d.MouseMotionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Iterator iter = this.eventListeners.getListeners(clazz);
        while (!e.isConsumed() && iter.hasNext()) {
            ((MouseMotionListener)iter.next()).mouseEntered(e);
        }
    }

    public void handleMouseExited(MouseEvent e) {
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.draw2d.MouseMotionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Iterator iter = this.eventListeners.getListeners(clazz);
        while (!e.isConsumed() && iter.hasNext()) {
            ((MouseMotionListener)iter.next()).mouseExited(e);
        }
    }

    public void handleMouseHover(MouseEvent e) {
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.draw2d.MouseMotionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Iterator iter = this.eventListeners.getListeners(clazz);
        while (!e.isConsumed() && iter.hasNext()) {
            ((MouseMotionListener)iter.next()).mouseHover(e);
        }
    }

    public void handleMouseMoved(MouseEvent e) {
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.draw2d.MouseMotionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Iterator iter = this.eventListeners.getListeners(clazz);
        while (!e.isConsumed() && iter.hasNext()) {
            ((MouseMotionListener)iter.next()).mouseMoved(e);
        }
    }

    public void handleMousePressed(MouseEvent e) {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.draw2d.MouseListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Iterator iter = this.eventListeners.getListeners(clazz);
        while (!e.isConsumed() && iter.hasNext()) {
            ((MouseListener)iter.next()).mousePressed(e);
        }
    }

    public void handleMouseReleased(MouseEvent e) {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.draw2d.MouseListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Iterator iter = this.eventListeners.getListeners(clazz);
        while (!e.isConsumed() && iter.hasNext()) {
            ((MouseListener)iter.next()).mouseReleased(e);
        }
    }

    public boolean hasFocus() {
        EventDispatcher dispatcher = this.internalGetEventDispatcher();
        if (dispatcher == null) {
            return false;
        }
        return dispatcher.getFocusOwner() == this;
    }

    public EventDispatcher internalGetEventDispatcher() {
        if (this.getParent() != null) {
            return this.getParent().internalGetEventDispatcher();
        }
        return null;
    }

    public boolean intersects(Rectangle r) {
        return this.getBounds().intersects(r);
    }

    public void invalidate() {
        if (!this.isValid()) {
            return;
        }
        this.setValid(false);
    }

    public boolean isEnabled() {
        return (this.flags & 0x10) != 0;
    }

    public boolean isFocusTraversable() {
        return (this.flags & 0x20) != 0;
    }

    protected boolean isMouseEventTarget() {
        block12: {
            block11: {
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = class$3 = Class.forName("org.eclipse.draw2d.MouseListener");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (this.eventListeners.containsListener(clazz)) break block11;
                Class<?> clazz2 = class$4;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$4 = Class.forName("org.eclipse.draw2d.MouseMotionListener");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!this.eventListeners.containsListener(clazz2)) break block12;
            }
            return true;
        }
        return false;
    }

    public boolean isOpaque() {
        return (this.flags & 2) != 0;
    }

    public boolean isRequestFocusEnabled() {
        return (this.flags & 8) != 0;
    }

    protected boolean isValid() {
        return (this.flags & 1) != 0;
    }

    protected boolean isValidationRoot() {
        return false;
    }

    public boolean isVisible() {
        return (this.flags & 4) != 0;
    }

    protected void layout() {
        if (this.getLayoutManager() != null) {
            this.getLayoutManager().layout(this);
        }
    }

    public void paint(Graphics graphics) {
        if (this.bgColor != null) {
            graphics.setBackgroundColor(this.bgColor);
        }
        if (this.fgColor != null) {
            graphics.setForegroundColor(this.fgColor);
        }
        if (this.font != null) {
            graphics.setFont(this.font);
        }
        this.paintFigure(graphics);
        this.paintClientArea(graphics);
        this.paintBorder(graphics);
    }

    protected void paintBorder(Graphics graphics) {
        if (this.getBorder() != null) {
            this.getBorder().paint(this, graphics, IFigure.NO_INSETS);
        }
    }

    protected void paintChildren(Graphics g) {
        g.pushState();
        Rectangle clip = Rectangle.SINGLETON;
        int i = 0;
        while (i < this.children.size()) {
            IFigure f = (IFigure)this.children.get(i);
            if (f.isVisible() && f.intersects(g.getClip(clip))) {
                g.clipRect(f.getBounds());
                f.paint(g);
                g.restoreState();
            }
            ++i;
        }
        g.popState();
    }

    protected void paintClientArea(Graphics g) {
        boolean optimizeClip;
        if (this.children.isEmpty()) {
            return;
        }
        boolean bl = optimizeClip = this.getBorder() == null || this.getBorder().isOpaque();
        if (this.useLocalCoordinates()) {
            g.pushState();
            g.translate(this.getBounds().x + this.getInsets().left, this.getBounds().y + this.getInsets().top);
            if (!optimizeClip) {
                g.clipRect(this.getClientArea(PRIVATE_RECT));
            }
            this.paintChildren(g);
            g.popState();
        } else if (optimizeClip) {
            this.paintChildren(g);
        } else {
            g.pushState();
            g.clipRect(this.getClientArea(PRIVATE_RECT));
            this.paintChildren(g);
            g.popState();
        }
    }

    protected void paintFigure(Graphics graphics) {
        if (this.isOpaque()) {
            graphics.fillRectangle(this.getBounds());
        }
    }

    protected void primTranslate(int dx, int dy) {
        this.bounds.x += dx;
        this.bounds.y += dy;
        if (this.useLocalCoordinates()) {
            return;
        }
        int i = 0;
        while (i < this.children.size()) {
            ((IFigure)this.children.get(i)).translate(dx, dy);
            ++i;
        }
    }

    public void remove(IFigure figure) {
        if (figure.getParent() != this || !this.children.contains(figure)) {
            throw new IllegalArgumentException(Draw2dMessages.ERR_Figure_Remove_Exception_IllegalArgument);
        }
        figure.removeNotify();
        if (this.layoutManager != null) {
            this.layoutManager.remove(figure);
        }
        figure.erase();
        figure.setParent(null);
        this.children.remove(figure);
        this.revalidate();
    }

    public void removeAll() {
        ArrayList list = new ArrayList(this.getChildren());
        int i = 0;
        while (i < list.size()) {
            this.remove((IFigure)list.get(i));
            ++i;
        }
    }

    public void removeAncestorListener(AncestorListener listener) {
        if (this.ancestorHelper != null) {
            this.ancestorHelper.removeAncestorListener(listener);
            if (this.ancestorHelper.getNumberOfListeners() == 0) {
                this.ancestorHelper.dispose();
                this.ancestorHelper = null;
            }
        }
    }

    public void removeFigureListener(FigureListener listener) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.draw2d.FigureListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.eventListeners.removeListener(clazz, listener);
    }

    public void removeFocusListener(FocusListener listener) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.draw2d.FocusListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.eventListeners.removeListener(clazz, listener);
    }

    protected void removeListener(Class clazz, Object listener) {
        if (this.eventListeners == null) {
            return;
        }
        this.eventListeners.removeListener(clazz, listener);
    }

    public void removeMouseListener(MouseListener listener) {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.draw2d.MouseListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.eventListeners.removeListener(clazz, listener);
    }

    public void removeMouseMotionListener(MouseMotionListener listener) {
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.draw2d.MouseMotionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.eventListeners.removeListener(clazz, listener);
    }

    public void removeNotify() {
        int i = 0;
        while (i < this.children.size()) {
            ((IFigure)this.children.get(i)).removeNotify();
            ++i;
        }
        if (this.internalGetEventDispatcher() != null) {
            this.internalGetEventDispatcher().requestRemoveFocus(this);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyListeners == null) {
            return;
        }
        this.propertyListeners.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        if (this.propertyListeners == null) {
            return;
        }
        this.propertyListeners.removePropertyChangeListener(property, listener);
    }

    public final void repaint(Rectangle r) {
        this.repaint(r.x, r.y, r.width, r.height);
    }

    public void repaint(int x, int y, int w, int h) {
        if (this.isVisible()) {
            this.getUpdateManager().addDirtyRegion(this, x, y, w, h);
        }
    }

    public void repaint() {
        this.repaint(this.getBounds());
    }

    public final void requestFocus() {
        if (!this.isRequestFocusEnabled() || this.hasFocus()) {
            return;
        }
        EventDispatcher dispatcher = this.internalGetEventDispatcher();
        if (dispatcher == null) {
            return;
        }
        dispatcher.requestFocus(this);
    }

    public void revalidate() {
        this.invalidate();
        if (this.getLayoutManager() != null) {
            this.getLayoutManager().invalidate();
        }
        if (this.getParent() == null || this.isValidationRoot()) {
            this.getUpdateManager().addInvalidFigure(this);
        } else {
            this.getParent().revalidate();
        }
    }

    public void setBackgroundColor(Color bg) {
        this.bgColor = bg;
        this.repaint();
    }

    public void setBorder(Border border) {
        this.border = border;
        this.revalidate();
    }

    public void setBounds(Rectangle r) {
        boolean translate;
        int x = this.bounds.x;
        int y = this.bounds.y;
        boolean resize = r.width != this.bounds.width || r.height != this.bounds.height;
        boolean bl = translate = r.x != x || r.y != y;
        if (this.isVisible() && (resize || translate)) {
            this.erase();
        }
        if (translate) {
            int dx = r.x - x;
            int dy = r.y - y;
            this.primTranslate(dx, dy);
        }
        this.bounds.width = r.width;
        this.bounds.height = r.height;
        if (resize) {
            this.invalidate();
        }
        if (resize || translate) {
            this.fireMoved();
            this.repaint();
        }
    }

    protected void setChildrenDirection(int dir) {
        FigureIterator iterator = new FigureIterator(this);
        while (iterator.hasNext()) {
            IFigure child = iterator.nextFigure();
            if (!(child instanceof Orientable)) continue;
            ((Orientable)child).setDirection(dir);
        }
    }

    protected void setChildrenEnabled(boolean value) {
        FigureIterator iterator = new FigureIterator(this);
        while (iterator.hasNext()) {
            iterator.nextFigure().setEnabled(value);
        }
    }

    protected void setChildrenOrientation(int orientation) {
        FigureIterator iterator = new FigureIterator(this);
        while (iterator.hasNext()) {
            IFigure child = iterator.nextFigure();
            if (!(child instanceof Orientable)) continue;
            ((Orientable)child).setOrientation(orientation);
        }
    }

    public void setConstraint(IFigure child, Object constraint) {
        if (!this.getChildren().contains(child)) {
            throw new IllegalArgumentException(Draw2dMessages.ERR_Figure_SetConstraint_Exception_IllegalArgument);
        }
        if (this.layoutManager != null) {
            this.layoutManager.setConstraint(child, constraint);
        }
        this.revalidate();
    }

    public void setCursor(Cursor cursor) {
        if (this.cursor == cursor) {
            return;
        }
        this.cursor = cursor;
        EventDispatcher dispatcher = this.internalGetEventDispatcher();
        if (dispatcher != null) {
            dispatcher.updateCursor();
        }
    }

    public void setEnabled(boolean value) {
        if (this.isEnabled() == value) {
            return;
        }
        this.setFlag(16, value);
    }

    protected final void setFlag(int flag, boolean value) {
        this.flags = value ? (this.flags |= flag) : (this.flags &= ~flag);
    }

    public void setFocusTraversable(boolean focusTraversable) {
        if (this.isFocusTraversable() == focusTraversable) {
            return;
        }
        this.setFlag(32, focusTraversable);
    }

    public void setFont(Font f) {
        if (this.font != f) {
            this.font = f;
            this.revalidate();
        }
    }

    public void setForegroundColor(Color fg) {
        if (this.fgColor != null && this.fgColor.equals((Object)fg)) {
            return;
        }
        this.fgColor = fg;
        this.repaint();
    }

    public void setLayoutManager(LayoutManager manager) {
        this.layoutManager = manager;
        this.revalidate();
    }

    public void setLocation(Point p) {
        if (this.getLocation().equals(p)) {
            return;
        }
        Rectangle r = new Rectangle(this.getBounds());
        r.setLocation(p);
        this.setBounds(r);
    }

    public void setMaximumSize(Dimension d) {
        if (this.maxSize != null && this.maxSize.equals(d)) {
            return;
        }
        this.maxSize = d;
        this.revalidate();
    }

    public void setMinimumSize(Dimension d) {
        if (this.minSize != null && this.minSize.equals(d)) {
            return;
        }
        this.minSize = d;
        this.revalidate();
    }

    public void setOpaque(boolean opaque) {
        if (this.isOpaque() == opaque) {
            return;
        }
        this.setFlag(2, opaque);
        this.repaint();
    }

    public void setParent(IFigure p) {
        IFigure oldParent = this.parent;
        this.parent = p;
        this.firePropertyChange("parent", oldParent, p);
    }

    public void setPreferredSize(Dimension size) {
        if (this.prefSize != null && this.prefSize.equals(size)) {
            return;
        }
        this.prefSize = size;
        this.revalidate();
    }

    public final void setPreferredSize(int w, int h) {
        this.setPreferredSize(new Dimension(w, h));
    }

    public void setRequestFocusEnabled(boolean requestFocusEnabled) {
        if (this.isRequestFocusEnabled() == requestFocusEnabled) {
            return;
        }
        this.setFlag(8, requestFocusEnabled);
    }

    public final void setSize(Dimension d) {
        this.setSize(d.width, d.height);
    }

    public void setSize(int w, int h) {
        Rectangle bounds = this.getBounds();
        if (bounds.width == w && bounds.height == h) {
            return;
        }
        Rectangle r = new Rectangle(this.getBounds());
        r.setSize(w, h);
        this.setBounds(r);
    }

    public void setToolTip(IFigure f) {
        if (this.toolTip == f) {
            return;
        }
        this.toolTip = f;
    }

    public final void setUpdateManager(UpdateManager updateManager) {
        this.updateManager = updateManager;
        this.revalidate();
        this.repaint();
    }

    public void setValid(boolean valid) {
        this.setFlag(1, valid);
    }

    public void setVisible(boolean visible) {
        boolean currentVisibility = this.isVisible();
        if (visible == currentVisibility) {
            return;
        }
        if (currentVisibility) {
            this.erase();
        }
        this.setFlag(4, visible);
        if (visible) {
            this.repaint();
        }
    }

    public final void translate(int x, int y) {
        this.primTranslate(x, y);
        this.fireMoved();
    }

    public void translateFromParent(Translatable t) {
        if (this.useLocalCoordinates()) {
            t.performTranslate(-this.getBounds().x - this.getInsets().left, -this.getBounds().y - this.getInsets().top);
        }
    }

    public final void translateToAbsolute(Translatable t) {
        if (this.getParent() != null) {
            this.getParent().translateToParent(t);
            this.getParent().translateToAbsolute(t);
        }
    }

    public void translateToParent(Translatable t) {
        if (this.useLocalCoordinates()) {
            t.performTranslate(this.getBounds().x + this.getInsets().left, this.getBounds().y + this.getInsets().top);
        }
    }

    public final void translateToRelative(Translatable t) {
        if (this.getParent() != null) {
            this.getParent().translateFromParent(t);
            this.getParent().translateToRelative(t);
        }
    }

    protected boolean useLocalCoordinates() {
        return false;
    }

    public void validate() {
        if (this.isValid()) {
            return;
        }
        this.setValid(true);
        this.layout();
        int i = 0;
        while (i < this.children.size()) {
            ((IFigure)this.children.get(i)).validate();
            ++i;
        }
    }

    public static class FigureIterator {
        protected List list;
        protected int index;

        public FigureIterator(IFigure f) {
            this.list = f.getChildren();
            this.index = this.list.size();
        }

        public IFigure nextFigure() {
            return (IFigure)this.list.get(--this.index);
        }

        public boolean hasNext() {
            return this.index > 0;
        }
    }
}

