/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Transposer;

public class FlowLayout
extends AbstractLayout {
    public static final int ALIGN_CENTER = 0;
    public static final int ALIGN_LEFTTOP = 1;
    public static final int ALIGN_RIGHTBOTTOM = 2;
    public static final boolean HORIZONTAL = true;
    public static final boolean VERTICAL = false;
    protected boolean horizontal = true;
    protected boolean fFill = false;
    protected Transposer transposer = new Transposer();
    protected int majorAlignment;
    protected int minorAlignment;
    private int hSpacing;
    private int vSpacing;
    private WorkingData data;

    public FlowLayout() {
        this.transposer.setEnabled(!this.horizontal);
        this.majorAlignment = 1;
        this.minorAlignment = 1;
        this.hSpacing = 5;
        this.vSpacing = 5;
        this.data = null;
    }

    public FlowLayout(boolean isHorizontal) {
        this.transposer.setEnabled(!this.horizontal);
        this.majorAlignment = 1;
        this.minorAlignment = 1;
        this.hSpacing = 5;
        this.vSpacing = 5;
        this.data = null;
        this.setHorizontal(isHorizontal);
    }

    protected Dimension calculatePreferredSize(IFigure parent) {
        List children = parent.getChildren();
        Dimension preferred = new Dimension();
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            Dimension childSize = this.transposer.t(child.getPreferredSize());
            preferred.width += childSize.width;
            preferred.height = Math.max(preferred.height, childSize.height);
            ++i;
        }
        if (children.size() > 0) {
            preferred.width += this.hSpacing * (children.size() - 1);
        }
        preferred = this.transposer.t(preferred);
        preferred.width += parent.getInsets().getWidth();
        preferred.height += parent.getInsets().getHeight();
        preferred.union(this.getBorderPreferredSize(parent));
        return preferred;
    }

    public int getMajorAlignment() {
        return this.majorAlignment;
    }

    public int getMinorAlignment() {
        return this.minorAlignment;
    }

    private void initRow() {
        this.data.rowX = this.data.insets.left;
        this.data.rowHeight = 0;
        this.data.rowWidth = 0;
        this.data.rowCount = 0;
    }

    private void initVariables(IFigure parent) {
        this.data.row = new IFigure[parent.getChildren().size()];
        this.data.bounds = new Rectangle[this.data.row.length];
        this.data.rowY = this.data.insets.top;
        this.data.maxWidth = this.data.area.width - this.data.insets.getWidth();
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public void layout(IFigure parent) {
        this.data = new WorkingData();
        Rectangle relativeArea = parent.getBounds().getCopy();
        parent.translateFromParent(relativeArea);
        this.data.area = this.transposer.t(relativeArea);
        this.data.insets = this.transposer.t(parent.getInsets());
        this.data.spacing = new Dimension(this.hSpacing, this.vSpacing);
        Iterator iterator = parent.getChildren().iterator();
        this.initVariables(parent);
        this.initRow();
        int i = 0;
        while (iterator.hasNext()) {
            IFigure f = (IFigure)iterator.next();
            Dimension pref = this.transposer.t(f.getPreferredSize());
            Rectangle r = new Rectangle(0, 0, pref.width, pref.height);
            if (this.data.rowCount > 0 && this.data.rowWidth + pref.width > this.data.maxWidth) {
                this.layoutRow(parent);
            }
            r.x = this.data.rowX;
            r.y = this.data.rowY;
            int dx = r.width + this.data.spacing.width;
            this.data.rowX += dx;
            this.data.rowWidth += dx;
            this.data.rowHeight = Math.max(this.data.rowHeight, r.height);
            this.data.row[this.data.rowCount] = f;
            this.data.bounds[this.data.rowCount] = r;
            ++this.data.rowCount;
            ++i;
        }
        if (this.data.rowCount != 0) {
            this.layoutRow(parent);
        }
        this.data = null;
    }

    protected void layoutRow(IFigure parent) {
        int majorAdjustment = 0;
        int minorAdjustment = 0;
        int correctMajorAlignment = this.majorAlignment;
        int correctMinorAlignment = this.minorAlignment;
        majorAdjustment = this.data.area.width - this.data.insets.getWidth() - this.data.rowWidth;
        if (!this.isHorizontal()) {
            correctMajorAlignment = this.minorAlignment;
            correctMinorAlignment = this.majorAlignment;
        }
        switch (correctMajorAlignment) {
            case 1: {
                majorAdjustment = 0;
                break;
            }
            case 0: {
                majorAdjustment /= 2;
                break;
            }
        }
        int j = 0;
        while (j < this.data.rowCount) {
            if (this.fFill) {
                this.data.bounds[j].height = this.data.rowHeight;
            } else {
                minorAdjustment = this.data.rowHeight - this.data.bounds[j].height;
                switch (correctMinorAlignment) {
                    case 1: {
                        minorAdjustment = 0;
                        break;
                    }
                    case 0: {
                        minorAdjustment /= 2;
                        break;
                    }
                }
                this.data.bounds[j].y += minorAdjustment;
            }
            this.data.bounds[j].x += majorAdjustment;
            this.setBoundsOfChild(parent, this.data.row[j], this.transposer.t(this.data.bounds[j]));
            ++j;
        }
        this.data.rowY += this.data.spacing.height + this.data.rowHeight;
        this.initRow();
    }

    protected void setBoundsOfChild(IFigure parent, IFigure child, Rectangle bounds) {
        bounds.translate(parent.getBounds().getLocation());
        child.setBounds(bounds);
    }

    public void setFill(boolean value) {
        this.fFill = value;
    }

    public void setHorizontal(boolean flag) {
        if (this.horizontal == flag) {
            return;
        }
        this.invalidate();
        this.horizontal = flag;
        this.transposer.setEnabled(!this.horizontal);
    }

    public void setMajorAlignment(int align) {
        this.majorAlignment = align;
    }

    public void setMajorSpacing(int n) {
        this.vSpacing = n;
    }

    public void setMinorAlignment(int align) {
        this.minorAlignment = align;
    }

    public void setMinorSpacing(int n) {
        this.hSpacing = n;
    }

    public void setAlignment(int align) {
        this.minorAlignment = align;
    }

    class WorkingData {
        int rowHeight;
        int rowWidth;
        int rowCount;
        int rowX;
        int rowY;
        int maxWidth;
        Rectangle[] bounds;
        Rectangle area;
        Insets insets;
        IFigure[] row;
        Dimension spacing;

        WorkingData() {
        }
    }
}

