/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.util.List;
import org.eclipse.draw2d.FreeformFigure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;

public class FreeformHelper {
    private FreeformFigure host;

    FreeformHelper(FreeformFigure host) {
        this.host = host;
    }

    public Rectangle updateFreeformBounds(Rectangle union) {
        Rectangle newBounds = null;
        List children = this.host.getChildren();
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            if (child instanceof FreeformFigure) {
                ((FreeformFigure)child).updateFreeformBounds(union);
            }
            Rectangle r = child.getBounds();
            if (newBounds == null) {
                newBounds = r.getCopy();
            } else {
                newBounds.union(r);
            }
            ++i;
        }
        Insets insets = this.host.getInsets();
        if (newBounds == null) {
            newBounds = new Rectangle(0, 0, insets.getWidth(), insets.getHeight());
        } else {
            newBounds.expand(insets);
            newBounds.union(0, 0);
        }
        newBounds.union(union);
        return newBounds;
    }
}

