/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public class RelativeLocator
implements Locator {
    private double relativeX;
    private double relativeY;
    private IFigure reference;

    public RelativeLocator() {
        this.relativeX = 0.0;
        this.relativeY = 0.0;
    }

    public RelativeLocator(IFigure reference, int location) {
        this.setReferenceFigure(reference);
        switch (location & 5) {
            case 1: {
                this.relativeY = 0.0;
                break;
            }
            case 4: {
                this.relativeY = 1.0;
                break;
            }
            default: {
                this.relativeY = 0.5;
            }
        }
        switch (location & 0x18) {
            case 8: {
                this.relativeX = 0.0;
                break;
            }
            case 16: {
                this.relativeX = 1.0;
                break;
            }
            default: {
                this.relativeX = 0.5;
            }
        }
    }

    public RelativeLocator(IFigure reference, double _relativeX, double _relativeY) {
        this.setReferenceFigure(reference);
        this.relativeX = _relativeX;
        this.relativeY = _relativeY;
    }

    protected Rectangle getReferenceBox() {
        return this.getReferenceFigure().getBounds();
    }

    protected IFigure getReferenceFigure() {
        return this.reference;
    }

    public void relocate(IFigure target) {
        IFigure reference = this.getReferenceFigure();
        Rectangle $refBounds = this.getReferenceBox();
        Rectangle tarBounds = $refBounds.getCopy();
        reference.translateToAbsolute(tarBounds);
        target.translateToRelative(tarBounds);
        Dimension tarSize = target.getPreferredSize();
        tarBounds.setSize(tarSize);
        tarBounds.x += (int)((double)$refBounds.width * this.relativeX - (double)((tarSize.width + 1) / 2));
        tarBounds.y += (int)((double)$refBounds.height * this.relativeY - (double)((tarSize.height + 1) / 2));
        target.setBounds(tarBounds);
    }

    public void setReferenceFigure(IFigure reference) {
        this.reference = reference;
    }
}

