/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class ViewportLayout
extends AbstractLayout {
    protected Dimension calculatePreferredSize(IFigure parent) {
        Viewport viewport = (Viewport)parent;
        IFigure contents = viewport.getContents();
        Dimension d = contents == null ? new Dimension() : contents.getPreferredSize().getCopy();
        Insets insets = viewport.getInsets();
        d.expand(insets.getWidth(), insets.getHeight());
        return d;
    }

    public void layout(IFigure figure) {
        Viewport viewport = (Viewport)figure;
        IFigure contents = viewport.getContents();
        if (contents == null) {
            return;
        }
        Point p = viewport.getClientArea().getLocation();
        p.translate(viewport.getViewLocation().getNegated());
        Dimension avail = viewport.getClientArea().getSize();
        Dimension size = avail.getUnioned(contents.getPreferredSize());
        Dimension min = contents.getMinimumSize();
        if (viewport.getContentsTracksHeight()) {
            size.height = Math.max(min.height, avail.height);
        }
        if (viewport.getContentsTracksWidth()) {
            size.width = Math.max(min.width, avail.width);
        }
        contents.setBounds(new Rectangle(p, size));
    }

    public Dimension getMinimumSize(IFigure figure) {
        Viewport viewport = (Viewport)figure;
        Dimension min = new Dimension();
        Insets insets = viewport.getInsets();
        return min.getExpanded(insets.getWidth(), insets.getHeight());
    }
}

