/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.core.search;

import org.aspectj.org.eclipse.jdt.core.search.IJavaSearchScope;
import org.aspectj.org.eclipse.jdt.core.search.SearchDocument;
import org.aspectj.org.eclipse.jdt.core.search.SearchPattern;
import org.aspectj.org.eclipse.jdt.core.search.SearchRequestor;
import org.aspectj.org.eclipse.jdt.internal.core.JavaModelManager;
import org.aspectj.org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public abstract class SearchParticipant {
    protected SearchParticipant() {
    }

    public void beginSearching() {
    }

    public void doneSearching() {
    }

    public String getDescription() {
        return "Search participant";
    }

    public abstract SearchDocument getDocument(String var1);

    public abstract void indexDocument(SearchDocument var1, IPath var2);

    public abstract void locateMatches(SearchDocument[] var1, SearchPattern var2, IJavaSearchScope var3, SearchRequestor var4, IProgressMonitor var5) throws CoreException;

    public final void scheduleDocumentIndexing(SearchDocument document, IPath indexLocation) {
        Path documentPath = new Path(document.getPath());
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)documentPath);
        Path containerPath = resource == null ? documentPath : resource.getProject().getFullPath();
        IndexManager manager = JavaModelManager.getJavaModelManager().getIndexManager();
        String osIndexLocation = indexLocation.toOSString();
        manager.ensureIndexExists(osIndexLocation, (IPath)containerPath);
        manager.scheduleDocumentIndexing(document, (IPath)containerPath, osIndexLocation, this);
    }

    public abstract IPath[] selectIndexes(SearchPattern var1, IJavaSearchScope var2);
}

