/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.lookup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AnnotationMethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Argument;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.Constant;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.IMemberFinder;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.IPrivilegedHandler;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodVerifier;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.SyntheticFieldBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.SyntheticMethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

public class SourceTypeBinding
extends ReferenceBinding {
    public ReferenceBinding superclass;
    public ReferenceBinding[] superInterfaces;
    public FieldBinding[] fields;
    public MethodBinding[] methods;
    public ReferenceBinding[] memberTypes;
    public TypeVariableBinding[] typeVariables;
    public ReferenceBinding originalSuperclass = null;
    public ReferenceBinding[] originalSuperInterfaces = null;
    public IPrivilegedHandler privilegedHandler = null;
    public IMemberFinder memberFinder = null;
    public ClassScope scope;
    public static final int METHOD_EMUL = 0;
    public static final int FIELD_EMUL = 1;
    public static final int CLASS_LITERAL_EMUL = 2;
    public static final int RECEIVER_TYPE_EMUL = 3;
    HashMap[] synthetics;
    char[] genericReferenceTypeSignature;

    public SourceTypeBinding() {
    }

    public SourceTypeBinding(char[][] compoundName, PackageBinding fPackage, ClassScope scope) {
        this.compoundName = compoundName;
        this.fPackage = fPackage;
        this.fileName = scope.referenceCompilationUnit().getFileName();
        this.modifiers = scope.referenceContext.modifiers;
        this.sourceName = scope.referenceContext.name;
        this.scope = scope;
        this.fields = TypeConstants.NoFields;
        this.methods = TypeConstants.NoMethods;
        this.computeId();
    }

    private void addDefaultAbstractMethod(MethodBinding abstractMethod) {
        MethodBinding defaultAbstract = new MethodBinding(abstractMethod.modifiers | 0x80000, abstractMethod.selector, abstractMethod.returnType, abstractMethod.parameters, abstractMethod.thrownExceptions, this);
        MethodBinding[] temp = new MethodBinding[this.methods.length + 1];
        System.arraycopy(this.methods, 0, temp, 0, this.methods.length);
        temp[this.methods.length] = defaultAbstract;
        this.methods = temp;
    }

    public void addDefaultAbstractMethods() {
        if ((this.tagBits & 0x400L) != 0L) {
            return;
        }
        this.tagBits |= 0x400L;
        if (this.isClass() && this.isAbstract()) {
            if (this.fPackage.environment.options.targetJDK >= 0x2E0000L) {
                return;
            }
            ReferenceBinding[][] interfacesToVisit = new ReferenceBinding[5][];
            int lastPosition = 0;
            interfacesToVisit[lastPosition] = this.superInterfaces();
            int i = 0;
            while (i <= lastPosition) {
                ReferenceBinding[] interfaces = interfacesToVisit[i];
                int j = 0;
                int length = interfaces.length;
                while (j < length) {
                    ReferenceBinding superType = interfaces[j];
                    if (superType.isValidBinding()) {
                        MethodBinding[] superMethods = superType.methods();
                        int m = superMethods.length;
                        while (--m >= 0) {
                            MethodBinding method = superMethods[m];
                            if (this.implementsMethod(method)) continue;
                            this.addDefaultAbstractMethod(method);
                        }
                        ReferenceBinding[] itsInterfaces = superType.superInterfaces();
                        if (itsInterfaces != TypeConstants.NoSuperInterfaces) {
                            if (++lastPosition == interfacesToVisit.length) {
                                ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                                interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                                System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
                            }
                            interfacesToVisit[lastPosition] = itsInterfaces;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public FieldBinding addSyntheticFieldForInnerclass(LocalVariableBinding actualOuterLocalVariable) {
        boolean needRecheck;
        FieldBinding synthField;
        if (this.synthetics == null) {
            this.synthetics = new HashMap[4];
        }
        if (this.synthetics[1] == null) {
            this.synthetics[1] = new HashMap(5);
        }
        if ((synthField = (FieldBinding)this.synthetics[1].get(actualOuterLocalVariable)) == null) {
            synthField = new SyntheticFieldBinding(CharOperation.concat(TypeConstants.SYNTHETIC_OUTER_LOCAL_PREFIX, actualOuterLocalVariable.name), actualOuterLocalVariable.type, 4114, this, Constant.NotAConstant, this.synthetics[1].size());
            this.synthetics[1].put(actualOuterLocalVariable, synthField);
        }
        int index = 1;
        block0: do {
            needRecheck = false;
            FieldBinding existingField = this.getField(synthField.name, true);
            if (existingField == null) continue;
            TypeDeclaration typeDecl = this.scope.referenceContext;
            int i = 0;
            int max = typeDecl.fields.length;
            while (i < max) {
                FieldDeclaration fieldDecl = typeDecl.fields[i];
                if (fieldDecl.binding == existingField) {
                    synthField.name = CharOperation.concat(TypeConstants.SYNTHETIC_OUTER_LOCAL_PREFIX, actualOuterLocalVariable.name, ("$" + String.valueOf(index++)).toCharArray());
                    needRecheck = true;
                    continue block0;
                }
                ++i;
            }
        } while (needRecheck);
        return synthField;
    }

    public FieldBinding addSyntheticFieldForInnerclass(ReferenceBinding enclosingType) {
        FieldBinding existingField;
        FieldBinding synthField;
        if (this.synthetics == null) {
            this.synthetics = new HashMap[4];
        }
        if (this.synthetics[1] == null) {
            this.synthetics[1] = new HashMap(5);
        }
        if ((synthField = (FieldBinding)this.synthetics[1].get(enclosingType)) == null) {
            synthField = new SyntheticFieldBinding(CharOperation.concat(TypeConstants.SYNTHETIC_ENCLOSING_INSTANCE_PREFIX, String.valueOf(enclosingType.depth()).toCharArray()), enclosingType, 4112, this, Constant.NotAConstant, this.synthetics[1].size());
            this.synthetics[1].put(enclosingType, synthField);
        }
        if ((existingField = this.getField(synthField.name, true)) != null) {
            TypeDeclaration typeDecl = this.scope.referenceContext;
            int i = 0;
            int max = typeDecl.fields.length;
            while (i < max) {
                FieldDeclaration fieldDecl = typeDecl.fields[i];
                if (fieldDecl.binding == existingField) {
                    this.scope.problemReporter().duplicateFieldInType(this, fieldDecl);
                    break;
                }
                ++i;
            }
        }
        return synthField;
    }

    public FieldBinding addSyntheticFieldForClassLiteral(TypeBinding targetType, BlockScope blockScope) {
        FieldBinding existingField;
        FieldBinding synthField;
        if (this.synthetics == null) {
            this.synthetics = new HashMap[4];
        }
        if (this.synthetics[2] == null) {
            this.synthetics[2] = new HashMap(5);
        }
        if ((synthField = (FieldBinding)this.synthetics[2].get(targetType)) == null) {
            synthField = new SyntheticFieldBinding(CharOperation.concat(TypeConstants.SYNTHETIC_CLASS, String.valueOf(this.synthetics[2].size()).toCharArray()), blockScope.getJavaLangClass(), 4104, this, Constant.NotAConstant, this.synthetics[2].size());
            this.synthetics[2].put(targetType, synthField);
        }
        if ((existingField = this.getField(synthField.name, true)) != null) {
            TypeDeclaration typeDecl = blockScope.referenceType();
            int i = 0;
            int max = typeDecl.fields.length;
            while (i < max) {
                FieldDeclaration fieldDecl = typeDecl.fields[i];
                if (fieldDecl.binding == existingField) {
                    blockScope.problemReporter().duplicateFieldInType(this, fieldDecl);
                    break;
                }
                ++i;
            }
        }
        return synthField;
    }

    public FieldBinding addSyntheticFieldForAssert(BlockScope blockScope) {
        boolean needRecheck;
        FieldBinding synthField;
        if (this.synthetics == null) {
            this.synthetics = new HashMap[4];
        }
        if (this.synthetics[1] == null) {
            this.synthetics[1] = new HashMap(5);
        }
        if ((synthField = (FieldBinding)this.synthetics[1].get("assertionEmulation")) == null) {
            synthField = new SyntheticFieldBinding(TypeConstants.SYNTHETIC_ASSERT_DISABLED, BaseTypes.BooleanBinding, 4120, this, Constant.NotAConstant, this.synthetics[1].size());
            this.synthetics[1].put("assertionEmulation", synthField);
        }
        int index = 0;
        block0: do {
            needRecheck = false;
            FieldBinding existingField = this.getField(synthField.name, true);
            if (existingField == null) continue;
            TypeDeclaration typeDecl = this.scope.referenceContext;
            int i = 0;
            int max = typeDecl.fields.length;
            while (i < max) {
                FieldDeclaration fieldDecl = typeDecl.fields[i];
                if (fieldDecl.binding == existingField) {
                    synthField.name = CharOperation.concat(TypeConstants.SYNTHETIC_ASSERT_DISABLED, ("_" + String.valueOf(index++)).toCharArray());
                    needRecheck = true;
                    continue block0;
                }
                ++i;
            }
        } while (needRecheck);
        return synthField;
    }

    public FieldBinding addSyntheticFieldForEnumValues() {
        boolean needRecheck;
        FieldBinding synthField;
        if (this.synthetics == null) {
            this.synthetics = new HashMap[4];
        }
        if (this.synthetics[1] == null) {
            this.synthetics[1] = new HashMap(5);
        }
        if ((synthField = (FieldBinding)this.synthetics[1].get("enumConstantValues")) == null) {
            synthField = new SyntheticFieldBinding(TypeConstants.SYNTHETIC_ENUM_VALUES, this.scope.createArrayType(this, 1), 4122, this, Constant.NotAConstant, this.synthetics[1].size());
            this.synthetics[1].put("enumConstantValues", synthField);
        }
        int index = 0;
        block0: do {
            needRecheck = false;
            FieldBinding existingField = this.getField(synthField.name, true);
            if (existingField == null) continue;
            TypeDeclaration typeDecl = this.scope.referenceContext;
            int i = 0;
            int max = typeDecl.fields.length;
            while (i < max) {
                FieldDeclaration fieldDecl = typeDecl.fields[i];
                if (fieldDecl.binding == existingField) {
                    synthField.name = CharOperation.concat(TypeConstants.SYNTHETIC_ENUM_VALUES, ("_" + String.valueOf(index++)).toCharArray());
                    needRecheck = true;
                    continue block0;
                }
                ++i;
            }
        } while (needRecheck);
        return synthField;
    }

    public SyntheticMethodBinding addSyntheticMethod(FieldBinding targetField, boolean isReadAccess) {
        if (this.synthetics == null) {
            this.synthetics = new HashMap[4];
        }
        if (this.synthetics[0] == null) {
            this.synthetics[0] = new HashMap(5);
        }
        SyntheticMethodBinding accessMethod = null;
        SyntheticMethodBinding[] accessors = (SyntheticMethodBinding[])this.synthetics[0].get(targetField);
        if (accessors == null) {
            accessMethod = new SyntheticMethodBinding(targetField, isReadAccess, (ReferenceBinding)this);
            accessors = new SyntheticMethodBinding[2];
            this.synthetics[0].put(targetField, accessors);
            accessors[isReadAccess ? 0 : 1] = accessMethod;
        } else {
            accessMethod = accessors[isReadAccess ? 0 : 1];
            if (accessMethod == null) {
                accessMethod = new SyntheticMethodBinding(targetField, isReadAccess, (ReferenceBinding)this);
                accessors[isReadAccess ? 0 : 1] = accessMethod;
            }
        }
        return accessMethod;
    }

    public SyntheticMethodBinding addSyntheticEnumMethod(char[] selector) {
        if (this.synthetics == null) {
            this.synthetics = new HashMap[4];
        }
        if (this.synthetics[0] == null) {
            this.synthetics[0] = new HashMap(5);
        }
        SyntheticMethodBinding accessMethod = null;
        SyntheticMethodBinding[] accessors = (SyntheticMethodBinding[])this.synthetics[0].get(selector);
        if (accessors == null) {
            accessMethod = new SyntheticMethodBinding(this, selector);
            accessors = new SyntheticMethodBinding[2];
            this.synthetics[0].put(selector, accessors);
            accessors[0] = accessMethod;
        } else {
            accessMethod = accessors[0];
            if (accessMethod == null) {
                accessors[0] = accessMethod = new SyntheticMethodBinding(this, selector);
            }
        }
        return accessMethod;
    }

    public SyntheticMethodBinding addSyntheticMethod(MethodBinding targetMethod, boolean isSuperAccess) {
        if (this.synthetics == null) {
            this.synthetics = new HashMap[4];
        }
        if (this.synthetics[0] == null) {
            this.synthetics[0] = new HashMap(5);
        }
        SyntheticMethodBinding accessMethod = null;
        SyntheticMethodBinding[] accessors = (SyntheticMethodBinding[])this.synthetics[0].get(targetMethod);
        if (accessors == null) {
            accessMethod = new SyntheticMethodBinding(targetMethod, isSuperAccess, (ReferenceBinding)this);
            accessors = new SyntheticMethodBinding[2];
            this.synthetics[0].put(targetMethod, accessors);
            accessors[isSuperAccess ? 0 : 1] = accessMethod;
        } else {
            accessMethod = accessors[isSuperAccess ? 0 : 1];
            if (accessMethod == null) {
                accessMethod = new SyntheticMethodBinding(targetMethod, isSuperAccess, (ReferenceBinding)this);
                accessors[isSuperAccess ? 0 : 1] = accessMethod;
            }
        }
        return accessMethod;
    }

    public SyntheticMethodBinding addSyntheticBridgeMethod(MethodBinding inheritedMethodToBridge, MethodBinding localTargetMethod) {
        if (!this.isClass()) {
            return null;
        }
        if (inheritedMethodToBridge.returnType.erasure() == localTargetMethod.returnType.erasure() && inheritedMethodToBridge.areParameterErasuresEqual(localTargetMethod)) {
            return null;
        }
        if (this.synthetics == null) {
            this.synthetics = new HashMap[4];
        }
        if (this.synthetics[0] == null) {
            this.synthetics[0] = new HashMap(5);
        } else {
            Iterator synthMethods = this.synthetics[0].keySet().iterator();
            while (synthMethods.hasNext()) {
                Object synthetic = synthMethods.next();
                if (!(synthetic instanceof MethodBinding)) continue;
                MethodBinding method = (MethodBinding)synthetic;
                if (!CharOperation.equals(inheritedMethodToBridge.selector, method.selector) || inheritedMethodToBridge.returnType.erasure() != method.returnType.erasure() || !inheritedMethodToBridge.areParameterErasuresEqual(method)) continue;
                return null;
            }
        }
        SyntheticMethodBinding accessMethod = null;
        SyntheticMethodBinding[] accessors = (SyntheticMethodBinding[])this.synthetics[0].get(inheritedMethodToBridge);
        if (accessors == null) {
            accessMethod = new SyntheticMethodBinding(inheritedMethodToBridge, localTargetMethod);
            accessors = new SyntheticMethodBinding[2];
            this.synthetics[0].put(inheritedMethodToBridge, accessors);
            accessors[1] = accessMethod;
        } else {
            accessMethod = accessors[1];
            if (accessMethod == null) {
                accessors[1] = accessMethod = new SyntheticMethodBinding(inheritedMethodToBridge, localTargetMethod);
            }
        }
        return accessMethod;
    }

    public void collectSubstitutes(TypeBinding otherType, Map substitutes) {
        if (otherType instanceof ReferenceBinding) {
            TypeBinding[] otherElements;
            TypeBinding[] elements;
            TypeVariableBinding[] variables = this.typeVariables;
            if (variables == TypeConstants.NoTypeVariables) {
                return;
            }
            ReferenceBinding equivalent = this;
            ReferenceBinding otherEquivalent = ((ReferenceBinding)otherType).findSuperTypeErasingTo(this);
            if (otherEquivalent == null) {
                equivalent = this.findSuperTypeErasingTo((ReferenceBinding)otherType.erasure());
                if (equivalent == null) {
                    return;
                }
                otherEquivalent = (ReferenceBinding)otherType;
            }
            switch (((TypeBinding)equivalent).kind()) {
                case 1028: {
                    elements = ((TypeBinding)equivalent).typeVariables();
                    break;
                }
                case 132: {
                    elements = ((ParameterizedTypeBinding)equivalent).arguments;
                    break;
                }
                default: {
                    return;
                }
            }
            switch (otherEquivalent.kind()) {
                case 1028: {
                    otherElements = otherEquivalent.typeVariables();
                    break;
                }
                case 132: {
                    otherElements = ((ParameterizedTypeBinding)otherEquivalent).arguments;
                    break;
                }
                case 516: {
                    substitutes.clear();
                    return;
                }
                default: {
                    return;
                }
            }
            int i = 0;
            int length = elements.length;
            while (i < length) {
                elements[i].collectSubstitutes(otherElements[i], substitutes);
                ++i;
            }
        }
    }

    public int kind() {
        if (this.typeVariables != TypeConstants.NoTypeVariables) {
            return 1028;
        }
        return 4;
    }

    void faultInTypesForFieldsAndMethods() {
        this.fields();
        this.methods();
        int i = 0;
        int length = this.memberTypes.length;
        while (i < length) {
            ((SourceTypeBinding)this.memberTypes[i]).faultInTypesForFieldsAndMethods();
            ++i;
        }
    }

    /*
     * Exception decompiling
     */
    public FieldBinding[] fields() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 150->153)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public char[] genericTypeSignature() {
        if (this.genericReferenceTypeSignature == null) {
            if (this.typeVariables == TypeConstants.NoTypeVariables) {
                this.genericReferenceTypeSignature = this.signature();
            } else {
                char[] typeSig = this.signature();
                StringBuffer sig = new StringBuffer(10);
                int i = 0;
                while (i < typeSig.length - 1) {
                    sig.append(typeSig[i]);
                    ++i;
                }
                sig.append('<');
                i = 0;
                int length = this.typeVariables.length;
                while (i < length) {
                    sig.append(this.typeVariables[i].genericTypeSignature());
                    ++i;
                }
                sig.append(">;");
                int sigLength = sig.length();
                this.genericReferenceTypeSignature = new char[sigLength];
                sig.getChars(0, sigLength, this.genericReferenceTypeSignature, 0);
            }
        }
        return this.genericReferenceTypeSignature;
    }

    public char[] genericSignature() {
        int length;
        int i;
        StringBuffer sig = null;
        if (this.typeVariables != TypeConstants.NoTypeVariables) {
            sig = new StringBuffer(10);
            sig.append('<');
            i = 0;
            length = this.typeVariables.length;
            while (i < length) {
                sig.append(this.typeVariables[i].genericSignature());
                ++i;
            }
            sig.append('>');
        } else {
            block9: {
                if (this.superclass == null || !this.superclass.isParameterizedType()) {
                    i = 0;
                    length = this.superInterfaces.length;
                    while (i < length) {
                        if (!this.superInterfaces[i].isParameterizedType()) {
                            ++i;
                            continue;
                        }
                        break block9;
                    }
                    return null;
                }
            }
            sig = new StringBuffer(10);
        }
        if (this.superclass != null) {
            sig.append(this.superclass.genericTypeSignature());
        } else {
            sig.append(this.scope.getJavaLangObject().genericTypeSignature());
        }
        i = 0;
        length = this.superInterfaces.length;
        while (i < length) {
            sig.append(this.superInterfaces[i].genericTypeSignature());
            ++i;
        }
        return sig.toString().toCharArray();
    }

    public long getAnnotationTagBits() {
        if ((this.tagBits & 0x200000000L) == 0L) {
            TypeDeclaration typeDecl = this.scope.referenceContext;
            ASTNode.resolveAnnotations(typeDecl.staticInitializerScope, typeDecl.annotations, this);
        }
        return this.tagBits;
    }

    public MethodBinding[] getDefaultAbstractMethods() {
        int count = 0;
        int i = this.methods.length;
        while (--i >= 0) {
            if (!this.methods[i].isDefaultAbstract()) continue;
            ++count;
        }
        if (count == 0) {
            return TypeConstants.NoMethods;
        }
        MethodBinding[] result = new MethodBinding[count];
        count = 0;
        int i2 = this.methods.length;
        while (--i2 >= 0) {
            if (!this.methods[i2].isDefaultAbstract()) continue;
            result[count++] = this.methods[i2];
        }
        return result;
    }

    public MethodBinding getExactConstructor(TypeBinding[] argumentTypes) {
        int argCount = argumentTypes.length;
        if ((this.modifiers & 0x2000000) == 0) {
            int m = this.methods.length;
            block0: while (--m >= 0) {
                MethodBinding method = this.methods[m];
                if (method.selector != TypeConstants.INIT || method.parameters.length != argCount) continue;
                TypeBinding[] toMatch = method.parameters;
                int p = 0;
                while (p < argCount) {
                    if (toMatch[p] != argumentTypes[p]) continue block0;
                    ++p;
                }
                return method;
            }
        } else {
            MethodBinding[] constructors = this.getMethods(TypeConstants.INIT);
            int c = constructors.length;
            block2: while (--c >= 0) {
                MethodBinding constructor = constructors[c];
                TypeBinding[] toMatch = constructor.parameters;
                if (toMatch.length != argCount) continue;
                int p = 0;
                while (p < argCount) {
                    if (toMatch[p] != argumentTypes[p]) continue block2;
                    ++p;
                }
                return constructor;
            }
        }
        return null;
    }

    public MethodBinding getExactMethod(char[] selector, TypeBinding[] argumentTypes, CompilationUnitScope refScope) {
        if (this.memberFinder != null) {
            return this.memberFinder.getExactMethod(this, selector, argumentTypes, refScope);
        }
        return this.getExactMethodBase(selector, argumentTypes, refScope);
    }

    public MethodBinding getExactMethodBase(char[] selector, TypeBinding[] argumentTypes, CompilationUnitScope refScope) {
        int argCount = argumentTypes.length;
        int selectorLength = selector.length;
        boolean foundNothing = true;
        if ((this.modifiers & 0x2000000) == 0) {
            int m = this.methods.length;
            block0: while (--m >= 0) {
                MethodBinding method = this.methods[m];
                if (method.selector.length != selectorLength || !CharOperation.equals(method.selector, selector)) continue;
                foundNothing = false;
                if (method.parameters.length != argCount) continue;
                TypeBinding[] toMatch = method.parameters;
                int p = 0;
                while (p < argCount) {
                    if (toMatch[p] != argumentTypes[p]) continue block0;
                    ++p;
                }
                return method;
            }
        } else {
            MethodBinding[] matchingMethods = this.getMethods(selector);
            foundNothing = matchingMethods == TypeConstants.NoMethods;
            int m = matchingMethods.length;
            block2: while (--m >= 0) {
                MethodBinding method = matchingMethods[m];
                TypeBinding[] toMatch = method.parameters;
                if (toMatch.length != argCount) continue;
                int p = 0;
                while (p < argCount) {
                    if (toMatch[p] != argumentTypes[p]) continue block2;
                    ++p;
                }
                return method;
            }
        }
        if (foundNothing) {
            if (this.isInterface()) {
                if (this.superInterfaces.length == 1) {
                    if (refScope != null) {
                        refScope.recordTypeReference(this.superInterfaces[0]);
                    }
                    return this.superInterfaces[0].getExactMethod(selector, argumentTypes, refScope);
                }
            } else if (this.superclass != null) {
                if (refScope != null) {
                    refScope.recordTypeReference(this.superclass);
                }
                return this.superclass.getExactMethod(selector, argumentTypes, refScope);
            }
        }
        return null;
    }

    public FieldBinding getField(char[] fieldName, boolean needResolve) {
        if (this.memberFinder != null) {
            return this.memberFinder.getField(this, fieldName, null, null);
        }
        return this.getFieldBase(fieldName, needResolve);
    }

    public FieldBinding getField(char[] fieldName, boolean needResolve, InvocationSite site, Scope scope) {
        if (this.memberFinder != null) {
            return this.memberFinder.getField(this, fieldName, site, scope);
        }
        return this.getFieldBase(fieldName, needResolve);
    }

    public FieldBinding getFieldBase(char[] fieldName, boolean needResolve) {
        int fieldLength = fieldName.length;
        int i = 0;
        int length = this.fields.length;
        while (i < length) {
            FieldBinding field = this.fields[i];
            if (field.name.length == fieldLength && CharOperation.equals(field.name, fieldName)) {
                FieldBinding fieldBinding;
                block9: {
                    FieldBinding result = null;
                    try {
                        fieldBinding = result = this.resolveTypeFor(field);
                        Object var8_9 = null;
                        if (result != null) break block9;
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        if (result == null) {
                            int newSize = this.fields.length - 1;
                            if (newSize == 0) {
                                this.fields = TypeConstants.NoFields;
                            } else {
                                FieldBinding[] newFields = new FieldBinding[newSize];
                                System.arraycopy(this.fields, 0, newFields, 0, i);
                                System.arraycopy(this.fields, i + 1, newFields, i, newSize - i);
                                this.fields = newFields;
                            }
                        }
                        throw throwable;
                    }
                    int newSize = this.fields.length - 1;
                    if (newSize == 0) {
                        this.fields = TypeConstants.NoFields;
                    } else {
                        FieldBinding[] newFields = new FieldBinding[newSize];
                        System.arraycopy(this.fields, 0, newFields, 0, i);
                        System.arraycopy(this.fields, i + 1, newFields, i, newSize - i);
                        this.fields = newFields;
                    }
                }
                return fieldBinding;
            }
            ++i;
        }
        return null;
    }

    public MethodBinding[] getMethods(char[] selector) {
        if (this.memberFinder != null) {
            return this.memberFinder.getMethods(this, selector);
        }
        return this.getMethodsBase(selector);
    }

    public MethodBinding[] getMethodsBase(char[] selector) {
        int selectorLength = selector.length;
        boolean methodsAreResolved = (this.modifiers & 0x2000000) == 0;
        ArrayList<MethodBinding> matchingMethods = null;
        int i = 0;
        int length = this.methods.length;
        while (i < length) {
            MethodBinding method = this.methods[i];
            if (method.selector.length == selectorLength && CharOperation.equals(method.selector, selector)) {
                if (!methodsAreResolved && this.resolveTypesFor(method) == null || method.returnType == null) {
                    this.methods();
                    return this.getMethods(selector);
                }
                if (matchingMethods == null) {
                    matchingMethods = new ArrayList<MethodBinding>(2);
                }
                matchingMethods.add(method);
            }
            ++i;
        }
        if (matchingMethods == null) {
            return TypeConstants.NoMethods;
        }
        MethodBinding[] result = new MethodBinding[matchingMethods.size()];
        matchingMethods.toArray(result);
        if (!methodsAreResolved) {
            int i2 = 0;
            int length2 = result.length - 1;
            while (i2 < length2) {
                MethodBinding method = result[i2];
                int j = length2;
                while (j > i2) {
                    boolean paramsMatch;
                    boolean bl = paramsMatch = this.fPackage.environment.options.sourceLevel >= 0x310000L ? method.areParameterErasuresEqual(result[j]) : method.areParametersEqual(result[j]);
                    if (paramsMatch) {
                        this.methods();
                        return this.getMethods(selector);
                    }
                    --j;
                }
                ++i2;
            }
        }
        return result;
    }

    public FieldBinding getSyntheticField(LocalVariableBinding actualOuterLocalVariable) {
        if (this.synthetics == null || this.synthetics[1] == null) {
            return null;
        }
        return (FieldBinding)this.synthetics[1].get(actualOuterLocalVariable);
    }

    public SyntheticMethodBinding getSyntheticBridgeMethod(MethodBinding inheritedMethodToBridge) {
        if (this.synthetics == null) {
            return null;
        }
        if (this.synthetics[0] == null) {
            return null;
        }
        SyntheticMethodBinding[] accessors = (SyntheticMethodBinding[])this.synthetics[0].get(inheritedMethodToBridge);
        if (accessors == null) {
            return null;
        }
        return accessors[1];
    }

    public boolean isEquivalentTo(TypeBinding otherType) {
        if (this == otherType) {
            return true;
        }
        if (otherType == null) {
            return false;
        }
        switch (otherType.kind()) {
            case 260: {
                return ((WildcardBinding)otherType).boundCheck(this);
            }
            case 132: {
                int otherLength;
                ReferenceBinding enclosing;
                if (!((otherType.tagBits & 0x40000000L) != 0L || this.isMemberType() && otherType.isMemberType())) {
                    return false;
                }
                ParameterizedTypeBinding otherParamType = (ParameterizedTypeBinding)otherType;
                if (this != otherParamType.type) {
                    return false;
                }
                if (!this.isStatic() && (enclosing = this.enclosingType()) != null && !enclosing.isEquivalentTo(otherParamType.enclosingType())) {
                    return false;
                }
                int length = this.typeVariables == null ? 0 : this.typeVariables.length;
                TypeBinding[] otherArguments = otherParamType.arguments;
                int n = otherLength = otherArguments == null ? 0 : otherArguments.length;
                if (otherLength != length) {
                    return false;
                }
                int i = 0;
                while (i < length) {
                    if (!this.typeVariables[i].isTypeArgumentContainedBy(otherArguments[i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            case 516: {
                return otherType.erasure() == this;
            }
        }
        return false;
    }

    public boolean isGenericType() {
        return this.typeVariables != TypeConstants.NoTypeVariables;
    }

    public ReferenceBinding[] memberTypes() {
        return this.memberTypes;
    }

    public FieldBinding getUpdatedFieldBinding(FieldBinding targetField, ReferenceBinding newDeclaringClass) {
        FieldBinding updatedField;
        Hashtable<ReferenceBinding, FieldBinding> fieldMap;
        if (this.synthetics == null) {
            this.synthetics = new HashMap[4];
        }
        if (this.synthetics[3] == null) {
            this.synthetics[3] = new HashMap(5);
        }
        if ((fieldMap = (Hashtable<ReferenceBinding, FieldBinding>)this.synthetics[3].get(targetField)) == null) {
            fieldMap = new Hashtable<ReferenceBinding, FieldBinding>(5);
            this.synthetics[3].put(targetField, fieldMap);
        }
        if ((updatedField = (FieldBinding)fieldMap.get(newDeclaringClass)) == null) {
            updatedField = new FieldBinding(targetField, newDeclaringClass);
            fieldMap.put(newDeclaringClass, updatedField);
        }
        return updatedField;
    }

    public MethodBinding getUpdatedMethodBinding(MethodBinding targetMethod, ReferenceBinding newDeclaringClass) {
        MethodBinding updatedMethod;
        Hashtable<ReferenceBinding, MethodBinding> methodMap;
        if (this.synthetics == null) {
            this.synthetics = new HashMap[4];
        }
        if (this.synthetics[3] == null) {
            this.synthetics[3] = new HashMap(5);
        }
        if ((methodMap = (Hashtable<ReferenceBinding, MethodBinding>)this.synthetics[3].get(targetMethod)) == null) {
            methodMap = new Hashtable<ReferenceBinding, MethodBinding>(5);
            this.synthetics[3].put(targetMethod, methodMap);
        }
        if ((updatedMethod = (MethodBinding)methodMap.get(newDeclaringClass)) == null) {
            updatedMethod = new MethodBinding(targetMethod, newDeclaringClass);
            methodMap.put(newDeclaringClass, updatedMethod);
        }
        return updatedMethod;
    }

    public boolean hasMemberTypes() {
        return this.memberTypes.length > 0;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MethodBinding[] methods() {
        block24: {
            block23: {
                block25: {
                    if ((this.modifiers & 0x2000000) == 0) {
                        return this.methods;
                    }
                    failed = 0;
                    try {
                        i = 0;
                        length = this.methods.length;
                        while (i < length) {
                            if (this.resolveTypesFor(this.methods[i]) == null) {
                                this.methods[i] = null;
                                ++failed;
                            }
                            ++i;
                        }
                        i = 0;
                        length = this.methods.length;
                        while (i < length) {
                            method = this.methods[i];
                            if (method != null) {
                                methodDecl = null;
                                j = length - 1;
                                while (j > i) {
                                    method2 = this.methods[j];
                                    if (method2 != null && CharOperation.equals(method.selector, method2.selector)) {
                                        v0 = paramsMatch = this.fPackage.environment.options.sourceLevel >= 0x310000L ? method.areParameterErasuresEqual(method2) : method.areParametersEqual(method2);
                                        if (paramsMatch) {
                                            v1 = isEnumSpecialMethod = this.isEnum() != false && (method.selector == TypeConstants.VALUEOF || method.selector == TypeConstants.VALUES);
                                            if (methodDecl == null && (methodDecl = method.sourceMethod()) != null && methodDecl.binding != null) {
                                                if (isEnumSpecialMethod) {
                                                    this.scope.problemReporter().duplicateEnumSpecialMethod(this, methodDecl);
                                                } else {
                                                    this.scope.problemReporter().duplicateMethodInType(this, methodDecl);
                                                }
                                                methodDecl.binding = null;
                                                this.methods[i] = null;
                                                ++failed;
                                            }
                                            if ((method2Decl = method2.sourceMethod()) != null && method2Decl.binding != null) {
                                                if (isEnumSpecialMethod) {
                                                    this.scope.problemReporter().duplicateEnumSpecialMethod(this, method2Decl);
                                                } else {
                                                    this.scope.problemReporter().duplicateMethodInType(this, method2Decl);
                                                }
                                                method2Decl.binding = null;
                                                this.methods[j] = null;
                                                ++failed;
                                            }
                                        }
                                    }
                                    --j;
                                }
                                if (method.returnType == null && methodDecl == null) {
                                    method.sourceMethod().binding = null;
                                    this.methods[i] = null;
                                    ++failed;
                                }
                            }
                            ++i;
                        }
                    }
                    catch (Throwable var12_11) {
                        var11_12 = null;
                        if (failed <= 0) break block23;
                        newSize = this.methods.length - failed;
                        if (newSize == 0) {
                            this.methods = TypeConstants.NoMethods;
                            break block23;
                        }
                        newMethods = new MethodBinding[newSize];
                        i = 0;
                        j = 0;
                        length = this.methods.length;
                        if (true) ** GOTO lbl80
                    }
                    {
                        var11_13 = null;
                        if (failed <= 0) break block24;
                    }
                    newSize = this.methods.length - failed;
                    if (newSize != 0) break block25;
                    this.methods = TypeConstants.NoMethods;
                    break block24;
                }
                newMethods = new MethodBinding[newSize];
                i = 0;
                j = 0;
                length = this.methods.length;
                if (true) ** GOTO lbl90
                do {
                    if (this.methods[i] != null) {
                        newMethods[j++] = this.methods[i];
                    }
                    ++i;
lbl80:
                    // 2 sources

                } while (i < length);
                this.methods = newMethods;
            }
            this.addDefaultAbstractMethods();
            this.modifiers &= -33554433;
            throw var12_11;
            do {
                if (this.methods[i] != null) {
                    newMethods[j++] = this.methods[i];
                }
                ++i;
lbl90:
                // 2 sources

            } while (i < length);
            this.methods = newMethods;
        }
        this.addDefaultAbstractMethods();
        this.modifiers &= -33554433;
        return this.methods;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private FieldBinding resolveTypeFor(FieldBinding field) {
        FieldBinding previousField;
        block12: {
            FieldBinding fieldBinding;
            block11: {
                FieldBinding fieldBinding2;
                block10: {
                    if ((field.modifiers & 0x2000000) == 0) {
                        return field;
                    }
                    FieldDeclaration[] fieldDecls = this.scope.referenceContext.fields;
                    int f = 0;
                    int length = fieldDecls.length;
                    while (true) {
                        if (f >= length) {
                            return null;
                        }
                        if (fieldDecls[f].binding == field) break;
                        ++f;
                    }
                    MethodScope initializationScope = field.isStatic() ? this.scope.referenceContext.staticInitializerScope : this.scope.referenceContext.initializerScope;
                    previousField = initializationScope.initializedField;
                    try {
                        initializationScope.initializedField = field;
                        FieldDeclaration fieldDecl = fieldDecls[f];
                        SourceTypeBinding fieldType = fieldDecl.getKind() == 3 ? this : fieldDecl.type.resolveType(initializationScope, true);
                        field.type = fieldType;
                        field.modifiers &= 0xFDFFFFFF;
                        if (fieldType == null) {
                            fieldDecls[f].binding = null;
                            FieldBinding fieldBinding3 = null;
                            Object var9_12 = null;
                            initializationScope.initializedField = previousField;
                            return fieldBinding3;
                        }
                        if (fieldType == BaseTypes.VoidBinding) {
                            this.scope.problemReporter().variableTypeCannotBeVoid(fieldDecls[f]);
                            fieldDecls[f].binding = null;
                            fieldBinding2 = null;
                            break block10;
                        }
                        if (fieldType.isArrayType() && ((ArrayBinding)((Object)fieldType)).leafComponentType == BaseTypes.VoidBinding) {
                            this.scope.problemReporter().variableTypeCannotBeVoidArray(fieldDecls[f]);
                            fieldDecls[f].binding = null;
                            fieldBinding = null;
                            break block11;
                        }
                        if (fieldType instanceof ReferenceBinding && (((ReferenceBinding)fieldType).modifiers & 0x40000000) != 0) {
                            field.modifiers |= 0x40000000;
                        }
                        break block12;
                    }
                    catch (Throwable throwable) {
                        Object var9_15 = null;
                        initializationScope.initializedField = previousField;
                        throw throwable;
                    }
                }
                Object var9_13 = null;
                initializationScope.initializedField = previousField;
                return fieldBinding2;
            }
            Object var9_14 = null;
            initializationScope.initializedField = previousField;
            return fieldBinding;
        }
        Object var9_16 = null;
        initializationScope.initializedField = previousField;
        return field;
    }

    public MethodBinding resolveTypesFor(MethodBinding method) {
        TypeReference[] exceptionTypes;
        if ((method.modifiers & 0x2000000) == 0) {
            return method;
        }
        AbstractMethodDeclaration methodDecl = method.sourceMethod();
        if (methodDecl == null) {
            return null;
        }
        TypeParameter[] typeParameters = methodDecl.typeParameters();
        if (typeParameters != null) {
            methodDecl.scope.connectTypeVariables(typeParameters);
            int i = 0;
            int paramLength = typeParameters.length;
            while (i < paramLength) {
                typeParameters[i].checkBounds(methodDecl.scope);
                ++i;
            }
        }
        if ((exceptionTypes = methodDecl.thrownExceptions) != null) {
            int size = exceptionTypes.length;
            method.thrownExceptions = new ReferenceBinding[size];
            ReferenceBinding throwable = this.scope.getJavaLangThrowable();
            int count = 0;
            int i = 0;
            while (i < size) {
                ReferenceBinding resolvedExceptionType = (ReferenceBinding)exceptionTypes[i].resolveType(methodDecl.scope, true);
                if (resolvedExceptionType != null) {
                    if (resolvedExceptionType.isGenericType() || resolvedExceptionType.isParameterizedType()) {
                        methodDecl.scope.problemReporter().invalidParameterizedExceptionType(resolvedExceptionType, exceptionTypes[i]);
                    } else if (throwable != resolvedExceptionType && !throwable.isSuperclassOf(resolvedExceptionType)) {
                        methodDecl.scope.problemReporter().cannotThrowType(this, methodDecl, exceptionTypes[i], resolvedExceptionType);
                    } else {
                        if ((resolvedExceptionType.modifiers & 0x40000000) != 0) {
                            method.modifiers |= 0x40000000;
                        }
                        method.thrownExceptions[count++] = resolvedExceptionType;
                    }
                }
                ++i;
            }
            if (count < size) {
                method.thrownExceptions = new ReferenceBinding[count];
                System.arraycopy(method.thrownExceptions, 0, method.thrownExceptions, 0, count);
            }
        }
        boolean foundArgProblem = false;
        Argument[] arguments = methodDecl.arguments;
        if (arguments != null) {
            int size = arguments.length;
            method.parameters = new TypeBinding[size];
            int i = 0;
            while (i < size) {
                Argument arg = arguments[i];
                TypeBinding parameterType = arg.type.resolveType(methodDecl.scope, true);
                if (parameterType == null) {
                    foundArgProblem = true;
                } else if (parameterType == BaseTypes.VoidBinding) {
                    methodDecl.scope.problemReporter().argumentTypeCannotBeVoid(this, methodDecl, arg);
                    foundArgProblem = true;
                } else if (parameterType.isArrayType() && ((ArrayBinding)parameterType).leafComponentType == BaseTypes.VoidBinding) {
                    methodDecl.scope.problemReporter().argumentTypeCannotBeVoidArray(this, methodDecl, arg);
                    foundArgProblem = true;
                } else {
                    if (parameterType instanceof ReferenceBinding && (((ReferenceBinding)parameterType).modifiers & 0x40000000) != 0) {
                        method.modifiers |= 0x40000000;
                    }
                    method.parameters[i] = parameterType;
                }
                ++i;
            }
        }
        boolean foundReturnTypeProblem = false;
        if (!method.isConstructor()) {
            TypeReference returnType;
            TypeReference typeReference = returnType = methodDecl instanceof MethodDeclaration ? ((MethodDeclaration)methodDecl).returnType : ((AnnotationMethodDeclaration)methodDecl).returnType;
            if (returnType == null) {
                methodDecl.scope.problemReporter().missingReturnType(methodDecl);
                method.returnType = null;
                foundReturnTypeProblem = true;
            } else {
                TypeBinding methodType = returnType.resolveType(methodDecl.scope, true);
                if (methodType == null) {
                    foundReturnTypeProblem = true;
                } else if (methodType.isArrayType() && ((ArrayBinding)methodType).leafComponentType == BaseTypes.VoidBinding) {
                    methodDecl.scope.problemReporter().returnTypeCannotBeVoidArray(this, (MethodDeclaration)methodDecl);
                    foundReturnTypeProblem = true;
                } else {
                    method.returnType = methodType;
                    if (methodType instanceof ReferenceBinding && (((ReferenceBinding)methodType).modifiers & 0x40000000) != 0) {
                        method.modifiers |= 0x40000000;
                    }
                }
            }
        }
        if (foundArgProblem) {
            methodDecl.binding = null;
            if (typeParameters != null) {
                int i = 0;
                int length = typeParameters.length;
                while (i < length) {
                    TypeParameter parameter = typeParameters[i];
                    parameter.binding = null;
                    ++i;
                }
            }
            return null;
        }
        if (foundReturnTypeProblem) {
            return method;
        }
        method.modifiers &= 0xFDFFFFFF;
        return method;
    }

    public final int sourceEnd() {
        return this.scope.referenceContext.sourceEnd;
    }

    public final int sourceStart() {
        return this.scope.referenceContext.sourceStart;
    }

    public ReferenceBinding superclass() {
        return this.superclass;
    }

    public ReferenceBinding[] superInterfaces() {
        return this.superInterfaces;
    }

    public SyntheticMethodBinding[] syntheticMethods() {
        if (this.synthetics == null || this.synthetics[0] == null || this.synthetics[0].size() == 0) {
            return null;
        }
        int index = 0;
        SyntheticMethodBinding[] bindings = new SyntheticMethodBinding[1];
        Iterator fieldsOrMethods = this.synthetics[0].keySet().iterator();
        while (fieldsOrMethods.hasNext()) {
            int numberOfAccessors;
            Object fieldOrMethod = fieldsOrMethods.next();
            if (fieldOrMethod instanceof MethodBinding) {
                SyntheticMethodBinding[] methodAccessors = (SyntheticMethodBinding[])this.synthetics[0].get(fieldOrMethod);
                numberOfAccessors = 0;
                if (methodAccessors[0] != null) {
                    ++numberOfAccessors;
                }
                if (methodAccessors[1] != null) {
                    ++numberOfAccessors;
                }
                if (index + numberOfAccessors > bindings.length) {
                    SyntheticMethodBinding[] syntheticMethodBindingArray = bindings;
                    bindings = new SyntheticMethodBinding[index + numberOfAccessors];
                    System.arraycopy(syntheticMethodBindingArray, 0, bindings, 0, index);
                }
                if (methodAccessors[0] != null) {
                    bindings[index++] = methodAccessors[0];
                }
                if (methodAccessors[1] == null) continue;
                bindings[index++] = methodAccessors[1];
                continue;
            }
            SyntheticMethodBinding[] fieldAccessors = (SyntheticMethodBinding[])this.synthetics[0].get(fieldOrMethod);
            numberOfAccessors = 0;
            if (fieldAccessors[0] != null) {
                ++numberOfAccessors;
            }
            if (fieldAccessors[1] != null) {
                ++numberOfAccessors;
            }
            if (index + numberOfAccessors > bindings.length) {
                SyntheticMethodBinding[] syntheticMethodBindingArray = bindings;
                bindings = new SyntheticMethodBinding[index + numberOfAccessors];
                System.arraycopy(syntheticMethodBindingArray, 0, bindings, 0, index);
            }
            if (fieldAccessors[0] != null) {
                bindings[index++] = fieldAccessors[0];
            }
            if (fieldAccessors[1] == null) continue;
            bindings[index++] = fieldAccessors[1];
        }
        int length = bindings.length;
        SyntheticMethodBinding[] sortedBindings = new SyntheticMethodBinding[length];
        int i = 0;
        while (i < length) {
            SyntheticMethodBinding binding;
            sortedBindings[binding.index] = binding = bindings[i];
            ++i;
        }
        return sortedBindings;
    }

    public FieldBinding[] syntheticFields() {
        SyntheticFieldBinding synthBinding;
        int i;
        Iterator elements;
        int literalSize;
        if (this.synthetics == null) {
            return null;
        }
        int fieldSize = this.synthetics[1] == null ? 0 : this.synthetics[1].size();
        int totalSize = fieldSize + (literalSize = this.synthetics[2] == null ? 0 : this.synthetics[2].size());
        if (totalSize == 0) {
            return null;
        }
        FieldBinding[] bindings = new FieldBinding[totalSize];
        if (this.synthetics[1] != null) {
            elements = this.synthetics[1].values().iterator();
            i = 0;
            while (i < fieldSize) {
                synthBinding = (SyntheticFieldBinding)elements.next();
                bindings[synthBinding.index] = synthBinding;
                ++i;
            }
        }
        if (this.synthetics[2] != null) {
            elements = this.synthetics[2].values().iterator();
            i = 0;
            while (i < literalSize) {
                synthBinding = (SyntheticFieldBinding)elements.next();
                bindings[fieldSize + synthBinding.index] = synthBinding;
                ++i;
            }
        }
        return bindings;
    }

    public String toString() {
        int length;
        int i;
        StringBuffer buffer = new StringBuffer(30);
        buffer.append("(id=");
        if (this.id == Integer.MAX_VALUE) {
            buffer.append("NoId");
        } else {
            buffer.append(this.id);
        }
        buffer.append(")\n");
        if (this.isDeprecated()) {
            buffer.append("deprecated ");
        }
        if (this.isPublic()) {
            buffer.append("public ");
        }
        if (this.isProtected()) {
            buffer.append("protected ");
        }
        if (this.isPrivate()) {
            buffer.append("private ");
        }
        if (this.isAbstract() && this.isClass()) {
            buffer.append("abstract ");
        }
        if (this.isStatic() && this.isNestedType()) {
            buffer.append("static ");
        }
        if (this.isFinal()) {
            buffer.append("final ");
        }
        buffer.append(this.isInterface() ? "interface " : "class ");
        buffer.append(this.compoundName != null ? CharOperation.toString(this.compoundName) : "UNNAMED TYPE");
        if (this.typeVariables != null && this.typeVariables != TypeConstants.NoTypeVariables) {
            buffer.append("\n\t<");
            i = 0;
            length = this.typeVariables.length;
            while (i < length) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(this.typeVariables[i] != null ? this.typeVariables[i].toString() : "NULL TYPE VARIABLE");
                ++i;
            }
            buffer.append(">");
        } else {
            buffer.append("<NULL TYPE VARIABLES>");
        }
        buffer.append("\n\textends ");
        buffer.append(this.superclass != null ? this.superclass.debugName() : "NULL TYPE");
        if (this.superInterfaces != null) {
            if (this.superInterfaces != TypeConstants.NoSuperInterfaces) {
                buffer.append("\n\timplements : ");
                i = 0;
                length = this.superInterfaces.length;
                while (i < length) {
                    if (i > 0) {
                        buffer.append(", ");
                    }
                    buffer.append(this.superInterfaces[i] != null ? this.superInterfaces[i].debugName() : "NULL TYPE");
                    ++i;
                }
            }
        } else {
            buffer.append("NULL SUPERINTERFACES");
        }
        if (this.enclosingType() != null) {
            buffer.append("\n\tenclosing type : ");
            buffer.append(this.enclosingType().debugName());
        }
        if (this.fields != null) {
            if (this.fields != TypeConstants.NoFields) {
                buffer.append("\n/*   fields   */");
                i = 0;
                length = this.fields.length;
                while (i < length) {
                    buffer.append('\n').append(this.fields[i] != null ? this.fields[i].toString() : "NULL FIELD");
                    ++i;
                }
            }
        } else {
            buffer.append("NULL FIELDS");
        }
        if (this.methods != null) {
            if (this.methods != TypeConstants.NoMethods) {
                buffer.append("\n/*   methods   */");
                i = 0;
                length = this.methods.length;
                while (i < length) {
                    buffer.append('\n').append(this.methods[i] != null ? this.methods[i].toString() : "NULL METHOD");
                    ++i;
                }
            }
        } else {
            buffer.append("NULL METHODS");
        }
        if (this.memberTypes != null) {
            if (this.memberTypes != TypeConstants.NoMemberTypes) {
                buffer.append("\n/*   members   */");
                i = 0;
                length = this.memberTypes.length;
                while (i < length) {
                    buffer.append('\n').append(this.memberTypes[i] != null ? this.memberTypes[i].toString() : "NULL TYPE");
                    ++i;
                }
            }
        } else {
            buffer.append("NULL MEMBER TYPES");
        }
        buffer.append("\n\n");
        return buffer.toString();
    }

    public TypeVariableBinding[] typeVariables() {
        return this.typeVariables;
    }

    void verifyMethods(MethodVerifier verifier) {
        verifier.verify(this);
        int i = this.memberTypes.length;
        while (--i >= 0) {
            ((SourceTypeBinding)this.memberTypes[i]).verifyMethods(verifier);
        }
    }

    public FieldBinding getSyntheticField(ReferenceBinding targetEnclosingType, boolean onlyExactMatch) {
        if (this.synthetics == null || this.synthetics[1] == null) {
            return null;
        }
        FieldBinding field = (FieldBinding)this.synthetics[1].get(targetEnclosingType);
        if (field != null) {
            return field;
        }
        if (!onlyExactMatch) {
            Iterator accessFields = this.synthetics[1].values().iterator();
            while (accessFields.hasNext()) {
                field = (FieldBinding)accessFields.next();
                if (!CharOperation.prefixEquals(TypeConstants.SYNTHETIC_ENCLOSING_INSTANCE_PREFIX, field.name) || ((ReferenceBinding)field.type).findSuperTypeErasingTo(targetEnclosingType) == null) continue;
                return field;
            }
        }
        return null;
    }

    public void addField(FieldBinding binding) {
        if (this.fields == null) {
            this.fields = new FieldBinding[]{binding};
        } else {
            ArrayList<FieldBinding> l = new ArrayList<FieldBinding>(Arrays.asList(this.fields));
            l.add(binding);
            this.fields = l.toArray(new FieldBinding[l.size()]);
        }
    }

    public void addMethod(MethodBinding binding) {
        int len = 1;
        if (this.methods != null) {
            len = this.methods.length + 1;
        }
        MethodBinding[] newMethods = new MethodBinding[len];
        if (len > 1) {
            System.arraycopy(this.methods, 0, newMethods, 0, len - 1);
        }
        newMethods[len - 1] = binding;
        this.methods = newMethods;
    }

    public void removeMethod(int index) {
        int len = this.methods.length;
        MethodBinding[] newMethods = new MethodBinding[len - 1];
        System.arraycopy(this.methods, 0, newMethods, 0, index);
        System.arraycopy(this.methods, index + 1, newMethods, index, len - index - 1);
        this.methods = newMethods;
    }

    public void rememberTypeHierarchy() {
        if (this.originalSuperclass == null) {
            this.originalSuperclass = this.superclass;
        }
        if (this.originalSuperInterfaces == null) {
            this.originalSuperInterfaces = new ReferenceBinding[this.superInterfaces.length];
            System.arraycopy(this.superInterfaces, 0, this.originalSuperInterfaces, 0, this.superInterfaces.length);
        }
    }
}

