/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.aspectj.org.eclipse.jdt.core.IBuffer;
import org.aspectj.org.eclipse.jdt.core.ICompilationUnit;
import org.aspectj.org.eclipse.jdt.core.IJavaElement;
import org.aspectj.org.eclipse.jdt.core.IJavaElementDelta;
import org.aspectj.org.eclipse.jdt.core.IJavaModelStatus;
import org.aspectj.org.eclipse.jdt.core.IJavaProject;
import org.aspectj.org.eclipse.jdt.core.IPackageFragment;
import org.aspectj.org.eclipse.jdt.core.IPackageFragmentRoot;
import org.aspectj.org.eclipse.jdt.core.IType;
import org.aspectj.org.eclipse.jdt.core.JavaModelException;
import org.aspectj.org.eclipse.jdt.core.jdom.DOMException;
import org.aspectj.org.eclipse.jdt.core.jdom.DOMFactory;
import org.aspectj.org.eclipse.jdt.core.jdom.IDOMCompilationUnit;
import org.aspectj.org.eclipse.jdt.core.jdom.IDOMNode;
import org.aspectj.org.eclipse.jdt.core.jdom.IDOMPackage;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.aspectj.org.eclipse.jdt.internal.core.CompilationUnit;
import org.aspectj.org.eclipse.jdt.internal.core.JavaElement;
import org.aspectj.org.eclipse.jdt.internal.core.JavaElementDelta;
import org.aspectj.org.eclipse.jdt.internal.core.JavaModelStatus;
import org.aspectj.org.eclipse.jdt.internal.core.MultiOperation;
import org.aspectj.org.eclipse.jdt.internal.core.PackageFragment;
import org.aspectj.org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.aspectj.org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class CopyResourceElementsOperation
extends MultiOperation
implements SuffixConstants {
    protected ArrayList createdElements;
    protected Map deltasPerProject = new HashMap(1);
    protected DOMFactory fFactory;
    protected ArrayList fRenamedCompilationUnits = null;

    public CopyResourceElementsOperation(IJavaElement[] resourcesToCopy, IJavaElement destContainer, boolean force) {
        this(resourcesToCopy, new IJavaElement[]{destContainer}, force);
    }

    public CopyResourceElementsOperation(IJavaElement[] resourcesToCopy, IJavaElement[] destContainers, boolean force) {
        super(resourcesToCopy, destContainers, force);
        this.initializeDOMFactory();
    }

    private void initializeDOMFactory() {
        this.fFactory = new DOMFactory();
    }

    private IResource[] collectResourcesOfInterest(IPackageFragment source) throws JavaModelException {
        IJavaElement[] children = source.getChildren();
        int childOfInterest = 5;
        if (source.getKind() == 2) {
            childOfInterest = 6;
        }
        ArrayList<IResource> correctKindChildren = new ArrayList<IResource>(children.length);
        int i = 0;
        while (i < children.length) {
            IJavaElement child = children[i];
            if (child.getElementType() == childOfInterest) {
                correctKindChildren.add(child.getResource());
            }
            ++i;
        }
        Object[] nonJavaResources = source.getNonJavaResources();
        int actualNonJavaResourceCount = 0;
        int i2 = 0;
        int max = nonJavaResources.length;
        while (i2 < max) {
            if (nonJavaResources[i2] instanceof IResource) {
                ++actualNonJavaResourceCount;
            }
            ++i2;
        }
        IResource[] actualNonJavaResources = new IResource[actualNonJavaResourceCount];
        int i3 = 0;
        int max2 = nonJavaResources.length;
        int index = 0;
        while (i3 < max2) {
            if (nonJavaResources[i3] instanceof IResource) {
                actualNonJavaResources[index++] = (IResource)nonJavaResources[i3];
            }
            ++i3;
        }
        if (actualNonJavaResourceCount != 0) {
            int correctKindChildrenSize = correctKindChildren.size();
            IResource[] result = new IResource[correctKindChildrenSize + actualNonJavaResourceCount];
            correctKindChildren.toArray(result);
            System.arraycopy(actualNonJavaResources, 0, result, correctKindChildrenSize, actualNonJavaResourceCount);
            return result;
        }
        IResource[] result = new IResource[correctKindChildren.size()];
        correctKindChildren.toArray(result);
        return result;
    }

    private boolean createNeededPackageFragments(IContainer sourceFolder, PackageFragmentRoot root, String[] newFragName, boolean moveFolder) throws JavaModelException {
        boolean containsReadOnlyPackageFragment = false;
        IContainer parentFolder = (IContainer)root.getResource();
        JavaElementDelta projectDelta = null;
        String[] sideEffectPackageName = null;
        char[][] inclusionPatterns = root.fullInclusionPatternChars();
        char[][] exclusionPatterns = root.fullExclusionPatternChars();
        int i = 0;
        while (i < newFragName.length) {
            String subFolderName = newFragName[i];
            sideEffectPackageName = Util.arrayConcat(sideEffectPackageName, subFolderName);
            IResource subFolder = parentFolder.findMember(subFolderName);
            if (subFolder == null) {
                if (!moveFolder || i != newFragName.length - 1) {
                    this.createFolder(parentFolder, subFolderName, this.force);
                }
                parentFolder = parentFolder.getFolder((IPath)new Path(subFolderName));
                if (Util.isReadOnly((IResource)(sourceFolder = sourceFolder.getFolder((IPath)new Path(subFolderName))))) {
                    containsReadOnlyPackageFragment = true;
                }
                PackageFragment sideEffectPackage = root.getPackageFragment(sideEffectPackageName);
                if (i < newFragName.length - 1 && !Util.isExcluded((IResource)parentFolder, inclusionPatterns, exclusionPatterns)) {
                    if (projectDelta == null) {
                        projectDelta = this.getDeltaFor(root.getJavaProject());
                    }
                    projectDelta.added(sideEffectPackage);
                }
                this.createdElements.add(sideEffectPackage);
            } else {
                parentFolder = (IContainer)subFolder;
            }
            ++i;
        }
        return containsReadOnlyPackageFragment;
    }

    private JavaElementDelta getDeltaFor(IJavaProject javaProject) {
        JavaElementDelta delta = (JavaElementDelta)this.deltasPerProject.get(javaProject);
        if (delta == null) {
            delta = new JavaElementDelta(javaProject);
            this.deltasPerProject.put(javaProject, delta);
        }
        return delta;
    }

    protected String getMainTaskName() {
        return Util.bind("operation.copyResourceProgress");
    }

    protected void prepareDeltas(IJavaElement sourceElement, IJavaElement destinationElement, boolean isMove) {
        if (Util.isExcluded(sourceElement) || Util.isExcluded(destinationElement)) {
            return;
        }
        IJavaProject destProject = destinationElement.getJavaProject();
        if (isMove) {
            IJavaProject sourceProject = sourceElement.getJavaProject();
            this.getDeltaFor(sourceProject).movedFrom(sourceElement, destinationElement);
            this.getDeltaFor(destProject).movedTo(destinationElement, sourceElement);
        } else {
            this.getDeltaFor(destProject).added(destinationElement);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processCompilationUnitResource(ICompilationUnit source, PackageFragment dest) throws JavaModelException {
        IFile destFile;
        String sourceEncoding;
        String newContent;
        block25: {
            String destName;
            String newCUName;
            block26: {
                newCUName = this.getNewNameFor(source);
                destName = newCUName != null ? newCUName : source.getElementName();
                newContent = this.updatedContent(source, dest, newCUName);
                IFile sourceResource = (IFile)source.getResource();
                sourceEncoding = null;
                try {
                    sourceEncoding = sourceResource.getCharset(false);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                IContainer destFolder = (IContainer)dest.getResource();
                destFile = destFolder.getFile((IPath)new Path(destName));
                if (destFile.equals((Object)sourceResource)) break block25;
                try {
                    int flags;
                    if (destFile.exists()) {
                        if (!this.force) throw new JavaModelException(new JavaModelStatus(977, Util.bind("status.nameCollision", destFile.getFullPath().toString())));
                        this.deleteResource((IResource)destFile, 2);
                    }
                    int n = flags = this.force ? 1 : 0;
                    if (this.isMove()) {
                        sourceResource.move(destFile.getFullPath(), flags |= 2, this.getSubProgressMonitor(1));
                    } else {
                        if (newContent != null) {
                            flags |= 2;
                        }
                        sourceResource.copy(destFile.getFullPath(), flags, this.getSubProgressMonitor(1));
                    }
                    this.setAttribute("hasModifiedResource", "true");
                }
                catch (JavaModelException e) {
                    throw e;
                }
                catch (CoreException e) {
                    throw new JavaModelException(e);
                }
                if (newContent == null) break block26;
                boolean wasReadOnly = destFile.isReadOnly();
                try {
                    try {
                        String encoding = null;
                        try {
                            if (sourceEncoding != null) {
                                destFile.setCharset(sourceEncoding, this.progressMonitor);
                            }
                            encoding = destFile.getCharset();
                        }
                        catch (CoreException coreException) {
                            // empty catch block
                        }
                        Util.setReadOnly((IResource)destFile, false);
                        destFile.setContents((InputStream)new ByteArrayInputStream(encoding == null ? newContent.getBytes() : newContent.getBytes(encoding)), this.force ? 3 : 2, this.getSubProgressMonitor(1));
                    }
                    catch (IOException e) {
                        throw new JavaModelException(e, 985);
                    }
                    catch (CoreException e) {
                        throw new JavaModelException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var13_25 = null;
                    Util.setReadOnly((IResource)destFile, wasReadOnly);
                    throw throwable;
                }
                {
                    Object var13_26 = null;
                }
                Util.setReadOnly((IResource)destFile, wasReadOnly);
            }
            ICompilationUnit destCU = dest.getCompilationUnit(destName);
            this.prepareDeltas(source, destCU, this.isMove());
            if (newCUName == null) return;
            String oldName = source.getElementName();
            oldName = oldName.substring(0, oldName.length() - 5);
            String newName = newCUName;
            newName = newName.substring(0, newName.length() - 5);
            this.prepareDeltas(source.getType(oldName), destCU.getType(newName), this.isMove());
            return;
        }
        if (!this.force) {
            throw new JavaModelException(new JavaModelStatus(977, Util.bind("status.nameCollision", destFile.getFullPath().toString())));
        }
        try {
            if (newContent == null) return;
            String encoding = null;
            try {
                if (sourceEncoding != null) {
                    destFile.setCharset(sourceEncoding, this.progressMonitor);
                }
                encoding = destFile.getCharset();
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            destFile.setContents((InputStream)new ByteArrayInputStream(encoding == null ? newContent.getBytes() : newContent.getBytes(encoding)), this.force ? 3 : 2, this.getSubProgressMonitor(1));
            return;
        }
        catch (IOException e) {
            throw new JavaModelException(e, 985);
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
    }

    protected void processDeltas() {
        Iterator deltas = this.deltasPerProject.values().iterator();
        while (deltas.hasNext()) {
            this.addDelta((IJavaElementDelta)deltas.next());
        }
    }

    protected void processElement(IJavaElement element) throws JavaModelException {
        IJavaElement dest = this.getDestinationParent(element);
        switch (element.getElementType()) {
            case 5: {
                this.processCompilationUnitResource((ICompilationUnit)element, (PackageFragment)dest);
                this.createdElements.add(((IPackageFragment)dest).getCompilationUnit(element.getElementName()));
                break;
            }
            case 4: {
                this.processPackageFragmentResource((PackageFragment)element, (PackageFragmentRoot)dest, this.getNewNameFor(element));
                break;
            }
            default: {
                throw new JavaModelException(new JavaModelStatus(967, element));
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processElements() throws JavaModelException {
        this.createdElements = new ArrayList(this.elementsToProcess.length);
        try {
            super.processElements();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.resultElements = new IJavaElement[this.createdElements.size()];
            this.createdElements.toArray(this.resultElements);
            this.processDeltas();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.resultElements = new IJavaElement[this.createdElements.size()];
        this.createdElements.toArray(this.resultElements);
        this.processDeltas();
    }

    private void processPackageFragmentResource(PackageFragment source, PackageFragmentRoot root, String newName) throws JavaModelException {
        try {
            Object[] newFragName = newName == null ? source.names : Util.getTrimmedSimpleNames(newName);
            PackageFragment newFrag = root.getPackageFragment((String[])newFragName);
            IResource[] resources = this.collectResourcesOfInterest(source);
            boolean shouldMoveFolder = this.isMove() && !newFrag.getResource().exists();
            IFolder srcFolder = (IFolder)source.getResource();
            IPath destPath = newFrag.getPath();
            if (shouldMoveFolder) {
                if (srcFolder.getFullPath().isPrefixOf(destPath)) {
                    shouldMoveFolder = false;
                } else {
                    IResource[] members = srcFolder.members();
                    int i = 0;
                    while (i < members.length) {
                        if (members[i] instanceof IFolder) {
                            shouldMoveFolder = false;
                            break;
                        }
                        ++i;
                    }
                }
            }
            boolean containsReadOnlySubPackageFragments = this.createNeededPackageFragments((IContainer)source.getParent().getResource(), root, (String[])newFragName, shouldMoveFolder);
            boolean sourceIsReadOnly = srcFolder.isReadOnly();
            if (shouldMoveFolder) {
                if (sourceIsReadOnly) {
                    srcFolder.setReadOnly(false);
                }
                srcFolder.move(destPath, this.force, true, this.getSubProgressMonitor(1));
                if (sourceIsReadOnly) {
                    srcFolder.setReadOnly(true);
                }
                this.setAttribute("hasModifiedResource", "true");
            } else if (resources.length > 0) {
                IResource destinationResource;
                int max;
                int i;
                if (this.isRename()) {
                    if (!destPath.equals((Object)source.getPath())) {
                        this.moveResources(resources, destPath);
                    }
                } else if (this.isMove()) {
                    i = 0;
                    max = resources.length;
                    while (i < max) {
                        destinationResource = ResourcesPlugin.getWorkspace().getRoot().findMember(destPath.append(resources[i].getName()));
                        if (destinationResource != null) {
                            if (this.force) {
                                this.deleteResource(destinationResource, 2);
                            } else {
                                throw new JavaModelException(new JavaModelStatus(977, Util.bind("status.nameCollision", destinationResource.getFullPath().toString())));
                            }
                        }
                        ++i;
                    }
                    this.moveResources(resources, destPath);
                } else {
                    i = 0;
                    max = resources.length;
                    while (i < max) {
                        destinationResource = ResourcesPlugin.getWorkspace().getRoot().findMember(destPath.append(resources[i].getName()));
                        if (destinationResource != null) {
                            if (this.force) {
                                this.deleteResource(destinationResource, 2);
                            } else {
                                throw new JavaModelException(new JavaModelStatus(977, Util.bind("status.nameCollision", destinationResource.getFullPath().toString())));
                            }
                        }
                        ++i;
                    }
                    this.copyResources(resources, destPath);
                }
            }
            if (!Util.equalArraysOrNull(newFragName, source.names)) {
                char[][] inclusionPatterns = root.fullInclusionPatternChars();
                char[][] exclusionPatterns = root.fullExclusionPatternChars();
                int i = 0;
                while (i < resources.length) {
                    IDOMCompilationUnit domCU;
                    ICompilationUnit cu;
                    String resourceName = resources[i].getName();
                    if (Util.isJavaLikeFileName(resourceName) && !Util.isExcluded((cu = newFrag.getCompilationUnit(resourceName)).getPath(), inclusionPatterns, exclusionPatterns, false) && (domCU = this.fFactory.createCompilationUnit(cu.getSource(), cu.getElementName())) != null) {
                        String bufferContents;
                        this.updatePackageStatement(domCU, (String[])newFragName);
                        IBuffer buffer = cu.getBuffer();
                        if (buffer != null && (bufferContents = buffer.getContents()) != null) {
                            String domCUContents = domCU.getContents();
                            String cuContents = null;
                            cuContents = domCUContents != null ? Util.normalizeCRs(domCU.getContents(), bufferContents) : bufferContents;
                            buffer.setContents(cuContents);
                            cu.save(null, false);
                        }
                    }
                    ++i;
                }
            }
            boolean isEmpty = true;
            if (this.isMove()) {
                this.updateReadOnlyPackageFragmentsForMove((IContainer)source.getParent().getResource(), root, (String[])newFragName, sourceIsReadOnly);
                if (srcFolder.exists()) {
                    IResource[] remaining = srcFolder.members();
                    int i = 0;
                    int length = remaining.length;
                    while (i < length) {
                        IResource file = remaining[i];
                        if (file instanceof IFile) {
                            if (file.isReadOnly()) {
                                file.setReadOnly(false);
                            }
                            this.deleteResource(file, 3);
                        } else {
                            isEmpty = false;
                        }
                        ++i;
                    }
                }
                if (isEmpty) {
                    IResource rootResource = destPath.isPrefixOf(srcFolder.getFullPath()) ? newFrag.getResource() : source.getParent().getResource();
                    this.deleteEmptyPackageFragment(source, false, rootResource);
                }
            } else if (containsReadOnlySubPackageFragments) {
                this.updateReadOnlyPackageFragmentsForCopy((IContainer)source.getParent().getResource(), root, (String[])newFragName);
            }
            if (isEmpty && this.isMove() && !Util.isExcluded(source) && !Util.isExcluded(newFrag)) {
                IJavaProject sourceProject = source.getJavaProject();
                this.getDeltaFor(sourceProject).movedFrom(source, newFrag);
                IJavaProject destProject = newFrag.getJavaProject();
                this.getDeltaFor(destProject).movedTo(newFrag, source);
            }
        }
        catch (DOMException dom) {
            throw new JavaModelException(dom, 986);
        }
        catch (JavaModelException e) {
            throw e;
        }
        catch (CoreException ce) {
            throw new JavaModelException(ce);
        }
    }

    private String updatedContent(ICompilationUnit cu, PackageFragment dest, String newName) throws JavaModelException {
        Object[] currPackageName = ((PackageFragment)cu.getParent()).names;
        Object[] destPackageName = dest.names;
        if (Util.equalArraysOrNull(currPackageName, destPackageName) && newName == null) {
            return null;
        }
        String typeName = cu.getElementName();
        typeName = typeName.substring(0, typeName.length() - 5);
        IDOMCompilationUnit cuDOM = null;
        IBuffer buffer = cu.getBuffer();
        if (buffer == null) {
            return null;
        }
        char[] contents = buffer.getCharacters();
        if (contents == null) {
            return null;
        }
        cuDOM = this.fFactory.createCompilationUnit(contents, typeName);
        this.updateTypeName(cu, cuDOM, cu.getElementName(), newName);
        this.updatePackageStatement(cuDOM, (String[])destPackageName);
        return cuDOM.getContents();
    }

    private void updatePackageStatement(IDOMCompilationUnit domCU, String[] pkgName) {
        boolean defaultPackage = pkgName.length == 0;
        boolean seenPackageNode = false;
        Enumeration nodes = domCU.getChildren();
        while (nodes.hasMoreElements()) {
            IDOMNode node = (IDOMNode)nodes.nextElement();
            if (node.getNodeType() != 2) continue;
            if (!defaultPackage) {
                node.setName(Util.concatWith(pkgName, '.'));
            } else {
                node.remove();
            }
            seenPackageNode = true;
            break;
        }
        if (!seenPackageNode && !defaultPackage) {
            IDOMPackage pkg = this.fFactory.createPackage("package " + Util.concatWith(pkgName, '.') + ";" + org.aspectj.org.eclipse.jdt.internal.compiler.util.Util.LINE_SEPARATOR);
            IDOMNode firstChild = domCU.getFirstChild();
            if (firstChild != null) {
                firstChild.insertSibling(pkg);
            }
        }
    }

    private void updateReadOnlyPackageFragmentsForCopy(IContainer sourceFolder, IPackageFragmentRoot root, String[] newFragName) {
        IContainer parentFolder = (IContainer)root.getResource();
        int i = 0;
        int length = newFragName.length;
        while (i < length) {
            String subFolderName = newFragName[i];
            parentFolder = parentFolder.getFolder((IPath)new Path(subFolderName));
            if ((sourceFolder = sourceFolder.getFolder((IPath)new Path(subFolderName))).exists() && Util.isReadOnly((IResource)sourceFolder)) {
                Util.setReadOnly((IResource)parentFolder, true);
            }
            ++i;
        }
    }

    private void updateReadOnlyPackageFragmentsForMove(IContainer sourceFolder, IPackageFragmentRoot root, String[] newFragName, boolean sourceFolderIsReadOnly) {
        IContainer parentFolder = (IContainer)root.getResource();
        int i = 0;
        int length = newFragName.length;
        while (i < length) {
            String subFolderName = newFragName[i];
            parentFolder = parentFolder.getFolder((IPath)new Path(subFolderName));
            if ((sourceFolder = sourceFolder.getFolder((IPath)new Path(subFolderName))).exists() && Util.isReadOnly((IResource)sourceFolder) || i == length - 1 && sourceFolderIsReadOnly) {
                Util.setReadOnly((IResource)parentFolder, true);
                Util.setReadOnly((IResource)sourceFolder, false);
            }
            ++i;
        }
    }

    private void updateTypeName(ICompilationUnit cu, IDOMCompilationUnit domCU, String oldName, String newName) throws JavaModelException {
        if (newName != null) {
            if (this.fRenamedCompilationUnits == null) {
                this.fRenamedCompilationUnits = new ArrayList(1);
            }
            this.fRenamedCompilationUnits.add(cu);
            String oldTypeName = oldName.substring(0, oldName.length() - 5);
            String newTypeName = newName.substring(0, newName.length() - 5);
            IType[] types = cu.getTypes();
            int i = 0;
            int max = types.length;
            while (i < max) {
                IDOMNode typeNode;
                IType currentType = types[i];
                if (currentType.getElementName().equals(oldTypeName) && (typeNode = ((JavaElement)((Object)currentType)).findNode(domCU)) != null) {
                    typeNode.setName(newTypeName);
                }
                ++i;
            }
        }
    }

    protected IJavaModelStatus verify() {
        IJavaModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        if (this.renamingsList != null && this.renamingsList.length != this.elementsToProcess.length) {
            return new JavaModelStatus(980);
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    protected void verify(IJavaElement element) throws JavaModelException {
        int elementType;
        IResource resource;
        if (element == null || !element.exists()) {
            this.error(969, element);
        }
        if (element.isReadOnly() && (this.isRename() || this.isMove())) {
            this.error(976, element);
        }
        if ((resource = element.getResource()) instanceof IFolder && resource.isLinked()) {
            this.error(995, element);
        }
        if ((elementType = element.getElementType()) == 5) {
            CompilationUnit compilationUnit = (CompilationUnit)element;
            if (this.isMove() && compilationUnit.isWorkingCopy() && !compilationUnit.isPrimary()) {
                this.error(967, element);
            }
        } else if (elementType != 4) {
            this.error(967, element);
        }
        JavaElement dest = (JavaElement)this.getDestinationParent(element);
        this.verifyDestination(element, dest);
        if (this.renamings != null) {
            this.verifyRenaming(element);
        }
    }
}

