/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.builder;

import java.util.ArrayList;
import java.util.HashMap;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.BuildManager;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AJLog;
import org.eclipse.ajdt.core.CoreUtils;
import org.eclipse.ajdt.core.builder.IAJBuildListener;
import org.eclipse.ajdt.core.lazystart.IAdviceChangedListener;
import org.eclipse.ajdt.internal.ui.ajde.CompilerTaskListManager;
import org.eclipse.ajdt.internal.ui.ajde.ProjectProperties;
import org.eclipse.ajdt.internal.ui.diff.ChangesView;
import org.eclipse.ajdt.internal.ui.markers.MarkerUpdating;
import org.eclipse.ajdt.internal.ui.text.UIMessages;
import org.eclipse.ajdt.internal.ui.visualiser.AJDTContentProvider;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.contribution.visualiser.VisualiserPlugin;
import org.eclipse.contribution.visualiser.core.ProviderManager;
import org.eclipse.contribution.xref.ui.XReferenceUIPlugin;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class UIBuildListener
implements IAJBuildListener {
    private HashMap outjars = null;
    private ListenerList fListeners = new ListenerList();
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;

    public void preAJBuild(int kind, IProject project, IProject[] requiredProjects) {
        ProjectProperties props = AspectJUIPlugin.getDefault().getAjdtProjectProperties();
        boolean haveClearedMarkers = false;
        int i = 0;
        while (i < requiredProjects.length) {
            String referencedMessage = NLS.bind((String)UIMessages.buildPrereqsMessage, (Object)requiredProjects[i].getName());
            if (this.projectAlreadyMarked(project, referencedMessage)) {
                if (kind == 6) {
                    props.clearMarkers(true);
                    CompilerTaskListManager.clearOtherProjectMarkers(project);
                } else {
                    props.clearMarkers(false);
                }
                this.markProject(project, referencedMessage);
                haveClearedMarkers = true;
            }
            ++i;
        }
        if (!haveClearedMarkers) {
            if (kind == 6) {
                props.clearMarkers(true);
            } else {
                props.clearMarkers(false);
            }
            CompilerTaskListManager.clearOtherProjectMarkers(project);
        }
        BuildManager buildManager = Ajde.getDefault().getBuildManager();
        if (!AspectJUIPlugin.getDefault().getAjdtBuildOptionsAdapter().getBuildAsm()) {
            AJLog.log((int)2, (String)("build: No structure model to be built for project: " + project.getName()));
            buildManager.setBuildModelMode(false);
        } else {
            buildManager.setBuildModelMode(true);
        }
        MarkerUpdating.deleteAllMarkers(project);
    }

    private boolean projectAlreadyMarked(IProject project, String errorMessage) {
        try {
            IMarker[] problemMarkers = project.findMarkers("org.eclipse.jdt.core.problem", false, 2);
            if (problemMarkers.length > 0) {
                int j = 0;
                while (j < problemMarkers.length) {
                    IMarker marker = problemMarkers[j];
                    int markerSeverity = marker.getAttribute("severity", -1);
                    String markerMessage = marker.getAttribute("message", "no message");
                    if (markerSeverity == 2 && markerMessage.equals(errorMessage)) {
                        return true;
                    }
                    ++j;
                }
            }
        }
        catch (CoreException coreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_0, ajc$tjp_1);
            CoreException e = coreException;
            AJLog.log((int)2, (String)("build: Problem occured finding the markers for project " + project.getName() + ": " + e.getStackTrace()));
        }
        return false;
    }

    private void markProject(IProject project, String errorMessage) {
        try {
            IMarker errorMarker = project.createMarker("org.eclipse.jdt.core.problem");
            errorMarker.setAttribute("message", (Object)errorMessage);
            errorMarker.setAttribute("severity", 2);
        }
        catch (CoreException coreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_2, ajc$tjp_3);
            CoreException e = coreException;
            AJLog.log((int)2, (String)("build: Problem occured creating the error marker for project " + project.getName() + ": " + e.getStackTrace()));
        }
    }

    public void postAJBuild(IProject project, boolean buildCancelled, boolean noSourceChanges) {
        if (noSourceChanges) {
            MarkerUpdating.addNewMarkers(project);
            return;
        }
        String buildPrereqsMessage = NLS.bind((String)UIMessages.buildPrereqsMessage, (Object)project.getName());
        if (buildCancelled) {
            this.markReferencingProjects(project, buildPrereqsMessage);
        } else {
            this.removeMarkerOnReferencingProjects(project, buildPrereqsMessage);
        }
        CompilerTaskListManager.showOutstandingProblems();
        this.checkOutJarEntry(project);
        MarkerUpdating.addNewMarkers(project);
        if (AspectJUIPlugin.getDefault().getDisplay().isDisposed()) {
            AJLog.log((String)"Not updating vis, xref, or changes views as display is disposed!");
        } else {
            AspectJUIPlugin.getDefault().getDisplay().syncExec(new Runnable(){

                public void run() {
                    Bundle vis;
                    Object[] listeners = UIBuildListener.this.fListeners.getListeners();
                    int i = 0;
                    while (i < listeners.length) {
                        ((IAdviceChangedListener)listeners[i]).adviceChanged();
                        ++i;
                    }
                    if (AspectJUIPlugin.usingXref) {
                        XReferenceUIPlugin.refresh();
                    }
                    ChangesView.refresh(false);
                    if (AspectJUIPlugin.usingVisualiser && (vis = Platform.getBundle((String)"org.eclipse.contribution.visualiser")) != null && vis.getState() == 32 && ProviderManager.getContentProvider() instanceof AJDTContentProvider) {
                        AJDTContentProvider provider = (AJDTContentProvider)ProviderManager.getContentProvider();
                        provider.reset();
                        VisualiserPlugin.refresh();
                    }
                }
            });
        }
    }

    public void addAdviceListener(IAdviceChangedListener adviceListener) {
        this.fListeners.add((Object)adviceListener);
    }

    public void removeAdviceListener(IAdviceChangedListener adviceListener) {
        this.fListeners.remove((Object)adviceListener);
    }

    private void markReferencingProjects(IProject project, String errorMessage) {
        IProject[] referencingProjects = this.getDependingProjects(project);
        int i = 0;
        while (i < referencingProjects.length) {
            IProject referencingProject = referencingProjects[i];
            if (!this.projectAlreadyMarked(referencingProject, errorMessage)) {
                this.markProject(referencingProject, errorMessage);
            }
            ++i;
        }
    }

    private void removeMarkerOnReferencingProjects(IProject project, String errorMessage) {
        try {
            IProject[] referencingProjects = this.getDependingProjects(project);
            int i = 0;
            while (i < referencingProjects.length) {
                IProject referencingProject = referencingProjects[i];
                IMarker[] problemMarkers = referencingProject.findMarkers("org.eclipse.jdt.core.problem", false, 2);
                if (problemMarkers.length > 0) {
                    int j = 0;
                    while (j < problemMarkers.length) {
                        IMarker marker = problemMarkers[j];
                        int markerSeverity = marker.getAttribute("severity", -1);
                        String markerMessage = marker.getAttribute("message", "no message");
                        if (markerSeverity == 2 && markerMessage.equals(errorMessage)) {
                            marker.delete();
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_4, ajc$tjp_5);
            CoreException e = coreException;
            AJLog.log((int)2, (String)("build: Problem occured either finding the markers for project " + project.getName() + ", or deleting the error marker: " + e.getStackTrace()));
        }
    }

    private void checkOutJarEntry(IProject project) {
        String outJar = AspectJUIPlugin.getDefault().getAjdtProjectProperties().getOutJar();
        if (outJar != null && !outJar.equals("")) {
            if (this.outjars == null) {
                this.outjars = new HashMap();
            }
            IPath newPath = this.getRelativePath(project, outJar);
            IClasspathEntry newEntry = JavaCore.newLibraryEntry((IPath)newPath.makeAbsolute(), null, null);
            if (this.outjars.containsKey(project)) {
                if (!this.outjars.get(project).equals(newEntry)) {
                    IClasspathEntry oldEntry = (IClasspathEntry)this.outjars.get(project);
                    this.outjars.remove(project);
                    this.removeOutjarFromDependingProjects(project, oldEntry);
                    this.outjars.put(project, newEntry);
                    this.updateDependingProjectsWithJar(project, newEntry);
                }
            } else {
                this.outjars.put(project, newEntry);
                this.updateDependingProjectsWithJar(project, newEntry);
            }
        } else if (this.outjars != null && this.outjars.containsKey(project)) {
            IClasspathEntry oldEntry = (IClasspathEntry)this.outjars.get(project);
            this.outjars.remove(project);
            if (this.outjars.size() == 0) {
                this.outjars = null;
            }
            this.removeOutjarFromDependingProjects(project, oldEntry);
        }
    }

    private void removeOutjarFromDependingProjects(IProject project, IClasspathEntry unwantedEntry) {
        IProject[] dependingProjects = this.getDependingProjects(project);
        int i = 0;
        while (i < dependingProjects.length) {
            IJavaProject javaProject = JavaCore.create((IProject)dependingProjects[i]);
            if (javaProject != null) {
                try {
                    IClasspathEntry[] cpEntry = javaProject.getRawClasspath();
                    ArrayList<IClasspathEntry> newEntries = new ArrayList<IClasspathEntry>();
                    int j = 0;
                    while (j < cpEntry.length) {
                        if (!cpEntry[j].equals(unwantedEntry)) {
                            newEntries.add(cpEntry[j]);
                        }
                        ++j;
                    }
                    IClasspathEntry[] newCP = newEntries.toArray(new IClasspathEntry[newEntries.size()]);
                    javaProject.setRawClasspath(newCP, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException coreException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_6, ajc$tjp_7);
                }
            }
            ++i;
        }
    }

    private void updateDependingProjectsWithJar(IProject project, IClasspathEntry newEntry) {
        IProject[] dependingProjects = this.getDependingProjects(project);
        int i = 0;
        while (i < dependingProjects.length) {
            block6: {
                IJavaProject javaProject = JavaCore.create((IProject)dependingProjects[i]);
                if (javaProject != null) {
                    try {
                        IClasspathEntry[] cpEntry = javaProject.getRawClasspath();
                        ArrayList<IClasspathEntry> newEntries = new ArrayList<IClasspathEntry>();
                        int j = 0;
                        while (j < cpEntry.length) {
                            if (!cpEntry[j].equals(newEntry)) {
                                newEntries.add(cpEntry[j]);
                                ++j;
                                continue;
                            }
                            break block6;
                        }
                        newEntries.add(newEntry);
                        IClasspathEntry[] newCP = newEntries.toArray(new IClasspathEntry[newEntries.size()]);
                        javaProject.setRawClasspath(newCP, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException coreException) {
                        UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_8, ajc$tjp_9);
                    }
                }
            }
            ++i;
        }
    }

    private IProject[] getDependingProjects(IProject project) {
        IProject[] referencingProjects = project.getReferencingProjects();
        IProject[] classFolderReferences = (IProject[])CoreUtils.getDependingProjects((IProject)project).get(0);
        IProject[] dependingProjects = new IProject[referencingProjects.length + classFolderReferences.length];
        int i = 0;
        while (i < referencingProjects.length) {
            dependingProjects[i] = referencingProjects[i];
            ++i;
        }
        i = 0;
        while (i < classFolderReferences.length) {
            dependingProjects[i + referencingProjects.length] = classFolderReferences[i];
            ++i;
        }
        return dependingProjects;
    }

    private IPath getRelativePath(IProject project, String outJar) {
        StringBuffer sb = new StringBuffer(outJar);
        int index = sb.lastIndexOf(project.getName());
        Path path = index > 0 ? new Path(sb.substring(sb.lastIndexOf(project.getName()))) : new Path(outJar);
        return path.makeAbsolute();
    }

    static {
        Factory factory = new Factory("UIBuildListener.java", Class.forName("org.eclipse.ajdt.internal.builder.UIBuildListener"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.builder.UIBuildListener-org.eclipse.core.runtime.CoreException-e-"), 134);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-projectAlreadyMarked-org.eclipse.ajdt.internal.builder.UIBuildListener-org.eclipse.core.resources.IProject:java.lang.String:-project:errorMessage:--boolean-"), 117);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.builder.UIBuildListener-org.eclipse.core.runtime.CoreException-e-"), 146);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-markProject-org.eclipse.ajdt.internal.builder.UIBuildListener-org.eclipse.core.resources.IProject:java.lang.String:-project:errorMessage:--void-"), 141);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.builder.UIBuildListener-org.eclipse.core.runtime.CoreException-e-"), 271);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-removeMarkerOnReferencingProjects-org.eclipse.ajdt.internal.builder.UIBuildListener-org.eclipse.core.resources.IProject:java.lang.String:-project:errorMessage:--void-"), 247);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.builder.UIBuildListener-org.eclipse.core.runtime.CoreException-<missing>-"), 338);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-removeOutjarFromDependingProjects-org.eclipse.ajdt.internal.builder.UIBuildListener-org.eclipse.core.resources.IProject:org.eclipse.jdt.core.IClasspathEntry:-project:unwantedEntry:--void-"), 319);
        ajc$tjp_8 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.builder.UIBuildListener-org.eclipse.core.runtime.CoreException-<missing>-"), 364);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-updateDependingProjectsWithJar-org.eclipse.ajdt.internal.builder.UIBuildListener-org.eclipse.core.resources.IProject:org.eclipse.jdt.core.IClasspathEntry:-project:newEntry:--void-"), 343);
    }
}

