/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.diff;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ajdt.internal.ui.text.UIMessages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class AJMapEditor
extends EditorPart
implements IPropertyChangeListener {
    private ScrolledComposite fScrolledComposite;
    private Color fBackgroundColor;
    private Color fForegroundColor;
    private Color fSeparatorColor;
    private List fBannerLabels = new ArrayList();
    private List fHeaderLabels = new ArrayList();
    private Font fFont;
    private static final int HORIZONTAL_SCROLL_INCREMENT = 10;
    private static final int VERTICAL_SCROLL_INCREMENT = 10;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setPartName(input.getName());
        this.setContentDescription(input.getName());
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        Display display = parent.getDisplay();
        this.fBackgroundColor = display.getSystemColor(25);
        this.fForegroundColor = display.getSystemColor(24);
        this.fSeparatorColor = new Color((Device)display, 152, 170, 203);
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
        this.fScrolledComposite = new ScrolledComposite(parent, 768);
        this.fScrolledComposite.setAlwaysShowScrollBars(false);
        this.fScrolledComposite.setExpandHorizontal(true);
        this.fScrolledComposite.setExpandVertical(true);
        this.fScrolledComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)AJMapEditor.this);
                AJMapEditor.this.fScrolledComposite = null;
                AJMapEditor.this.fSeparatorColor.dispose();
                AJMapEditor.this.fSeparatorColor = null;
                AJMapEditor.this.fBannerLabels.clear();
                AJMapEditor.this.fHeaderLabels.clear();
                if (AJMapEditor.this.fFont != null) {
                    AJMapEditor.this.fFont.dispose();
                    AJMapEditor.this.fFont = null;
                }
            }
        });
        this.fScrolledComposite.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                Rectangle clientArea = AJMapEditor.this.fScrolledComposite.getClientArea();
                ScrollBar verticalBar = AJMapEditor.this.fScrolledComposite.getVerticalBar();
                verticalBar.setIncrement(10);
                verticalBar.setPageIncrement(clientArea.height - verticalBar.getIncrement());
                ScrollBar horizontalBar = AJMapEditor.this.fScrolledComposite.getHorizontalBar();
                horizontalBar.setIncrement(10);
                horizontalBar.setPageIncrement(clientArea.width - horizontalBar.getIncrement());
            }
        });
        Composite composite = this.createComposite((Composite)this.fScrolledComposite);
        composite.setLayout((Layout)new GridLayout());
        this.createTitleLabel(composite, UIMessages.ajmapEditor_title);
        this.createLabel(composite, null);
        this.createLabel(composite, null);
        this.createHeadingLabel(composite, UIMessages.ajmapEditor_heading);
        Composite separator = this.createCompositeSeparator(composite);
        GridData data = new GridData(768);
        data.heightHint = 2;
        separator.setLayoutData((Object)data);
        this.createText(composite, UIMessages.ajmapEditor_description);
        separator = this.createCompositeSeparator(composite);
        data = new GridData(768);
        data.heightHint = 2;
        separator.setLayoutData((Object)data);
        this.fScrolledComposite.setContent((Control)composite);
        this.fScrolledComposite.setMinSize(composite.computeSize(-1, -1));
    }

    private Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(this.fBackgroundColor);
        return composite;
    }

    private Composite createCompositeSeparator(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(this.fSeparatorColor);
        return composite;
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        if (text != null) {
            label.setText(text);
        }
        label.setBackground(this.fBackgroundColor);
        label.setForeground(this.fForegroundColor);
        return label;
    }

    private Text createText(Composite parent, String text) {
        Text label = new Text(parent, 10);
        if (text != null) {
            label.setText(text);
        }
        label.setBackground(this.fBackgroundColor);
        label.setForeground(this.fForegroundColor);
        return label;
    }

    private Label createTitleLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        if (text != null) {
            label.setText(text);
        }
        label.setBackground(this.fBackgroundColor);
        label.setForeground(this.fForegroundColor);
        label.setFont(JFaceResources.getHeaderFont());
        this.fHeaderLabels.add(label);
        return label;
    }

    private Label createHeadingLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        if (text != null) {
            label.setText(text);
        }
        label.setBackground(this.fBackgroundColor);
        label.setForeground(this.fForegroundColor);
        label.setFont(JFaceResources.getBannerFont());
        this.fBannerLabels.add(label);
        return label;
    }

    public void setFocus() {
        this.fScrolledComposite.setFocus();
    }

    public void propertyChange(PropertyChangeEvent event) {
        Label label;
        Iterator iterator = this.fBannerLabels.iterator();
        while (iterator.hasNext()) {
            label = (Label)iterator.next();
            label.setFont(JFaceResources.getBannerFont());
        }
        iterator = this.fHeaderLabels.iterator();
        while (iterator.hasNext()) {
            label = (Label)iterator.next();
            label.setFont(JFaceResources.getHeaderFont());
        }
        Control control = this.fScrolledComposite.getContent();
        this.fScrolledComposite.setMinSize(control.computeSize(-1, -1));
        this.fScrolledComposite.setContent(control);
        this.fScrolledComposite.layout(true);
        this.fScrolledComposite.redraw();
    }
}

