/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.core;

import java.io.File;
import java.util.StringTokenizer;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.internal.core.ras.CoreFFDC;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;

public class AspectJCorePreferences {
    public static final String OUT_JAR = "org.eclipse.ajdt.ui.outJar";
    public static final String ASPECTPATH = "org.eclipse.ajdt.ui.aspectPath";
    public static final String ASPECTPATH_CON_KINDS = "org.eclipse.ajdt.ui.aspectPath.contentKind";
    public static final String ASPECTPATH_ENT_KINDS = "org.eclipse.ajdt.ui.aspectPath.entryKind";
    public static final String INPATH = "org.eclipse.ajdt.ui.inPath";
    public static final String INPATH_CON_KINDS = "org.eclipse.ajdt.ui.inPath.contentKind";
    public static final String INPATH_ENT_KINDS = "org.eclipse.ajdt.ui.inPath.entryKind";
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;

    public static String getProjectOutJar(IProject project) {
        ProjectScope projectScope = new ProjectScope(project);
        IEclipsePreferences projectNode = projectScope.getNode("org.eclipse.ajdt.ui");
        return projectNode.get(OUT_JAR, "");
    }

    public static void setProjectOutJar(IProject project, String value) {
        ProjectScope projectScope = new ProjectScope(project);
        IEclipsePreferences projectNode = projectScope.getNode("org.eclipse.ajdt.ui");
        projectNode.put(OUT_JAR, value);
        if (value.length() == 0) {
            projectNode.remove(OUT_JAR);
        }
        try {
            projectNode.flush();
        }
        catch (BackingStoreException backingStoreException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$1$31280822(backingStoreException, ajc$tjp_0, ajc$tjp_1);
        }
    }

    public static String[] getProjectAspectPath(IProject project) {
        ProjectScope projectScope = new ProjectScope(project);
        IEclipsePreferences projectNode = projectScope.getNode("org.eclipse.ajdt.ui");
        String pathString = "";
        int index = 1;
        String value = projectNode.get(ASPECTPATH + index, "");
        while (value.length() > 0) {
            pathString = String.valueOf(pathString) + value;
            pathString = String.valueOf(pathString) + File.pathSeparator;
            value = projectNode.get(ASPECTPATH + ++index, "");
        }
        String contentString = "";
        index = 1;
        value = projectNode.get(ASPECTPATH_CON_KINDS + index, "");
        while (value.length() > 0) {
            contentString = String.valueOf(contentString) + AspectJCorePreferences.toContentKind(value.toUpperCase());
            contentString = String.valueOf(contentString) + File.pathSeparator;
            value = projectNode.get(ASPECTPATH_CON_KINDS + ++index, "");
        }
        String entryString = "";
        index = 1;
        value = projectNode.get(ASPECTPATH_ENT_KINDS + index, "");
        while (value.length() > 0) {
            entryString = String.valueOf(entryString) + AspectJCorePreferences.toEntryKind(value.toUpperCase());
            entryString = String.valueOf(entryString) + File.pathSeparator;
            value = projectNode.get(ASPECTPATH_ENT_KINDS + ++index, "");
        }
        return new String[]{pathString, contentString, entryString};
    }

    public static void setProjectAspectPath(IProject project, String path, String cKinds, String eKinds) {
        ProjectScope projectScope = new ProjectScope(project);
        IEclipsePreferences projectNode = projectScope.getNode("org.eclipse.ajdt.ui");
        StringTokenizer tok = new StringTokenizer(path, File.pathSeparator);
        int index = 1;
        while (tok.hasMoreTokens()) {
            projectNode.put(ASPECTPATH + index, tok.nextToken());
            ++index;
        }
        while (projectNode.get(ASPECTPATH + index, "").length() > 0) {
            projectNode.remove(ASPECTPATH + index);
            ++index;
        }
        tok = new StringTokenizer(cKinds, File.pathSeparator);
        index = 1;
        while (tok.hasMoreTokens()) {
            projectNode.put(ASPECTPATH_CON_KINDS + index, AspectJCorePreferences.fromContentKind(tok.nextToken()));
            ++index;
        }
        while (projectNode.get(ASPECTPATH_CON_KINDS + index, "").length() > 0) {
            projectNode.remove(ASPECTPATH_CON_KINDS + index);
            ++index;
        }
        tok = new StringTokenizer(eKinds, File.pathSeparator);
        index = 1;
        while (tok.hasMoreTokens()) {
            projectNode.put(ASPECTPATH_ENT_KINDS + index, AspectJCorePreferences.fromEntryKind(tok.nextToken()));
            ++index;
        }
        while (projectNode.get(ASPECTPATH_ENT_KINDS + index, "").length() > 0) {
            projectNode.remove(ASPECTPATH_ENT_KINDS + index);
            ++index;
        }
        try {
            projectNode.flush();
        }
        catch (BackingStoreException backingStoreException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$1$31280822(backingStoreException, ajc$tjp_2, ajc$tjp_3);
        }
    }

    public static String[] getProjectInPath(IProject project) {
        ProjectScope projectScope = new ProjectScope(project);
        IEclipsePreferences projectNode = projectScope.getNode("org.eclipse.ajdt.ui");
        String pathString = "";
        int index = 1;
        String value = projectNode.get(INPATH + index, "");
        while (value.length() > 0) {
            pathString = String.valueOf(pathString) + value;
            pathString = String.valueOf(pathString) + File.pathSeparator;
            value = projectNode.get(INPATH + ++index, "");
        }
        String contentString = "";
        index = 1;
        value = projectNode.get(INPATH_CON_KINDS + index, "");
        while (value.length() > 0) {
            contentString = String.valueOf(contentString) + AspectJCorePreferences.toContentKind(value.toUpperCase());
            contentString = String.valueOf(contentString) + File.pathSeparator;
            value = projectNode.get(INPATH_CON_KINDS + ++index, "");
        }
        String entryString = "";
        index = 1;
        value = projectNode.get(INPATH_ENT_KINDS + index, "");
        while (value.length() > 0) {
            entryString = String.valueOf(entryString) + AspectJCorePreferences.toEntryKind(value.toUpperCase());
            entryString = String.valueOf(entryString) + File.pathSeparator;
            value = projectNode.get(INPATH_ENT_KINDS + ++index, "");
        }
        return new String[]{pathString, contentString, entryString};
    }

    public static void setProjectInPath(IProject project, String path, String cKinds, String eKinds) {
        ProjectScope projectScope = new ProjectScope(project);
        IEclipsePreferences projectNode = projectScope.getNode("org.eclipse.ajdt.ui");
        StringTokenizer tok = new StringTokenizer(path, File.pathSeparator);
        int index = 1;
        while (tok.hasMoreTokens()) {
            projectNode.put(INPATH + index, tok.nextToken());
            ++index;
        }
        while (projectNode.get(INPATH + index, "").length() > 0) {
            projectNode.remove(INPATH + index);
            ++index;
        }
        tok = new StringTokenizer(cKinds, File.pathSeparator);
        index = 1;
        while (tok.hasMoreTokens()) {
            projectNode.put(INPATH_CON_KINDS + index, AspectJCorePreferences.fromContentKind(tok.nextToken()));
            ++index;
        }
        while (projectNode.get(INPATH_CON_KINDS + index, "").length() > 0) {
            projectNode.remove(INPATH_CON_KINDS + index);
            ++index;
        }
        tok = new StringTokenizer(eKinds, File.pathSeparator);
        index = 1;
        while (tok.hasMoreTokens()) {
            projectNode.put(INPATH_ENT_KINDS + index, AspectJCorePreferences.fromEntryKind(tok.nextToken()));
            ++index;
        }
        while (projectNode.get(INPATH_ENT_KINDS + index, "").length() > 0) {
            projectNode.remove(INPATH_ENT_KINDS + index);
            ++index;
        }
        try {
            projectNode.flush();
        }
        catch (BackingStoreException backingStoreException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$1$31280822(backingStoreException, ajc$tjp_4, ajc$tjp_5);
        }
    }

    private static String fromContentKind(String cKinds) {
        String contentStr = "unknown";
        try {
            int content = Integer.parseInt(cKinds);
            if (content == 1) {
                contentStr = "SOURCE";
            } else if (content == 2) {
                contentStr = "BINARY";
            }
        }
        catch (NumberFormatException numberFormatException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$1$31280822(numberFormatException, ajc$tjp_6, ajc$tjp_7);
        }
        return contentStr;
    }

    private static String fromEntryKind(String eKinds) {
        String entryStr = "unknown";
        try {
            int entry = Integer.parseInt(eKinds);
            if (entry == 3) {
                entryStr = "SOURCE";
            } else if (entry == 1) {
                entryStr = "LIBRARY";
            } else if (entry == 2) {
                entryStr = "PROJECT";
            } else if (entry == 4) {
                entryStr = "VARIABLE";
            } else if (entry == 5) {
                entryStr = "CONTAINER";
            }
        }
        catch (NumberFormatException numberFormatException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$1$31280822(numberFormatException, ajc$tjp_8, ajc$tjp_9);
        }
        return entryStr;
    }

    private static String toContentKind(String contentStr) {
        int content = 0;
        if (contentStr.equals("SOURCE")) {
            content = 1;
        } else if (contentStr.equals("BINARY")) {
            content = 2;
        }
        return new Integer(content).toString();
    }

    private static String toEntryKind(String entryStr) {
        int entry = 0;
        if (entryStr.equals("SOURCE")) {
            entry = 3;
        } else if (entryStr.equals("LIBRARY")) {
            entry = 1;
        } else if (entryStr.equals("PROJECT")) {
            entry = 2;
        } else if (entryStr.equals("VARIABLE")) {
            entry = 4;
        } else if (entryStr.equals("CONTAINER")) {
            entry = 5;
        }
        return new Integer(entry).toString();
    }

    static {
        Factory factory = new Factory("AspectJCorePreferences.java", Class.forName("org.eclipse.ajdt.core.AspectJCorePreferences"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.AspectJCorePreferences-org.osgi.service.prefs.BackingStoreException-<missing>-"), 61);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-setProjectOutJar-org.eclipse.ajdt.core.AspectJCorePreferences-org.eclipse.core.resources.IProject:java.lang.String:-project:value:--void-"), 51);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.AspectJCorePreferences-org.osgi.service.prefs.BackingStoreException-<missing>-"), 144);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-setProjectAspectPath-org.eclipse.ajdt.core.AspectJCorePreferences-org.eclipse.core.resources.IProject:java.lang.String:java.lang.String:java.lang.String:-project:path:cKinds:eKinds:--void-"), 101);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.AspectJCorePreferences-org.osgi.service.prefs.BackingStoreException-<missing>-"), 227);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-setProjectInPath-org.eclipse.ajdt.core.AspectJCorePreferences-org.eclipse.core.resources.IProject:java.lang.String:java.lang.String:java.lang.String:-project:path:cKinds:eKinds:--void-"), 184);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.AspectJCorePreferences-java.lang.NumberFormatException-<missing>-"), 240);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-fromContentKind-org.eclipse.ajdt.core.AspectJCorePreferences-java.lang.String:-cKinds:--java.lang.String-"), 231);
        ajc$tjp_8 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.AspectJCorePreferences-java.lang.NumberFormatException-<missing>-"), 260);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-fromEntryKind-org.eclipse.ajdt.core.AspectJCorePreferences-java.lang.String:-eKinds:--java.lang.String-"), 245);
    }
}

