/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.aspectj.ajde.Ajde;
import org.aspectj.asm.AsmManager;
import org.aspectj.asm.IHierarchy;
import org.aspectj.asm.IProgramElement;

public class StructureModelUtil {
    public static void checkModel(String toCheck) throws ModelIncorrectException {
        Properties modelProperties = AsmManager.ModelInfo.summarizeModel().getProperties();
        StringTokenizer st = new StringTokenizer(toCheck, ",=");
        while (st.hasMoreTokens()) {
            String key = st.nextToken();
            String expValue = st.nextToken();
            boolean expectingZero = false;
            try {
                expectingZero = Integer.parseInt(expValue) == 0;
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            String value = modelProperties.getProperty(key);
            if (value == null) {
                if (expectingZero) continue;
                throw new ModelIncorrectException("Couldn't find '" + key + "' property for the model");
            }
            if (value.equals(expValue)) continue;
            throw new ModelIncorrectException("Model property '" + key + "' incorrect:  Expected " + expValue + " but found " + value);
        }
    }

    public static Map getLinesToAspectMap(String sourceFilePath) {
        HashMap aspectMap = new HashMap();
        return aspectMap;
    }

    public static Set getAspectsAffectingPackage(IProgramElement packageNode) {
        List files = StructureModelUtil.getFilesInPackage(packageNode);
        HashSet aspects = new HashSet();
        Iterator it = files.iterator();
        while (it.hasNext()) {
            IProgramElement fileNode = (IProgramElement)it.next();
            Map adviceMap = StructureModelUtil.getLinesToAspectMap(fileNode.getSourceLocation().getSourceFile().getAbsolutePath());
            Collection values = adviceMap.values();
            Iterator it2 = values.iterator();
            while (it2.hasNext()) {
                aspects.add(it2.next());
            }
        }
        return aspects;
    }

    public static List getPackagesInModel() {
        ArrayList packages = new ArrayList();
        IHierarchy model = Ajde.getDefault().getStructureModelManager().getHierarchy();
        if (model.getRoot().equals(IHierarchy.NO_STRUCTURE)) {
            return null;
        }
        return StructureModelUtil.getPackagesHelper(model.getRoot(), IProgramElement.Kind.PACKAGE, null, packages);
    }

    private static List getPackagesHelper(IProgramElement node, IProgramElement.Kind kind, String prename, List matches) {
        if (kind == null || node.getKind().equals(kind)) {
            prename = prename == null ? new String(node.toString()) : new String(prename + "." + node);
            Object[] o = new Object[]{node, prename};
            matches.add(o);
        }
        Iterator it = node.getChildren().iterator();
        while (it.hasNext()) {
            IProgramElement nextNode = (IProgramElement)it.next();
            if (!(nextNode instanceof IProgramElement)) continue;
            StructureModelUtil.getPackagesHelper(nextNode, kind, prename, matches);
        }
        return matches;
    }

    public static List getFilesInPackage(IProgramElement packageNode) {
        if (packageNode == null) {
            return null;
        }
        List packageContents = packageNode.getChildren();
        ArrayList<IProgramElement> files = new ArrayList<IProgramElement>();
        Iterator it = packageContents.iterator();
        while (it.hasNext()) {
            IProgramElement packageItem = (IProgramElement)it.next();
            if (packageItem.getKind() != IProgramElement.Kind.FILE_JAVA && packageItem.getKind() != IProgramElement.Kind.FILE_ASPECTJ) continue;
            files.add(packageItem);
        }
        return files;
    }

    public static class ModelIncorrectException
    extends Exception {
        private static final long serialVersionUID = 8920868549577870993L;

        public ModelIncorrectException(String s) {
            super(s);
        }
    }
}

