/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.dialogs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.ajdt.internal.ui.dialogs.AJTypeInfoFactory;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.CorextMessages;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.TypeFilter;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.internal.corext.util.TypeInfoFilter;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaUIException;
import org.eclipse.jdt.internal.ui.JavaUIStatus;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class AJTypeInfoHistory {
    private static final String NODE_ROOT = "typeInfoHistroy";
    private static final String NODE_TYPE_INFO = "typeInfo";
    private static final String NODE_NAME = "name";
    private static final String NODE_PACKAGE = "package";
    private static final String NODE_ENCLOSING_NAMES = "enclosingTypes";
    private static final String NODE_PATH = "path";
    private static final String NODE_MODIFIERS = "modifiers";
    private static final char[][] EMPTY_ENCLOSING_NAMES = new char[0][0];
    private Map fHistroy = new LinkedHashMap(80, 0.75f, true){
        private static final long serialVersionUID = 1L;

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 60;
        }
    };
    private static final String FILENAME = "TypeInfoHistory.xml";
    private static AJTypeInfoHistory fgInstance;

    public static synchronized AJTypeInfoHistory getInstance() {
        if (fgInstance == null) {
            fgInstance = new AJTypeInfoHistory();
        }
        return fgInstance;
    }

    private AJTypeInfoHistory() {
        this.load();
    }

    public synchronized boolean isEmpty() {
        return this.fHistroy.isEmpty();
    }

    public synchronized boolean contains(TypeInfo type) {
        return this.fHistroy.get(type) != null;
    }

    public synchronized void checkConsistency(IProgressMonitor monitor) {
        IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
        ArrayList keys = new ArrayList(this.fHistroy.keySet());
        monitor.beginTask(CorextMessages.TypeInfoHistory_consistency_check, keys.size());
        monitor.setTaskName(CorextMessages.TypeInfoHistory_consistency_check);
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            TypeInfo type = (TypeInfo)iter.next();
            try {
                IType element = type.resolveType(scope);
                if (element == null || !element.exists()) {
                    this.fHistroy.remove(type);
                }
            }
            catch (JavaModelException javaModelException) {
                this.fHistroy.remove(type);
            }
            monitor.worked(1);
        }
        monitor.done();
    }

    public synchronized void accessed(TypeInfo info) {
        this.fHistroy.put(info, info);
    }

    public synchronized TypeInfo remove(TypeInfo info) {
        return (TypeInfo)this.fHistroy.remove(info);
    }

    public synchronized TypeInfo[] getTypeInfos() {
        Collection values = this.fHistroy.values();
        int size = values.size();
        TypeInfo[] result = new TypeInfo[size];
        int i = size - 1;
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            result[i] = (TypeInfo)iter.next();
            --i;
        }
        return result;
    }

    public synchronized TypeInfo[] getFilteredTypeInfos(TypeInfoFilter filter) {
        Collection values = this.fHistroy.values();
        ArrayList<TypeInfo> result = new ArrayList<TypeInfo>();
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            TypeInfo type = (TypeInfo)iter.next();
            if (filter != null && !filter.matchesHistoryElement(type) || TypeFilter.isFiltered((String)type.getFullyQualifiedName())) continue;
            result.add(type);
        }
        Collections.reverse(result);
        return result.toArray(new TypeInfo[result.size()]);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void load() {
        IPath stateLocation = AspectJUIPlugin.getDefault().getStateLocation().append(FILENAME);
        File file = new File(stateLocation.toOSString());
        if (!file.exists()) return;
        InputStreamReader reader = null;
        try {
            try {
                reader = new InputStreamReader((InputStream)new FileInputStream(file), "utf-8");
                this.load(new InputSource(reader));
            }
            catch (IOException e) {
                JavaPlugin.log((Throwable)e);
            }
            catch (CoreException e) {
                JavaPlugin.log((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            try {
                if (reader == null) throw throwable;
                reader.close();
                throw throwable;
            }
            catch (IOException e) {
                JavaPlugin.log((Throwable)e);
            }
            throw throwable;
        }
        {
            Object var5_8 = null;
        }
        try {}
        catch (IOException e) {
            JavaPlugin.log((Throwable)e);
            return;
        }
        if (reader == null) return;
        reader.close();
    }

    private void load(InputSource inputSource) throws CoreException {
        Element root;
        AJTypeInfoFactory factory = new AJTypeInfoFactory();
        try {
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            root = parser.parse(inputSource).getDocumentElement();
        }
        catch (SAXException e) {
            throw AJTypeInfoHistory.createException(e, Messages.format((String)CorextMessages.History_error_read, (Object)FILENAME));
        }
        catch (ParserConfigurationException e) {
            throw AJTypeInfoHistory.createException(e, Messages.format((String)CorextMessages.History_error_read, (Object)FILENAME));
        }
        catch (IOException e) {
            throw AJTypeInfoHistory.createException(e, Messages.format((String)CorextMessages.History_error_read, (Object)FILENAME));
        }
        if (root == null) {
            return;
        }
        if (!root.getNodeName().equalsIgnoreCase(NODE_ROOT)) {
            return;
        }
        NodeList list = root.getChildNodes();
        int length = list.getLength();
        int i = 0;
        while (i < length) {
            Element type;
            Node node = list.item(i);
            if (node.getNodeType() == 1 && (type = (Element)node).getNodeName().equalsIgnoreCase(NODE_TYPE_INFO)) {
                String name = type.getAttribute(NODE_NAME);
                String pack = type.getAttribute(NODE_PACKAGE);
                char[][] enclosingNames = this.getEnclosingNames(type);
                String path = type.getAttribute(NODE_PATH);
                int modifiers = 0;
                try {
                    modifiers = Integer.parseInt(type.getAttribute(NODE_MODIFIERS));
                }
                catch (NumberFormatException numberFormatException) {}
                TypeInfo info = factory.create(pack.toCharArray(), name.toCharArray(), enclosingNames, modifiers, path);
                this.fHistroy.put(info, info);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void save() {
        IPath stateLocation = AspectJUIPlugin.getDefault().getStateLocation().append(FILENAME);
        File file = new File(stateLocation.toOSString());
        FileOutputStream out = null;
        try {
            try {
                out = new FileOutputStream(file);
                this.save(out);
            }
            catch (IOException e) {
                JavaPlugin.log((Throwable)e);
            }
            catch (CoreException e) {
                JavaPlugin.log((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            try {
                if (out == null) throw throwable;
                ((OutputStream)out).close();
                throw throwable;
            }
            catch (IOException e) {
                JavaPlugin.log((Throwable)e);
            }
            throw throwable;
        }
        {
            Object var5_8 = null;
        }
        try {}
        catch (IOException e) {
            JavaPlugin.log((Throwable)e);
            return;
        }
        if (out == null) return;
        ((OutputStream)out).close();
    }

    private void save(OutputStream stream) throws CoreException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element rootElement = document.createElement(NODE_ROOT);
            document.appendChild(rootElement);
            Iterator values = this.fHistroy.values().iterator();
            while (values.hasNext()) {
                TypeInfo type = (TypeInfo)values.next();
                Element typeElement = document.createElement(NODE_TYPE_INFO);
                typeElement.setAttribute(NODE_NAME, type.getTypeName());
                typeElement.setAttribute(NODE_PACKAGE, type.getPackageName());
                typeElement.setAttribute(NODE_ENCLOSING_NAMES, type.getEnclosingName());
                typeElement.setAttribute(NODE_PATH, type.getPath());
                typeElement.setAttribute(NODE_MODIFIERS, Integer.toString(type.getModifiers()));
                rootElement.appendChild(typeElement);
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(stream);
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw AJTypeInfoHistory.createException(e, Messages.format((String)CorextMessages.History_error_serialize, (Object)FILENAME));
        }
        catch (ParserConfigurationException e) {
            throw AJTypeInfoHistory.createException(e, Messages.format((String)CorextMessages.History_error_serialize, (Object)FILENAME));
        }
    }

    private char[][] getEnclosingNames(Element type) {
        String enclosingNames = type.getAttribute(NODE_ENCLOSING_NAMES);
        if (enclosingNames.length() == 0) {
            return EMPTY_ENCLOSING_NAMES;
        }
        StringTokenizer tokenizer = new StringTokenizer(enclosingNames, ".");
        ArrayList<char[]> names = new ArrayList<char[]>();
        while (tokenizer.hasMoreTokens()) {
            String name = tokenizer.nextToken();
            names.add(name.toCharArray());
        }
        return (char[][])names.toArray((T[])new char[names.size()][]);
    }

    private static JavaUIException createException(Throwable t, String message) {
        return new JavaUIException(JavaUIStatus.createError((int)4, (String)message, (Throwable)t));
    }
}

