/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.debug.ui.actions;

import java.util.HashMap;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnit;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnitManager;
import org.eclipse.ajdt.core.javaelements.PointcutElement;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.IEditorStatusLine;

public class BreakpointLocationVerifierJob
extends Job {
    private IDocument fDocument;
    private IJavaLineBreakpoint fBreakpoint;
    private int fLineNumber;
    private String fTypeName;
    private IType fType;
    private IResource fResource;
    private IEditorStatusLine fStatusLine;
    private int fOffset;
    static /* synthetic */ Class class$0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;

    public BreakpointLocationVerifierJob(IDocument document, IJavaLineBreakpoint breakpoint, int offset, int lineNumber, String typeName, IType type, IResource resource, IEditorPart editorPart) {
        super(ActionMessages.BreakpointLocationVerifierJob_breakpoint_location);
        this.fDocument = document;
        this.fBreakpoint = breakpoint;
        this.fOffset = offset;
        this.fLineNumber = lineNumber;
        this.fTypeName = typeName;
        this.fType = type;
        this.fResource = resource;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(classNotFoundException, (Object)this, ajc$tjp_0, ajc$tjp_1);
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fStatusLine = (IEditorStatusLine)editorPart.getAdapter((Class)clazz);
        this.setSystem(true);
    }

    public IStatus run(IProgressMonitor monitor) {
        AJCompilationUnit cu = AJCompilationUnitManager.INSTANCE.getAJCompilationUnit((IFile)this.fResource);
        if (cu == null) {
            cu = (ICompilationUnit)JavaCore.create((IResource)this.fResource);
        }
        try {
            IJavaElement element = cu.getElementAt(this.fOffset);
            if (element == null || element instanceof ICompilationUnit || element instanceof IType || element instanceof PointcutElement || element instanceof IField || this.emptyOrComment(this.fDocument.get(this.fOffset, this.fDocument.getLineInformation(this.fLineNumber - 1).getLength()))) {
                if (this.fBreakpoint != null) {
                    DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)this.fBreakpoint, true);
                }
                int lineNumber = this.fLineNumber + 1;
                while (lineNumber < this.fDocument.getNumberOfLines()) {
                    IRegion line = this.fDocument.getLineInformation(lineNumber - 1);
                    int offset = line.getOffset();
                    element = cu.getElementAt(offset);
                    if (!(element == null || element instanceof ICompilationUnit || element instanceof IType || element instanceof PointcutElement || element instanceof IField || this.emptyOrComment(this.fDocument.get(offset, line.getLength())))) {
                        this.createNewBreakpoint(lineNumber, this.fTypeName);
                        return new Status(0, JDIDebugUIPlugin.getUniqueIdentifier(), 4, ActionMessages.BreakpointLocationVerifierJob_not_valid_location, null);
                    }
                    ++lineNumber;
                }
                this.report(ActionMessages.BreakpointLocationVerifierJob_not_valid_location);
                return new Status(0, JDIDebugUIPlugin.getUniqueIdentifier(), 4, ActionMessages.BreakpointLocationVerifierJob_not_valid_location, null);
            }
        }
        catch (JavaModelException javaModelException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_2, ajc$tjp_3);
        }
        catch (CoreException coreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_4, ajc$tjp_3);
        }
        catch (BadLocationException badLocationException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(badLocationException, (Object)this, ajc$tjp_5, ajc$tjp_3);
        }
        return new Status(0, JDIDebugUIPlugin.getUniqueIdentifier(), 0, ActionMessages.BreakpointLocationVerifierJob_breakpoint_set, null);
    }

    private boolean emptyOrComment(String line) {
        String trimmed = line.trim();
        return trimmed.equals("") || trimmed.startsWith("/*") || trimmed.startsWith("*") || trimmed.startsWith("//");
    }

    private void createNewBreakpoint(int lineNumber, String typeName) throws CoreException {
        HashMap newAttributes = new HashMap(10);
        if (this.fType != null) {
            try {
                IRegion line = this.fDocument.getLineInformation(lineNumber - 1);
                int start = line.getOffset();
                int end = start + line.getLength() - 1;
                BreakpointUtils.addJavaBreakpointAttributesWithMemberDetails(newAttributes, (IJavaElement)this.fType, (int)start, (int)end);
            }
            catch (BadLocationException badLocationException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(badLocationException, (Object)this, ajc$tjp_6, ajc$tjp_7);
                BadLocationException ble = badLocationException;
                JDIDebugUIPlugin.log((Throwable)ble);
            }
        }
        JDIDebugModel.createLineBreakpoint((IResource)this.fResource, (String)typeName, (int)lineNumber, (int)-1, (int)-1, (int)0, (boolean)true, newAttributes);
    }

    protected void report(final String message) {
        JDIDebugUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                if (BreakpointLocationVerifierJob.this.fStatusLine != null) {
                    BreakpointLocationVerifierJob.this.fStatusLine.setMessage(true, message, null);
                }
                if (message != null && JDIDebugUIPlugin.getActiveWorkbenchShell() != null) {
                    Display.getCurrent().beep();
                }
            }
        });
    }

    static {
        Factory factory = new Factory("BreakpointLocationVerifierJob.java", Class.forName("org.eclipse.ajdt.internal.debug.ui.actions.BreakpointLocationVerifierJob"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.debug.ui.actions.BreakpointLocationVerifierJob-java.lang.ClassNotFoundException-<missing>-"), 99);
        ajc$tjp_1 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1--org.eclipse.ajdt.internal.debug.ui.actions.BreakpointLocationVerifierJob-org.eclipse.jface.text.IDocument:org.eclipse.jdt.debug.core.IJavaLineBreakpoint:int:int:java.lang.String:org.eclipse.jdt.core.IType:org.eclipse.core.resources.IResource:org.eclipse.ui.IEditorPart:-document:breakpoint:offset:lineNumber:typeName:type:resource:editorPart:--"), 90);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.debug.ui.actions.BreakpointLocationVerifierJob-org.eclipse.jdt.core.JavaModelException-<missing>-"), 140);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-run-org.eclipse.ajdt.internal.debug.ui.actions.BreakpointLocationVerifierJob-org.eclipse.core.runtime.IProgressMonitor:-monitor:--org.eclipse.core.runtime.IStatus-"), 103);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.debug.ui.actions.BreakpointLocationVerifierJob-org.eclipse.core.runtime.CoreException-<missing>-"), 141);
        ajc$tjp_5 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.debug.ui.actions.BreakpointLocationVerifierJob-org.eclipse.jface.text.BadLocationException-<missing>-"), 142);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.debug.ui.actions.BreakpointLocationVerifierJob-org.eclipse.jface.text.BadLocationException-ble-"), 173);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-createNewBreakpoint-org.eclipse.ajdt.internal.debug.ui.actions.BreakpointLocationVerifierJob-int:java.lang.String:-lineNumber:typeName:-org.eclipse.core.runtime.CoreException:-void-"), 165);
    }
}

