/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.launching;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AJLog;
import org.eclipse.ajdt.core.BuildConfig;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnit;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnitManager;
import org.eclipse.ajdt.core.javaelements.AspectElement;
import org.eclipse.ajdt.core.model.AJModel;
import org.eclipse.ajdt.core.model.AJProjectModel;
import org.eclipse.ajdt.internal.launching.XMLPrintHandler;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class LTWUtils {
    public static final String AOP_XML_LOCATION = "META-INF/aop.xml";
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public static void generateLTWConfigFile(IJavaProject project) {
        try {
            IPackageFragmentRoot[] roots = project.getAllPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                IPackageFragmentRoot root = roots[i];
                if (!(root instanceof JarPackageFragmentRoot) && root.getJavaProject().equals(project)) {
                    List aspects = LTWUtils.getAspects(root);
                    String path = root.getElementName().trim().equals("") ? AOP_XML_LOCATION : root.getElementName().trim().concat("/").concat(AOP_XML_LOCATION);
                    IFile ltwConfigFile = (IFile)project.getProject().findMember(path);
                    if (ltwConfigFile == null) {
                        if (aspects.size() != 0) {
                            IFolder metainf = (IFolder)((Workspace)ResourcesPlugin.getWorkspace()).newResource(project.getPath().append("/" + root.getElementName() + "/META-INF"), 2);
                            IFile aopFile = (IFile)((Workspace)ResourcesPlugin.getWorkspace()).newResource(project.getPath().append(path), 1);
                            if (metainf == null || !metainf.exists()) {
                                metainf.create(true, true, null);
                            }
                            aopFile.create((InputStream)new ByteArrayInputStream(new byte[0]), true, null);
                            project.getProject().refreshLocal(4, null);
                            LTWUtils.addAspectsToLTWConfigFile(false, aspects, aopFile);
                            LTWUtils.copyToOutputFolder(aopFile, project, root.getRawClasspathEntry());
                        }
                    } else {
                        LTWUtils.addAspectsToLTWConfigFile(true, aspects, ltwConfigFile);
                        LTWUtils.copyToOutputFolder(ltwConfigFile, project, root.getRawClasspathEntry());
                    }
                }
                ++i;
            }
        }
        catch (Exception exception) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(exception, ajc$tjp_0, ajc$tjp_1);
        }
    }

    private static void copyToOutputFolder(IFile file, IJavaProject javaProject, IClasspathEntry srcEntry) throws CoreException {
        IContainer srcContainer;
        IContainer outputFolder;
        IPath outputPath = srcEntry.getOutputLocation();
        if (outputPath == null) {
            outputPath = javaProject.getOutputLocation();
        }
        if (!(outputFolder = LTWUtils.getContainerForGivenPath(outputPath = outputPath.removeFirstSegments(1).makeRelative(), javaProject.getProject())).equals((Object)(srcContainer = LTWUtils.getContainerForGivenPath(srcEntry.getPath().removeFirstSegments(1), javaProject.getProject())))) {
            IFile outputFile = outputFolder.getFile((IPath)new Path(AOP_XML_LOCATION));
            if (outputFile.exists()) {
                AJLog.log((String)("Deleting existing file " + outputFile));
                outputFile.delete(1, null);
            }
            AJLog.log((String)("Copying added file " + file));
            IFolder metainf = (IFolder)((Workspace)ResourcesPlugin.getWorkspace()).newResource((IPath)new Path(outputFolder.getFullPath() + "/META-INF"), 2);
            if (metainf == null || !metainf.exists()) {
                metainf.create(true, true, null);
            }
            file.copy(outputFile.getFullPath(), 1, null);
            outputFile.setDerived(true);
            outputFile.refreshLocal(0, null);
        }
    }

    private static IContainer getContainerForGivenPath(IPath path, IProject project) {
        if (path.toOSString().equals("")) {
            return project;
        }
        return project.getFolder(path);
    }

    private static Document createNewXMLDocument() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        DOMImplementation impl = builder.getDOMImplementation();
        Document doc = impl.createDocument(null, "aspectj", null);
        Element root = doc.getDocumentElement();
        Element aspectsElement = doc.createElement("aspects");
        root.appendChild(aspectsElement);
        return doc;
    }

    private static void addAspectsToLTWConfigFile(boolean readFileFirst, List aspects, IFile configFile) throws Exception {
        Document doc = readFileFirst ? LTWUtils.readFile(configFile) : LTWUtils.createNewXMLDocument();
        if (doc == null) {
            return;
        }
        NodeList children = doc.getDocumentElement().getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeName().equals("aspects")) {
                if (child.hasChildNodes()) {
                    Node root = child.getFirstChild();
                    while (root != null) {
                        child.removeChild(root);
                        root = child.getFirstChild();
                    }
                }
                Iterator iter = aspects.iterator();
                while (iter.hasNext()) {
                    AspectElement aspect = (AspectElement)iter.next();
                    Element grandChild = doc.createElement("aspect");
                    grandChild.setAttribute("name", LTWUtils.getFullyQualifiedName(aspect));
                    child.appendChild(grandChild);
                }
            }
            ++i;
        }
        File file = new File(LTWUtils.getFileName(configFile));
        XMLPrintHandler.writeFile(doc, file);
        configFile.refreshLocal(1, null);
    }

    private static Document readFile(IFile configFile) throws Exception {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        builder.setErrorHandler(new AOPXMLErrorHandler());
        return builder.parse(configFile.getContents());
    }

    private static String getFileName(IFile configFile) {
        return String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString()) + configFile.getFullPath().toOSString();
    }

    private static String getFullyQualifiedName(AspectElement aspect) {
        StringBuffer sb = new StringBuffer();
        IJavaElement parent = aspect.getCompilationUnit().getParent();
        if (parent instanceof IPackageFragment && !parent.getElementName().equals("")) {
            sb.append(parent.getElementName());
            sb.append(".");
        }
        sb.append(LTWUtils.getFullTypeName((IType)aspect));
        return sb.toString();
    }

    private static String getFullTypeName(IType element) {
        if (element != null && element.getParent() instanceof IType) {
            return String.valueOf(LTWUtils.getFullTypeName((IType)element.getParent())) + "." + element.getElementName();
        }
        return element.getElementName();
    }

    public static List getAspects(IPackageFragmentRoot root) throws CoreException {
        final ArrayList aspects = new ArrayList();
        final List includedFiles = BuildConfig.getIncludedSourceFiles((IProject)root.getJavaProject().getProject());
        root.getResource().accept(new IResourceVisitor(){
            private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
            private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

            public boolean visit(IResource resource) {
                if (includedFiles.contains(resource)) {
                    AJCompilationUnit ajcu = AJCompilationUnitManager.INSTANCE.getAJCompilationUnit((IFile)resource);
                    if (ajcu != null) {
                        try {
                            IType[] types = ajcu.getAllTypes();
                            int i = 0;
                            while (i < types.length) {
                                IType type = types[i];
                                if (type instanceof AspectElement) {
                                    aspects.add(type);
                                }
                                ++i;
                            }
                        }
                        catch (JavaModelException javaModelException) {
                            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_0, ajc$tjp_1);
                        }
                    } else {
                        AJProjectModel model;
                        ICompilationUnit cu = JavaCore.createCompilationUnitFrom((IFile)((IFile)resource));
                        if (cu != null && (model = AJModel.getInstance().getModelForProject(resource.getProject())) != null) {
                            Set types = model.getAspectsForJavaFile(cu);
                            Iterator iter = types.iterator();
                            while (iter.hasNext()) {
                                AspectElement element = (AspectElement)iter.next();
                                aspects.add(element);
                            }
                        }
                    }
                }
                return resource.getType() == 2 || resource.getType() == 4;
            }

            static {
                Factory factory = new Factory("LTWUtils.java", Class.forName("org.eclipse.ajdt.internal.launching.LTWUtils$1"));
                ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.launching.LTWUtils$1-org.eclipse.jdt.core.JavaModelException-<missing>-"), 304);
                ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-visit-org.eclipse.ajdt.internal.launching.LTWUtils$1-org.eclipse.core.resources.IResource:-resource:--boolean-"), 291);
            }
        });
        return aspects;
    }

    static {
        Factory factory = new Factory("LTWUtils.java", Class.forName("org.eclipse.ajdt.internal.launching.LTWUtils"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.launching.LTWUtils-java.lang.Exception-<missing>-"), 118);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-generateLTWConfigFile-org.eclipse.ajdt.internal.launching.LTWUtils-org.eclipse.jdt.core.IJavaProject:-project:--void-"), 73);
    }

    private static class AOPXMLErrorHandler
    extends DefaultHandler {
        AOPXMLErrorHandler() {
        }

        public void error(SAXParseException exception) throws SAXException {
            throw new AOPXMLException("A problem occurred parsing aop.xml file " + exception.getSystemId().substring(exception.getSystemId().indexOf("file:///") + 8) + "[" + exception.getLineNumber() + "," + exception.getColumnNumber() + "]" + System.getProperty("line.separator") + exception.getMessage().substring(exception.getMessage().indexOf(58) + 2));
        }

        public void warning(SAXParseException exception) throws SAXException {
            this.error(exception);
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            this.error(exception);
        }
    }

    private static class AOPXMLException
    extends SAXException {
        private static final long serialVersionUID = 4296332843488816647L;

        AOPXMLException(String input) {
            super(input);
        }
    }
}

