/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui;

import java.util.ArrayList;
import org.aspectj.asm.IProgramElement;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.BuildConfig;
import org.eclipse.ajdt.core.javaelements.AJCodeElement;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnit;
import org.eclipse.ajdt.core.javaelements.AdviceElement;
import org.eclipse.ajdt.core.javaelements.DeclareElement;
import org.eclipse.ajdt.core.javaelements.IAspectJElement;
import org.eclipse.ajdt.core.javaelements.IntertypeElement;
import org.eclipse.ajdt.core.model.AJModel;
import org.eclipse.ajdt.internal.ui.resources.AJDTIcon;
import org.eclipse.ajdt.internal.ui.resources.AspectJImages;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.internal.ui.viewsupport.TreeHierarchyLayoutProblemsDecorator;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.decorators.DecoratorManager;

public class ImageDecorator
implements ILabelDecorator {
    private ArrayList listeners;
    private ImageDescriptorRegistry fRegistry;
    private boolean preventRecursion = false;
    private TreeHierarchyLayoutProblemsDecorator problemsDecorator;
    private DecoratorManager decman;
    private AspectJImages iconRegistry = AspectJImages.instance();
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    public ImageDecorator() {
        this.listeners = new ArrayList(2);
        this.problemsDecorator = new TreeHierarchyLayoutProblemsDecorator();
        this.decman = WorkbenchPlugin.getDefault().getDecoratorManager();
    }

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add(listener);
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove(listener);
    }

    public Image decorateImage(Image image, Object element) {
        if (this.preventRecursion) {
            return null;
        }
        Image img = null;
        if (element instanceof ICompilationUnit) {
            ICompilationUnit comp = (ICompilationUnit)element;
            IFile file = null;
            try {
                file = (IFile)comp.getCorrespondingResource();
            }
            catch (JavaModelException javaModelException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_0, ajc$tjp_1);
            }
            if (file != null && comp instanceof AJCompilationUnit) {
                if (BuildConfig.isIncluded((IResource)file)) {
                    Rectangle rect = image.getBounds();
                    img = this.getImageLabel(ImageDecorator.getJavaImageDescriptor(AspectJImages.ASPECTJ_FILE.getImageDescriptor(), rect, 0));
                } else {
                    Rectangle rect = image.getBounds();
                    img = this.getImageLabel(ImageDecorator.getJavaImageDescriptor(AspectJImages.EXCLUDED_ASPECTJ_FILE.getImageDescriptor(), rect, 0));
                }
            }
        } else if (element instanceof IFile) {
            IFile file = (IFile)element;
            if (file.getFileExtension() != null && file.getFileExtension().equals("ajproperties")) {
                img = this.getImageLabel(AspectJImages.BC_FILE.getImageDescriptor());
            }
        } else if (element instanceof AJCodeElement) {
            img = this.getImageLabel(AspectJImages.AJ_CODE.getImageDescriptor());
        } else if (element instanceof IAspectJElement) {
            try {
                IAspectJElement ajElem = (IAspectJElement)element;
                if (ajElem.getJavaProject().getProject().exists()) {
                    IProgramElement.Accessibility acceb = ajElem.getAJAccessibility();
                    AJDTIcon icon = null;
                    icon = acceb == null ? (ajElem instanceof AdviceElement ? (AJDTIcon)this.iconRegistry.getAdviceIcon(ajElem.getAJExtraInformation(), AJModel.getInstance().hasRuntimeTest((IJavaElement)ajElem)) : (ajElem instanceof IntertypeElement ? (AJDTIcon)this.iconRegistry.getStructureIcon(ajElem.getAJKind(), ajElem.getAJAccessibility()) : (ajElem instanceof DeclareElement ? (AJDTIcon)this.iconRegistry.getStructureIcon(ajElem.getAJKind(), ajElem.getAJAccessibility()) : (AJDTIcon)this.iconRegistry.getIcon(ajElem.getAJKind())))) : (AJDTIcon)this.iconRegistry.getStructureIcon(ajElem.getAJKind(), ajElem.getAJAccessibility());
                    if (icon != null) {
                        img = this.getImageLabel(ImageDecorator.getJavaImageDescriptor(icon.getImageDescriptor(), image.getBounds(), this.computeJavaAdornmentFlags((IJavaElement)ajElem)));
                    }
                }
            }
            catch (JavaModelException javaModelException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_2, ajc$tjp_1);
            }
        }
        if (img != null) {
            this.preventRecursion = true;
            img = this.problemsDecorator.decorateImage(img, element);
            img = this.decman.decorateImage(img, element);
            this.preventRecursion = false;
            return img;
        }
        return null;
    }

    private Image getImageLabel(ImageDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        return this.getRegistry().get(descriptor);
    }

    private ImageDescriptorRegistry getRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = JavaPlugin.getImageDescriptorRegistry();
        }
        return this.fRegistry;
    }

    public static ImageDescriptor getJavaImageDescriptor(ImageDescriptor descriptor, Rectangle rect, int adorflags) {
        int flags = rect.width == 16 ? 2 : 0;
        Point size = ImageDecorator.useSmallSize(flags) ? JavaElementImageProvider.SMALL_SIZE : JavaElementImageProvider.BIG_SIZE;
        return new JavaElementImageDescriptor(descriptor, adorflags, size);
    }

    private static boolean useSmallSize(int flags) {
        return (flags & 2) != 0;
    }

    public String decorateText(String text, Object element) {
        if (element instanceof AJCompilationUnit) {
            return text.replaceFirst(".java", ".aj");
        }
        if (element instanceof IAspectJElement) {
            try {
                IProgramElement.Kind kind;
                if (((IAspectJElement)element).getJavaProject().getProject().exists() && (kind = ((IAspectJElement)element).getAJKind()) != IProgramElement.Kind.ASPECT && kind != IProgramElement.Kind.ADVICE && kind != IProgramElement.Kind.POINTCUT && kind != IProgramElement.Kind.INTER_TYPE_METHOD && kind != IProgramElement.Kind.INTER_TYPE_CONSTRUCTOR) {
                    return text.substring(0, text.length() - 2);
                }
            }
            catch (JavaModelException javaModelException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_3, ajc$tjp_4);
            }
        }
        return null;
    }

    private int computeJavaAdornmentFlags(IJavaElement element) {
        int flags = 0;
        if (element instanceof IMember) {
            try {
                int modifiers;
                IMember member = (IMember)element;
                if (element.getElementType() == 9 && ((IMethod)element).isConstructor()) {
                    flags |= 0x200;
                }
                if (Flags.isAbstract((int)(modifiers = member.getFlags())) && ImageDecorator.confirmAbstract(member)) {
                    flags |= 1;
                }
                if (Flags.isFinal((int)modifiers) || ImageDecorator.isInterfaceField(member)) {
                    flags |= 2;
                }
                if (Flags.isSynchronized((int)modifiers) && ImageDecorator.confirmSynchronized((IJavaElement)member)) {
                    flags |= 4;
                }
                if (Flags.isStatic((int)modifiers) || ImageDecorator.isInterfaceField(member)) {
                    flags |= 8;
                }
                if (Flags.isDeprecated((int)modifiers)) {
                    flags |= 0x400;
                }
                if (member.getElementType() == 7 && JavaModelUtil.hasMainMethod((IType)((IType)member))) {
                    flags |= 0x10;
                }
            }
            catch (JavaModelException javaModelException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_5, ajc$tjp_6);
            }
        }
        return flags;
    }

    private static boolean confirmAbstract(IMember element) throws JavaModelException {
        if (element.getElementType() == 7) {
            return ((IType)element).isClass();
        }
        return element.getDeclaringType().isClass();
    }

    private static boolean isInterfaceField(IMember element) throws JavaModelException {
        if (element.getElementType() == 8) {
            return element.getDeclaringType().isInterface();
        }
        return false;
    }

    private static boolean confirmSynchronized(IJavaElement member) {
        return member.getElementType() != 7;
    }

    static {
        Factory factory = new Factory("ImageDecorator.java", Class.forName("org.eclipse.ajdt.internal.ui.ImageDecorator"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.ImageDecorator-org.eclipse.jdt.core.JavaModelException-<missing>-"), 101);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-decorateImage-org.eclipse.ajdt.internal.ui.ImageDecorator-org.eclipse.swt.graphics.Image:java.lang.Object:-image:element:--org.eclipse.swt.graphics.Image-"), 91);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.ImageDecorator-org.eclipse.jdt.core.JavaModelException-<missing>-"), 144);
        ajc$tjp_3 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.ImageDecorator-org.eclipse.jdt.core.JavaModelException-<missing>-"), 202);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-decorateText-org.eclipse.ajdt.internal.ui.ImageDecorator-java.lang.String:java.lang.Object:-text:element:--java.lang.String-"), 190);
        ajc$tjp_5 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.ImageDecorator-org.eclipse.jdt.core.JavaModelException-<missing>-"), 236);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-computeJavaAdornmentFlags-org.eclipse.ajdt.internal.ui.ImageDecorator-org.eclipse.jdt.core.IJavaElement:-element:--int-"), 209);
    }
}

