/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.diff;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.model.AJModel;
import org.eclipse.ajdt.core.model.AJProjectModel;
import org.eclipse.ajdt.internal.ui.text.UIMessages;
import org.eclipse.ajdt.internal.utils.AJDTUtils;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class SaveCrosscuttingMap
implements IWorkbenchWindowActionDelegate {
    private IProject currentProject;
    static /* synthetic */ Class class$0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        String mapName;
        if (this.currentProject == null) {
            return;
        }
        String title = UIMessages.savemap_dialog_title;
        String msg = UIMessages.savemap_dialog_message;
        String defaultFileName = UIMessages.savemap_as_default;
        String initial = AJDTUtils.getFreeFileName(this.currentProject, defaultFileName, "ajmap");
        InputDialog input = new InputDialog(null, title, msg, initial, null);
        input.setBlockOnOpen(true);
        if (input.open() == 0 && (mapName = input.getValue()) != null && mapName.length() > 0) {
            IPath file;
            if (!mapName.endsWith(".ajmap")) {
                mapName = String.valueOf(mapName) + ".ajmap";
            }
            if ((file = this.currentProject.getFile(mapName).getLocation()).toFile().exists() && !this.askUserOverwrite(mapName)) {
                return;
            }
            AJProjectModel pm = AJModel.getInstance().getModelForProject(this.currentProject);
            pm.saveModel(file);
            try {
                this.currentProject.getFile(mapName).refreshLocal(0, null);
            }
            catch (CoreException coreException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_0, ajc$tjp_1);
            }
        }
    }

    private boolean askUserOverwrite(String fileName) {
        String[] options = new String[]{UIMessages.BCDialog_Overwrite_yes, UIMessages.BCDialog_Overwrite_no};
        String title = UIMessages.BCDialog_Overwrite_title;
        String msg = UIMessages.BCDialog_Overwrite_message.replaceAll("%fileName", fileName);
        MessageDialog mdiag = new MessageDialog(null, title, null, msg, 3, options, 1);
        return mdiag.open() == 0;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.currentProject = null;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object first = structuredSelection.getFirstElement();
            if (first instanceof IProject) {
                this.currentProject = (IProject)first;
            } else if (first instanceof IAdaptable) {
                IAdaptable iAdaptable = (IAdaptable)first;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.core.resources.IProject");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(classNotFoundException, this, ajc$tjp_2, ajc$tjp_3);
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.currentProject = (IProject)iAdaptable.getAdapter((Class)clazz);
            }
        }
    }

    static {
        Factory factory = new Factory("SaveCrosscuttingMap.java", Class.forName("org.eclipse.ajdt.internal.ui.diff.SaveCrosscuttingMap"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.diff.SaveCrosscuttingMap-org.eclipse.core.runtime.CoreException-<missing>-"), 82);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-run-org.eclipse.ajdt.internal.ui.diff.SaveCrosscuttingMap-org.eclipse.jface.action.IAction:-action:--void-"), 53);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.diff.SaveCrosscuttingMap-java.lang.ClassNotFoundException-<missing>-"), 111);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-selectionChanged-org.eclipse.ajdt.internal.ui.diff.SaveCrosscuttingMap-org.eclipse.jface.action.IAction:org.eclipse.jface.viewers.ISelection:-action:selection:--void-"), 103);
    }
}

