/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.editor;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnitManager;
import org.eclipse.ajdt.core.model.AJModel;
import org.eclipse.ajdt.core.model.AJRelationshipManager;
import org.eclipse.ajdt.core.model.AJRelationshipType;
import org.eclipse.ajdt.internal.ui.ajde.ErrorHandler;
import org.eclipse.ajdt.internal.ui.markers.AJMarkersDialog;
import org.eclipse.ajdt.internal.ui.text.UIMessages;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.DecoratingJavaLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.ImageImageDescriptor;
import org.eclipse.jdt.internal.ui.viewsupport.JavaUILabelProvider;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.AbstractRulerActionDelegate;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;

public class AdviceActionDelegate
extends AbstractRulerActionDelegate {
    IEditorPart editor = null;
    IVerticalRulerInfo rulerInfo = null;
    static /* synthetic */ Class class$0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    public void setActiveEditor(IAction callerAction, IEditorPart targetEditor) {
        String id;
        if (!(targetEditor == null || (id = targetEditor.getSite().getId()).equals("org.eclipse.jdt.ui.CompilationUnitEditor") || id.equals("org.eclipse.jdt.ui.ClassFileEditor") || id.equals("org.eclipse.ajdt.internal.ui.editor.CompilationUnitEditor"))) {
            targetEditor = null;
        }
        this.editor = targetEditor;
        super.setActiveEditor(callerAction, targetEditor);
    }

    protected IAction createAction(ITextEditor editor, IVerticalRulerInfo rulerInfo) {
        this.rulerInfo = rulerInfo;
        return null;
    }

    public void menuAboutToShow(IMenuManager manager) {
        try {
            IFileEditorInput ifep = (IFileEditorInput)this.editor.getEditorInput();
            IFile ifile = ifep.getFile();
            int linenumber = this.rulerInfo.getLineOfLastMouseButtonActivity();
            Integer clickedLine = new Integer(linenumber + 1);
            Object cu = ifile.getFileExtension().equals("aj") ? AJCompilationUnitManager.INSTANCE.getAJCompilationUnit(ifile) : (ICompilationUnit)JavaCore.create((IFile)ifile);
            List javaElementsForLine = this.getJavaElementsForLine((IJavaElement)cu, clickedLine);
            boolean addedMenu = false;
            addedMenu = this.createMenuForRelationshipType(javaElementsForLine, manager, addedMenu, AJRelationshipManager.ADVISES);
            addedMenu = this.createMenuForRelationshipType(javaElementsForLine, manager, addedMenu, AJRelationshipManager.ADVISED_BY);
            addedMenu = this.createMenuForRelationshipType(javaElementsForLine, manager, addedMenu, AJRelationshipManager.ANNOTATES);
            addedMenu = this.createMenuForRelationshipType(javaElementsForLine, manager, addedMenu, AJRelationshipManager.ANNOTATED_BY);
            addedMenu = this.createMenuForRelationshipType(javaElementsForLine, manager, addedMenu, AJRelationshipManager.DECLARED_ON);
            addedMenu = this.createMenuForRelationshipType(javaElementsForLine, manager, addedMenu, AJRelationshipManager.ASPECT_DECLARATIONS);
            addedMenu = this.createMenuForRelationshipType(javaElementsForLine, manager, addedMenu, AJRelationshipManager.SOFTENS);
            addedMenu = this.createMenuForRelationshipType(javaElementsForLine, manager, addedMenu, AJRelationshipManager.SOFTENED_BY);
            if (addedMenu) {
                this.createAJToolsMenu(manager);
            }
            IMarker[] probMarkers = ifile.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            MenuManager problemSubmenu = null;
            boolean problemSubmenuInitialized = false;
            if (probMarkers != null && probMarkers.length != 0) {
                int j = 0;
                while (j < probMarkers.length) {
                    IMarker m = probMarkers[j];
                    if (m.getAttribute("lineNumber").equals(clickedLine)) {
                        String loc;
                        int relCount = 0;
                        if ((loc = (String)m.getAttribute("relatedLocations-" + relCount++)) != null) {
                            while (loc != null) {
                                String[] s = loc.split(":::");
                                String resName = s[0].substring(s[0].lastIndexOf(File.separator) + 1);
                                String textLabel = NLS.bind((String)UIMessages.EditorRulerContextMenu_relatedLocation_message, (Object[])new String[]{resName, s[1]});
                                RelatedLocationMenuAction ama = new RelatedLocationMenuAction(textLabel, loc);
                                if (!problemSubmenuInitialized) {
                                    problemSubmenu = new MenuManager(UIMessages.EditorRulerContextMenu_relatedLocations);
                                    manager.add((IContributionItem)problemSubmenu);
                                    problemSubmenuInitialized = true;
                                }
                                problemSubmenu.add((IAction)ama);
                                loc = (String)m.getAttribute("relatedLocations-" + relCount++);
                            }
                        }
                    }
                    ++j;
                }
            }
        }
        catch (CoreException coreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_0, ajc$tjp_1);
            CoreException ce = coreException;
            ErrorHandler.handleAJDTError(UIMessages.AdviceActionDelegate_exception_adding_advice_to_context_menu, ce);
        }
    }

    private void createAJToolsMenu(IMenuManager manager) {
        MenuManager menu = new MenuManager(UIMessages.AdviceActionDelegate_ajtools);
        manager.add((IContributionItem)menu);
        menu.add((IAction)new Action(){

            public String getText() {
                return UIMessages.AdviceActionDelegate_configure_markers;
            }

            public void run() {
                IFile resource = ((IFileEditorInput)AdviceActionDelegate.this.editor.getEditorInput()).getFile();
                if (resource != null) {
                    Shell shell = AspectJUIPlugin.getDefault().getActiveWorkbenchWindow().getShell();
                    IProject project = resource.getProject();
                    AJMarkersDialog dialog = new AJMarkersDialog(shell, project);
                    dialog.open();
                }
            }
        });
    }

    private boolean createMenuForRelationshipType(List javaElements, IMenuManager manager, boolean addedMenu, AJRelationshipType relationshipType) {
        boolean menuInitialized = false;
        MenuManager menu = null;
        Iterator iter = javaElements.iterator();
        while (iter.hasNext()) {
            IJavaElement element = (IJavaElement)iter.next();
            List relationships = AJModel.getInstance().getRelatedElements(relationshipType, element);
            if (relationships == null) continue;
            addedMenu = true;
            Iterator iterator = relationships.iterator();
            while (iterator.hasNext()) {
                IJavaElement el = (IJavaElement)iterator.next();
                if (!menuInitialized) {
                    menu = new MenuManager(relationshipType.getMenuName());
                    manager.add((IContributionItem)menu);
                    menuInitialized = true;
                }
                menu.add((IAction)new MenuAction(el));
            }
        }
        return addedMenu;
    }

    private List getJavaElementsForLine(IJavaElement je, int clickedLine) {
        IJavaElement[] children;
        AJModel model = AJModel.getInstance();
        ArrayList<IJavaElement> toReturn = new ArrayList<IJavaElement>();
        List extraChildren = model.getExtraChildren(je);
        if (extraChildren != null) {
            Iterator iter = extraChildren.iterator();
            while (iter.hasNext()) {
                IJavaElement element = (IJavaElement)iter.next();
                if (model.getJavaElementLineNumber(element) == clickedLine) {
                    toReturn.add(element);
                }
                toReturn.addAll(this.getJavaElementsForLine(element, clickedLine));
            }
        }
        if (je instanceof ICompilationUnit) {
            try {
                children = ((ICompilationUnit)je).getChildren();
                int i = 0;
                while (i < children.length) {
                    IJavaElement element = children[i];
                    if (model.getJavaElementLineNumber(element) == clickedLine) {
                        toReturn.add(element);
                    }
                    toReturn.addAll(this.getJavaElementsForLine(element, clickedLine));
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_2, ajc$tjp_3);
            }
        } else if (je instanceof IType) {
            try {
                children = ((IType)je).getChildren();
                int i = 0;
                while (i < children.length) {
                    IJavaElement element = children[i];
                    if (model.getJavaElementLineNumber(element) == clickedLine) {
                        toReturn.add(element);
                    }
                    toReturn.addAll(this.getJavaElementsForLine(element, clickedLine));
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_4, ajc$tjp_3);
            }
        } else if (je instanceof IParent) {
            try {
                children = ((IParent)je).getChildren();
                int i = 0;
                while (i < children.length) {
                    IJavaElement element = children[i];
                    if (model.getJavaElementLineNumber(element) == clickedLine) {
                        toReturn.add(element);
                    }
                    toReturn.addAll(this.getJavaElementsForLine(element, clickedLine));
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_5, ajc$tjp_3);
            }
        }
        return toReturn;
    }

    protected void report(final String message) {
        JDIDebugUIPlugin.getStandardDisplay().asyncExec(new Runnable(){
            private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
            private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

            public void run() {
                IEditorStatusLine fStatusLine;
                IEditorPart iEditorPart = AdviceActionDelegate.this.editor;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(classNotFoundException, this, ajc$tjp_0, ajc$tjp_1);
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((fStatusLine = (IEditorStatusLine)iEditorPart.getAdapter((Class)clazz)) != null) {
                    fStatusLine.setMessage(true, message, null);
                }
                if (message != null && JDIDebugUIPlugin.getActiveWorkbenchShell() != null) {
                    Display.getCurrent().beep();
                }
            }

            static {
                Factory factory = new Factory("AdviceActionDelegate.java", Class.forName("org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate$2"));
                ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate$2-java.lang.ClassNotFoundException-<missing>-"), 458);
                ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-run-org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate$2----void-"), 457);
            }
        });
    }

    static {
        Factory factory = new Factory("AdviceActionDelegate.java", Class.forName("org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate-org.eclipse.core.runtime.CoreException-ce-"), 190);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-menuAboutToShow-org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate-org.eclipse.jface.action.IMenuManager:-manager:--void-"), 116);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate-org.eclipse.jdt.core.JavaModelException-<missing>-"), 281);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getJavaElementsForLine-org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate-org.eclipse.jdt.core.IJavaElement:int:-je:clickedLine:--java.util.List-"), 258);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate-org.eclipse.jdt.core.JavaModelException-<missing>-"), 293);
        ajc$tjp_5 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate-org.eclipse.jdt.core.JavaModelException-<missing>-"), 306);
    }

    private static class MenuAction
    extends Action {
        private static ILabelProvider labelProvider;
        private IJavaElement jumpLocation;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

        static {
            Factory factory = new Factory("AdviceActionDelegate.java", Class.forName("org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate$MenuAction"));
            ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate$MenuAction-org.eclipse.core.runtime.CoreException-<missing>-"), 347);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-run-org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate$MenuAction----void-"), 335);
            labelProvider = new DecoratingJavaLabelProvider((JavaUILabelProvider)new AppearanceAwareLabelProvider());
        }

        public MenuAction(IJavaElement el) {
            super(AJModel.getInstance().getJavaElementLinkName(el));
            Image image = labelProvider.getImage((Object)el);
            if (image != null) {
                this.setImageDescriptor((ImageDescriptor)new ImageImageDescriptor(image));
            }
            this.jumpLocation = el;
        }

        public void run() {
            IJavaElement parentCU = this.jumpLocation.getAncestor(5);
            if (parentCU != null) {
                IResource res = parentCU.getResource();
                try {
                    IMarker marker = res.createMarker("org.eclipse.core.resources.marker");
                    int lineNumber = AJModel.getInstance().getJavaElementLineNumber(this.jumpLocation);
                    if (lineNumber >= 0) {
                        marker.setAttribute("lineNumber", lineNumber);
                    }
                    IDE.openEditor((IWorkbenchPage)AspectJUIPlugin.getDefault().getActiveWorkbenchWindow().getActivePage(), (IMarker)marker);
                }
                catch (CoreException coreException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_0, ajc$tjp_1);
                }
            }
        }
    }

    abstract class BaseAJDTMenuAction
    extends Action {
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

        BaseAJDTMenuAction(String s) {
            super(s);
        }

        abstract String getJumpLocation();

        public void run() {
            String[] s = this.getJumpLocation().split(":::");
            String filepath = s[0];
            String linenumber = s[1];
            IResource r = AspectJUIPlugin.getDefault().getAjdtProjectProperties().findResource(filepath);
            if (r == null) {
                r = AspectJUIPlugin.getDefault().getAjdtProjectProperties().findResource(filepath, AspectJPlugin.getDefault().getCurrentProject());
            }
            IResource ir = r;
            IMarker jumpMarker = null;
            if (ir != null && ir.exists()) {
                try {
                    jumpMarker = ir.createMarker("org.eclipse.core.resources.textmarker");
                    jumpMarker.setAttribute("lineNumber", new Integer(linenumber).intValue());
                }
                catch (CoreException coreException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_0, ajc$tjp_1);
                    CoreException ce = coreException;
                    ErrorHandler.handleAJDTError(UIMessages.AdviceActionDelegate_unable_to_create_marker, ce);
                }
                try {
                    IDE.openEditor((IWorkbenchPage)AspectJUIPlugin.getDefault().getActiveWorkbenchWindow().getActivePage(), (IMarker)jumpMarker, (boolean)true);
                }
                catch (CoreException coreException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_2, ajc$tjp_1);
                    CoreException e = coreException;
                    ErrorHandler.handleAJDTError(UIMessages.AdviceActionDelegate_exception_jumping, e);
                }
            } else {
                AdviceActionDelegate.this.report(UIMessages.AdviceActionDelegate_resource_not_found);
            }
        }

        static {
            Factory factory = new Factory("AdviceActionDelegate.java", Class.forName("org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate$BaseAJDTMenuAction"));
            ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate$BaseAJDTMenuAction-org.eclipse.core.runtime.CoreException-ce-"), 417);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-run-org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate$BaseAJDTMenuAction----void-"), 380);
            ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate$BaseAJDTMenuAction-org.eclipse.core.runtime.CoreException-e-"), 428);
        }
    }

    class RelatedLocationMenuAction
    extends BaseAJDTMenuAction {
        private String jumpLocation;

        RelatedLocationMenuAction(String s, String jumpLocation) {
            super(s);
            this.jumpLocation = jumpLocation;
            this.setImageDescriptor(JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.jcu_obj.gif"));
        }

        String getJumpLocation() {
            return this.jumpLocation;
        }
    }
}

