/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.editor;

import org.eclipse.ajdt.core.javaelements.AJCompilationUnit;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnitManager;
import org.eclipse.ajdt.core.javaelements.PointcutUtilities;
import org.eclipse.ajdt.internal.ui.editor.AspectJEditor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaElementHyperlink;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.ui.texteditor.ITextEditor;

public class PointcutElementHyperlinkDetector
implements IHyperlinkDetector {
    private ITextEditor fTextEditor;

    public PointcutElementHyperlinkDetector(ITextEditor editor) {
        Assert.isNotNull((Object)editor);
        this.fTextEditor = editor;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        IRegion reg;
        String source;
        if (region == null || canShowMultipleHyperlinks || !(this.fTextEditor instanceof AspectJEditor)) {
            return null;
        }
        IAction openAction = this.fTextEditor.getAction("OpenEditor");
        if (openAction == null) {
            return null;
        }
        int offset = region.getOffset();
        IJavaElement input = SelectionConverter.getInput((JavaEditor)((JavaEditor)this.fTextEditor));
        if (input instanceof ICompilationUnit) {
            input = AJCompilationUnitManager.mapToAJCompilationUnit((ICompilationUnit)((ICompilationUnit)input));
        }
        if (input instanceof AJCompilationUnit && (source = PointcutUtilities.isInPointcutContext((AJCompilationUnit)((AJCompilationUnit)input), (int)offset)) != null && (reg = this.selectWord(source, offset)) != null) {
            return new IHyperlink[]{new JavaElementHyperlink(reg, openAction)};
        }
        return null;
    }

    private IRegion selectWord(String document, int anchor) {
        char c;
        int offset = anchor;
        while (offset >= 0) {
            c = document.charAt(offset);
            if (!Character.isJavaIdentifierPart(c)) break;
            --offset;
        }
        int start = offset;
        offset = anchor;
        int length = document.length();
        while (offset < length) {
            c = document.charAt(offset);
            if (!Character.isJavaIdentifierPart(c)) break;
            ++offset;
        }
        int end = offset;
        if (start == end) {
            return null;
        }
        if (PointcutUtilities.isAjPointcutKeyword((String)document.substring(start + 1, end))) {
            return null;
        }
        return new Region(start + 1, end - start - 1);
    }
}

