/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.utils;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.aspectj.asm.IProgramElement;
import org.aspectj.bridge.IMessage;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AJLog;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.core.CoreUtils;
import org.eclipse.ajdt.core.builder.AJBuilder;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnitManager;
import org.eclipse.ajdt.internal.javamodel.AJCompilationUnitUtils;
import org.eclipse.ajdt.internal.ui.ajde.ErrorHandler;
import org.eclipse.ajdt.internal.ui.dialogs.MessageDialogWithToggle;
import org.eclipse.ajdt.internal.ui.markers.MarkerUpdating;
import org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences;
import org.eclipse.ajdt.internal.ui.text.UIMessages;
import org.eclipse.ajdt.pde.internal.core.AJDTWorkspaceModelManager;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.progress.UIJob;

public class AJDTUtils {
    private static final Point SMALL_SIZE;
    private static final Point BIG_SIZE;
    private static final int SMALL_ICONS_MASK = 32;
    private static Hashtable imageDescriptorCache;
    private static Job refreshJob;
    private static int previousExecutionTime;
    private static final String ID_NATURE = "org.eclipse.ajdt.ui.ajnature";
    private static boolean myEclipseMessageDisplayed;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;

    static {
        Factory factory = new Factory("AJDTUtils.java", Class.forName("org.eclipse.ajdt.internal.utils.AJDTUtils"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.utils.AJDTUtils-java.lang.reflect.InvocationTargetException-<missing>-"), 169);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-addAspectJNature-org.eclipse.ajdt.internal.utils.AJDTUtils-org.eclipse.core.resources.IProject:boolean:-project:prompt:-org.eclipse.core.runtime.CoreException:-void-"), 157);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-importRuntimePlugin-org.eclipse.ajdt.internal.utils.AJDTUtils-org.eclipse.core.resources.IProject:-project:--void-"), 427);
        ajc$tjp_11 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.utils.AJDTUtils-org.eclipse.jdt.core.JavaModelException-<missing>-"), 654);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-includeAJfiles-org.eclipse.ajdt.internal.utils.AJDTUtils-org.eclipse.core.resources.IProject:boolean:-project:prompt:--void-"), 611);
        ajc$tjp_13 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.utils.AJDTUtils-org.eclipse.jdt.core.JavaModelException-<missing>-"), 694);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-excludeAJfiles-org.eclipse.ajdt.internal.utils.AJDTUtils-org.eclipse.core.resources.IProject:-project:--void-"), 658);
        ajc$tjp_15 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.utils.AJDTUtils-org.eclipse.jdt.core.JavaModelException-<missing>-"), 710);
        ajc$tjp_16 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.utils.AJDTUtils-org.eclipse.jdt.core.JavaModelException-<missing>-"), 736);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-hasAJPluginDependency-org.eclipse.ajdt.internal.utils.AJDTUtils-org.eclipse.core.resources.IProject:-project:--boolean-"), 717);
        ajc$tjp_18 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.utils.AJDTUtils-org.eclipse.core.runtime.CoreException-e-"), 769);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-removeAJPluginDependency-org.eclipse.ajdt.internal.utils.AJDTUtils-org.eclipse.core.resources.IProject:-project:--void-"), 753);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.utils.AJDTUtils-java.lang.InterruptedException-<missing>-"), 170);
        ajc$tjp_20 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.utils.AJDTUtils-org.eclipse.jdt.core.JavaModelException-<missing>-"), 857);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-verifyAjrtVersion-org.eclipse.ajdt.internal.utils.AJDTUtils-org.eclipse.core.resources.IProject:-current:--void-"), 817);
        ajc$tjp_3 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.utils.AJDTUtils-org.eclipse.core.runtime.CoreException-<missing>-"), 314);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-containsAJFiles-org.eclipse.ajdt.internal.utils.AJDTUtils-org.eclipse.core.resources.IResource:-resource:--boolean-"), 302);
        ajc$tjp_5 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.utils.AJDTUtils-org.eclipse.core.runtime.CoreException-<missing>-"), 346);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-checkMyEclipseNature-org.eclipse.ajdt.internal.utils.AJDTUtils-org.eclipse.core.resources.IProject:-project:--void-"), 327);
        ajc$tjp_7 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.utils.AJDTUtils-org.eclipse.core.runtime.CoreException-<missing>-"), 395);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-removeMarkerOnReferencingProjects-org.eclipse.ajdt.internal.utils.AJDTUtils-org.eclipse.core.resources.IProject:-project:--void-"), 357);
        ajc$tjp_9 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.utils.AJDTUtils-org.eclipse.core.runtime.CoreException-<missing>-"), 447);
        SMALL_SIZE = new Point(16, 16);
        BIG_SIZE = new Point(22, 16);
        imageDescriptorCache = new Hashtable();
        myEclipseMessageDisplayed = false;
    }

    public static String getWorkspacePath() {
        return AspectJPlugin.getWorkspace().getRoot().getLocation().toOSString();
    }

    public static String getResourcePath(IResource resource) {
        return resource.getLocation().toOSString();
    }

    public static ImageDescriptor decorate(ImageDescriptor base, int decorations) {
        Point size = AJDTUtils.useSmallSize(decorations) ? SMALL_SIZE : BIG_SIZE;
        String key = new String(String.valueOf(base.toString()) + ":::" + decorations + ":::" + size.toString());
        if (imageDescriptorCache.get(key) != null) {
            return (ImageDescriptor)imageDescriptorCache.get(key);
        }
        JavaElementImageDescriptor imageDescriptor = new JavaElementImageDescriptor(base, decorations, size);
        imageDescriptorCache.put(key, imageDescriptor);
        return imageDescriptor;
    }

    private static boolean useSmallSize(int flags) {
        return (flags & 0x20) != 0;
    }

    public static void addAspectJNature(final IProject project, final boolean prompt) throws CoreException {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                AJDTUtils.internal_addAspectJNature(project, prompt);
            }
        };
        try {
            op.run(null);
        }
        catch (InvocationTargetException invocationTargetException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(invocationTargetException, ajc$tjp_0, ajc$tjp_1);
        }
        catch (InterruptedException interruptedException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(interruptedException, ajc$tjp_2, ajc$tjp_1);
        }
    }

    private static void internal_addAspectJNature(IProject project, boolean prompt) throws CoreException {
        AJDTUtils.checkOutputFoldersForAJFiles(project);
        IProjectDescription description = project.getDescription();
        String[] prevNatures = description.getNatureIds();
        String[] newNatures = new String[prevNatures.length + 1];
        System.arraycopy(prevNatures, 0, newNatures, 1, prevNatures.length);
        newNatures[0] = ID_NATURE;
        description.setNatureIds(newNatures);
        project.setDescription(description, null);
        if (project.hasNature("org.eclipse.pde.PluginNature") && (WorkspaceModelManager.hasPluginManifest((IProject)project) || WorkspaceModelManager.hasBundleManifest((IProject)project))) {
            if (!AJDTUtils.hasAJPluginDependency(project)) {
                AJDTUtils.getAndPrepareToChangePDEModel(project);
                AJDTUtils.addAJPluginDependency(project, prompt);
            }
        } else {
            AspectJUIPlugin.addAjrtToBuildPath(project);
        }
        AJDTUtils.includeAJfiles(project, prompt);
        AJCompilationUnitManager.INSTANCE.initCompilationUnits(project);
        if (prompt) {
            AJDTUtils.checkMyEclipseNature(project);
        }
        AJDTUtils.refreshPackageExplorer();
    }

    private static void checkOutputFoldersForAJFiles(IProject project) throws CoreException {
        IWorkbenchWindow window;
        boolean remove;
        IJavaProject jp = JavaCore.create((IProject)project);
        if (jp == null) {
            return;
        }
        IPath defaultOutputLocation = jp.getOutputLocation();
        if (defaultOutputLocation.equals((Object)project.getFullPath())) {
            return;
        }
        boolean defaultOutputLocationIsSrcFolder = false;
        ArrayList<IPath> extraOutputLocations = new ArrayList<IPath>();
        ArrayList<IClasspathEntry> srcFolders = new ArrayList<IClasspathEntry>();
        IClasspathEntry[] cpe = jp.getRawClasspath();
        int i = 0;
        while (i < cpe.length) {
            if (cpe[i].getEntryKind() == 3) {
                srcFolders.add(cpe[i]);
                IPath output = cpe[i].getOutputLocation();
                if (output != null) {
                    extraOutputLocations.add(output);
                }
            }
            ++i;
        }
        Iterator iter = srcFolders.iterator();
        while (iter.hasNext()) {
            IClasspathEntry entry = (IClasspathEntry)iter.next();
            IPath path = entry.getPath();
            if (path.equals((Object)defaultOutputLocation)) {
                defaultOutputLocationIsSrcFolder = true;
            }
            Iterator iterator = extraOutputLocations.iterator();
            while (iterator.hasNext()) {
                IPath outputPath = (IPath)iterator.next();
                if (!outputPath.equals((Object)path)) continue;
                iterator.remove();
            }
        }
        boolean ajFilesFound = false;
        if (!defaultOutputLocationIsSrcFolder) {
            IFolder folder = project.getWorkspace().getRoot().getFolder(defaultOutputLocation);
            ajFilesFound = AJDTUtils.containsAJFiles((IResource)folder);
        }
        if (!ajFilesFound && extraOutputLocations.size() > 0) {
            Iterator iter2 = extraOutputLocations.iterator();
            while (iter2.hasNext()) {
                IPath outputPath = (IPath)iter2.next();
                IFolder folder = project.getWorkspace().getRoot().getFolder(outputPath);
                boolean bl = ajFilesFound = ajFilesFound || AJDTUtils.containsAJFiles((IResource)folder);
            }
        }
        if (ajFilesFound && (remove = MessageDialog.openQuestion((Shell)(window = AspectJUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow()).getShell(), (String)UIMessages.AJFiles_title, (String)UIMessages.AJFiles_message))) {
            if (!defaultOutputLocationIsSrcFolder) {
                AJBuilder.cleanAJFilesFromOutputFolder((IPath)defaultOutputLocation);
            }
            Iterator iter3 = extraOutputLocations.iterator();
            while (iter3.hasNext()) {
                IPath extraLocationPath = (IPath)iter3.next();
                AJBuilder.cleanAJFilesFromOutputFolder((IPath)extraLocationPath);
            }
        }
    }

    private static boolean containsAJFiles(IResource resource) {
        if (resource instanceof IFile && resource.getName().endsWith(".aj")) {
            return true;
        }
        if (resource instanceof IFolder && ((IFolder)resource).exists()) {
            try {
                IResource[] members = ((IFolder)resource).members();
                int i = 0;
                while (i < members.length) {
                    if (AJDTUtils.containsAJFiles(members[i])) {
                        return true;
                    }
                    ++i;
                }
            }
            catch (CoreException coreException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(coreException, ajc$tjp_3, ajc$tjp_4);
            }
        }
        return false;
    }

    public static void checkMyEclipseNature(IProject project) {
        try {
            if ((project.hasNature("com.genuitec.eclipse.j2eedt.core.webnature") || project.hasNature("com.genuitec.eclipse.j2eedt.core.ejbnature")) && !myEclipseMessageDisplayed) {
                myEclipseMessageDisplayed = true;
                IWorkbenchWindow window = AspectJUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
                MessageDialog.openInformation((Shell)window.getShell(), (String)UIMessages.myEclipse_natureDetected_title, (String)UIMessages.myEclipse_natureDetected_message);
            }
        }
        catch (CoreException coreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(coreException, ajc$tjp_5, ajc$tjp_6);
        }
    }

    private static void removeMarkerOnReferencingProjects(IProject project) {
        try {
            String errorMessage = String.valueOf(UIMessages.AJDTUtils_project_cannot_be_rebuilt) + project.getName() + UIMessages.AJDTUtils_cleaning_recommended;
            IProject[] refProjects = project.getReferencingProjects();
            IProject[] classFolderReferences = (IProject[])CoreUtils.getDependingProjects((IProject)project).get(0);
            IProject[] referencingProjects = new IProject[refProjects.length + classFolderReferences.length];
            int i = 0;
            while (i < refProjects.length) {
                referencingProjects[i] = refProjects[i];
                ++i;
            }
            i = 0;
            while (i < classFolderReferences.length) {
                referencingProjects[i + refProjects.length] = classFolderReferences[i];
                ++i;
            }
            i = 0;
            while (i < referencingProjects.length) {
                IProject referencingProject = referencingProjects[i];
                IMarker[] problemMarkers = referencingProject.findMarkers("org.eclipse.core.resources.problemmarker", false, 2);
                if (problemMarkers.length > 0) {
                    int j = 0;
                    while (j < problemMarkers.length) {
                        IMarker marker = problemMarkers[j];
                        int markerSeverity = marker.getAttribute("severity", -1);
                        String markerMessage = marker.getAttribute("message", UIMessages.AJDTUtils_no_message);
                        if (markerSeverity == 2 && markerMessage.equals(errorMessage)) {
                            marker.delete();
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(coreException, ajc$tjp_7, ajc$tjp_8);
        }
    }

    private static void addAJPluginDependency(IProject project, boolean prompt) {
        IWorkbenchWindow window = AspectJUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        boolean autoImport = false;
        if (!prompt || AspectJPreferences.askPDEAutoImport() && AJDTUtils.confirmPDEAutoAddImport(window) || AspectJPreferences.doPDEAutoImport()) {
            autoImport = true;
        }
        if (autoImport) {
            AJDTUtils.importRuntimePlugin(project);
        } else {
            MessageDialog.openWarning((Shell)window.getShell(), (String)UIMessages.NoAutoPluginImportDialog_title, (String)UIMessages.NoAutoPluginImportDialog_message);
        }
    }

    public static void importRuntimePlugin(IProject project) {
        ManifestEditor manEd = AJDTUtils.getAndPrepareToChangePDEModel(project);
        if (manEd != null) {
            IPluginModel model = (IPluginModel)manEd.getAggregateModel();
            try {
                AJDTUtils.addImportToPDEModel(model, "org.aspectj.runtime");
                manEd.doSave((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(coreException, ajc$tjp_9, ajc$tjp_10);
            }
        } else {
            MessageDialog.openError((Shell)AspectJUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)UIMessages.AutoPluginImportDialog_noEditor_title, (String)UIMessages.AutoPluginImportDialog_noEditor_message);
        }
    }

    private static void addImportToPDEModel(IPluginModel model, String importId) throws CoreException {
        IPluginImport importNode = model.getPluginFactory().createImport();
        importNode.setId(importId);
        model.getPluginBase().add(importNode);
        IFile manifestFile = (IFile)model.getUnderlyingResource();
        manifestFile.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
    }

    public static ManifestEditor getPDEManifestEditor(IProject project) {
        String pluginId = new AJDTWorkspaceModelManager().getWorkspacePluginModel(project).getPluginBase().getId();
        ManifestEditor manEd = null;
        IEditorReference[] eRefs = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int i = 0;
        while (i < eRefs.length) {
            IEditorReference er = eRefs[i];
            if (er.getId().equals("org.eclipse.pde.ui.manifestEditor") && er.getPartName().equals(pluginId)) {
                IEditorReference manEdRef = er;
                manEd = (ManifestEditor)manEdRef.getPart(true);
                break;
            }
            ++i;
        }
        return manEd;
    }

    public static ManifestEditor getAndPrepareToChangePDEModel(IProject project) {
        String pluginId = new AJDTWorkspaceModelManager().getWorkspacePluginModel(project).getPluginBase().getId();
        ManifestEditor.openPluginEditor((String)pluginId);
        ManifestEditor manEd = AJDTUtils.getPDEManifestEditor(project);
        if (manEd != null) {
            manEd.setActivePage("dependencies");
        }
        return manEd;
    }

    public static void removeAspectJNature(IProject project) throws CoreException {
        MarkerUpdating.deleteAllMarkers(project);
        AJCompilationUnitUtils.removeCUsfromJavaModelAndCloseEditors(project);
        AspectJUIPlugin ajPlugin = AspectJUIPlugin.getDefault();
        AspectJPlugin.getDefault().setCurrentProject(project);
        ajPlugin.getAjdtProjectProperties().clearMarkers(true);
        AJDTUtils.excludeAJfiles(project);
        IProjectDescription description = project.getDescription();
        String[] prevNatures = description.getNatureIds();
        String[] newNatures = new String[prevNatures.length - 1];
        int newPosition = 0;
        int i = 0;
        while (i < prevNatures.length) {
            if (!prevNatures[i].equals(ID_NATURE)) {
                if (newPosition < newNatures.length) {
                    newNatures[newPosition++] = prevNatures[i];
                } else {
                    newNatures = prevNatures;
                    break;
                }
            }
            ++i;
        }
        description.setNatureIds(newNatures);
        project.setDescription(description, null);
        if (project.hasNature("org.eclipse.pde.PluginNature") && (WorkspaceModelManager.hasPluginManifest((IProject)project) || WorkspaceModelManager.hasBundleManifest((IProject)project))) {
            if (AJDTUtils.hasAJPluginDependency(project)) {
                AJDTUtils.getAndPrepareToChangePDEModel(project);
                AJDTUtils.removeAJPluginDependency(project);
            }
        } else {
            AspectJUIPlugin.removeAjrtFromBuildPath(project);
        }
        AJDTUtils.removeMarkerOnReferencingProjects(project);
        AJDTUtils.refreshPackageExplorer();
    }

    private static void includeAJfiles(IProject project, boolean prompt) {
        IJavaProject jp = JavaCore.create((IProject)project);
        try {
            boolean changed = false;
            IClasspathEntry[] cpEntry = jp.getRawClasspath();
            int i = 0;
            while (i < cpEntry.length) {
                IClasspathEntry entry = cpEntry[i];
                if (entry.getEntryKind() == 3) {
                    IPath[] exc = entry.getExclusionPatterns();
                    ArrayList<IPath> removeList = new ArrayList<IPath>();
                    int j = 0;
                    while (j < exc.length) {
                        if (exc[j].getFileExtension().equals("aj")) {
                            removeList.add(exc[j]);
                        }
                        ++j;
                    }
                    if (removeList.size() > 0) {
                        IClasspathEntry classpathEntry;
                        IPath[] exc2 = new IPath[exc.length - removeList.size()];
                        int ind = 0;
                        int j2 = 0;
                        while (j2 < exc.length) {
                            if (!removeList.contains(exc[j2])) {
                                exc2[ind++] = exc[j2];
                            }
                            ++j2;
                        }
                        cpEntry[i] = classpathEntry = JavaCore.newSourceEntry((IPath)entry.getPath(), (IPath[])exc2);
                        changed = true;
                    }
                }
                ++i;
            }
            if (changed) {
                boolean restore = true;
                if (prompt) {
                    IWorkbenchWindow window = AspectJUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
                    restore = MessageDialog.openQuestion((Shell)window.getShell(), (String)UIMessages.ExcludedAJ_title, (String)UIMessages.ExcludedAJ_message);
                }
                if (restore) {
                    jp.setRawClasspath(cpEntry, null);
                }
            }
        }
        catch (JavaModelException javaModelException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(javaModelException, ajc$tjp_11, ajc$tjp_12);
        }
    }

    private static void excludeAJfiles(IProject project) {
        IJavaProject jp = JavaCore.create((IProject)project);
        try {
            boolean changed = false;
            IClasspathEntry[] cpEntry = jp.getRawClasspath();
            int i = 0;
            while (i < cpEntry.length) {
                IClasspathEntry entry = cpEntry[i];
                if (entry.getEntryKind() == 3) {
                    ArrayList<IPath> excludeList = new ArrayList<IPath>();
                    IPackageFragmentRoot[] roots = jp.findPackageFragmentRoots(entry);
                    int j = 0;
                    while (j < roots.length) {
                        try {
                            IJavaElement[] rootFragments = roots[j].getChildren();
                            int k = 0;
                            while (k < rootFragments.length) {
                                if (rootFragments[k] instanceof IPackageFragment) {
                                    IPackageFragment pack = (IPackageFragment)rootFragments[k];
                                    ICompilationUnit[] files = pack.getCompilationUnits();
                                    int l = 0;
                                    while (l < files.length) {
                                        IResource resource = files[l].getResource();
                                        if (resource.getFileExtension().equals("aj")) {
                                            IPath resPath = resource.getFullPath();
                                            int seg = resPath.matchingFirstSegments(roots[j].getPath());
                                            excludeList.add(resPath.removeFirstSegments(seg));
                                        }
                                        ++l;
                                    }
                                }
                                ++k;
                            }
                        }
                        catch (JavaModelException javaModelException) {
                            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(javaModelException, ajc$tjp_13, ajc$tjp_14);
                        }
                        ++j;
                    }
                    if (excludeList.size() > 0) {
                        IClasspathEntry classpathEntry;
                        IPath[] exc = new IPath[excludeList.size()];
                        excludeList.toArray(exc);
                        cpEntry[i] = classpathEntry = JavaCore.newSourceEntry((IPath)entry.getPath(), (IPath[])exc);
                        changed = true;
                    }
                }
                ++i;
            }
            if (changed) {
                jp.setRawClasspath(cpEntry, null);
            }
        }
        catch (JavaModelException javaModelException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(javaModelException, ajc$tjp_15, ajc$tjp_14);
        }
    }

    public static boolean hasAJPluginDependency(IProject project) {
        ManifestEditor manEd = AJDTUtils.getPDEManifestEditor(project);
        IPluginModel model = null;
        IPluginImport[] imports = null;
        if (manEd == null) {
            try {
                IPackageFragmentRoot[] dependencies = JavaCore.create((IProject)project).getPackageFragmentRoots();
                int i = 0;
                while (i < dependencies.length) {
                    if (dependencies[i].getElementName().equals("aspectjrt.jar")) {
                        return true;
                    }
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(javaModelException, ajc$tjp_16, ajc$tjp_17);
            }
            return false;
        }
        model = (IPluginModel)manEd.getAggregateModel();
        imports = model.getPluginBase().getImports();
        int i = 0;
        while (i < imports.length) {
            IPluginImport importObj = imports[i];
            if (importObj.getId().equals("org.aspectj.runtime")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static void removeAJPluginDependency(IProject project) {
        IWorkbenchWindow window = AspectJUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (AspectJPreferences.askPDEAutoRemoveImport() && AJDTUtils.confirmPDEAutoRemoveImport(window) || AspectJPreferences.doPDEAutoRemoveImport()) {
            ManifestEditor manEd = AJDTUtils.getPDEManifestEditor(project);
            if (manEd != null) {
                IPluginModel model = (IPluginModel)manEd.getAggregateModel();
                try {
                    AJDTUtils.removeImportFromPDEModel(model, "org.aspectj.runtime");
                    manEd.doSave((IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException coreException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(coreException, ajc$tjp_18, ajc$tjp_19);
                    CoreException e = coreException;
                    ErrorHandler.handleAJDTError(UIMessages.AutoPluginRemoveErrorDialog_title, UIMessages.AutoPluginRemoveErrorDialog_message, e);
                }
            } else {
                MessageDialog.openError((Shell)AspectJUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)UIMessages.AutoPluginRemoveDialog_noEditor_title, (String)UIMessages.AutoPluginRemoveDialog_noEditor_message);
            }
        }
    }

    public static void removeImportFromPDEModel(IPluginModel model, String importId) throws CoreException {
        IPluginImport[] imports = model.getPluginBase().getImports();
        IPluginImport doomed = null;
        int i = 0;
        while (i < imports.length) {
            IPluginImport importObj = imports[i];
            if (importObj.getId().equals(importId)) {
                doomed = importObj;
                break;
            }
            ++i;
        }
        if (doomed != null) {
            model.getPluginBase().remove(doomed);
        }
        IFile manifestFile = (IFile)model.getUnderlyingResource();
        manifestFile.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void verifyAjrtVersion(IProject current) {
        IJavaProject javaProject = JavaCore.create((IProject)current);
        String ajrtPath = CoreUtils.getAspectjrtClasspath();
        try {
            IClasspathEntry[] originalCP = javaProject.getRawClasspath();
            ArrayList<IClasspathEntry> tempCP = new ArrayList<IClasspathEntry>();
            boolean changed = false;
            int i = 0;
            while (i < originalCP.length) {
                IPath path = originalCP[i].getPath();
                if (path.toOSString().endsWith("aspectjrt.jar")) {
                    IClasspathEntry ajrtCP = JavaCore.newLibraryEntry((IPath)new Path(ajrtPath), null, null);
                    tempCP.add(ajrtCP);
                    changed = true;
                    AJLog.log((String)("In project " + current.getName() + " - replacing " + originalCP[i].getPath() + " with " + ajrtCP.getPath()));
                } else {
                    tempCP.add(originalCP[i]);
                }
                ++i;
            }
            if (changed) {
                IClasspathEntry[] newCP = tempCP.toArray(new IClasspathEntry[tempCP.size()]);
                javaProject.setRawClasspath(newCP, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (JavaModelException javaModelException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(javaModelException, ajc$tjp_20, ajc$tjp_21);
        }
    }

    private static boolean confirmPDEAutoAddImport(IWorkbenchWindow window) {
        MessageDialogWithToggle dialog = MessageDialogWithToggle.openQuestion(window.getShell(), UIMessages.PluginImportDialog_importConfirmTitle, UIMessages.PluginImportDialog_importConfirmMsg, UIMessages.PluginImportDialog_importConfirmToggleMsg, false);
        int result = dialog.getReturnCode();
        if (result >= 0 && dialog.getToggleState()) {
            if (result == 0) {
                AspectJPreferences.setDoPDEAutoImport(true);
                AspectJPreferences.setAskPDEAutoImport(false);
            } else {
                AspectJPreferences.setDoPDEAutoImport(false);
                AspectJPreferences.setAskPDEAutoImport(false);
            }
        }
        return result == 0;
    }

    private static boolean confirmPDEAutoRemoveImport(IWorkbenchWindow window) {
        MessageDialogWithToggle dialog = MessageDialogWithToggle.openQuestion(window.getShell(), UIMessages.PluginImportDialog_removeImportConfirmTitle, UIMessages.PluginImportDialog_removeImportConfirmMsg, UIMessages.PluginImportDialog_removeImportConfirmToggleMsg, false);
        int result = dialog.getReturnCode();
        if (result >= 0 && dialog.getToggleState()) {
            if (result == 0) {
                AspectJPreferences.setDoPDEAutoRemoveImport(true);
                AspectJPreferences.setAskPDEAutoRemoveImport(false);
            } else {
                AspectJPreferences.setDoPDEAutoRemoveImport(false);
                AspectJPreferences.setAskPDEAutoRemoveImport(false);
            }
        }
        return result == 0;
    }

    public static ImageDescriptor decorate(ImageDescriptor base, IProgramElement pNode) {
        int flags = 0;
        if (pNode != null) {
            IMessage sMessage;
            List modifiers = pNode.getModifiers();
            if (modifiers != null) {
                if (modifiers.contains(IProgramElement.Modifiers.ABSTRACT)) {
                    flags |= 1;
                }
                if (modifiers.contains(IProgramElement.Modifiers.FINAL)) {
                    flags |= 2;
                }
                if (modifiers.contains(IProgramElement.Modifiers.SYNCHRONIZED)) {
                    flags |= 4;
                }
                if (modifiers.contains(IProgramElement.Modifiers.STATIC)) {
                    flags |= 8;
                }
            }
            if (pNode.getKind() == IProgramElement.Kind.CONSTRUCTOR || pNode.getKind() == IProgramElement.Kind.INTER_TYPE_CONSTRUCTOR) {
                flags |= 0x200;
            }
            if (pNode.isRunnable()) {
                flags |= 0x10;
            }
            if (pNode.isOverrider()) {
                flags |= 0x80;
            }
            if (pNode.isImplementor()) {
                flags |= 0x100;
            }
            if ((sMessage = pNode.getMessage()) != null) {
                if (sMessage.getKind() == IMessage.ERROR) {
                    flags |= 0x40;
                } else if (sMessage.getKind() == IMessage.WARNING) {
                    flags |= 0x20;
                }
            }
        }
        return AJDTUtils.decorate(base, flags);
    }

    public static void refreshPackageExplorer() {
        int delay = 5 * previousExecutionTime;
        if (delay < 250) {
            delay = 250;
        } else if (delay > 5000) {
            delay = 5000;
        }
        AJDTUtils.getRefreshPackageExplorerJob().schedule((long)delay);
    }

    private static Job getRefreshPackageExplorerJob() {
        if (refreshJob == null) {
            refreshJob = new RefreshPackageExplorerJob();
        }
        return refreshJob;
    }

    public static char[][] getEnclosingTypes(IType startType) {
        char[][] enclosingTypes = new char[][]{};
        IType type = startType.getDeclaringType();
        ArrayList<char[]> enclosingTypeList = new ArrayList<char[]>();
        while (type != null) {
            char[] typeName = type.getElementName().toCharArray();
            enclosingTypeList.add(0, typeName);
            type = type.getDeclaringType();
        }
        if (enclosingTypeList.size() > 0) {
            enclosingTypes = new char[enclosingTypeList.size()][];
            int k = 0;
            while (k < enclosingTypeList.size()) {
                char[] typeName = (char[])enclosingTypeList.get(k);
                enclosingTypes[k] = typeName;
                ++k;
            }
        }
        return enclosingTypes;
    }

    public static String getFreeFileName(IProject project, String defaultFileName, String extension) {
        int counter = 0;
        if (project != null) {
            boolean foundFreeName = false;
            while (!foundFreeName) {
                String name = counter == 0 ? defaultFileName : String.valueOf(defaultFileName) + counter;
                IPath path = project.getFullPath().append(String.valueOf(name) + "." + extension);
                if (!AspectJPlugin.getWorkspace().getRoot().getFile(path).exists()) {
                    foundFreeName = true;
                    continue;
                }
                ++counter;
            }
        }
        return counter == 0 ? defaultFileName : String.valueOf(defaultFileName) + counter;
    }

    private static class RefreshPackageExplorerJob
    extends UIJob {
        RefreshPackageExplorerJob() {
            super(UIMessages.utils_refresh_explorer_job);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            long start = System.currentTimeMillis();
            PackageExplorerPart pep = PackageExplorerPart.getFromActivePerspective();
            if (pep != null) {
                pep.getTreeViewer().refresh();
            }
            previousExecutionTime = (int)(System.currentTimeMillis() - start);
            return Status.OK_STATUS;
        }
    }
}

