/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.AnnotatedElement;
import org.aspectj.weaver.AnnotationX;
import org.aspectj.weaver.IHasPosition;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.JoinPointSignature;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.MemberImpl;
import org.aspectj.weaver.ReferenceType;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.ShadowMunger;
import org.aspectj.weaver.TypeFactory;
import org.aspectj.weaver.TypeVariable;
import org.aspectj.weaver.TypeVariableDeclaringElement;
import org.aspectj.weaver.TypeVariableReference;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.VersionedDataInputStream;
import org.aspectj.weaver.World;

public class ResolvedMemberImpl
extends MemberImpl
implements IHasPosition,
AnnotatedElement,
TypeVariableDeclaringElement,
ResolvedMember {
    private String[] parameterNames = null;
    protected UnresolvedType[] checkedExceptions = UnresolvedType.NONE;
    protected ResolvedMember backingGenericMember = null;
    protected Set annotationTypes = null;
    private boolean isAnnotatedElsewhere = false;
    private boolean isAjSynthetic = false;
    protected TypeVariable[] typeVariables;
    protected int start;
    protected int end;
    protected ISourceContext sourceContext = null;
    private ResolvedMember myErasure = null;
    private boolean calculatedMyErasure = false;
    private String myParameterSignatureWithBoundsRemoved = null;
    private String myParameterSignatureErasure = null;
    public static boolean showParameterNames = true;

    public ResolvedMemberImpl(Member.Kind kind, UnresolvedType declaringType, int modifiers, UnresolvedType returnType, String name, UnresolvedType[] parameterTypes) {
        super(kind, declaringType, modifiers, returnType, name, parameterTypes);
    }

    public ResolvedMemberImpl(Member.Kind kind, UnresolvedType declaringType, int modifiers, UnresolvedType returnType, String name, UnresolvedType[] parameterTypes, UnresolvedType[] checkedExceptions) {
        super(kind, declaringType, modifiers, returnType, name, parameterTypes);
        this.checkedExceptions = checkedExceptions;
    }

    public ResolvedMemberImpl(Member.Kind kind, UnresolvedType declaringType, int modifiers, UnresolvedType returnType, String name, UnresolvedType[] parameterTypes, UnresolvedType[] checkedExceptions, ResolvedMember backingGenericMember) {
        this(kind, declaringType, modifiers, returnType, name, parameterTypes, checkedExceptions);
        this.backingGenericMember = backingGenericMember;
        this.isAjSynthetic = backingGenericMember.isAjSynthetic();
    }

    public ResolvedMemberImpl(Member.Kind kind, UnresolvedType declaringType, int modifiers, String name, String signature) {
        super(kind, declaringType, modifiers, name, signature);
    }

    public static JoinPointSignature[] getJoinPointSignatures(Member joinPointSignature, World inAWorld) {
        ResolvedType originalDeclaringType = joinPointSignature.getDeclaringType().resolve(inAWorld);
        ResolvedMemberImpl firstDefiningMember = (ResolvedMemberImpl)joinPointSignature.resolve(inAWorld);
        if (firstDefiningMember == null) {
            return new JoinPointSignature[0];
        }
        ResolvedType firstDefiningType = firstDefiningMember.getDeclaringType().resolve(inAWorld);
        if (firstDefiningType != originalDeclaringType && joinPointSignature.getKind() == Member.CONSTRUCTOR) {
            return new JoinPointSignature[0];
        }
        ArrayList declaringTypes = new ArrayList();
        ResolvedMemberImpl.accumulateTypesInBetween(originalDeclaringType, firstDefiningType, declaringTypes);
        HashSet<JoinPointSignature> memberSignatures = new HashSet<JoinPointSignature>();
        Iterator iter = declaringTypes.iterator();
        while (iter.hasNext()) {
            ResolvedType declaringType = (ResolvedType)iter.next();
            JoinPointSignature member = firstDefiningMember.withSubstituteDeclaringType(declaringType);
            memberSignatures.add(member);
        }
        if (ResolvedMemberImpl.shouldWalkUpHierarchyFor(firstDefiningMember)) {
            Iterator superTypeIterator = firstDefiningType.getDirectSupertypes();
            ArrayList typesAlreadyVisited = new ArrayList();
            ResolvedMemberImpl.accumulateMembersMatching(firstDefiningMember, superTypeIterator, typesAlreadyVisited, memberSignatures);
        }
        JoinPointSignature[] ret = new JoinPointSignature[memberSignatures.size()];
        memberSignatures.toArray(ret);
        return ret;
    }

    private static boolean shouldWalkUpHierarchyFor(Member aMember) {
        if (aMember.getKind() == Member.CONSTRUCTOR) {
            return false;
        }
        if (aMember.getKind() == Member.FIELD) {
            return false;
        }
        return !aMember.isStatic();
    }

    private static void accumulateTypesInBetween(ResolvedType subType, ResolvedType superType, List types) {
        types.add(subType);
        if (subType == superType) {
            return;
        }
        Iterator iter = subType.getDirectSupertypes();
        while (iter.hasNext()) {
            ResolvedType parent = (ResolvedType)iter.next();
            if (!superType.isAssignableFrom(parent)) continue;
            ResolvedMemberImpl.accumulateTypesInBetween(parent, superType, types);
        }
    }

    private static void accumulateMembersMatching(ResolvedMemberImpl memberToMatch, Iterator typesToLookIn, List typesAlreadyVisited, Set foundMembers) {
        while (typesToLookIn.hasNext()) {
            ResolvedType toLookIn = (ResolvedType)typesToLookIn.next();
            if (typesAlreadyVisited.contains(toLookIn)) continue;
            typesAlreadyVisited.add(toLookIn);
            ResolvedMemberImpl foundMember = (ResolvedMemberImpl)toLookIn.lookupResolvedMember(memberToMatch, true);
            if (foundMember == null || !ResolvedMemberImpl.isVisibleTo(memberToMatch, foundMember)) continue;
            ArrayList declaringTypes = new ArrayList();
            ResolvedType resolvedDeclaringType = foundMember.getDeclaringType().resolve(toLookIn.getWorld());
            ResolvedMemberImpl.accumulateTypesInBetween(toLookIn, resolvedDeclaringType, declaringTypes);
            Iterator iter = declaringTypes.iterator();
            while (iter.hasNext()) {
                ResolvedType declaringType = (ResolvedType)iter.next();
                JoinPointSignature member = foundMember.withSubstituteDeclaringType(declaringType);
                foundMembers.add(member);
            }
            if (toLookIn.isParameterizedType() && foundMember.backingGenericMember != null) {
                foundMembers.add(new JoinPointSignature(foundMember.backingGenericMember, foundMember.declaringType.resolve(toLookIn.getWorld())));
            }
            ResolvedMemberImpl.accumulateMembersMatching(foundMember, toLookIn.getDirectSupertypes(), typesAlreadyVisited, foundMembers);
        }
    }

    private static boolean isVisibleTo(ResolvedMember childMember, ResolvedMember parentMember) {
        if (childMember.getDeclaringType().equals(parentMember.getDeclaringType())) {
            return true;
        }
        return !Modifier.isPrivate(parentMember.getModifiers());
    }

    public final int getModifiers(World world) {
        return this.modifiers;
    }

    public final int getModifiers() {
        return this.modifiers;
    }

    public final UnresolvedType[] getExceptions(World world) {
        return this.getExceptions();
    }

    public UnresolvedType[] getExceptions() {
        return this.checkedExceptions;
    }

    public ShadowMunger getAssociatedShadowMunger() {
        return null;
    }

    public boolean isAjSynthetic() {
        return this.isAjSynthetic;
    }

    protected void setAjSynthetic(boolean b) {
        this.isAjSynthetic = b;
    }

    public boolean hasAnnotations() {
        return this.annotationTypes != null;
    }

    public boolean hasAnnotation(UnresolvedType ofType) {
        if (this.annotationTypes == null) {
            return false;
        }
        return this.annotationTypes.contains(ofType);
    }

    public ResolvedType[] getAnnotationTypes() {
        if (this.annotationTypes == null) {
            return null;
        }
        return this.annotationTypes.toArray(new ResolvedType[0]);
    }

    public AnnotationX[] getAnnotations() {
        if (this.backingGenericMember != null) {
            return this.backingGenericMember.getAnnotations();
        }
        return super.getAnnotations();
    }

    public void setAnnotationTypes(UnresolvedType[] annotationtypes) {
        if (this.annotationTypes == null) {
            this.annotationTypes = new HashSet();
        }
        for (int i = 0; i < annotationtypes.length; ++i) {
            UnresolvedType typeX = annotationtypes[i];
            this.annotationTypes.add(typeX);
        }
    }

    public void addAnnotation(AnnotationX annotation) {
        if (this.annotationTypes == null) {
            this.annotationTypes = new HashSet();
        }
        this.annotationTypes.add(annotation.getSignature());
    }

    public boolean isBridgeMethod() {
        return (this.modifiers & 0x40) != 0;
    }

    public boolean isVarargsMethod() {
        return (this.modifiers & 0x80) != 0;
    }

    public void setVarargsMethod() {
        this.modifiers |= 0x80;
    }

    public boolean isSynthetic() {
        return (this.modifiers & 0x1000) != 0;
    }

    public void write(DataOutputStream s) throws IOException {
        this.getKind().write(s);
        this.getDeclaringType().write(s);
        s.writeInt(this.modifiers);
        s.writeUTF(this.getName());
        s.writeUTF(this.getSignature());
        UnresolvedType.writeArray(this.getExceptions(), s);
        s.writeInt(this.getStart());
        s.writeInt(this.getEnd());
        s.writeBoolean(this.isVarargsMethod());
        if (this.typeVariables == null) {
            s.writeInt(0);
        } else {
            s.writeInt(this.typeVariables.length);
            for (int i = 0; i < this.typeVariables.length; ++i) {
                this.typeVariables[i].write(s);
            }
        }
        String gsig = this.getGenericSignature();
        if (this.getSignature().equals(gsig)) {
            s.writeBoolean(false);
        } else {
            s.writeBoolean(true);
            s.writeInt(this.parameterTypes.length);
            for (int i = 0; i < this.parameterTypes.length; ++i) {
                UnresolvedType array_element = this.parameterTypes[i];
                array_element.write(s);
            }
            this.returnType.write(s);
        }
    }

    public String getGenericSignature() {
        int i;
        StringBuffer sb = new StringBuffer();
        if (this.typeVariables != null) {
            sb.append("<");
            for (i = 0; i < this.typeVariables.length; ++i) {
                sb.append(this.typeVariables[i].getSignature());
            }
            sb.append(">");
        }
        sb.append("(");
        for (i = 0; i < this.parameterTypes.length; ++i) {
            UnresolvedType array_element = this.parameterTypes[i];
            sb.append(array_element.getSignature());
        }
        sb.append(")");
        sb.append(this.returnType.getSignature());
        return sb.toString();
    }

    public static void writeArray(ResolvedMember[] members, DataOutputStream s) throws IOException {
        s.writeInt(members.length);
        int len = members.length;
        for (int i = 0; i < len; ++i) {
            members[i].write(s);
        }
    }

    public static ResolvedMemberImpl readResolvedMember(VersionedDataInputStream s, ISourceContext sourceContext) throws IOException {
        ResolvedMemberImpl m = new ResolvedMemberImpl(Member.Kind.read(s), UnresolvedType.read(s), s.readInt(), s.readUTF(), s.readUTF());
        m.checkedExceptions = UnresolvedType.readArray(s);
        m.start = s.readInt();
        m.end = s.readInt();
        m.sourceContext = sourceContext;
        if (s.getMajorVersion() >= AjAttribute.WeaverVersionInfo.WEAVER_VERSION_MAJOR_AJ150) {
            boolean hasAGenericSignature;
            int tvcount;
            boolean isvarargs;
            if (s.getMajorVersion() >= AjAttribute.WeaverVersionInfo.WEAVER_VERSION_MAJOR_AJ150M4 && (isvarargs = s.readBoolean())) {
                m.setVarargsMethod();
            }
            if ((tvcount = s.readInt()) != 0) {
                m.typeVariables = new TypeVariable[tvcount];
                for (int i = 0; i < tvcount; ++i) {
                    m.typeVariables[i] = TypeVariable.read(s);
                    m.typeVariables[i].setDeclaringElement(m);
                }
            }
            if (s.getMajorVersion() >= AjAttribute.WeaverVersionInfo.WEAVER_VERSION_MAJOR_AJ150M4 && (hasAGenericSignature = s.readBoolean())) {
                int ps = s.readInt();
                UnresolvedType[] params = new UnresolvedType[ps];
                for (int i = 0; i < params.length; ++i) {
                    UnresolvedType type = params[i];
                    params[i] = TypeFactory.createTypeFromSignature(s.readUTF());
                }
                UnresolvedType rt = TypeFactory.createTypeFromSignature(s.readUTF());
                m.parameterTypes = params;
                m.returnType = rt;
            }
        }
        return m;
    }

    public static ResolvedMember[] readResolvedMemberArray(VersionedDataInputStream s, ISourceContext context) throws IOException {
        int len = s.readInt();
        ResolvedMember[] members = new ResolvedMember[len];
        for (int i = 0; i < len; ++i) {
            members[i] = ResolvedMemberImpl.readResolvedMember(s, context);
        }
        return members;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResolvedMember resolve(World world) {
        try {
            int i;
            if (this.typeVariables != null && this.typeVariables.length > 0) {
                for (i = 0; i < this.typeVariables.length; ++i) {
                    this.typeVariables[i] = this.typeVariables[i].resolve(world);
                }
            }
            world.setTypeVariableLookupScope(this);
            if (this.annotationTypes != null) {
                HashSet<ResolvedType> r = new HashSet<ResolvedType>();
                Iterator iter = this.annotationTypes.iterator();
                while (iter.hasNext()) {
                    UnresolvedType element = (UnresolvedType)iter.next();
                    r.add(world.resolve(element));
                }
                this.annotationTypes = r;
            }
            this.declaringType = this.declaringType.resolve(world);
            if (this.declaringType.isRawType()) {
                this.declaringType = ((ReferenceType)this.declaringType).getGenericType();
            }
            if (this.parameterTypes != null && this.parameterTypes.length > 0) {
                for (i = 0; i < this.parameterTypes.length; ++i) {
                    this.parameterTypes[i] = this.parameterTypes[i].resolve(world);
                }
            }
            this.returnType = this.returnType.resolve(world);
        }
        finally {
            world.setTypeVariableLookupScope(null);
        }
        return this;
    }

    public ISourceContext getSourceContext(World world) {
        return this.getDeclaringType().resolve(world).getSourceContext();
    }

    public String[] getParameterNames() {
        return this.parameterNames;
    }

    public final void setParameterNames(String[] pnames) {
        this.parameterNames = pnames;
    }

    public final String[] getParameterNames(World world) {
        return this.getParameterNames();
    }

    public AjAttribute.EffectiveSignatureAttribute getEffectiveSignature() {
        return null;
    }

    public ISourceLocation getSourceLocation() {
        if (this.getSourceContext() == null) {
            return null;
        }
        return this.getSourceContext().makeSourceLocation(this);
    }

    public int getEnd() {
        return this.end;
    }

    public ISourceContext getSourceContext() {
        return this.sourceContext;
    }

    public int getStart() {
        return this.start;
    }

    public void setPosition(int sourceStart, int sourceEnd) {
        this.start = sourceStart;
        this.end = sourceEnd;
    }

    public void setDeclaringType(ReferenceType rt) {
        this.declaringType = rt;
    }

    public void setSourceContext(ISourceContext sourceContext) {
        this.sourceContext = sourceContext;
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.modifiers);
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.modifiers);
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.modifiers);
    }

    public boolean isNative() {
        return Modifier.isNative(this.modifiers);
    }

    public boolean isDefault() {
        return !this.isPublic() && !this.isProtected() && !this.isPrivate();
    }

    public boolean isVisible(ResolvedType fromType) {
        World world = fromType.getWorld();
        return ResolvedType.isVisible(this.getModifiers(), this.getDeclaringType().resolve(world), fromType);
    }

    public void setCheckedExceptions(UnresolvedType[] checkedExceptions) {
        this.checkedExceptions = checkedExceptions;
    }

    public void setAnnotatedElsewhere(boolean b) {
        this.isAnnotatedElsewhere = b;
    }

    public boolean isAnnotatedElsewhere() {
        return this.isAnnotatedElsewhere;
    }

    public UnresolvedType getGenericReturnType() {
        return this.getReturnType();
    }

    public UnresolvedType[] getGenericParameterTypes() {
        return this.getParameterTypes();
    }

    public ResolvedMemberImpl parameterizedWith(UnresolvedType[] typeParameters, ResolvedType newDeclaringType, boolean isParameterized) {
        return this.parameterizedWith(typeParameters, newDeclaringType, isParameterized, null);
    }

    public ResolvedMemberImpl parameterizedWith(UnresolvedType[] typeParameters, ResolvedType newDeclaringType, boolean isParameterized, List aliases) {
        boolean typeParametersSupplied;
        if (!this.getDeclaringType().isGenericType()) {
            throw new IllegalStateException("Can't ask to parameterize a member of non-generic type: " + this.getDeclaringType() + "  kind(" + this.getDeclaringType().typeKind + ")");
        }
        TypeVariable[] typeVariables = this.getDeclaringType().getTypeVariables();
        if (isParameterized && typeVariables.length != typeParameters.length) {
            throw new IllegalStateException("Wrong number of type parameters supplied");
        }
        HashMap<String, UnresolvedType> typeMap = new HashMap<String, UnresolvedType>();
        boolean bl = typeParametersSupplied = typeParameters != null && typeParameters.length > 0;
        if (typeVariables != null) {
            for (int i = 0; i < typeVariables.length; ++i) {
                UnresolvedType ut = !typeParametersSupplied ? typeVariables[i].getFirstBound() : typeParameters[i];
                typeMap.put(typeVariables[i].getName(), ut);
            }
        }
        if (aliases != null) {
            int posn = 0;
            Iterator iter = aliases.iterator();
            while (iter.hasNext()) {
                String typeVariableAlias = (String)iter.next();
                typeMap.put(typeVariableAlias, !typeParametersSupplied ? typeVariables[posn].getFirstBound() : typeParameters[posn]);
                ++posn;
            }
        }
        UnresolvedType parameterizedReturnType = this.parameterize(this.getGenericReturnType(), typeMap, isParameterized);
        UnresolvedType[] parameterizedParameterTypes = new UnresolvedType[this.getGenericParameterTypes().length];
        for (int i = 0; i < parameterizedParameterTypes.length; ++i) {
            parameterizedParameterTypes[i] = this.parameterize(this.getGenericParameterTypes()[i], typeMap, isParameterized);
        }
        ResolvedMemberImpl ret = new ResolvedMemberImpl(this.getKind(), newDeclaringType, this.getModifiers(), parameterizedReturnType, this.getName(), parameterizedParameterTypes, this.getExceptions(), this);
        ret.setTypeVariables(this.getTypeVariables());
        ret.setSourceContext(this.getSourceContext());
        ret.setPosition(this.getStart(), this.getEnd());
        ret.setParameterNames(this.getParameterNames());
        return ret;
    }

    public void setTypeVariables(TypeVariable[] tvars) {
        this.typeVariables = tvars;
    }

    public TypeVariable[] getTypeVariables() {
        return this.typeVariables;
    }

    protected UnresolvedType parameterize(UnresolvedType aType, Map typeVariableMap, boolean inParameterizedType) {
        if (aType instanceof TypeVariableReference) {
            String variableName = ((TypeVariableReference)((Object)aType)).getTypeVariable().getName();
            if (!typeVariableMap.containsKey(variableName)) {
                return aType;
            }
            return (UnresolvedType)typeVariableMap.get(variableName);
        }
        if (aType.isParameterizedType()) {
            if (inParameterizedType) {
                return aType.parameterize(typeVariableMap);
            }
            return aType.getRawType();
        }
        return aType;
    }

    public ResolvedMember getErasure() {
        if (this.calculatedMyErasure) {
            return this.myErasure;
        }
        this.calculatedMyErasure = true;
        ResolvedType resolvedDeclaringType = (ResolvedType)this.getDeclaringType();
        if (!resolvedDeclaringType.hasParameterizedSuperType()) {
            return null;
        }
        Collection declaringTypes = this.getDeclaringTypes(resolvedDeclaringType.getWorld());
        Iterator iter = declaringTypes.iterator();
        while (iter.hasNext()) {
            ResolvedMemberImpl matchingMember;
            ResolvedType aDeclaringType = (ResolvedType)iter.next();
            if (!aDeclaringType.isParameterizedType() || (matchingMember = (ResolvedMemberImpl)aDeclaringType.lookupMemberNoSupers(this)) == null || matchingMember.backingGenericMember == null) continue;
            this.myErasure = matchingMember.backingGenericMember;
            return this.myErasure;
        }
        return null;
    }

    public boolean hasBackingGenericMember() {
        return this.backingGenericMember != null;
    }

    public ResolvedMember getBackingGenericMember() {
        return this.backingGenericMember;
    }

    public void resetName(String newName) {
        this.name = newName;
    }

    public void resetKind(Member.Kind newKind) {
        this.kind = newKind;
    }

    public void resetModifiers(int newModifiers) {
        this.modifiers = newModifiers;
    }

    public void resetReturnTypeToObjectArray() {
        this.returnType = UnresolvedType.OBJECTARRAY;
    }

    public JoinPointSignature withSubstituteDeclaringType(ResolvedType newDeclaringType) {
        JoinPointSignature ret = new JoinPointSignature(this, newDeclaringType);
        return ret;
    }

    public boolean matches(ResolvedMember aCandidateMatch) {
        String candidateParameterSignature;
        UnresolvedType[] candidateParameterTypes;
        ResolvedMemberImpl candidateMatchImpl = (ResolvedMemberImpl)aCandidateMatch;
        if (!this.getName().equals(aCandidateMatch.getName())) {
            return false;
        }
        UnresolvedType[] myParameterTypes = this.getGenericParameterTypes();
        if (myParameterTypes.length != (candidateParameterTypes = aCandidateMatch.getGenericParameterTypes()).length) {
            return false;
        }
        String myParameterSignature = this.getParameterSigWithBoundsRemoved();
        if (myParameterSignature.equals(candidateParameterSignature = candidateMatchImpl.getParameterSigWithBoundsRemoved())) {
            return true;
        }
        myParameterSignature = this.getParameterSigErasure();
        candidateParameterSignature = candidateMatchImpl.getParameterSigErasure();
        return myParameterSignature.equals(candidateParameterSignature);
    }

    private String getParameterSigWithBoundsRemoved() {
        if (this.myParameterSignatureWithBoundsRemoved != null) {
            return this.myParameterSignatureWithBoundsRemoved;
        }
        StringBuffer sig = new StringBuffer();
        UnresolvedType[] myParameterTypes = this.getGenericParameterTypes();
        for (int i = 0; i < myParameterTypes.length; ++i) {
            this.appendSigWithTypeVarBoundsRemoved(myParameterTypes[i], sig);
        }
        this.myParameterSignatureWithBoundsRemoved = sig.toString();
        return this.myParameterSignatureWithBoundsRemoved;
    }

    private String getParameterSigErasure() {
        if (this.myParameterSignatureErasure != null) {
            return this.myParameterSignatureErasure;
        }
        StringBuffer sig = new StringBuffer();
        UnresolvedType[] myParameterTypes = this.getParameterTypes();
        for (int i = 0; i < myParameterTypes.length; ++i) {
            UnresolvedType thisParameter = myParameterTypes[i];
            if (thisParameter.isTypeVariableReference()) {
                sig.append(thisParameter.getUpperBound().getSignature());
                continue;
            }
            sig.append(thisParameter.getSignature());
        }
        this.myParameterSignatureErasure = sig.toString();
        return this.myParameterSignatureErasure;
    }

    private void appendSigWithTypeVarBoundsRemoved(UnresolvedType aType, StringBuffer toBuffer) {
        if (aType.isTypeVariableReference()) {
            toBuffer.append("T;");
        } else if (aType.isParameterizedType()) {
            toBuffer.append(aType.getRawType().getSignature());
            toBuffer.append("<");
            for (int i = 0; i < aType.getTypeParameters().length; ++i) {
                this.appendSigWithTypeVarBoundsRemoved(aType.getTypeParameters()[i], toBuffer);
            }
            toBuffer.append(">;");
        } else {
            toBuffer.append(aType.getSignature());
        }
    }

    public String toDebugString() {
        String modsStr;
        StringBuffer r = new StringBuffer();
        int mods = this.modifiers;
        if ((mods & 0x1000) > 0) {
            mods -= 4096;
        }
        if ((mods & 0x200) > 0) {
            mods -= 512;
        }
        if ((mods & 0x20000) > 0) {
            mods -= 131072;
        }
        if ((modsStr = Modifier.toString(mods)).length() != 0) {
            r.append(modsStr).append("(" + mods + ")").append(" ");
        }
        if (this.typeVariables != null && this.typeVariables.length > 0) {
            r.append("<");
            for (int i = 0; i < this.typeVariables.length; ++i) {
                if (i > 0) {
                    r.append(",");
                }
                TypeVariable t = this.typeVariables[i];
                r.append(t.toDebugString());
            }
            r.append("> ");
        }
        r.append(this.getGenericReturnType().toDebugString());
        r.append(' ');
        r.append(this.declaringType.getName());
        r.append('.');
        r.append(this.name);
        if (this.kind != Member.FIELD) {
            boolean parameterNamesExist;
            r.append("(");
            UnresolvedType[] params = this.getGenericParameterTypes();
            boolean bl = parameterNamesExist = showParameterNames && this.parameterNames != null && this.parameterNames.length == params.length;
            if (params.length != 0) {
                int len = params.length;
                for (int i = 0; i < len; ++i) {
                    if (i > 0) {
                        r.append(", ");
                    }
                    r.append(params[i].toDebugString());
                    if (!parameterNamesExist) continue;
                    r.append(" ").append(this.parameterNames[i]);
                }
            }
            r.append(")");
        }
        return r.toString();
    }

    public String toGenericString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getGenericReturnType().getSimpleName());
        buf.append(' ');
        buf.append(this.declaringType.getName());
        buf.append('.');
        buf.append(this.name);
        if (this.kind != Member.FIELD) {
            buf.append("(");
            UnresolvedType[] params = this.getGenericParameterTypes();
            if (params.length != 0) {
                buf.append(params[0].getSimpleName());
                int len = params.length;
                for (int i = 1; i < len; ++i) {
                    buf.append(", ");
                    buf.append(params[i].getSimpleName());
                }
            }
            buf.append(")");
        }
        return buf.toString();
    }

    public TypeVariable getTypeVariableNamed(String name) {
        if (this.typeVariables != null) {
            for (int i = 0; i < this.typeVariables.length; ++i) {
                if (!this.typeVariables[i].getName().equals(name)) continue;
                return this.typeVariables[i];
            }
        }
        return this.declaringType.getTypeVariableNamed(name);
    }

    public void evictWeavingState() {
    }
}

