/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.examples;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.ajdt.examples.AspectJExampleCreationOperation;
import org.eclipse.ajdt.examples.AspectJExampleCreationWizardPage;
import org.eclipse.ajdt.examples.AspectJExampleMessages;
import org.eclipse.ajdt.examples.AspectJExamplePlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class AspectJExampleCreationWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    public static final String PROJECT_SETUP_EXTENSION = "org.eclipse.ajdt.examples.projectsetup";
    private AspectJExampleCreationWizardPage[] fPages;
    private IConfigurationElement fConfigElement;

    public AspectJExampleCreationWizard() {
        this.setDialogSettings(AspectJExamplePlugin.getDefault().getDialogSettings());
        this.setWindowTitle(AspectJExampleMessages.getString("ExampleProjectCreationWizard.title"));
        this.setNeedsProgressMonitor(true);
    }

    private void initializeDefaultPageImageDescriptor() {
        String banner;
        if (this.fConfigElement != null && (banner = this.fConfigElement.getAttribute("banner")) != null) {
            ImageDescriptor desc = AspectJExamplePlugin.getDefault().getImageDescriptor(banner);
            this.setDefaultPageImageDescriptor(desc);
        }
    }

    public void addPages() {
        super.addPages();
        String id = this.fConfigElement.getAttribute("id");
        IConfigurationElement child = this.getProjectSetupInfo(id);
        this.fPages = new AspectJExampleCreationWizardPage[1];
        this.fPages[0] = new AspectJExampleCreationWizardPage(0, child);
        this.addPage((IWizardPage)this.fPages[0]);
    }

    private IConfigurationElement getProjectSetupInfo(String matchingID) {
        IExtensionPoint exP = Platform.getExtensionRegistry().getExtensionPoint(PROJECT_SETUP_EXTENSION);
        IExtension[] exs = exP.getExtensions();
        for (int i = 0; i < exs.length; ++i) {
            IConfigurationElement[] ces = exs[i].getConfigurationElements();
            for (int j = 0; j < ces.length; ++j) {
                String id = ces[j].getAttribute("id");
                if (!id.equals(matchingID)) continue;
                return ces[j];
            }
        }
        return null;
    }

    public boolean performFinish() {
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfigElement);
        AspectJExampleCreationOperation runnable = new AspectJExampleCreationOperation(this.fPages, new ImportOverwriteQuery());
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation((IRunnableWithProgress)runnable);
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            this.handleException(e.getTargetException());
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
        IResource res = runnable.getElementToOpen();
        if (res != null) {
            this.openResource(res);
        }
        return true;
    }

    private void handleException(Throwable target) {
        String title = AspectJExampleMessages.getString("ExampleProjectCreationWizard.op_error.title");
        String message = AspectJExampleMessages.getString("ExampleProjectCreationWizard.op_error.message");
        if (target instanceof CoreException) {
            IStatus status = ((CoreException)target).getStatus();
            ErrorDialog.openError((Shell)this.getShell(), (String)title, (String)message, (IStatus)status);
            AspectJExamplePlugin.log(status);
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)title, (String)target.getMessage());
            AspectJExamplePlugin.log(target);
        }
    }

    private void openResource(final IResource resource) {
        if (resource.getType() != 1) {
            return;
        }
        IWorkbenchWindow window = AspectJExamplePlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        final IWorkbenchPage activePage = window.getActivePage();
        if (activePage != null) {
            Display display = this.getShell().getDisplay();
            display.asyncExec(new Runnable(){

                public void run() {
                    try {
                        IDE.openEditor((IWorkbenchPage)activePage, (IFile)((IFile)resource), (boolean)true);
                    }
                    catch (PartInitException e) {
                        AspectJExamplePlugin.log(e);
                    }
                }
            });
            BasicNewResourceWizard.selectAndReveal((IResource)resource, (IWorkbenchWindow)activePage.getWorkbenchWindow());
        }
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.fConfigElement = cfig;
        this.initializeDefaultPageImageDescriptor();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    private class ImportOverwriteQuery
    implements IOverwriteQuery {
        private ImportOverwriteQuery() {
        }

        public String queryOverwrite(String file) {
            String[] returnCodes = new String[]{"YES", "NO", "ALL", "CANCEL"};
            int returnVal = this.openDialog(file);
            return returnVal < 0 ? "CANCEL" : returnCodes[returnVal];
        }

        private int openDialog(String file) {
            int[] result = new int[]{1};
            AspectJExampleCreationWizard.this.getShell().getDisplay().syncExec(new Runnable(this, file, result){
                private final /* synthetic */ String val$file;
                private final /* synthetic */ int[] val$result;
                private final /* synthetic */ ImportOverwriteQuery this$1;
                {
                    this.this$1 = this$1;
                    this.val$file = val$file;
                    this.val$result = val$result;
                }

                public void run() {
                    String title = AspectJExampleMessages.getString("ExampleProjectCreationWizard.overwritequery.title");
                    String msg = AspectJExampleMessages.getFormattedString("ExampleProjectCreationWizard.overwritequery.message", this.val$file);
                    String[] options = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL};
                    MessageDialog dialog = new MessageDialog(ImportOverwriteQuery.access$100(this.this$1).getShell(), title, null, msg, 3, options, 0);
                    this.val$result[0] = dialog.open();
                }
            });
            return result[0];
        }

        static /* synthetic */ AspectJExampleCreationWizard access$100(ImportOverwriteQuery x0) {
            return x0.AspectJExampleCreationWizard.this;
        }
    }
}

