/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.core.builder;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.internal.core.builder.ClasspathLocation;
import org.eclipse.ajdt.internal.core.ras.CoreFFDC;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.jdt.internal.compiler.util.SimpleSet;
import org.eclipse.jdt.internal.core.JavaModelManager;

public class ClasspathJar
extends ClasspathLocation {
    static SimpleLookupTable PackageCache;
    String zipFilename;
    IFile resource;
    ZipFile zipFile;
    boolean closeZipFileAtEnd;
    SimpleSet knownPackageNames;
    AccessRuleSet accessRuleSet;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    static {
        Factory factory = new Factory("ClasspathJar.java", Class.forName("org.eclipse.ajdt.internal.core.builder.ClasspathJar"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.core.builder.ClasspathJar-java.io.IOException-<missing>-"), 119);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-cleanup-org.eclipse.ajdt.internal.core.builder.ClasspathJar----void-"), 115);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.core.builder.ClasspathJar-java.lang.Exception-<missing>-"), 147);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-findClass-org.eclipse.ajdt.internal.core.builder.ClasspathJar-java.lang.String:java.lang.String:java.lang.String:-binaryFileName:qualifiedPackageName:qualifiedBinaryFileName:--org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer-"), 137);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.core.builder.ClasspathJar-java.lang.Exception-<missing>-"), 170);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-isPackage-org.eclipse.ajdt.internal.core.builder.ClasspathJar-java.lang.String:-qualifiedPackageName:--boolean-"), 157);
        PackageCache = new SimpleLookupTable();
    }

    static SimpleSet findPackageSet(ZipFile zipFile) {
        String zipFileName = zipFile.getName();
        File zipFileObject = new File(zipFileName);
        long lastModified = zipFileObject.lastModified();
        long fileSize = zipFileObject.length();
        PackageCacheEntry cacheEntry = (PackageCacheEntry)PackageCache.get((Object)zipFileName);
        if (cacheEntry != null && cacheEntry.lastModified == lastModified && cacheEntry.fileSize == fileSize) {
            return cacheEntry.packageSet;
        }
        SimpleSet packageSet = new SimpleSet(41);
        packageSet.add((Object)"");
        Enumeration<? extends ZipEntry> e = zipFile.entries();
        block0: while (e.hasMoreElements()) {
            String fileName = e.nextElement().getName();
            int last = fileName.lastIndexOf(47);
            while (last > 0) {
                String packageName = fileName.substring(0, last);
                if (packageSet.includes((Object)packageName)) continue block0;
                packageSet.add((Object)packageName);
                last = packageName.lastIndexOf(47);
            }
        }
        PackageCache.put((Object)zipFileName, (Object)new PackageCacheEntry(lastModified, fileSize, packageSet));
        return packageSet;
    }

    ClasspathJar(String zipFilename, AccessRuleSet accessRuleSet) {
        this.zipFilename = zipFilename;
        this.zipFile = null;
        this.knownPackageNames = null;
        this.accessRuleSet = accessRuleSet;
    }

    ClasspathJar(IFile resource, AccessRuleSet accessRuleSet) {
        this.resource = resource;
        IPath location = resource.getLocation();
        this.zipFilename = location != null ? location.toString() : "";
        this.zipFile = null;
        this.knownPackageNames = null;
        this.accessRuleSet = accessRuleSet;
    }

    public ClasspathJar(ZipFile zipFile, AccessRuleSet accessRuleSet) {
        this.zipFilename = zipFile.getName();
        this.zipFile = zipFile;
        this.closeZipFileAtEnd = false;
        this.knownPackageNames = null;
        this.accessRuleSet = accessRuleSet;
    }

    public void cleanup() {
        if (this.zipFile != null && this.closeZipFileAtEnd) {
            try {
                this.zipFile.close();
            }
            catch (IOException iOException) {
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(iOException, this, ajc$tjp_0, ajc$tjp_1);
            }
            this.zipFile = null;
        }
        this.knownPackageNames = null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClasspathJar)) {
            return false;
        }
        ClasspathJar jar = (ClasspathJar)o;
        if (!(this.accessRuleSet == jar.accessRuleSet || this.accessRuleSet != null && this.accessRuleSet.equals((Object)jar.accessRuleSet))) {
            return false;
        }
        return this.zipFilename.equals(((ClasspathJar)o).zipFilename);
    }

    public NameEnvironmentAnswer findClass(String binaryFileName, String qualifiedPackageName, String qualifiedBinaryFileName) {
        if (!this.isPackage(qualifiedPackageName)) {
            return null;
        }
        try {
            ClassFileReader reader = ClassFileReader.read((ZipFile)this.zipFile, (String)qualifiedBinaryFileName);
            if (reader != null) {
                if (this.accessRuleSet == null) {
                    return new NameEnvironmentAnswer((IBinaryType)reader, null);
                }
                return new NameEnvironmentAnswer((IBinaryType)reader, this.accessRuleSet.getViolatedRestriction(qualifiedBinaryFileName.toCharArray()));
            }
        }
        catch (Exception exception) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(exception, this, ajc$tjp_2, ajc$tjp_3);
        }
        return null;
    }

    public IPath getProjectRelativePath() {
        if (this.resource == null) {
            return null;
        }
        return this.resource.getProjectRelativePath();
    }

    public boolean isPackage(String qualifiedPackageName) {
        if (this.knownPackageNames != null) {
            return this.knownPackageNames.includes((Object)qualifiedPackageName);
        }
        try {
            if (this.zipFile == null) {
                if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                    System.out.println("(" + Thread.currentThread() + ") [ClasspathJar.isPackage(String)] Creating ZipFile on " + this.zipFilename);
                }
                this.zipFile = new ZipFile(this.zipFilename);
                this.closeZipFileAtEnd = true;
            }
            this.knownPackageNames = ClasspathJar.findPackageSet(this.zipFile);
        }
        catch (Exception exception) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(exception, this, ajc$tjp_4, ajc$tjp_5);
            this.knownPackageNames = new SimpleSet();
        }
        return this.knownPackageNames.includes((Object)qualifiedPackageName);
    }

    public String toString() {
        return "Classpath jar file " + this.zipFilename;
    }

    public String toOSString() {
        return this.zipFilename;
    }

    static class PackageCacheEntry {
        long lastModified;
        long fileSize;
        SimpleSet packageSet;

        PackageCacheEntry(long lastModified, long fileSize, SimpleSet packageSet) {
            this.lastModified = lastModified;
            this.fileSize = fileSize;
            this.packageSet = packageSet;
        }
    }
}

