/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.core.builder;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.aspectj.ajde.OutputLocationManager;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.internal.core.ras.CoreFFDC;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;

public class CoreOutputLocationManager
implements OutputLocationManager {
    private String projectName;
    private File defaultOutput;
    private Map srcFolderToOutput = new HashMap();
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    private static File workspacePathToFile(IPath path) {
        IFolder out = ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
        return out.getLocation().toFile();
    }

    public CoreOutputLocationManager(IJavaProject jp) {
        this.projectName = jp.getProject().getName();
        try {
            this.defaultOutput = CoreOutputLocationManager.workspacePathToFile(jp.getOutputLocation());
            IClasspathEntry[] cpe = jp.getRawClasspath();
            int i = 0;
            while (i < cpe.length) {
                IPath output;
                if (cpe[i].getEntryKind() == 3 && (output = cpe[i].getOutputLocation()) != null) {
                    String srcFolder = cpe[i].getPath().lastSegment();
                    File out = CoreOutputLocationManager.workspacePathToFile(output);
                    this.srcFolderToOutput.put(srcFolder, out);
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_0, ajc$tjp_1);
        }
    }

    public File getOutputLocationForClass(File compilationUnit) {
        return this.getOutputLocationForResource(compilationUnit);
    }

    public File getOutputLocationForResource(File resource) {
        String srcFolder;
        File out;
        String rest;
        int ind2;
        String fileName = resource.toString().replace('\\', '/');
        int ind = fileName.indexOf(this.projectName);
        if (ind != -1 && (ind2 = (rest = fileName.substring(ind + this.projectName.length() + 1)).indexOf(47)) != -1 && (out = (File)this.srcFolderToOutput.get(srcFolder = rest.substring(0, ind2))) != null) {
            return out;
        }
        return this.defaultOutput;
    }

    static {
        Factory factory = new Factory("CoreOutputLocationManager.java", Class.forName("org.eclipse.ajdt.core.builder.CoreOutputLocationManager"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.builder.CoreOutputLocationManager-org.eclipse.jdt.core.JavaModelException-<missing>-"), 56);
        ajc$tjp_1 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1--org.eclipse.ajdt.core.builder.CoreOutputLocationManager-org.eclipse.jdt.core.IJavaProject:-jp:--"), 40);
    }
}

